

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileForDB2Backupset.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc.  The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileForDB2Backupset.sp,v $ $Id: archFileForDB2Backupset.sp,v 1.14.194.2 2018/03/22 01:13:08 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archFileForDB2Backupset <<<'

IF EXISTS (select * from sysobjects where name='archFileForDB2Backupset')
	drop procedure archFileForDB2Backupset
IF EXISTS (select * from GxQscripts where name='archFileForDB2Backupset')
	delete from GxQscripts where name = 'archFileForDB2Backupset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileForDB2Backupset')
	delete from GXDBVersions where aliasname = 'archFileForDB2Backupset'
GO
print '... Creating Procedure: archFileForDB2Backupset'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archFileForDB2Backupset
  @i_clientId integer,
  @i_appTypeId integer,
  @i_instanceId integer,
  @i_backupSetId integer,
  @i_copyPrec integer,
  @i_includeAgedData integer,
  @i_includeLoadCopyBkpAF integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @r_afileId integer
  DECLARE @r_commCellId integer
  DECLARE @r_fileName NVARCHAR(2048)
  DECLARE @r_creationTime integer
  DECLARE @r_backupLevel integer
  DECLARE @r_numStreams integer
  DECLARE @r_initFrom integer
  DECLARE @r_attributes bigint
  DECLARE @r_afcFlags integer
  DECLARE @r_copyPrec integer
  DECLARE @r_physicalSize bigint
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
--SET @i_clientId= %d
--SET @i_appTypeId= %d
--SET @i_instanceId= %d
--SET @i_backupSetId= %d
--SET @i_copyPrec = %d
--SET @i_includeAgedData = %d
DECLARE @tblAF	TABLE (
archFileId int, commCellId int, archGroupId int, jobId int, name NVARCHAR(2048), cTime int
)
DECLARE @tblAFC	TABLE (
	archFileId int, commCellId int, archCopyId int, flags int, physicalSize bigint, copyPrecedence int
)
INSERT	INTO @tblAF
SELECT	AF.id, AF.commCellId, AF.archGroupId, AF.jobId, AF.name, AF.cTime
FROM 	archFile AF WITH (NOLOCK),
		(SELECT	id
		FROM	APP_Application WITH (NOLOCK)
		WHERE	clientId = @i_clientId AND appTypeId = @i_appTypeId
			AND instance = @i_instanceId AND backupSet = @i_backupSetId) APP
WHERE	AF.appId = APP.id
AND AF.fileType IN (1, 4)
	AND AF.isValid = 1
AND (AF.flags & 2) = 0
AND (AF.flags & 4) = 0
AND (AF.flags & 512) = 0
DELETE	@tblAF
FROM	@tblAF AF, ArchDB2Log LOG WITH (NOLOCK)
WHERE	AF.archFileId = LOG.archFileId
	AND AF.commCellId = LOG.commCellId
INSERT	INTO @tblAFC
SELECT	AFC.archFileId, AFC.commCellId, AFC.archCopyId, AFC.flags, AFC.physicalSize, AGC.copy
FROM	@tblAF AF, archFileCopy AFC WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
WHERE	AFC.archFileId = AF.archFileId AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = AGC.id
	AND AFC.isValid > 0
	AND AGC.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
	AND (@i_copyPrec = 0 OR AGC.copy = @i_copyPrec)
AND (@i_includeAgedData <> 0 OR (AFC.flags & 256) = 0)
SELECT	AF.archFileId, AF.commCellId, AF.name, AF.cTime,
		BKP.bkpLevel, BKP.numStreams, BKP.initFrom, BKP.bkpattributes,
		AFC.flags, AFC.copyPrecedence, AFC.physicalSize
FROM	(SELECT	archFileId, commCellId, MIN(copyPrecedence) AS copyPrecedence
		FROM	@tblAFC
		GROUP BY archFileId, commCellId) AFP,
		@tblAFC AFC, @tblAF AF, JMBkpStats BKP WITH (NOLOCK)
WHERE	AFC.archFileId = AFP.archFileId AND AFC.commCellId = AFP.commCellId AND AFC.copyPrecedence = AFP.copyPrecedence
	AND AF.archFileId = AFC.archFileId AND AF.commCellId = AFC.commCellId
	AND BKP.jobId = AF.jobId AND BKP.commCellId = AF.commCellId
	AND BKP.dataArchGrpId = AF.archGroupId AND BKP.status IN (1, 3, 14)
	AND ((BKP.bkpattributes & 0x8000000000000 = 0) OR @i_includeLoadCopyBkpAF > 0) --#define JMBKP_DB2_LOADCOPY_BKP          0x8000000000000LL
ORDER BY AF.archFileId DESC
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archFileForDB2Backupset')
	delete from GxQscripts where name = 'archFileForDB2Backupset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileForDB2Backupset')
	delete from GXDBVersions where aliasname = 'archFileForDB2Backupset'
GO

insert into GXDBVersions values(2, 'archFileForDB2Backupset',  '00010014019400020000', 'archFileForDB2Backupset', '00010014019400020000')
GO

