

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileEncryptionInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileEncryptionInfo.sp,v $ $Id: archFileEncryptionInfo.sp,v 1.29.12.9 2020/12/31 00:20:52 pnara Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archFileEncryptionInfo')
BEGIN
	print '>>> Drop Stored Procedure: archFileEncryptionInfo <<<'
	drop procedure archFileEncryptionInfo
END
IF EXISTS (select * from GxQscripts where name='archFileEncryptionInfo')
	delete from GxQscripts where name = 'archFileEncryptionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileEncryptionInfo')
	delete from GXDBVersions where aliasname = 'archFileEncryptionInfo'
GO
print '... Creating Procedure: archFileEncryptionInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archFileEncryptionInfo
  @i_archFileId int,
  @i_commCellId int,
  @i_archCopyId int
AS
  DECLARE @o_name NVARCHAR(2048);
  DECLARE @o_archGroupId int;
  DECLARE @o_mediaGroupId int; 
  DECLARE @o_objName1 varchar(2048); 
  DECLARE @o_flags int; 
  DECLARE @o_fileType int; 
  DECLARE @o_cTime int; 
  DECLARE @o_jobId int; 
  DECLARE @o_backupLevel int; 
  DECLARE @o_isValid int;
  DECLARE @o_appId int; 
  DECLARE @o_clientId int;
  DECLARE @o_appTypeId int;
  DECLARE @o_AFC_flags int;
  DECLARE @o_encRSA int;
  DECLARE @o_encKeyType int;
  DECLARE @o_encKey varchar(1024);
  DECLARE @o_clientEnc int;
  DECLARE @o_restoreAccess int;
  DECLARE @o_drToolAccess int;
  DECLARE @o_subclientEnc int;
  DECLARE @o_rsaPriKey varchar(4096);
  DECLARE @o_appEncType int;
  DECLARE @o_appEncKeyLen int;
  DECLARE @o_SIDBStoreId int;
  DECLARE @o_companyId int;
  DECLARE @o_companyGUID uniqueidentifier;
  DECLARE @o_encKeyId int;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@l_streamNum	int
DECLARE	@l_mediaGroupId	int
DECLARE	@l_dedupeFlags	int
DECLARE	@l_copyFlags	int = 0
DECLARE @l_archGroupType int =  0
SET @l_streamNum	= 0
SET @l_mediaGroupId	= 0
SET @l_dedupeFlags	= 0
SET @o_name			= ''
SET @o_archGroupId	= 0
SET @o_objName1		= 0
SET @o_flags		= 0
SET @o_fileType		= 0
SET @o_cTime		= 0
SET @o_jobId		= 0
SET @o_backupLevel	= 0
SET @o_isValid		= 1
SET @o_appId		= 0
SET @o_clientId		= 0
SET @o_appTypeId	= 0
SET @o_AFC_flags	= 0
SET @o_encRSA		= 0
SET @o_encKeyType	= 0
SET @o_encKey		= ''
SET @o_clientEnc	= 0
SET @o_restoreAccess= 0
SET @o_drToolAccess	= 0
SET @o_subclientEnc	= 0
SET @o_rsaPriKey	= ''
SET @o_appEncType	= 0
SET @o_appEncKeyLen	= 0
SET @o_SIDBStoreId	= 0
SET	@o_companyId	= 0
SET @o_encKeyId		= 0
IF @i_archCopyId = 0
BEGIN
	-- This call must come from an MA prior to 7.0 for a Restore job.
	-- Encryption was done in Backup so it's the same for all copies.
	SELECT	TOP 1 @i_archCopyId = archCopyId, @o_AFC_flags = flags, @l_streamNum = streamNum,
			@o_encRSA = encRSA, @o_encKeyType = encKeyType, @o_encKey = encKey, @o_encKeyId = encKeyId
	FROM	archFileCopy WITH (NOLOCK)
	WHERE	archFileId = @i_archFileId AND commCellId = @i_commCellId AND isValid > 0
END
ELSE
BEGIN
	SELECT	@o_SIDBStoreId	= AGC.SIDBStoreId, @l_dedupeFlags = AGC.dedupeFlags,
			@l_copyFlags = AGC.flags, @l_archGroupType = AG.type
	FROM	archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH(READUNCOMMITTED)
	WHERE	AGC.id = @i_archCopyId AND AGC.archGroupId = AG.id
IF (@l_dedupeFlags & 134217728) = 0
		SELECT	@o_AFC_flags = flags, @l_streamNum = streamNum,
				@o_encRSA = encRSA, @o_encKeyType = encKeyType, @o_encKey = encKey, @o_encKeyId = encKeyId
		FROM	archFileCopy WITH (NOLOCK)
		WHERE	archFileId = @i_archFileId AND commCellId = @i_commCellId AND archCopyId = @i_archCopyId
	ELSE
		SELECT	@o_AFC_flags = flags, @l_streamNum = streamNum,
				@o_encRSA = encRSA, @o_encKeyType = encKeyType, @o_encKey = encKey, @o_encKeyid = encKeyId
		FROM	archFileCopy WITH (NOLOCK)
		WHERE	archFileId = @i_archFileId AND commCellId = @i_commCellId
			AND archCopyId IN (SELECT copyId FROM archCopySIDBStore WITH (NOLOCK) WHERE SIDBStoreId = @o_SIDBStoreId)
	-- Encryption info of single-instanced archive files are saved in archFileSIDBKeys table.
	IF @@ERROR = 0 AND @@ROWCOUNT = 0
	BEGIN
IF (@l_dedupeFlags & 134217728) = 0
			SELECT	TOP 1   @o_encRSA		= ISNULL(keys.encRSA, a.encRSA),
							@o_encKeyType	= ISNULL(keys.encKeyType, a.encKeyType),
							@o_encKey		= ISNULL(keys.encKey, a.encKey),
							@o_encKeyId		= ISNULL(keys.encKeyId, a.encKeyId)
			FROM	archFileSIDBKeys a WITH (NOLOCK)
					LEFT JOIN ArchEncKeys keys WITH (NOLOCK) ON a.encKeyId = keys.encKeyId
			WHERE	a.archFileId = @i_archFileId AND a.commCellId = @i_commCellId AND a.archCopyId = @i_archCopyId
		ELSE
			SELECT	TOP 1   @o_encRSA		= ISNULL(keys.encRSA, a.encRSA),
							@o_encKeyType	= ISNULL(keys.encKeyType, a.encKeyType),
							@o_encKey		= ISNULL(keys.encKey, a.encKey),
							@o_encKeyId		= ISNULL(keys.encKeyId, a.encKeyId)
			FROM	archFileSIDBKeys a WITH (NOLOCK)
					LEFT JOIN ArchEncKeys keys WITH (NOLOCK) ON a.encKeyId = keys.encKeyId
			WHERE	a.archFileId = @i_archFileId AND a.commCellId = @i_commCellId
				AND (a.archCopyId IN (SELECT copyId FROM archCopySIDBStore WITH (NOLOCK) WHERE SIDBStoreId = @o_SIDBStoreId)
					OR a.SIDBStoreId IN (SELECT SIDBStoreId FROM archCopySIDBStore WITH (NOLOCK) WHERE copyId = @i_archCopyId))
		IF @@ERROR = 0 AND @@ROWCOUNT > 0
SET	@o_AFC_flags = (@o_AFC_flags | 16)
	END
END
IF @l_streamNum > 0
	SELECT	@l_mediaGroupId = mediaGroupId
	FROM	archStream WITH (NOLOCK)
	WHERE	archGroupCopyId = @i_archCopyId AND stream = @l_streamNum
SELECT	@o_name = name, @o_archGroupId = archGroupId, @o_objName1 = objName1, @o_flags = flags, @o_fileType = fileType,
		@o_cTime = cTime, @o_jobId = jobId, @o_backupLevel = backupLevel, @o_isValid = isValid, @o_appId = appId
FROM	archFile WITH (NOLOCK)
WHERE	id = @i_archFileId AND commCellId = @i_commCellId
IF @@ERROR = 0 AND @@ROWCOUNT > 0
BEGIN
	DECLARE @l_realAppId	INT
	SET		@l_realAppId	= @o_appId
	-- Get the real appId for a SnapToMedia job
	SELECT	@l_realAppId = applicationId, @o_jobId = processedJobId FROM JMJobWF WITH (NOLOCK) WHERE childJobId = @o_jobId
	AND childOpType = 60 and processedJobId > 0
	CREATE	TABLE #tblAppEnc (clientId int, appTypeId int, encryption int, restoreAccess int, drToolAccess int, subclientEnc int,
			encType int, encKeyLen int, SIDBStoreId int, RSAPubKey varchar(1024), RSAPriKeyBPF varchar(1024), RSAPriKeyUPF varchar(1024),
			companyId int, companyGUID uniqueidentifier)
	INSERT	INTO #tblAppEnc
	EXEC archBackupEncryptionInfo @l_realAppId, @i_archCopyId
	SELECT	@o_clientId = clientId, @o_appTypeId = appTypeId,
			@o_clientEnc = encryption, @o_restoreAccess = restoreAccess, @o_drToolAccess = drToolAccess,
			@o_subclientEnc = subclientEnc, @o_rsaPriKey = (case when restoreAccess = 0 then RSAPriKeyBPF else RSAPriKeyUPF end),
			@o_appEncType = encType, @o_appEncKeyLen = encKeyLen, @o_SIDBStoreId = SIDBStoreId,
			@o_companyId = companyId, @o_companyGUID = companyGUID
	FROM	#tblAppEnc
	DROP TABLE #tblAppEnc
	--Check for copy level DirectMediaAccess flag when AF is not encrypted either with client RSA or company RSA
	--For client or company we should stick to client level settings only
IF (@o_encRSA & (1 | 16)) = 0 AND @o_encKeyType > 0 AND @i_archCopyId > 0
	BEGIN
		-- Values for drToolAccess: 0 for Via Media Password, 1 for Via Pass Phrase, 2 for No Access
SELECT	@o_drToolAccess = (CASE WHEN (@l_copyFlags & 131072) = 0 AND @l_archGroupType <> 2 THEN 2 ELSE 0 END)
	END
	-- When data key is encrypted with copy or company RSA then we should write copy priKey, masterKeyId and keyProviderType to media
	-- This helps to recover data using tape import
	IF @o_encKeyType > 0 AND @o_drToolAccess = 0 --Via Media Password
	BEGIN
IF (@o_encRSA & 2) > 0
		BEGIN
			IF OBJECT_ID('tempdb..#lt_archCopyEncInfo') IS NOT NULL DROP TABLE #lt_archCopyEncInfo
			CREATE TABLE #lt_archCopyEncInfo
			(
				o_errorCode			int,
				o_KeyCopyId			int,
o_RSAPubKey			varchar(2048),
o_RSAPriKey			varchar(3072),
				o_MasterKeyId		varchar(2048),
				o_KeyProviderId 	int,
				o_KeyProviderName	nvarchar(1024),
				o_NewKeyProviderId 	int,
				o_EncType			int,
				o_PriKeyLen			int,
				o_MasterKeyLen		int,
				o_KeyProviderType 	int,
				o_LastValidation    int,
				o_KeyProviderGUID 	uniqueidentifier
			)
			INSERT INTO #lt_archCopyEncInfo
			EXEC archCopyEncryptionInfo @i_archCopyId
			SET @o_rsaPriKey = CAST((SELECT o_RSAPriKey PriKey, o_MasterKeyId MasterKeyId,
											o_KeyProviderType KeyProviderType, o_KeyProviderGUID KeyProviderGUID
									FROM	#lt_archCopyEncInfo
									FOR	XML RAW('RSAPriKeyInfo'), TYPE) AS varchar(5000))
		END
ELSE IF (@o_encRSA & 16) > 0
		BEGIN
			IF OBJECT_ID('tempdb..#lt_archCompanyEncInfo') IS NOT NULL DROP TABLE #lt_archCompanyEncInfo
			CREATE TABLE #lt_archCompanyEncInfo
			(
				o_errorCode			int,
o_RSAPubKey			varchar(2048),
o_RSAPriKey			varchar(3072),
				o_MasterKeyId		varchar(2048),
				o_EncType			int,
				o_KeyProviderId 	int,
				o_KeyProviderType 	int,
				o_KeyProviderGUID 	uniqueidentifier,
				o_LastValidation    int
			)
			INSERT INTO #lt_archCompanyEncInfo
			EXEC archCompanyEncryptionInfo @o_companyId
			SET @o_rsaPriKey = CAST((SELECT o_RSAPriKey PriKey, o_MasterKeyId MasterKeyId,
											o_KeyProviderType KeyProviderType, o_KeyProviderGUID KeyProviderGUID,
											@o_companyGUID CompanyGUID
									FROM	#lt_archCopyEncInfo
									FOR	XML RAW('RSAPriKeyInfo'), TYPE) AS varchar(5000))
		END
	END
END
ELSE
IF	@i_archCopyId > 0
	SELECT	@o_archGroupId = archGroupId, @o_SIDBStoreId = SIDBStoreId
	FROM	archGroupCopy WITH (NOLOCK) WHERE id = @i_archCopyId
--
-- Send a falg to DataMover to store DDB backups on non-archive tier if library is cloud and combined tier is set
--
DECLARE @l_DDBBackupPropChkSum INT = CHECKSUM(N'DDB Backup')
IF EXISTS(SELECT 1 FROM APP_SubClientProp WITH(READUNCOMMITTED) WHERE componentNameId = @o_appId AND attrName = N'DDB Backup' AND modified = 0 AND cs_attrName = @l_DDBBackupPropChkSum)
BEGIN
SET	@o_AFC_flags = (@o_AFC_flags | 32768)
END
SELECT	@o_name, @o_archGroupId, @l_mediaGroupId,
		@o_objName1, @o_flags, @o_fileType, @o_cTime, @o_jobId, @o_backupLevel, @o_isValid,
		@o_appId, @o_clientId, @o_appTypeId, @o_AFC_flags, @o_encRSA, @o_encKeyType, @o_encKey,
		@o_clientEnc, @o_restoreAccess, @o_drToolAccess, @o_subclientEnc, @o_rsaPriKey, @o_appEncType, @o_appEncKeyLen,
		@o_SIDBStoreId, @o_companyId, @o_companyGUID, @o_encKeyId
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archFileEncryptionInfo')
	delete from GxQscripts where name = 'archFileEncryptionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileEncryptionInfo')
	delete from GXDBVersions where aliasname = 'archFileEncryptionInfo'
GO

insert into GXDBVersions values(2, 'archFileEncryptionInfo',  '00010029001200090000', 'archFileEncryptionInfo', '00010029001200090000')
GO

