

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileEncKey.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileEncKey.sp,v $ $Id: archFileEncKey.sp,v 1.13.12.7 2020/08/21 22:45:05 sjohnson Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 	Procedure: "archFileEncKey"						|
--	|												|
--    |	Initial Version: 	4/20/2007 by Jun Lu					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archFileEncKey')
BEGIN
	print '>>> Drop Stored Procedure: archFileEncKey <<<'
	drop procedure archFileEncKey
END
IF EXISTS (select * from GxQscripts where name='archFileEncKey')
	delete from GxQscripts where name = 'archFileEncKey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileEncKey')
	delete from GXDBVersions where aliasname = 'archFileEncKey'
GO
print '... Creating Procedure: archFileEncKey'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archFileEncKey
  @i_commCellId integer,
  @i_archCopyId integer,
  @i_options integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_archFileId integer
  DECLARE @o_encRSA integer
  DECLARE @o_encKeyType integer
  DECLARE @o_encKey varchar(1024)
  DECLARE @o_encKeyId integer
  DECLARE @o_restoreAccess integer
  DECLARE @o_rsaPriKey varchar(1024)
  DECLARE @o_keyCopyId integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
/*	This temp table must be created and populated by the caller
	CREATE TABLE #ArchFileIdList (archFileId int)
*/
--For MediaRefresh on GACP AuxCopy uses GACP copyId for key lookups
--But archFiles are actually associated with dependent copies, so use dependent copies for lookup
IF OBJECT_ID('tempdb..#lt_Copies') IS NOT NULL DROP TABLE #lt_Copies
CREATE TABLE #lt_Copies (copyId int)
INSERT 	INTO #lt_Copies
SELECT	id
FROM	archGroupCopy WITH (READUNCOMMITTED)
WHERE	id = @i_archCopyId AND (extendedFlags & 1) = 0
UNION
SELECT	id
FROM	archGroupCopy WITH (READUNCOMMITTED)
WHERE	destMediaCopyId = @i_archCopyId AND (extendedFlags & 2) > 0
IF OBJECT_ID('tempdb..#tblAFC') IS NOT NULL DROP TABLE #tblAFC
CREATE TABLE #tblAFC (
	archFileId int, commCellId int, encRSA int, encKeyType int, encKey varchar(1024), encKeyId int, appId int, restoreAccess int, rsaPriKey varchar(1024), keyCopyId int)
INSERT	INTO #tblAFC
SELECT	AFC.archFileId, AFC.commCellId, AFC.encRSA, AFC.encKeyType, AFC.encKey, AFC.encKeyId, 0, 0, '', AFC.archCopyId
FROM	#ArchFileIdList T, archFileCopy AFC WITH (NOLOCK), #lt_Copies AGC
WHERE	AFC.archFileId = T.archFileId AND AFC.commCellId = @i_commCellId AND AFC.archCopyId = AGC.copyId
DELETE	#ArchFileIdList
FROM	#tblAFC T
WHERE	#ArchFileIdList.archFileId = T.archFileId
IF	EXISTS (SELECT * FROM #ArchFileIdList)
BEGIN
    -- This is done to cover the case where recopy of a job is done after sealing the store to which the job was originally copied.
    -- This created another entry to archFileSIDBKeys with different storeId.
    WITH Key_CTE (archFileId, CommCellId, encRSA, encKeyType, encKey, encKeyId, appId, restoreAccess, rsaPriKey, RowNumber)
    AS
    (
            SELECT  AFC.archFileId, AFC.commCellId, ISNULL(keys.encRSA, AFC.encRSA), ISNULL(keys.encKeyType, AFC.encKeyType), ISNULL(keys.encKey, AFC.encKey), ISNULL(keys.encKeyId, AFC.encKeyId),
					0, 0, '', ROW_NUMBER() OVER (PARTITION BY AFC.archFileId, AFC.commCellId ORDER BY AFC.SIDBStoreId DESC) AS RowNumber
            FROM    #ArchFileIdList T1, archFileSIDBKeys AFC WITH (NOLOCK) LEFT JOIN archEncKeys keys WITH (NOLOCK) ON AFC.encKeyId = keys.encKeyId
            WHERE   AFC.archFileId = T1.archFileId AND AFC.commCellId = @i_commCellId AND AFC.archCopyId = @i_archCopyId
    )
    INSERT INTO #tblAFC
    SELECT CTE.archFileId, CTE.CommCellId, CTE.encRSA, CTE.encKeyType, CTE.encKey, CTE.encKeyId, 0, 0, '', @i_archCopyId
    FROM Key_CTE AS CTE
    WHERE CTE.RowNumber = 1
	DELETE	#ArchFileIdList
	FROM	#tblAFC T
	WHERE	#ArchFileIdList.archFileId = T.archFileId
END
IF	EXISTS (SELECT * FROM #ArchFileIdList)
BEGIN
	DECLARE	@tblSrcCopy	TABLE (copyId int)
	DECLARE	@l_archGroupId	int
	DECLARE	@l_defCopyId	int
	DECLARE	@l_srcCopyId	int
	DECLARE	@l_copyId		int
	DECLARE	@l_dedupeFlags	int
	SELECT	@l_archGroupId = archGroupId, @l_dedupeFlags = dedupeFlags
	FROM	archGroupCopy WITH (NOLOCK)
	WHERE	id = @i_archCopyId
IF (@l_dedupeFlags & (134217728 | 268435456)) <> 0
	BEGIN
		-- This is done to cover the case where a copy pointing to GDSP created 1 entry to archFileSIDBKeys, copy deleted and another copy created pointing to same GDSP
		-- which create another entry to archFileSIDBKeys with different encryption key.
		WITH Key_CTE (archFileId, CommCellId, encRSA, encKeyType, encKey, encKeyId, appId, restoreAccess, rsaPriKey, RowNumber)
		AS
		(
			SELECT  AFC.archFileId, AFC.commCellId, ISNULL(keys.encRSA, AFC.encRSA), ISNULL(keys.encKeyType, AFC.encKeyType), ISNULL(keys.encKey, AFC.encKey), ISNULL(keys.encKeyId, AFC.encKeyId),
					0, 0, '', ROW_NUMBER() OVER (PARTITION BY AFC.archFileId, AFC.commCellId ORDER BY AFC.archCopyId DESC) AS RowNumber
			FROM    #ArchFileIdList T1,  archCopySIDBStore ACS WITH (NOLOCK), archFileSIDBKeys AFC WITH (NOLOCK) LEFT JOIN archEncKeys keys WITH (NOLOCK) ON AFC.encKeyId = keys.encKeyId
			WHERE   AFC.archFileId = T1.archFileId AND AFC.commCellId = @i_commCellId AND AFC.SIDBStoreId = ACS.SIDBStoreId
					AND ACS.CopyId = @i_archCopyId
		)
		INSERT INTO #tblAFC
		SELECT CTE.archFileId, CTE.CommCellId, CTE.encRSA, CTE.encKeyType, CTE.encKey, CTE.encKeyId, 0, 0, '', @i_archCopyId
		FROM Key_CTE AS CTE
		WHERE CTE.RowNumber = 1
		DELETE	#ArchFileIdList
		FROM	#tblAFC T
		WHERE	#ArchFileIdList.archFileId = T.archFileId
	END
	IF	EXISTS (SELECT * FROM #ArchFileIdList)
	BEGIN
		SELECT	@l_defCopyId = defaultCopy
		FROM	archGroup WITH (NOLOCK)
		WHERE	id = @l_archGroupId
		SET	@l_srcCopyId	= 0
		SET	@l_copyId		= @i_archCopyId
		WHILE @l_srcCopyId <> @l_defCopyId
		BEGIN
			SELECT	@l_srcCopyId = (CASE WHEN sourceCopyId > 0 THEN sourceCopyId ELSE @l_defCopyId END)
			FROM	archGroupCopy WITH (NOLOCK)
			WHERE	id = @l_copyId
			IF	@@ERROR <> 0 OR @@ROWCOUNT = 0
				BREAK
			INSERT	INTO @tblSrcCopy
			SELECT	@l_srcCopyId
			SET		@l_copyId = @l_srcCopyId
		END
		INSERT	INTO #tblAFC
		SELECT	DISTINCT AFC.archFileId, AFC.commCellId, ISNULL(keys.encRSA, AFC.encRSA),
				ISNULL(keys.encKeyType, AFC.encKeyType), ISNULL(keys.encKey, AFC.encKey), ISNULL(keys.encKeyId, AFC.encKeyId),
				0, 0, '', @i_archCopyId
		FROM	#ArchFileIdList T, @tblSrcCopy AGC, archFileSIDBKeys AFC WITH (NOLOCK) LEFT JOIN archEncKeys keys WITH (NOLOCK) ON AFC.encKeyId = keys.encKeyId
		WHERE	AFC.archFileId = T.archFileId AND AFC.commCellId = @i_commCellId AND AFC.archCopyId = AGC.copyId
	END
END
IF EXISTS (SELECT * FROM #tblAFC WHERE encRSA <> 0)
BEGIN
	DECLARE	@tblApp	TABLE (appId int, clientId int)
	DECLARE	@tblClientEnc TABLE (clientId int, restoreAccess int, rsaPriKeyUPF varchar(1024), rsaPriKeyBPF varchar(1024))
	DECLARE	@tblClientPriKey TABLE (clientId int, restoreAccess int, rsaPriKey varchar(1024))
	UPDATE	#tblAFC	SET appId = AF.appId
	FROM	#tblAFC T, archFile AF WITH (NOLOCK)
WHERE	AF.id = T.archFileId AND AF.commCellId = T.commCellId AND (T.encRSA & 1) <> 0
	INSERT	INTO @tblApp
	SELECT	DISTINCT A.id, A.clientId
	FROM	APP_Application A WITH (NOLOCK), #tblAFC T
	WHERE	A.id = T.appId
	INSERT	INTO @tblClientEnc
	SELECT	ComponentNameId,
			(case when attrName = N'Encrypt: restoreAccess'	then CONVERT(int, attrVal) else 0 end),
			(case when attrName = N'Encrypt: rsaPriKeyUPF'	then attrVal else '' end),
			(case when attrName = N'Encrypt: rsaPriKeyBPF'	then attrVal else '' end)
	FROM	APP_ClientProp WITH (NOLOCK)
	WHERE	ComponentNameId IN (SELECT DISTINCT clientId FROM @tblApp)
		AND modified = 0
		AND attrName IN (N'Encrypt: restoreAccess', N'Encrypt: rsaPriKeyUPF', N'Encrypt: rsaPriKeyBPF')
	INSERT	INTO @tblClientPriKey
	SELECT	clientId, MAX(restoreAccess), ''
	FROM	@tblClientEnc
	GROUP BY clientId
	UPDATE	@tblClientPriKey
	SET		rsaPriKey = C.rsaPriKeyUPF
	FROM	@tblClientPriKey A, @tblClientEnc C
	WHERE	A.clientId = C.clientId AND A.restoreAccess = 1 AND C.rsaPriKeyUPF <> ''
	UPDATE	@tblClientPriKey
	SET		rsaPriKey = C.rsaPriKeyBPF
	FROM	@tblClientPriKey A, @tblClientEnc C
	WHERE	A.clientId = C.clientId AND A.restoreAccess = 0 AND C.rsaPriKeyBPF <> ''
	UPDATE	#tblAFC
	SET		rsaPriKey = C.rsaPriKey, restoreAccess = C.restoreAccess
	FROM	#tblAFC A, @tblApp B, @tblClientPriKey C
WHERE	B.appId = A.appId AND C.clientId = B.clientId AND (encRSA & 1) <> 0
END
	SELECT	DISTINCT archFileId, encRSA, encKeyType, encKey, encKeyId, restoreAccess, rsaPriKey, keyCopyId
	FROM	#tblAFC
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archFileEncKey')
	delete from GxQscripts where name = 'archFileEncKey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileEncKey')
	delete from GXDBVersions where aliasname = 'archFileEncKey'
GO

insert into GXDBVersions values(2, 'archFileEncKey',  '00010013001200070000', 'archFileEncKey', '00010013001200070000')
GO

