

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileDeleteViaTable.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileDeleteViaTable.sp,v $ $Id: archFileDeleteViaTable.sp,v 1.49.2.10 2019/12/21 21:47:14 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archFileDeleteViaTable')
BEGIN
	print '>>> Drop Stored Procedure: archFileDeleteViaTable <<<'
	drop procedure archFileDeleteViaTable
END
IF EXISTS (select * from GxQscripts where name='archFileDeleteViaTable')
	delete from GxQscripts where name = 'archFileDeleteViaTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileDeleteViaTable')
	delete from GXDBVersions where aliasname = 'archFileDeleteViaTable'
GO
print '... Creating Procedure: archFileDeleteViaTable'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archFileDeleteViaTable
  @i_dummy integer,
  @magneticBytes bigint	OUTPUT,
  @i_DADeletionFlags INT=0
AS
  DECLARE @retVal integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET		@retVal = 0
DECLARE	@hasMagnetic INT
SET		@hasMagnetic = 0
DECLARE	@currentTime INT
SET		@currentTime = dbo.GetUnixTime(GETUTCDATE())
DECLARE @oneConstReal REAL
SET			@oneConstReal = 1.0
/* This temp table must be created and populated by caller before calling this stored procedure
CREATE TABLE #ToBeAgedAFC (
	archFileId INT, commCellId INT, archCopyId INT,
	PRIMARY KEY (archFileId, commCellId, archCopyId))
*/
IF NOT EXISTS (SELECT 1 FROM #ToBeAgedAFC)
BEGIN
	SET @retVal = 0
	GOTO CX_EXIT
END
--
-- Check if DA is enabled before proceeding
--
if ( (@i_DADeletionFlags & 1 ) = 0)
begin
	declare @l_isDAEnabled integer
	set @l_isDAEnabled = dbo.isDataAgingActivityEnabled (2)
	if (@l_isDAEnabled = 0)
	begin
set @retVal = -1000
		GOTO CX_EXIT
	end
end
IF object_id('tempdb.dbo.#ToBeAgedAFCOnTransitiveCopy') IS NOT NULL DROP TABLE #ToBeAgedAFCOnTransitiveCopy
CREATE TABLE #ToBeAgedAFCOnTransitiveCopy (
	archFileId INT, commCellId INT, archCopyId INT,
	PRIMARY KEY (archFileId, commCellId, archCopyId))
IF object_id('tempdb.dbo.#ToBeAgedACM') IS NOT NULL DROP TABLE #ToBeAgedACM
CREATE TABLE #ToBeAgedACM (
	archChunkId BIGINT, acCommcellId INT, archFileId INT, afCommCellId INT, archCopyId INT, physicalSize BIGINT, isAged INT, dedupSize BIGINT, JobId INT, appSizeFreedBytes BIGINT,
	PRIMARY KEY (archChunkId, acCommcellId, archFileId, afCommCellId, archCopyId))
IF object_id('tempdb.dbo.#ToBeAgedAC') IS NOT NULL DROP TABLE #ToBeAgedAC
CREATE TABLE #ToBeAgedAC (
	archChunkId BIGINT, commCellId INT, archCopyId INT, volumeId INT, version INT,
	cclip varchar(255), physicalSize BIGINT, isAged INT,
	SIDBStoreId INT, isMagnetic INT, MountPathId INT, allAFsAged INT,
 	PRIMARY KEY (archChunkId, commCellId, archCopyId))
IF object_id('tempdb.dbo.#NotAgedAC') IS NOT NULL DROP TABLE #NotAgedAC
CREATE TABLE #NotAgedAC (archChunkId BIGINT, commCellId INT, isAged INT)
IF object_id('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL DROP TABLE #tmpJobSizeInfo
CREATE TABLE #tmpJobSizeInfo (
	JobId INT, CommCellId INT, totalBackupSize BIGINT, totalAppSize BIGINT, totalIndexSize BIGINT
 	PRIMARY KEY (JobId, CommCellId))
IF object_id('tempdb.dbo.#ToBeAgedAFCWithoutChunks') IS NOT NULL DROP TABLE #ToBeAgedAFCWithoutChunks
CREATE TABLE #ToBeAgedAFCWithoutChunks (
	archFileId INT, commCellId INT, archCopyId INT, SIDBStoreId INT, isAged INT
	PRIMARY KEY (archFileId, commCellId, archCopyId))
CREATE INDEX Idx_tmpToBeAgedAFCWithoutChunks_1 ON #ToBeAgedAFCWithoutChunks (SIDBStoreId)
IF object_id('tempdb.dbo.#removableMedia') IS NOT NULL DROP TABLE #removableMedia
CREATE TABLE #removableMedia (volId INT)
--BEGIN TRY
--IF (@i_dummy = 1)
	BEGIN
		-- Do not delete archFileCopy entries if they are sent for copying to MA both on source or destination copy
		DELETE  T
		FROM	JMAdminJobInfoTable JA WITH (READUNCOMMITTED), archChunkToReplicate R WITH (READUNCOMMITTED), #ToBeAgedAFC T, archFileCopy AFC WITH (READUNCOMMITTED)
		WHERE	JA.JobId = R.adminJobId
				AND JA.opType = 104 /*AUXCOPY2*/
				AND R.archFileId = T.archFileId
				AND R.commcellId = T.commcellId
				AND R.destCopyId = T.archCopyId
AND R.Status = 1
				AND T.archFileId = AFC.archFileId
				AND T.commcellId = AFC.commCellId
				AND T.archCopyId = AFC.archCopyId
				AND AFC.isValid = 0
		DELETE  T
		FROM	JMAdminJobInfoTable JA WITH (READUNCOMMITTED), archChunkToCopyHistory R WITH (READUNCOMMITTED), #ToBeAgedAFC T, archFileCopy AFC WITH (READUNCOMMITTED)
		WHERE	JA.JobId = R.adminJobId
				AND JA.opType = 13 /*AUXCOPY*/
				AND R.archFileId = T.archFileId
				AND R.commcellId = T.commcellId
				AND R.destCopyId = T.archCopyId
				AND T.archFileId = AFC.archFileId
				AND T.commcellId = AFC.commCellId
				AND T.archCopyId = AFC.archCopyId
				AND AFC.isValid = 0
AND (R.extraFlags & 2) = 0
	END
	-- Prune the corresponding archive files on transitive copy
	INSERT INTO #ToBeAgedAFCOnTransitiveCopy
	SELECT	A.archFileId, A.CommCellId, M.targetCopyId
	FROM	#ToBeAgedAFC A, archCopyMediaRefreshProp M  WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
	WHERE	A.archCopyId = M.CopyId
			AND A.archFileId = AFC.archFileId
			AND A.commcellId = AFC.commcellId
			AND M.targetCopyId = AFC.archCopyId
			--AND AFC.flags & CVA_AGED_DATA_FLAG = 0
	INSERT INTO #ToBeAgedAFCOnTransitiveCopy
	SELECT	A.archFileId, A.CommCellId, M.targetCopyId
	FROM	#ToBeAgedAFC A, archGroupCopy AGC WITH (NOLOCK), archCopyMediaRefreshProp M  WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
	WHERE	A.archCopyId = AGC.id
			AND AGC.destMediaCopyId = M.CopyId
			AND A.archFileId = AFC.archFileId
			AND A.commcellId = AFC.commcellId
			AND M.targetCopyId = AFC.archCopyId
			AND AGC.destMediaCopyId > 0
	-- Get chunks of pruneable archive files
	INSERT	INTO #ToBeAgedACM
SELECT	ACM.archChunkId, ACM.chunkCommcellId, ACM.archFileId, ACM.commCellId, ACM.archCopyId, ACM.physicalSize, (ACM.flags & 256), ACM.dedupedSize, ACM.JobId, ACM.unCompSize
	FROM	#ToBeAgedAFC T, archChunkMapping ACM WITH(NOLOCK)
	WHERE	ACM.archFileId = T.archFileId AND ACM.commCellId = T.commCellId AND ACM.archCopyId = T.archCopyId
	UNION
SELECT	ACM.archChunkId, ACM.chunkCommcellId, ACM.archFileId, ACM.commCellId, ACM.archCopyId, ACM.physicalSize, (ACM.flags & 256), ACM.dedupedSize, ACM.JobId, ACM.unCompSize
	FROM	#ToBeAgedAFCOnTransitiveCopy T, archChunkMapping ACM WITH(NOLOCK)
	WHERE	ACM.archFileId = T.archFileId AND ACM.commCellId = T.commCellId AND ACM.archCopyId = T.archCopyId
IF (@i_dummy != 1)
	BEGIN
		--Get all archive files without any chunks to populate MMDeletedAF table
		INSERT INTO #ToBeAgedAFCWithoutChunks
		SELECT T.archFileId, T.commCellId, T.archCopyId, 0, 0
		FROM #ToBeAgedAFC T LEFT OUTER JOIN archChunkMapping ACM WITH (NOLOCK)
		ON 	T.archFileId = ACM.archFileId
		AND	T.commCellId = ACM.commCellId
		AND 	T.archCopyId = ACM.archCopyId
		WHERE	ACM.archFileId IS NULL
		--Get the SIDBStoreId for archive files
		UPDATE #ToBeAgedAFCWithoutChunks
		SET	SIDBStoreId = AFCD.SIDBStoreId
		FROM 	#ToBeAgedAFCWithoutChunks T, archFileCopyDedup AFCD WITH (NOLOCK)
		WHERE	T.archFileId = AFCD.archFileId
		AND	T.commCellId = AFCD.commCellId
		AND 	T.archCopyId = AFCD.archCopyId
		--Get AGED status of archive files
		UPDATE #ToBeAgedAFCWithoutChunks
SET	isAged = (AFC.flags & 256)
		FROM 	#ToBeAgedAFCWithoutChunks T, archFileCopy AFC WITH (NOLOCK)
		WHERE	T.archFileId = AFC.archFileId
		AND	T.commCellId = AFC.commCellId
		AND 	T.archCopyId = AFC.archCopyId
	END
	INSERT	INTO #ToBeAgedAC
SELECT	AC.id, AC.commCellId, T.archCopyId, AC.volumeId, AC.version, AC.cclip, AC.physicalSize, (AC.flags & 256),
0, 0, 0, (1 + 256)
	FROM	(SELECT DISTINCT archChunkId, acCommCellId, archCopyId FROM #ToBeAgedACM) T,
			archChunk AC WITH(NOLOCK)
	WHERE	AC.id = T.archChunkId AND AC.commCellId = T.acCommCellId
IF (@i_dummy = 1)
	BEGIN
		UPDATE	archFileSubStore
SET		flags = FS.flags | 8
		FROM	archFileSubStore FS, archCopySIDBStore AGC WITH (NOLOCK), #ToBeAgedAFC C
		WHERE	FS.archFileId = C.archFileId
				AND FS.CommCellId = C.CommCellId
				AND FS.SIDBStoreId = AGC.SIDBStoreId
				AND AGC.CopyId = C.archCopyId
    	INSERT INTO archFileMarkedForRecopy
	    SELECT A.archFileId, A.commCellId, A.archCopyId, A.flags, 0, A.physicalSize, A.logicalSize, A.mediaType, @currentTime, 0, 0, ''
	    FROM	#ToBeAgedAFC T, archFileCopy A WITH (NOLOCK)
		    	INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AGC.id = A.archCopyId
			LEFT OUTER JOIN archFileMarkedForRecopy AFMR WITH (NOLOCK) ON AFMR.archFileId = A.archFileId AND AFMR.archCopyId = A.archCopyId AND AFMR.commCellId = A.commCellId
	    WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commCellId AND A.archCopyId = T.archCopyId
AND (((AGC.dedupeFlags & 524288) > 0) OR ((AGC.dedupeFlags & 8388608) > 0))
AND (AGC.dedupeFlags & 1073741824) > 0
			AND AFMR.archFileId = null
	END
	-- Flag magnetic chunks
	UPDATE	#ToBeAgedAC
	SET 	isMagnetic = 1, SIDBStoreId = V.SIDBStoreId, MountPathId = MP.MountPathId
	FROM	#ToBeAgedAC T, MMVolume V WITH (NOLOCK), MMMountPath MP WITH (NOLOCK)
	WHERE	T.volumeId = V.VolumeId
AND V.RecordingFormatId = 10001
		AND V.MediaSideId = MP.MediaSideId
	IF @@ERROR = 0 AND @@ROWCOUNT > 0
		SET @hasMagnetic = 1
	IF EXISTS (SELECT 1 FROM MMConfigs WITH (READUNCOMMITTED) WHERE (name = 'MMS2_CONFIG_ENABLE_REMOVABLE_MEDIA_PRUNING') AND value > 0)
	BEGIN
		INSERT INTO #removableMedia
		SELECT DISTINCT V.VolumeId
		FROM 	#ToBeAgedAC T, MMVolume V WITH (NOLOCK), MMMedia M WITH (NOLOCK)
		WHERE	T.volumeId = V.VolumeId AND V.MediaId = M.MediaId
AND (M.MediaTypeId >= 11001 AND M.MediaTypeId <= 11999)
		UPDATE	#ToBeAgedAC
		SET		isMagnetic = 1,
		isAged = 0
		FROM	#ToBeAgedAC T
			LEFT OUTER JOIN MMDeletedAF D WITH (NOLOCK) ON T.archChunkId = D.archChunkId AND T.commCellId = D.chunkCommCellId
			INNER JOIN  #removableMedia V ON T.volumeId = V.VolId
		WHERE
		D.archChunkId IS NULL
		IF @@ERROR = 0 AND @@ROWCOUNT > 0 AND @hasMagnetic = 0
		BEGIN
			SET @hasMagnetic = 1
		END
	END
	-- Calculate appSizeFreedBytes ONLY for dedupe data
	INSERT INTO #tmpJobSizeInfo
	SELECT DISTINCT ACM.JobId, ACM.afCommcellId, 0, 0, 0
	FROM	#ToBeAgedACM ACM, #ToBeAgedAC AC
	WHERE	ACM.archChunkId = AC.archChunkId
	AND 	ACM.acCommcellId = AC.commCellId
	AND 	AC.SIDBStoreId > 0 AND ACM.appSizeFreedBytes = -1
	-- Get totalBackupSize, totalAppSize, totalIndexSize for dedupe jobs
	EXEC archGetJobSizeInfo 0
	UPDATE #ToBeAgedACM
	SET		appSizeFreedBytes = (CASE WHEN JI.totalBackupSize > 0
																	THEN CAST(((@oneConstReal * (JI.totalAppSize + JI.totalIndexSize) * ACM.physicalSize) / JI.totalBackupSize) AS BIGINT)
																	ELSE ACM.physicalSize
															END)
	FROM	#ToBeAgedACM ACM, #tmpJobSizeInfo JI
	WHERE ACM.JobId = JI.JobId
	AND  	ACM.afCommcellId = JI.CommCellId
	AND ACM.appSizeFreedBytes = -1
	-- Delete archFileCopy and archChunkMapping entries
	DELETE	archFileCopy
	FROM	#ToBeAgedAFC T, archFileCopy A
	WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commCellId AND A.archCopyId = T.archCopyId
	DELETE	archFileCopy
	FROM	#ToBeAgedAFCOnTransitiveCopy T, archFileCopy A
	WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commCellId AND A.archCopyId = T.archCopyId
	--Delete archive files from archVSAAppAFLink table before deleting from archFile table
	DELETE	archVSAAppAFLink
	FROM	#ToBeAgedAFC T, archVSAAppAFLink A
	WHERE	A.childAFId = T.archFileId AND A.commCellId = T.commCellId
	AND NOT EXISTS (SELECT * FROM archFileCopy C WITH (NOLOCK)
					WHERE	C.archFileId = T.archFileId AND C.commCellId = T.commCellId)
	DELETE	archVSAAppAFLink
	FROM	#ToBeAgedAFC T, archVSAAppAFLink A
	WHERE	A.ParentIndexAFId = T.archFileId AND A.commCellId = T.commCellId
	AND NOT EXISTS (SELECT * FROM archFileCopy C WITH (NOLOCK)
					WHERE	C.archFileId = T.archFileId AND C.commCellId = T.commCellId)
	-- Remove archive files which do not exist in any copy from archFile table.
	DELETE	archFile
	FROM	#ToBeAgedAFC T, archFile A
	WHERE	A.id = T.archFileId AND A.commCellId = T.commCellId
	AND NOT EXISTS (SELECT * FROM archFileCopy C WITH (NOLOCK)
					WHERE	C.archFileId = T.archFileId AND C.commCellId = T.commCellId)
	-- Flag if remaining archive files are all aged:
	-- allAFsAged = LOCAL_NO_AF_REMAIN_FLAG if no entry remain in archChunkMapping table for a chunk.
	-- allAFsAged = CVA_AGED_DATA_FLAG if all remaning archChunkMapping table entries are aged.
	-- allAFsAged = 0 if some remaining archChunkMapping table entries are not aged.
	INSERT	INTO #NotAgedAC
SELECT	A.archChunkId, A.chunkCommCellId, MIN(A.flags & 256)
	FROM	#ToBeAgedAC T, archChunkMapping A WITH (NOLOCK)
	WHERE	A.archChunkId = T.archChunkId AND A.chunkCommCellId = T.commCellId
	GROUP BY A.archChunkId, A.chunkCommCellId
	UPDATE	#ToBeAgedAC
	SET		allAFsAged = (T.allAFsAged & N.isAged)
	FROM	#ToBeAgedAC T, #NotAgedAC N
	WHERE	T.archChunkId = N.archChunkId AND T.commCellId = N.commCellId
	-- Delete chunks which have no more archive files.
	DELETE	archChunk
	FROM	#ToBeAgedAC T, archChunk A
	WHERE	A.id = T.archChunkId AND A.commCellId = T.commCellId
AND	T.allAFsAged & 1 <> 0
	-- Set aged flag if only aged archive files remain in a chunk.
	UPDATE	archChunk
SET		flags = (A.flags | 256), agedBy = (agedBy | 2048), modifiedTime = @currentTime
	FROM	#ToBeAgedAC T, archChunk A
	WHERE	A.id = T.archChunkId AND A.commCellId = T.commCellId
AND	A.flags & 256 = 0
AND	T.allAFsAged = 256
	---------------------------------------------------------
	-- Prune snap records after archfilecopy table is pruned
	---------------------------------------------------------
	declare @tblRtn table (retVal int)
	insert into @tblRtn
	EXEC @retVal = archPruneVolSnaps 0, 0
	if @retVal <> 0 GOTO CX_EXIT
	---------------------------------------------------------
	-- For archive files prior to 5.0
	-- Keep appSizeFreedBytes = 0 since these are older version archive files without dedupe
	IF @hasMagnetic = 1
	INSERT	INTO MMDeletedAF
	SELECT	A.archFileId, B.volumeId, 0, 0, A.archCopyId, B.cclip, SUM(A.physicalSize),
			0, B.MountPathId, 0, A.afCommCellId, @currentTime, 0, 0, 0, 0, 0, A.acCommCellId
	FROM	#ToBeAgedACM A, #ToBeAgedAC B
	WHERE	A.archChunkId = B.archChunkId AND A.acCommCellId = B.commCellId
		AND A.isAged = 0
		AND B.isMagnetic = 1
		AND B.version < 3
	GROUP	BY A.archFileId, B.volumeId, A.archCopyId, B.cclip, A.afCommCellId, B.MountPathId, A.acCommCellId
	-- For CV-Single-Instanced archive files
	-- Set appSizeFreedBytes only for dedupe chunks
	INSERT	INTO MMDeletedAF
SELECT	(case when @i_dummy = 1 then 0x7FFFFFFF else A.archFileId end), B.volumeId, 0, 0, A.archCopyId, B.cclip, A.dedupSize,
A.archChunkId, B.MountPathId, B.SIDBStoreId, (case when @i_dummy = 1 then 0 else A.afCommCellId end), @currentTime, 0, 0, 0, A.appSizeFreedBytes, 0, A.acCommCellId
	FROM	#ToBeAgedACM A, #ToBeAgedAC B
	WHERE	A.archChunkId = B.archChunkId AND A.acCommCellId = B.commCellId
		AND A.isAged = 0
		AND B.SIDBStoreId > 0
	INSERT INTO MMDeletedAF
	SELECT	archFileId, 0, 0, 0, archCopyId, 0, 0, 0, 0, SIDBStoreId, commCellId, @currentTime, 0, 0, 0, 0, 0, 0
	FROM 	#ToBeAgedAFCWithoutChunks
	WHERE	SIDBStoreId > 0
	AND	isAged = 0
	-- Filter out chunks which still have non-aged archive files.
	DELETE	#ToBeAgedAC
	WHERE	allAFsAged = 0
	-- Keep appSizeFreedBytes = 0 for non dedupe chunks
	IF @hasMagnetic = 1
	INSERT	INTO MMDeletedAF
	SELECT	0, volumeId, 0, 0, archCopyId, cclip, physicalSize,
			archChunkId, #ToBeAgedAC.MountPathId, 0, 0, @currentTime, 0, 0, 0, 0, 0, commCellId
	FROM	#ToBeAgedAC
	WHERE	isAged = 0
		AND isMagnetic = 1
		AND version >= 3
		AND SIDBStoreId = 0
	-- Keep appSizeFreedBytes = 0 for non magnetic chunks
	INSERT	INTO MMDeletedAF
	SELECT	0, volumeId, 0, 0, archCopyId, '', SUM(physicalSize),
			0, 0, 0, 0, @currentTime, 0, 0, 0, 0, 0, commCellId
	FROM	#ToBeAgedAC
	WHERE	isAged = 0
		AND isMagnetic = 0
		AND SIDBStoreId = 0
	GROUP BY volumeId, archCopyId, commCellId
	SET @magneticBytes = (
		SELECT	SUM(physicalSize)
		FROM	#ToBeAgedAC
		WHERE	isAged = 0
			AND isMagnetic = 1)
--Try catch is disable to figure which query failed. MR 42524.
--END TRY
--BEGIN CATCH
--	SET @retVal = (SELECT ERROR_NUMBER())
--END CATCH
CX_EXIT:
IF object_id('tempdb.dbo.#ToBeAgedAFCOnTransitiveCopy') IS NOT NULL DROP TABLE #ToBeAgedAFCOnTransitiveCopy
IF object_id('tempdb.dbo.#ToBeAgedACM') IS NOT NULL DROP TABLE #ToBeAgedACM
IF object_id('tempdb.dbo.#ToBeAgedAC') IS NOT NULL DROP TABLE #ToBeAgedAC
IF object_id('tempdb.dbo.#NotAgedAC') IS NOT NULL DROP TABLE #NotAgedAC
IF object_id('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL DROP TABLE #tmpJobSizeInfo
IF object_id('tempdb.dbo.#ToBeAgedAFCWithoutChunks') IS NOT NULL DROP TABLE #ToBeAgedAFCWithoutChunks
IF object_id('tempdb.dbo.#removableMedia') IS NOT NULL DROP TABLE #removableMedia
RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'archFileDeleteViaTable')
	delete from GxQscripts where name = 'archFileDeleteViaTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileDeleteViaTable')
	delete from GXDBVersions where aliasname = 'archFileDeleteViaTable'
GO

insert into GXDBVersions values(2, 'archFileDeleteViaTable',  '00010049000200100000', 'archFileDeleteViaTable', '00010049000200100000')
GO

