

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileDDBPostRestoreVerify.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileDDBPostRestoreVerify.sp,v $ $Id: archFileDDBPostRestoreVerify.sp,v 1.1.2.5 2018/07/31 16:03:08 anarulkar Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "archFileDDBPostRestoreVerify"		|
--	|									|
--	| Execute the stored procedure to fetch the pruned archfiles		|
--	| .. which are recopied.						|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archFileDDBPostRestoreVerify <<<'

IF EXISTS (select * from sysobjects where name='archFileDDBPostRestoreVerify')
	drop procedure archFileDDBPostRestoreVerify
IF EXISTS (select * from GxQscripts where name='archFileDDBPostRestoreVerify')
	delete from GxQscripts where name = 'archFileDDBPostRestoreVerify'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileDDBPostRestoreVerify')
	delete from GXDBVersions where aliasname = 'archFileDDBPostRestoreVerify'
GO
print '... Creating Procedure: archFileDDBPostRestoreVerify'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archFileDDBPostRestoreVerify
  @i_jobId int,
  @i_SIDBStoreId int,
  @i_mode int,
  @i_afXML NVARCHAR(MAX)
AS
  DECLARE @o_SIDBStoreId int
  DECLARE @o_SubStoreId int
  DECLARE @o_archFileId bigint
  DECLARE @o_isValid int
SET NOCOUNT ON
DECLARE     @retVal     INTEGER = 0
DECLARE @handle                 int
EXEC sp_xml_preparedocument @handle OUTPUT, @i_afXML
if object_id('tempdb.dbo.#receivedAFTempFromSIDB') is not null DROP TABLE #receivedAFTempFromSIDB
CREATE TABLE #receivedAFTempFromSIDB (SIDBStoreId int, SubStoreId int, archFileId bigint, isValid int)
CREATE TABLE #SubStoreBackupTime (SubStoreId int, BackupTime int)
    INSERT INTO #receivedAFTempFromSIDB
    SELECT @i_SIDBStoreId, T.SubStoreId, T.archFileId, 1
    FROM OPENXML(@handle, '/SIDBAFVerifyXML/AF', 0)
    WITH   (archFileId      int '@AFId',
        SubStoreId        int '@SubStoreId') T
    IF @i_jobId = 0
    BEGIN
	-- we do not know which partitions are in recon. get all partitions DDB backup time.
	INSERT INTO #SubStoreBackupTime
	SELECT S.SubStoreId, S.LastSnapTime
	FROM IdxSIDBSubStore S WITH (READUNCOMMITTED)
	WHERE S.SIDBStoreId = @i_SIDBStoreId
    END
    ELSE
    BEGIN
	INSERT INTO #SubStoreBackupTime
	SELECT S.SubStoreId, S.LastSnapTime
	FROM IdxSIDBSubStore S WITH (READUNCOMMITTED),
             (
            	  SELECT sb.value('@val', 'INT') AS t_substoreId
	          FROM
                  (
                	        select CAST(value AS XML) AS xmlstr
                        	from dbo.GetAllJobOptions(@i_jobId)
	                        where optionId=34449693 -- DEDUPDBSYNCOPTION__SUB_STORE_ID_LIST
        	  ) AS O
                  CROSS APPLY O.xmlstr.nodes ('SubStoreIdList') R(sb)
	     ) T
	    WHERE S.SIDBStoreId = @i_SIDBStoreId
		AND S.SubStoreId = T.t_substoreId
    END
    -- Find if there are any AFs given by SIDB for which the first Chunk's create Time is greater than the DDB Backup time. Those chunks are indication of reappearing AF.
    UPDATE T
    SET isValid = 0
    FROM #receivedAFTempFromSIDB T, #SubStoreBackupTime ST, archFileCopyDedup AFCD WITH (READUNCOMMITTED)
		LEFT OUTER JOIN archChunkMapping ACM WITH (READUNCOMMITTED) ON AFCD.archFileId = ACM.archFileId AND AFCD.archCopyId = ACM.archCopyId
				AND AFCD.commCellId = ACM.commCellId AND ACM.chunkNumber = 1
		LEFT OUTER JOIN archChunk AC WITH (READUNCOMMITTED) ON ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
    WHERE T.SIDBStoreId = AFCD.SIDBStoreId AND T.archFileId = AFCD.archFileId
	AND T.SubStoreId = ST.SubStoreId
	AND (((AC.createTime - AC.writeTime) > ST.BackupTime) OR (ACM.archChunkId IS NULL))
IF @i_mode = 0
BEGIN
	SELECT TOP 1 SIDBStoreId, SubStoreId, archFileId, isValid
	FROM #receivedAFTempFromSIDB
	WHERE isValid = 0
END
ELSE
BEGIN
	SELECT SIDBStoreId, SubStoreId, archFileId, isValid
	FROM #receivedAFTempFromSIDB
END
if object_id('tempdb.dbo.#receivedAFTempFromSIDB') is not null DROP TABLE #receivedAFTempFromSIDB
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archFileDDBPostRestoreVerify')
	delete from GxQscripts where name = 'archFileDDBPostRestoreVerify'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileDDBPostRestoreVerify')
	delete from GXDBVersions where aliasname = 'archFileDDBPostRestoreVerify'
GO

insert into GXDBVersions values(2, 'archFileDDBPostRestoreVerify',  '00010001000200050000', 'archFileDDBPostRestoreVerify', '00010001000200050000')
GO

