

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileCreate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileCreate.sp,v $ $Id: archFileCreate.sp,v 1.62.12.27 2020/12/04 18:27:21 anarulkar Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archFileCreate')
BEGIN
	print '>>> Drop Stored Procedure: archFileCreate <<<'
	drop procedure archFileCreate
END
IF EXISTS (select * from GxQscripts where name='archFileCreate')
	delete from GxQscripts where name = 'archFileCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileCreate')
	delete from GXDBVersions where aliasname = 'archFileCreate'
GO
print '... Creating Procedure: archFileCreate'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archFileCreate
  @i_name NVARCHAR(2048),
  @i_commCellId int,
  @i_archGroupId int,
  @i_objName varchar(2048),
  @i_flags int,
  @i_appId int,
  @i_fileType int,
  @i_cTime int,
  @i_jobId int,
  @i_backupLevel int,
  @i_isValid int,
  @i_encRSA int,
  @i_encKeyType int,
  @i_encKey varchar(1024),
  @i_archCopyId int,
  @i_AFC_flags int,
  @i_clientId int,
  @i_appTypeId int,
  @i_instanceId int,
  @i_destRCId int,
  @i_destStreamNum int,
  @i_encKeyid int = 0
AS
  DECLARE @o_archFileId integer;
  DECLARE @o_cTime integer;
  DECLARE @o_reserved integer;
  DECLARE @o_encRSA int;
  DECLARE @o_encKeyType int;
  DECLARE @o_encKey varchar(1024);
  DECLARE @o_currPhysicalSize bigint;
  DECLARE @o_currLogicalSize bigint;
  DECLARE @o_encKeyid int;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@l_clientId		int
DECLARE @l_instanceId	int
DECLARE @l_name			NVARCHAR(2048)
DECLARE @l_instName		varchar(2048)
DECLARE @l_drivePoolId	int = 0
DECLARE @l_cTime		int
SET		@l_cTime		= @i_cTime
DECLARE	@l_origCCId		int
SET		@l_origCCId		= @i_commCellId
DECLARE @l_origCCType	int
SET		@l_origCCType	= 1
DECLARE @l_jobIdOfSnapJob int
SET		@l_jobIdOfSnapJob = 0
DECLARE @l_isSnapCopy int
SET		@l_isSnapCopy = 0
DECLARE @l_SIDBStoreId int
SET		@l_SIDBStoreId = 0
/*
There have been issue cases where ida ends up creating archive files across multiple appIds for same job. Which is not supported. Currently it creates archive file and
eventually fails in a different part of code causing primary key violation.
Adding this validation here to fail the archive file creation itself.
*/
DECLARE @l_existingAFId INT = 0
DECLARE @l_existingAppId INT = 0
SELECT @l_existingAFId = AF.id, @l_existingAppId = AF.appId
FROM ArchFile AF WITH(NOLOCK) WHERE AF.jobId = @i_jobId AND AF.commcellId = @i_commCellId AND AF.appId <> @i_appId
IF (@l_existingAFId > 0)
BEGIN
	RAISERROR('Archive file Id [%d] exists with a different AppId [%d] for same input JobId/CommcellId [%d/%d]. Cannot create new archive file with AppId [%d]', 16, 1, @l_existingAFId, @l_existingAppId, @i_jobId, @i_commCellId, @i_appId)
	GOTO FINISH
END
SELECT	@l_isSnapCopy = isSnapCopy
FROM	archGroupCopy WITH (READUNCOMMITTED)
WHERE	id = @i_archCopyId
SELECT @l_SIDBStoreId = SIDBStoreId
FROM	archSubclientCopyDDBMap WITH (READUNCOMMITTED)
WHERE	appId = @i_appId
		AND copyId = @i_archCopyId
IF (@i_destRCId > 0)
BEGIN
	SELECT	TOP 1 @l_drivePoolId = R.DrivePoolId
		FROM	MMResource R WITH (NOLOCK), MMResourceToJob RJ WITH (NOLOCK)
		WHERE	R.ReservationId = RJ.ReservationId
				AND RJ.RCID = @i_destRCId
END
IF	@l_isSnapCopy = 0 AND (@i_flags & 2) = 2
SET @i_flags = (@i_flags | 4194304)
-- Set CVA_AF_CLOUD_PAAS_FLAG for Cloud PaaS backup archive files
IF (@i_fileType IN (1, 4) AND EXISTS (	SELECT componentNameId
																				FROM APP_SubclientProp WITH (NOLOCK)
																				WHERE	componentNameId = @i_appId
																				AND 	attrName = N'Cloud PaaS Backup Enabled'
																				AND 	cs_attrName = CHECKSUM(N'Cloud PaaS Backup Enabled')
																				AND		attrVal = '1'
																				AND		modified = 0
																      )
)
BEGIN
SET @i_flags = (@i_flags | 134217728)
END
DECLARE @l_JMBkpAttributesEx BIGINT
SET @l_JMBkpAttributesEx = 0
SELECT	@l_JMBkpAttributesEx = bkpAttributesEx
FROM	JMBkpJobInfo WITH (NOLOCK)
WHERE	jobId = @i_jobId  AND commCellId = @i_commCellId
IF	@i_commCellId = 2
	SELECT	@l_jobIdOfSnapJob = jobId, @l_origCCId = commCellId
	FROM	JMPreparedJob WITH (NOLOCK)
	WHERE	miningJobId = @i_jobId
IF	@l_origCCId > 2
	SELECT	@l_origCCType = type
	FROM	APP_CommCell WITH (NOLOCK)
	WHERE	id = @l_origCCId
IF @l_jobIdOfSnapJob = 0
BEGIN
	DECLARE @l_opType	int
	SET		@l_opType	= 0
	SELECT	@l_opType = opType
	FROM	JMJobInfo WITH (NOLOCK)
	WHERE	jobId = @i_jobId  AND commCellId = @i_commCellId
	IF	@l_opType = 0
		SELECT	@l_opType = opType, @l_cTime = servStartDate
		FROM	JMBkpStats WITH (NOLOCK)
		WHERE	jobId = @i_jobId  AND commCellId = @i_commCellId
	-- Code for snapbackups - make sure that the ctime of the materialized
	-- index archfile is the same as the SNAPSHOT meta index archive file
	IF	@l_opType IN (59, 65)
		SET @l_jobIdOfSnapJob = @i_jobId
	ELSE
	IF	@l_opType = 60
		SELECT	@l_jobIdOfSnapJob = processedJobId
		FROM	JMJobWF WITH (NOLOCK)
		WHERE	childJobId = @i_jobId AND commCellId = @i_commCellId
	IF	@@ERROR <> 0 GOTO FINISH
END
SELECT	@l_clientId = clientId, @i_appTypeId = appTypeId, @l_instanceId = instance
FROM	APP_application WITH (NOLOCK)
WHERE	id = @i_appId
IF	@l_jobIdOfSnapJob > 0 AND @l_cTime = @i_cTime
BEGIN
	/*Note the final else if block here that has to be executed for delayed
	 cataloging job when the file type is bcd index. Please take care of that when any change made to the conditions here*/
	IF	@l_origCCType > 1
	BEGIN
		-- For foreign snapshot job - use job start time as creation time of archive file
		SELECT	@l_cTime = servStartDate
		FROM	JMBkpStats WITH (NOLOCK)
		WHERE	jobId = @l_jobIdOfSnapJob AND commCellId = @l_origCCId
	END
	ELSE
IF  (((@l_opType = 60) OR ((@l_opType IN (59, 65)) AND (dbo.GetOptionInt(1848338092, @l_jobIdOfSnapJob, 0, 0) = 1)))
AND (@i_fileType IN (1, 4))
AND (@l_JMBkpAttributesEx & 0x800000 = 0))
	BEGIN
		SELECT	TOP 1 @l_cTime = cTime
		FROM	archFile WITH (NOLOCK)
		WHERE 	jobId = @l_jobIdOfSnapJob AND commCellId = @i_commCellId
			AND archGroupId = @i_archGroupId
			AND fileType = @i_fileType AND isValid = 1
		ORDER BY cTime
	END
	ELSE
IF(@i_fileType IN(2, 6))
    BEGIN
    	DECLARE @l_isIndexingV2Enabled int = 0
    	SELECT @l_isIndexingV2Enabled = dbo.IsIndexingV2Enabled(0, 0, @i_appId)
    	IF(@l_isIndexingV2Enabled = 0) --For new indexing type ctime should not be overridden
    	BEGIN
IF (@i_fileType = 2)
			BEGIN
				IF ((@i_appTypeId = 61) AND NOT EXISTS(
						SELECT *
						FROM	archFile WITH (NOLOCK)
						WHERE 	jobId = @l_jobIdOfSnapJob AND commCellId = @i_commCellId
						AND archGroupId = @i_archGroupId
AND fileType = 2 AND isValid = 1))
				BEGIN
					SELECT	TOP 1 @l_cTime = cTime - 1
					FROM	archFile WITH (NOLOCK)
					WHERE 	jobId = @l_jobIdOfSnapJob AND commCellId = @i_commCellId
						AND archGroupId = @i_archGroupId
AND fileType = 6 AND isValid = 1
					ORDER BY cTime DESC
					IF	@@ROWCOUNT = 0
						SELECT	@l_cTime = servEndDate - 1
						FROM	JMBkpStats WITH (NOLOCK)
						WHERE	jobId = @l_jobIdOfSnapJob AND commCellId = @i_commCellId
				END
				ELSE
				BEGIN
					SELECT	TOP 1 @l_cTime = cTime
					FROM	archFile WITH (NOLOCK)
					WHERE 	jobId = @l_jobIdOfSnapJob AND commCellId = @i_commCellId
						AND archGroupId = @i_archGroupId
AND fileType = 6 AND isValid = 1
					ORDER BY cTime DESC
					IF	@@ROWCOUNT = 0
						SELECT	@l_cTime = servEndDate
						FROM	JMBkpStats WITH (NOLOCK)
						WHERE	jobId = @l_jobIdOfSnapJob AND commCellId = @i_commCellId
				END
			END
			ELSE
IF (@i_fileType = 6)
			BEGIN
				--If delayed catalog then use the max created time of the data AF of the snap job as the created time for the bcd index AF
				DECLARE @l_subopType int
				SET @l_subopType = 0
				SELECT @l_subopType = subOpType FROM
				JMJobInfo WITH (NOLOCK)
				WHERE jobId = @i_jobId AND commCellId = @i_commCellId
				--enum CVOpType {DELAYEDCATALOG = 96,};
				IF @l_subopType = 96
				BEGIN
					DECLARE @l_snapJobIdOfDelayedCatalogJob int
					SET @l_snapJobIdOfDelayedCatalogJob = 0
					SELECT @l_snapJobIdOfDelayedCatalogJob = processedJobId
					FROM JMJobWF WITH (NOLOCK) WHERE childJobId = @i_jobId AND commcellId = @i_commCellId
					IF @l_snapJobIdOfDelayedCatalogJob > 0
						SELECT	TOP 1 @l_cTime = (cTime + 1)
						FROM	archFile WITH (NOLOCK)
						WHERE 	jobId = @l_snapJobIdOfDelayedCatalogJob AND commCellId = @i_commCellId
						AND archGroupId = @i_archGroupId
AND fileType = 1 AND isValid = 1
						ORDER BY cTime DESC
				END
			END
    	END
    END
	IF	@@ERROR <> 0 GOTO FINISH
END
IF	@l_jobIdOfSnapJob > 0 AND (@i_flags & 2) = 0 AND @i_fileType <> 6
SET @i_flags = (@i_flags | 4)
IF	@i_appTypeId = 3 AND (@i_name like '%.onconfig' OR @i_name like '%.oncfg' OR @i_name like '%.ixbar')
BEGIN
	SELECT	@l_instName = name
	FROM	APP_InstanceName WITH (NOLOCK)
	WHERE	id = @l_instanceId
	SET @l_name = @l_instName +
		(case	when @i_name like '%.onconfig'	then '.onconfig'
				when @i_name like '%.oncfg'		then '.oncfg'
				when @i_name like '%.ixbar'		then '.ixbar'	end)
	IF	@i_name = (CAST(@l_instanceId AS nvarchar(8)) + '.' + @l_name)
		SET @i_name = @l_name
END
IF (((@i_flags & 2097152) = 2097152) AND
	(@i_backupLevel = 2 /*INCR*/) AND
	NOT EXISTS (	SELECT	*
			FROm	MMConfigs WITH (NOLOCK)
			WHERE	name = 'MMCONFIG_IGNORE_ARCHFILE_REUSE' AND Value = 1))
BEGIN
	DECLARE @lastBackupLevel INTEGER = NULL
	DECLARE @streamNum INTEGER = NULL
DECLARE @retAFCreateIntervalMin INTEGER = 15
DECLARE @RetentionDaysWhenCyclesIgnored INTEGER = 30
	DECLARE	@l_edgeDriveAFCTime INTEGER = 0
	DECLARE	@l_archFileJobId INTEGER = 0
	DECLARE @l_DoNotReuseAF BIT = 0
	DECLARE @l_currPhysicalSize BIGINT = 0
	DECLARE @l_currLogicalSize BIGINT = 0
	IF (@i_destStreamNum > 0)
		SET	@streamNum = @i_destStreamNum
	ELSE IF (@i_destRCId > 0)
		SELECT	TOP 1 @streamNum = R.StreamId
		FROM	MMResource R WITH (NOLOCK), MMResourceToJob RJ WITH (NOLOCK)
		WHERE	R.ReservationId = RJ.ReservationId
				AND RJ.RCID = @i_destRCId
	ELSE
		SELECT	TOP 1 @streamNum = R.StreamId
		FROM	MMResource R WITH (NOLOCK), MMResourceToJob RJ WITH (NOLOCK)
		WHERE	R.ReservationId = RJ.ReservationId
				AND RJ.RCID = @i_instanceId
	SELECT	TOP 1 @o_archFileId = AF.id, @l_archFileJobId = AF.JobId, @lastBackupLevel = AF.backupLevel, @l_edgeDriveAFCTime = AF.CTime,
			@o_encRSA = AFC.encRSA, @o_encKeyType = AFC.encKeyType, @o_encKey = AFC.encKey, @o_encKeyId = AFC.encKeyId,
			@l_DoNotReuseAF =
			(
CASE WHEN (AF.flags & (256 | 1048576)) = 0
AND (AFC.flags & (256 | 8192)) = 0
						AND AF.isValid = 1
						AND AFC.isValid  = 1
AND (AC.flags & (256 | 8192 | 2048)) = 0
				THEN 0 ELSE 1 END
			) ,
			@l_currPhysicalSize = AFC.physicalSize, @l_currLogicalSize = AFC.logicalSize
	FROM	archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK), archChunkMapping ACM WITH (NOLOCK), archChunk AC WITH (NOLOCK)
	WHERE	appId = @i_appId
			AND AF.CommCellId = @i_commCellId
			AND AF.id = AFC.archFileId
			AND AF.CommCellId = AFC.CommCellId
			AND AFC.archCopyId = @i_archCopyId
			AND AFC.streamNum = @streamNum
			AND AFC.archFileId = ACM.archFileId
			AND AFC.CommCellId = ACM.CommCellId
			AND AFC.archCopyId = ACM.archCopyId
			AND AFC.lastChunkNumber = ACM.chunkNumber
			AND AC.id = ACM.archChunkId
			AND AC.CommCellId = ACM.chunkCommCellId
	ORDER BY AF.id DESC
SELECT	@RetentionDaysWhenCyclesIgnored = ISNULL(value, 30)
	FROM	MMConfigs WITH (NOLOCK)
	WHERE	name = 'DA_CONFIG_RETENTION_DAYS_WHEN_CYCLES_IGNORED'
SELECT	@retAFCreateIntervalMin = ISNULL(value, 15)
	FROM	MMConfigs WITH (NOLOCK)
	WHERE	name = 'DA_CONFIG_EDGEDRIVE_NEW_AF_CREATE_INTERVAL_IN_DAYS'
	-- Calculate the minimum retention days based copy the retention days
		-- If spool copy then use default days from config param DA_CONFIG_RETENTION_DAYS_WHEN_CYCLES_IGNORED
		-- If only cycles configured then use days from config param DA_CONFIG_RETENTION_DAYS_WHEN_CYCLES_IGNORED
		-- Otherwise min of retention days configured on all copies
	DECLARE @minRetDays INT = 0
	SELECT  @minRetDays = MIN(CASE WHEN ISNULL(retentionDays, 0) = 0 AND ISNULL(fullCycles, 0) = 0 THEN @retAFCreateIntervalMin
								WHEN ISNULL(retentionDays, 0) = 0 AND ISNULL(fullCycles, 0) > 0 THEN @RetentionDaysWhenCyclesIgnored
								ELSE retentionDays END)
	FROM	archGroupCopy AGC WITH (NOLOCK), archAgingRule AR WITH (NOLOCK)
	WHERE	AGC.archGroupId = @i_archGroupId
			AND isSnapCopy = 0
AND type != 5
			AND AGC.id = AR.copyId
			AND AR.retentionDays >= 0
	-- Pick the min days from above and config param DA_CONFIG_RETENTION_DAYS_WHEN_CYCLES_IGNORED
	SET	@minRetDays = CASE WHEN (@minRetDays > 0 AND @minRetDays > @retAFCreateIntervalMin) THEN @retAFCreateIntervalMin ELSE @minRetDays END
	-- if the default configured days for arch file recut is 0, then consider that as infinite otherwise us the calculated value
	IF ((@lastBackupLevel = 2 /*INCR*/)
		AND NOT EXISTS (SELECT  *
					FROM	archFileCopyDedup AFCD WITH (NOLOCK), IdxSIDBStore I WITH (NOLOCK)
					WHERE	AFCD.archFileId = @o_archFileId
							AND AFCD.CommCellId = @i_commCellId
							AND AFCD.SIDBStoreId = I.SIDBStoreId
							AND I.SealedTime != 0)
		AND (@minRetDays = 0 OR (DateAdd(d, @minRetDays, dbo.GetDateTime(@l_edgeDriveAFCTime)) >= GetUTCDate()))
		AND NOT EXISTS (SELECT TOP 1 * FROM JMBkpStats WITH (NOLOCK) WHERE	appId = @i_appId AND JobID > @l_archFileJobId AND CommCellId = @i_commCellId AND BkpLevel IN (1, 64, 128, 16384, 1024, 32768))
		AND NOT EXISTS (SELECT TOP 1 * FROM JMBkpJobInfo WITH (NOLOCK) WHERE applicationId = @i_appId AND JobID > @l_archFileJobId AND CommCellId = @i_commCellId AND BkpLevel IN (1, 64, 128, 16384, 1024, 32768))
		AND @l_DoNotReuseAF = 0
		)
	BEGIN
		UPDATE	archFile
SET		JobID = @i_jobId, flags |= 524288
		WHERE	id = @o_archFileId
				AND CommCellId = @i_commCellId
		UPDATE	archChunkMapping
		SET		JobID = @i_jobId
		WHERE	archFileId = @o_archFileId
				AND CommCellId = @i_commCellId
		/* MR:214061
		UPDATE	archFileCopy
		SET		isValid = 0
		WHERE	archFileId = @o_archFileId
				AND CommCellId = @i_commCellId
				AND archCopyId != @i_archCopyId
				AND isValid = 1
		*/
		IF (@o_encKeyType = 0 AND @i_encKeyType != 0)
		BEGIN
			UPDATE	archFileCopy
			SET		encRSA = @i_encRSA, encKeyType = @i_encKeyType, encKey = @i_encKey, encKeyId = @i_encKeyId
			WHERE	archFileId = @o_archFileId
					AND CommCellId = @i_commCellId
					AND archCopyId = @i_archCopyId
IF (@i_AFC_flags & 16) <> 0 AND @i_encKeyType > 0
			BEGIN
				INSERT	INTO archFileSIDBKeys
				SELECT	@o_archFileId, @i_commCellId, @i_archCopyId,
						case when @i_encKeyId > 0 then 0 else @i_encKeyType end,
						case when @i_encKeyId > 0 then '' else @i_encKey end,
						@l_SIDBStoreId,
						@i_encRSA,
						@i_encKeyId
			END
			SELECT	@o_archFileId, @l_edgeDriveAFCTime, 0, @i_encRSA, @i_encKeyType, @i_encKey, @l_currPhysicalSize, @l_currLogicalSize, @i_encKeyId
		END
		ELSE
			SELECT	@o_archFileId, @l_edgeDriveAFCTime, 0, @o_encRSA, @o_encKeyType, @o_encKey, @l_currPhysicalSize, @l_currLogicalSize, @i_encKeyId
		RETURN
	END
END
INSERT	INTO archFile
SELECT	@i_name, @i_commCellId, @i_archGroupId, @i_objName, @i_flags, @i_appId, @i_fileType,
		@l_cTime, @i_jobId, @i_backupLevel, @i_isValid, 0, 0, 0
IF	@@ERROR <> 0 GOTO FINISH
SET	@o_archFileId = ISNULL(SCOPE_IDENTITY(), 0)
IF	@o_archFileId = 0 GOTO FINISH
INSERT	INTO archFileCopy
SELECT	@o_archFileId, @i_commCellId, @i_archCopyId, @i_AFC_flags, @i_isValid, 0, 0, 0, 0, @l_drivePoolId,
		@i_encRSA, @i_encKeyType, @i_encKey, 0, 0, 0, @i_encKeyId, -1
IF	@@ERROR <> 0 GOTO FINISH
-- Enable this flag to indicate that an enc AF exists on copy. This will be used during auxCopy to indicate if decryption module needs to be brought up. Optimization.
IF (@i_encKeyType > 0)
BEGIN
	-- If AF is dedup, then set the flag on all the copies pointing to this store, else set it only on this copy.
IF (@i_AFC_flags & 16) <> 0
	BEGIN
		UPDATE	AGC
SET		extendedFlags = extendedFlags | 1024
		FROM	archGroupCopy AGC, archCopySIDBStore CS
		WHERE	AGC.id = CS.copyId
				AND CS.SIDBStoreId = @l_SIDBStoreId
AND (AGC.extendedFlags & 1024) = 0
AND ((CS.Flags & 4) > 0)
	END
	ELSE
	BEGIN
		UPDATE archGroupCopy
SET extendedFlags = extendedFlags | 1024
		WHERE id = @i_archCopyId
AND (extendedFlags & 1024) = 0
	END
END
IF	@@ERROR <> 0 GOTO FINISH
IF ((@i_AFC_flags & 16) <> 0 AND (@i_flags & 134217728) = 0)
BEGIN
	IF @i_encKeyType > 0
	BEGIN
		INSERT	INTO archFileSIDBKeys
		SELECT	@o_archFileId, @i_commCellId, @i_archCopyId,
				case when @i_encKeyId > 0 then 0 else @i_encKeyType end,
				case when @i_encKeyId > 0 then '' else @i_encKey end,
				@l_SIDBStoreId,
				@i_encRSA,
				@i_encKeyId
		IF	@@ERROR <> 0 GOTO FINISH
	END
	INSERT	INTO archFileCopyDedup(archFileId, commCellId, archCopyId, SIDBStoreId,
									primaryObjects, secondaryObjects, primaryObjSize, secondaryObjSize,
									primaryMetaDataSize, secondaryMetaDataSize, transDataSize, savedDataSize)
	SELECT @o_archFileId, @i_commCellId, @i_archCopyId, @l_SIDBStoreId,
			0, 0, 0, 0,
			0, 0, 0, 0
	IF	@@ERROR <> 0 GOTO FINISH
	INSERT INTO archFileSubStore(archFileId, commCellId, SIDBStoreId, SIDBSubStoreId, primaryObjects, secondaryObjects)
	SELECT	@o_archFileId, @i_commCellId, S.SIDBStoreId, S.SubStoreId, 0, 0
	FROM	IdxSIDBSubStore S WITH (NOLOCK)
	WHERE	S.SIDBStoreId = @l_SIDBStoreId
	IF	@@ERROR <> 0 GOTO FINISH
END
/*
-- Populate only valid archive files.
-- Move to archFileClose.sp. MR# 141691
-- To check for exist instead of not exist so that archfiles are not inserted into DB for unexpected type
-- This property DOCUMENTUM will be set to 0 in the Documentum Instance property if the underlying DB is Oracle
-- only based on this property, archfileOracle tables are populated
IF  ( (@i_flags & 2048) <> 0
    AND  EXISTS (SELECT * FROM APP_InstanceProp WITH (NOLOCK) WHERE componentNameId = @i_instanceId
                    AND attrName = N'DOCUMENTUM DbType' AND attrVal = N'0' AND modified = 0) )
OR	@i_appTypeId IN (22, 80)
BEGIN
	--Populate archFileOracle only for named archive files
	IF (@i_name IS NOT NULL AND LEN(LTRIM(RTRIM(@i_name))) > 0 AND UPPER(@i_name) != 'NOT NAMED')
	BEGIN
		IF @i_clientId > 0 AND @i_instanceId > 0
			INSERT	INTO archFileOracle
			SELECT	@o_archFileId, @i_commCellId, @i_appId, @i_instanceId, @i_clientId, @i_name, @i_fileType, @i_flags, @i_jobId
		ELSE
			INSERT	INTO archFileOracle
			SELECT	@o_archFileId, @i_commCellId, @i_appId, @l_instanceId, @l_clientId, @i_name, @i_fileType, @i_flags, @i_jobId
	END
END
*/
FINISH:
SELECT	ISNULL(@o_archFileId, 0), @l_cTime, 0, @i_encRSA, @i_encKeyType, @i_encKey, 0, 0, @i_encKeyId
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archFileCreate')
	delete from GxQscripts where name = 'archFileCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileCreate')
	delete from GXDBVersions where aliasname = 'archFileCreate'
GO

insert into GXDBVersions values(2, 'archFileCreate',  '00010062001200270000', 'archFileCreate', '00010062001200270000')
GO

