

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileCopyCreate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileCopyCreate.sp,v $ $Id: archFileCopyCreate.sp,v 1.10.12.7 2019/03/22 10:06:22 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archFileCopyCreate')
BEGIN
	print '>>> Drop Stored Procedure: archFileCopyCreate <<<'
	drop procedure archFileCopyCreate
END
IF EXISTS (select * from GxQscripts where name='archFileCopyCreate')
	delete from GxQscripts where name = 'archFileCopyCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileCopyCreate')
	delete from GXDBVersions where aliasname = 'archFileCopyCreate'
GO
print '... Creating Procedure: archFileCopyCreate'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archFileCopyCreate
  @i_archFileId int,
  @i_commCellId int,
  @i_archCopyId int,
  @i_flags int,
  @i_isValid int,
  @i_streamNum int
AS
  DECLARE @retVal integer;
  DECLARE @o_encRSA integer;
  DECLARE @o_encKeyType integer;
  DECLARE @o_encKey varchar(1024);
  DECLARE @o_rsaPriKey varchar(1024);
  DECLARE @o_SIDBStoreId integer;
  DECLARE @o_defCopyId integer;
  DECLARE @o_jobId integer;
  DECLARE @o_encKeyId integer;
  DECLARE @o_clientId integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @l_jobId                int
DECLARE	@l_defCopyId	int
DECLARE @l_SIDBStoreId	int
DECLARE	@l_encRSA		int
DECLARE	@l_encKeyType	int
DECLARE	@l_encKey		varchar(1024)
DECLARE @l_encKeyid		int
DECLARE	@l_rsaPriKey	varchar(1024)
DECLARE @l_needKeyAdjustment int
DECLARE @l_appId		int
SET	@retVal = 0
SET	@l_encRSA = 0
SET	@l_encKeyType = 0
SET	@l_encKey = ''
SET @l_encKeyid = 0
SET	@l_rsaPriKey = ''
SET @l_needKeyAdjustment = 0
SET @l_appId = 0
SELECT	@l_defCopyId = AG.defaultCopy
FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
WHERE	AG.id = AGC.archGroupId AND AGC.id = @i_archCopyId
IF @i_archCopyId = @l_defCopyId
BEGIN
	SET	@retVal = -1
	GOTO FINISH
END
SELECT	@l_encRSA = encRSA, @l_encKeyType = encKeyType, @l_encKey = encKey, @l_encKeyId = encKeyId
FROM	archFileCopy WITH (NOLOCK)
WHERE	archFileId = @i_archFileId AND commCellId = @i_commCellId AND archCopyId = @l_defCopyId
SELECT  @retVal = @@ERROR
IF      @retVal <> 0 GOTO FINISH
SELECT  @l_jobId = jobId, @l_appId = appId
FROM    archFile WITH (NOLOCK)
WHERE   id = @i_archFileId AND commCellId = @i_commCellId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
SELECT @l_SIDBStoreId = SIDBStoreId
FROM	archSubclientCopyDDBMap WITH (READUNCOMMITTED)
WHERE	appId = @l_appId
		AND copyId = @i_archCopyId
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
DECLARE	@l_clientId	int
SELECT	@l_clientId = clientId
FROM	APP_Application WITH (NOLOCK)
WHERE	id =  @l_appId
IF @l_SIDBStoreId > 0 AND @l_encKeyType > 0 AND (@l_encRSA & 1) > 0
BEGIN
	SELECT	@l_rsaPriKey = attrVal
	FROM	APP_ClientProp WITH (NOLOCK)
	WHERE	ComponentNameId = @l_clientId AND modified = 0
		AND attrName = N'Encrypt: rsaPriKeyBPF'
	SET	@l_needKeyAdjustment = 1
END
-- If primary copy is safenet enabled then unlock key and save it back to database.
ELSE IF @l_encKeyType > 0 AND (@l_encRSA & 2) > 0
BEGIN
	SET	@l_needKeyAdjustment = 1
END
INSERT	INTO archFileCopy
SELECT	@i_archFileId, @i_commCellId, @i_archCopyId, @i_flags, @i_isValid, @i_streamNum, 0, 0, 0, 0,
		(case when @l_needKeyAdjustment > 0 then 0 else @l_encRSA end), @l_encKeyType, (case when @l_needKeyAdjustment > 0 then '' else @l_encKey end), 0, 0, 0,
		(case when @l_needKeyAdjustment > 0 then 0 else @l_encKeyId end), -1
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Enable this flag to indicate that an enc AF exists on copy. This will be used during auxCopy to indicate if decryption module needs to be brought up. Optimization.
IF (@l_encKeyType > 0)
BEGIN
	IF (@l_SIDBStoreId > 0)
	BEGIN
		UPDATE	AGC
SET		extendedFlags = extendedFlags | 1024
		FROM	archGroupCopy AGC, archCopySIDBStore CS
		WHERE	AGC.id = CS.copyId
				AND CS.SIDBStoreId = @l_SIDBStoreId
AND (AGC.extendedFlags & 1024) = 0
AND ((CS.Flags & 4) > 0)
	END
	ELSE
	BEGIN
		UPDATE archGroupCopy
SET extendedFlags = extendedFlags | 1024
		WHERE id = @i_archCopyId
AND (extendedFlags & 1024) = 0
	END
END
SELECT	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
IF @l_SIDBStoreId > 0 AND @l_encKeyType > 0
BEGIN
	INSERT	INTO archFileSIDBKeys
	SELECT	@i_archFileId, @i_commCellId, @i_archCopyId, @l_encKeyType, (case when @l_needKeyAdjustment > 0 then '' else @l_encKey end), @l_SIDBStoreId, (case when @l_needKeyAdjustment > 0 then 0 else @l_encRSA end),
			(case when @l_needKeyAdjustment > 0 then '' else @l_encKeyId end)
END
IF @l_SIDBStoreId > 0
BEGIN
	INSERT	INTO archFileCopyDedup(archFileId, commCellId, archCopyId, SIDBStoreId,
									primaryObjects, secondaryObjects, primaryObjSize, secondaryObjSize,
									primaryMetaDataSize, secondaryMetaDataSize, transDataSize, savedDataSize)
						  VALUES   (@i_archFileId, @i_commCellId, @i_archCopyId, @l_SIDBStoreId,
									0, 0, 0, 0,
									0, 0, 0, 0)
	INSERT INTO archFileSubStore(archFileId, commCellId, SIDBStoreId, SIDBSubStoreId, primaryObjects, secondaryObjects)
	SELECT	@i_archFileId, @i_commCellId, SIDBStoreId, SubStoreId, 0, 0
	FROM	IdxSIDBSubStore WITH (NOLOCK)
	WHERE	SIDBStoreId = @l_SIDBStoreId
END
SELECT	@retVal = @@ERROR
FINISH:
SELECT	@retVal, @l_encRSA, @l_encKeyType, @l_encKey, @l_rsaPriKey, @l_SIDBStoreId, @l_defCopyId, @l_jobId, @l_encKeyId, @l_clientId
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archFileCopyCreate')
	delete from GxQscripts where name = 'archFileCopyCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileCopyCreate')
	delete from GXDBVersions where aliasname = 'archFileCopyCreate'
GO

insert into GXDBVersions values(2, 'archFileCopyCreate',  '00010010001200070000', 'archFileCopyCreate', '00010010001200070000')
GO

