

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileCopyByPrecedence.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc.  The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileCopyByPrecedence.sp,v $ $Id: archFileCopyByPrecedence.sp,v 1.12.2.5 2020/01/22 18:58:14 pmazur Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archFileCopyByPrecedence')
BEGIN
	print '>>> Drop Stored Procedure: archFileCopyByPrecedence <<<'
	drop procedure archFileCopyByPrecedence
END
IF EXISTS (select * from GxQscripts where name='archFileCopyByPrecedence')
	delete from GxQscripts where name = 'archFileCopyByPrecedence'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileCopyByPrecedence')
	delete from GXDBVersions where aliasname = 'archFileCopyByPrecedence'
GO
print '... Creating Procedure: archFileCopyByPrecedence'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archFileCopyByPrecedence
  @i_archFileId integer,
  @i_commCellId integer,
  @i_copyPrecedence integer,
  @i_includeAgedData integer,
  @i_preferMagnetic integer,
  @i_preferAccessible integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @r_errorCode integer
  DECLARE @r_copyId integer
  DECLARE @r_AFC_isValid integer
  DECLARE @r_AFC_flags integer
  DECLARE @r_fileType integer
  DECLARE @r_appId integer
  DECLARE @r_appType integer
  DECLARE @r_clientId integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @r_errorCode	= 0
SET @r_copyId		= 0
SET @r_AFC_isValid	= 0
SET @r_AFC_flags	= 0
SET @r_fileType		= 0
SET @r_appId		= 0
SET @r_appType		= 0
SET @r_clientId		= 0
DECLARE @l_error	INT
DECLARE @l_rowCount	INT
SET @l_error	= 0
SET @l_rowCount	= 0
--This is a special option added for synth. full. Added this MMConfig param, so we will turn it off by default and enable it only for specific customers who wants a change in existing behavior
IF(@i_copyPrecedence = -3 AND NOT EXISTS (SELECT 1 from MMConfigs WITH(NOLOCK) where name = 'ARMGR_CONFIG_ALLOW_CVA_COPY_CLASSIC_PRIMARY_AND_PRECEDENCE_ANY' and value > 0))
SET @i_copyPrecedence = 0
--Idx DB backup archive files can be aged but still be used
IF EXISTS(SELECT 1 FROM archFile WITH(NOLOCK) WHERE id = @i_archFileId AND commcellId = @i_commCellId AND fileType = 2 AND name like 'IdxLogs_V1%')
	SET @i_includeAgedData = 1
IF (@i_copyPrecedence = 0 OR @i_copyPrecedence = -4)AND (@i_preferMagnetic <> 0 OR @i_preferAccessible <> 0)
BEGIN
	DECLARE @l_archCopyId	INT
	DECLARE @l_AFC_isValid	INT
	DECLARE @l_AFC_flags	INT
	DECLARE @l_AF_flags		INT
	SELECT	TOP 1 @r_fileType = AF.fileType, @l_AF_flags = AF.flags, @r_appId = AF.appId, @r_appType = APP.appTypeId, @r_clientId = APP.clientId
	FROM	archFile AF WITH (NOLOCK), APP_Application APP WITH (NOLOCK)
	WHERE	AF.id = @i_archFileId AND AF.commCellId = @i_commCellId AND AF.appId = APP.id
IF (@l_AF_flags & 2) = 0
	BEGIN
		EXEC	@l_error = archFileCopyPreferred @i_archFileId, @i_commCellId, @i_includeAgedData, @i_preferMagnetic, @i_preferAccessible,
				@l_archCopyId OUTPUT, @l_AFC_isValid OUTPUT, @l_AFC_flags OUTPUT
		SELECT	@r_copyId = @l_archCopyId, @r_AFC_isValid = @l_AFC_isValid, @r_AFC_flags = @l_AFC_flags
		WHERE ISNULL(@l_archCopyId,0) > 0
		SELECT @l_error = @@ERROR, @l_rowCount = @@ROWCOUNT
	END
	ELSE
	BEGIN
		SELECT	TOP 1 @r_copyId = AFC.archCopyId, @r_AFC_isValid = AFC.isValid, @r_AFC_flags = AFC.flags
		FROM	archFileCopy AFC WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
		WHERE	AFC.archFileId = @i_archFileId AND AFC.commCellId = @i_commCellId AND AFC.archCopyId = AGC.id AND AFC.isValid > 0
AND (@i_includeAgedData <> 0 OR (AFC.flags & 256) = 0)
			AND AGC.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
AND ( (@i_copyPrecedence = -1 AND AGC.id IN (SELECT defaultCopy FROM archGroup WITH (NOLOCK)))
OR (@i_copyPrecedence = -4 AND AGC.isSnapCopy = 0)
OR @i_copyPrecedence = 0
				OR @i_copyPrecedence = AGC.copy )
		ORDER BY AGC.copy ASC
		SELECT @l_error = @@ERROR, @l_rowCount = @@ROWCOUNT
	END
END
ELSE IF @i_copyPrecedence = -3
BEGIN
	DECLARE @agId int
	DECLARE @defaultCopy int
	SELECT @agId = archGroupId FROM ArchFile WITH(NOLOCK) WHERE id = @i_archFileId AND commcellId = @i_commCellId
	SELECT @defaultCopy = defaultCopy FROM ArchGroup AG WITH(NOLOCK) WHERE id = @agId
	--Look for defaultcopy first
	SELECT	TOP 1 @r_copyId = AFC.archCopyId, @r_AFC_isValid = AFC.isValid, @r_AFC_flags = AFC.flags,
			@r_fileType = AF.fileType, @r_appId = AF.appId, @r_appType = APP.appTypeId, @r_clientId = APP.clientId
			FROM	archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK), APP_Application APP WITH (NOLOCK)
			WHERE	AFC.archFileId = @i_archFileId AND AFC.commCellId = @i_commCellId AND AFC.archCopyId = @defaultCopy AND AFC.isValid > 0
AND (@i_includeAgedData <> 0 OR (AFC.flags & 256) = 0)
				AND AF.id = @i_archFileId AND AF.commCellId = @i_commCellId AND AF.appId = APP.id
	SELECT @l_error = @@ERROR, @l_rowCount = @@ROWCOUNT
	--If archive file not found in default copy look for other copies
	IF(@r_copyId <= 0)
	BEGIN
		SELECT	TOP 1 @r_copyId = AFC.archCopyId, @r_AFC_isValid = AFC.isValid, @r_AFC_flags = AFC.flags,
			@r_fileType = AF.fileType, @r_appId = AF.appId, @r_appType = APP.appTypeId, @r_clientId = APP.clientId
			FROM	archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK), APP_Application APP WITH (NOLOCK)
			WHERE	AFC.archFileId = @i_archFileId AND AFC.commCellId = @i_commCellId AND AFC.archCopyId = AGC.id AND AFC.isValid > 0
AND (@i_includeAgedData <> 0 OR (AFC.flags & 256) = 0)
				AND AGC.type <> 5 -- SELECT only non transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
				AND AGC.id <> @defaultCopy
				AND AF.id = @i_archFileId AND AF.commCellId = @i_commCellId AND AF.appId = APP.id
			ORDER BY AGC.copy ASC
		SELECT @l_error = @@ERROR, @l_rowCount = @@ROWCOUNT
	END
END
ELSE
BEGIN
	SELECT	TOP 1 @r_copyId = AFC.archCopyId, @r_AFC_isValid = AFC.isValid, @r_AFC_flags = AFC.flags,
			@r_fileType = AF.fileType, @r_appId = AF.appId, @r_appType = APP.appTypeId, @r_clientId = APP.clientId
	FROM	archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK), APP_Application APP WITH (NOLOCK)
	WHERE	AFC.archFileId = @i_archFileId AND AFC.commCellId = @i_commCellId AND AFC.archCopyId = AGC.id AND AFC.isValid > 0
AND (@i_includeAgedData <> 0 OR (AFC.flags & 256) = 0)
		AND AGC.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
AND ( (@i_copyPrecedence = -1 AND AGC.id IN (SELECT defaultCopy FROM archGroup WITH (NOLOCK)))
OR (@i_copyPrecedence = -4 AND AGC.isSnapCopy = 0)
OR @i_copyPrecedence = 0
			OR @i_copyPrecedence = AGC.copy )
		AND AF.id = @i_archFileId AND AF.commCellId = @i_commCellId AND AF.appId = APP.id
	ORDER BY AGC.copy ASC
SELECT @l_error = @@ERROR, @l_rowCount = @@ROWCOUNT
END
IF @l_error = 0 AND @l_rowCount = 0
BEGIN
	IF NOT EXISTS (SELECT * FROM archFileCopy WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
					WHERE archFileId = @i_archFileId AND commCellId = @i_commCellId AND isValid > 0
						  AND archCopyId = AGC.id AND AGC.type <> 5	)
SET @l_error = 52
	ELSE
IF @i_copyPrecedence IN (0, -3, -4) AND @i_includeAgedData = 0
SET @l_error = 54
	ELSE
	IF @i_copyPrecedence <> 0 AND @i_includeAgedData <> 0
SET @l_error = 51
	ELSE
	IF @i_copyPrecedence <> 0 AND @i_includeAgedData = 0
	BEGIN
		-- it could either be that the achfile is aged in the copy, but
		-- it could also be that the archfile just doesn't exist in the copy that was specified by copy precidence
		-- in the latter case we do not want to return the error that it is aged
		IF EXISTS
			(
				SELECT *
				FROM archFileCopy AFC WITH (NOLOCK)
				INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AFC.archCopyId = AGC.id AND AGC.copy = @i_copyPrecedence
				WHERE AFC.archFileId = @i_archFileId AND AFC.commCellId = @i_commCellId AND AFC.isValid > 0
			)
		BEGIN
			-- a valid archfile copy entry is present for the copy, but it must be aged
SET @l_error = 53
		END ELSE
		BEGIN
SET @l_error = 51
			-- to do - new error code for 10.0
		END
	END
	SELECT	TOP 1 @r_copyId = 0, @r_AFC_isValid = 0, @r_AFC_flags = 0, @r_fileType = AF.fileType,
			@r_appId = AF.appId, @r_appType = APP.appTypeId, @r_clientId = APP.clientId
	FROM	archFile AF WITH (NOLOCK), APP_Application APP WITH (NOLOCK)
	WHERE	AF.id = @i_archFileId AND AF.commCellId = @i_commCellId AND AF.appId = APP.id
END
IF OBJECT_ID('tempdb.dbo.#tempCopyPrecedence') IS NOT NULL
BEGIN
	INSERT INTO #tempCopyPrecedence
	SELECT @l_error, @r_copyId, @r_AFC_isValid, @r_AFC_flags, @r_fileType, @r_appId, @r_appType, @r_clientId
END
ELSE
BEGIN
SELECT	@l_error, @r_copyId, @r_AFC_isValid, @r_AFC_flags, @r_fileType, @r_appId, @r_appType, @r_clientId
END
RETURN @l_error
GO

IF EXISTS (select * from GxQscripts where name = 'archFileCopyByPrecedence')
	delete from GxQscripts where name = 'archFileCopyByPrecedence'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileCopyByPrecedence')
	delete from GXDBVersions where aliasname = 'archFileCopyByPrecedence'
GO

insert into GXDBVersions values(2, 'archFileCopyByPrecedence',  '00010012000200050000', 'archFileCopyByPrecedence', '00010012000200050000')
GO

