

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileClose.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| 	Cursor: "archFileClose"						|
--	|												|
--    |	Initial Version: 	02/03/2004 by Jun Lu					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archFileClose')
BEGIN
	print '>>> Drop Stored Procedure: archFileClose <<<'
	drop procedure archFileClose
END
IF EXISTS (select * from GxQscripts where name='archFileClose')
	delete from GxQscripts where name = 'archFileClose'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileClose')
	delete from GXDBVersions where aliasname = 'archFileClose'
GO
print '... Creating Procedure: archFileClose'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archFileClose
  @i_archFileId int,
  @i_commCellId int,
  @i_archGroupId int,
  @i_archCopyId int,
  @i_AFCflags int,
  @i_AFflags int
AS
  DECLARE @retVal integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @errCode INT = 0
DECLARE	@l_clientId		INTEGER
DECLARE @l_appTypeId	INTEGER
DECLARE @l_instanceId	INTEGER
DECLARE	@l_appId			INTEGER
DECLARE	@l_jobId			INTEGER
DECLARE	@l_fileType		INTEGER
DECLARE @l_AFFlags		INTEGER
DECLARE @l_AFName			NVARCHAR(MAX)
UPDATE archFile SET isValid = 1 WHERE id = @i_archFileId AND commCellId = @i_commCellId AND isValid = 0
SELECT @errCode = @@ERROR
IF @errCode > 0 GOTO PROC_EXIT
--SET CVA_AF_USED_INDEX_FLAG flag only if close archive file is called on default copy
UPDATE archFile
SET	   flags = (AF.flags | @i_AFflags)
FROM	archFile AF, archGroup AG WITH (NOLOCK)
WHERE	AF.id = @i_archFileId
		AND AF.commCellId = @i_commCellId
		AND AF.archGroupId = AG.id
		AND (AG.defaultCopy = @i_archCopyId OR AG.defaultSnapCopy = @i_archCopyId)
SELECT @errCode = @@ERROR
IF @errCode > 0 GOTO PROC_EXIT
UPDATE archFileCopy SET flags = (flags | @i_AFCflags), isValid = 1
WHERE  archFileId = @i_archFileId AND commCellId = @i_commCellId AND archCopyId = @i_archCopyId
SELECT @errCode = @@ERROR
IF @errCode > 0 GOTO PROC_EXIT
/* MR:214061
IF (EXISTS (SELECT *
			FROM archFile
			WHERE	id = @i_archFileId
				AND CommCellId = @i_commCellId
AND (flags & (32768|2097152)) > 0))
BEGIN
	UPDATE	archFileCopy
	SET		isValid = 0
	WHERE	archFileId = @i_archFileId
			AND CommCellId = @i_commCellId
			AND archCopyId != @i_archCopyId
			AND isValid = 1
	SELECT @errCode = @@ERROR
	IF @errCode > 0 GOTO PROC_EXIT
END
*/
-- fetch archive file and appId info
SELECT	@l_clientId = APP.clientId,
				@l_appTypeId = APP.appTypeId,
				@l_instanceId = APP.instance,
				@l_AFFlags = AF.flags,
				@l_AFName	= AF.name,
				@l_appId = AF.appId,
				@l_jobId = AF.jobId,
				@l_fileType = AF.fileType
FROM	archFile AF WITH (NOLOCK), APP_application APP WITH (NOLOCK)
WHERE AF.id = @i_archFileId
AND 	AF.commCellId = @i_commCellId
AND		AF.appId = APP.id
SELECT @errCode = @@ERROR
IF @errCode > 0 GOTO PROC_EXIT
-- Moved from archFileCreate.sp. MR# 141691
-- To check for exist instead of not exist so that archfiles are not inserted into DB for unexpected type
-- This property DOCUMENTUM will be set to 0 in the Documentum Instance property if the underlying DB is Oracle
-- only based on this property, archfileOracle tables are populated
-- Create archFileOracle entry only if it is Primary copy
IF  (
			(
				(
(@l_AFFlags & 2048) != 0
	    		AND EXISTS (SELECT *
	    								FROM APP_InstanceProp WITH (NOLOCK)
	    								WHERE componentNameId = @l_instanceId
	                    AND attrName = N'DOCUMENTUM DbType'
	                    AND attrVal = N'0'
	                    AND modified = 0
	                   )
				)
				OR
(@l_appTypeId IN (22, 80))
			)
			AND
			(EXISTS (SELECT id FROM archGroup WITH (NOLOCK) WHERE	id = @i_archGroupId AND (defaultCopy = @i_archCopyId OR defaultSnapCopy = @i_archCopyId)))
		)
BEGIN
	--Populate archFileOracle only for named archive files
	--Exclude "OpenBKPData" named archive files for crosscheck
IF (@l_fileType IN (1, 4) AND @l_AFName IS NOT NULL AND LEN(LTRIM(RTRIM(@l_AFName))) > 0
			AND UPPER(@l_AFName) NOT IN ('NOT NAMED', 'OPENBKPDATA'))
	BEGIN
			INSERT	INTO archFileOracle
			SELECT	@i_archFileId, @i_commCellId, @l_appId, @l_instanceId, @l_clientId, @l_AFName, @l_fileType, @l_AFFlags, @l_jobId
			SELECT @errCode = @@ERROR
			IF @errCode > 0 GOTO PROC_EXIT
	END
END
PROC_EXIT:
SELECT @errCode
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archFileClose')
	delete from GxQscripts where name = 'archFileClose'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileClose')
	delete from GXDBVersions where aliasname = 'archFileClose'
GO

insert into GXDBVersions values(2, 'archFileClose',  '00000000000000000000', 'archFileClose', '00000000000000000000')
GO

