

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileChunkByJobCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc.  The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileChunkByJobCopy.sp,v $ $Id: archFileChunkByJobCopy.sp,v 1.5.208.2 2018/03/22 01:17:13 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archFileChunkByJobCopy <<<'

IF EXISTS (select * from sysobjects where name='archFileChunkByJobCopy')
	drop procedure archFileChunkByJobCopy
IF EXISTS (select * from GxQscripts where name='archFileChunkByJobCopy')
	delete from GxQscripts where name = 'archFileChunkByJobCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileChunkByJobCopy')
	delete from GXDBVersions where aliasname = 'archFileChunkByJobCopy'
GO
print '... Creating Procedure: archFileChunkByJobCopy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archFileChunkByJobCopy
  @i_jobId integer,
  @i_commCellId integer,
  @i_copyId integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_archChunkId bigint
  DECLARE @o_archFileId integer
  DECLARE @o_commCellId integer
  DECLARE @o_archFileName NVARCHAR(2048)
  DECLARE @o_fileType integer
  DECLARE @o_streamNum integer
  DECLARE @o_chunkNumber integer
  DECLARE @o_physicalOffset bigint
  DECLARE @o_logicalOffset bigint
  DECLARE @o_physicalSize bigint
  DECLARE @o_logicalSize bigint
  DECLARE @o_fileMarkerNo integer
  DECLARE @o_chunkVersion integer
  DECLARE @o_chunkPhysicalSize bigint
  DECLARE @o_chunkLogicalSize bigint
  DECLARE @o_volumeId integer
  DECLARE @o_mediaId integer
  DECLARE @o_barcode varchar(256)
  DECLARE @o_mediaTypeId integer
  DECLARE @o_mediaGroupId integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@tblArchFileChunk TABLE (archChunkId bigint, archFileId int, commCellId int,
name NVARCHAR(2048), fileType int, streamNum int,
		chunkNumber int, physicalOffset bigint, logicalOffset bigint, physicalSize bigint, logicalSize bigint,
		fileMarkerNo int, version int, chunkPhysicalSize bigint, chunkLogicalSize bigint, volumeId int)
INSERT	INTO @tblArchFileChunk
SELECT	ACM.archChunkId, ACM.archFileId, ACM.commCellId, AF.name, AF.fileType, AFC.streamNum,
		ACM.chunkNumber, ACM.physicalOffset, ACM.logicalOffset, ACM.physicalSize, ACM.logicalSize,
		AC.fileMarkerNo, AC.version, AC.physicalSize, AC.logicalSize, AC.volumeId
FROM	archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK), archChunkMapping ACM WITH (NOLOCK), archChunk AC WITH (NOLOCK)
WHERE	AF.jobId = @i_jobId AND AF.commCellId = @i_commCellId AND AF.isValid = 1
	AND AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = @i_copyId AND AFC.isValid = 1
	AND ACM.archFileId = AFC.archFileId AND ACM.commCellId = AFC.commCellId AND ACM.archCopyId = AFC.archCopyId
	AND AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId
SELECT	T.*, M.MediaId, M.BarCode, M.MediaTypeId, V.MediaGroupId
FROM	@tblArchFileChunk T, MMVolume V WITH (NOLOCK), MMMedia M WITH (NOLOCK)
WHERE	V.VolumeId = T.volumeId AND M.MediaId = V.MediaId
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archFileChunkByJobCopy')
	delete from GxQscripts where name = 'archFileChunkByJobCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileChunkByJobCopy')
	delete from GXDBVersions where aliasname = 'archFileChunkByJobCopy'
GO

insert into GXDBVersions values(2, 'archFileChunkByJobCopy',  '00010005020800020000', 'archFileChunkByJobCopy', '00010005020800020000')
GO

