

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileCTimeUpdate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archFileCTimeUpdate <<<'

IF EXISTS (select * from sysobjects where name='archFileCTimeUpdate')
	drop procedure archFileCTimeUpdate
IF EXISTS (select * from GxQscripts where name='archFileCTimeUpdate')
	delete from GxQscripts where name = 'archFileCTimeUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileCTimeUpdate')
	delete from GXDBVersions where aliasname = 'archFileCTimeUpdate'
GO
print '... Creating Procedure: archFileCTimeUpdate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archFileCTimeUpdate
--INPUT ARGUMENTS : archFileID <Comma seperated list of archive files> , commCellID <CommCell ID>, cTime <New CTime for given list of archive files>
  @archFileID NVARCHAR(MAX),
  @commCellID INT,
  @cTime INT
AS
  DECLARE @retVal integer
SET NOCOUNT ON
BEGIN
DECLARE @afCount INT = 0
DECLARE @ArchFiles TABLE( aFileId int )
INSERT INTO @ArchFiles SELECT DISTINCT _ID FROM SPLITIDs(@archFileID)
SET @afCount = @@ROWCOUNT
IF ( @afCount > 0 )
BEGIN
   UPDATE af SET af.cTime = @cTime
   FROM archFile af
   INNER JOIN @ArchFiles aFile
   ON af.id = aFile.aFileId
   WHERE af.commcellId = @commcellID
  SELECT  @retVal = @@ERROR, @afCount = @@ROWCOUNT
  IF (@retVal = 0 AND @afCount != (SELECT COUNT(*) FROM @ArchFiles))
               SET @retVal = -2
END
ELSE
                SET @retVal = -1
                GOTO FINISH
END
SELECT  @retVal = @@ERROR
FINISH:
SELECT @retVal
RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'archFileCTimeUpdate')
	delete from GxQscripts where name = 'archFileCTimeUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileCTimeUpdate')
	delete from GXDBVersions where aliasname = 'archFileCTimeUpdate'
GO

insert into GXDBVersions values(2, 'archFileCTimeUpdate',  '00000000000000000000', 'archFileCTimeUpdate', '00000000000000000000')
GO

