

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileByTimeSuperBrowse.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  archFileByTimeSuperBrowse.sp                               */
/*                                                                            */
/*  Description :  Stored procedure that returns list of last index archive   */
/*		   file in each cycle for given appId(s) and a time range     		  */
/*		   followed by a list of all the index                        		  */
/*		   and data archive files in all those cycles		      			  */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileByTimeSuperBrowse.sp,v $ $Id: archFileByTimeSuperBrowse.sp,v 1.26.2.35.4.1 2021/02/04 04:33:04 srajani Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archFileByTimeSuperBrowse')
BEGIN
	print '>>> Drop Stored Procedure: archFileByTimeSuperBrowse <<<'
	drop procedure archFileByTimeSuperBrowse
END
IF EXISTS (select * from GxQscripts where name='archFileByTimeSuperBrowse')
	delete from GxQscripts where name = 'archFileByTimeSuperBrowse'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileByTimeSuperBrowse')
	delete from GXDBVersions where aliasname = 'archFileByTimeSuperBrowse'
GO
print '... Creating Procedure: archFileByTimeSuperBrowse'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archFileByTimeSuperBrowse
  @i_appType INTEGER,
  @i_clientId INTEGER,
  @i_backupSetId INTEGER,
  @i_appId INTEGER,    
  @i_fromTime INTEGER,
  @i_ToTime INTEGER,
  @i_copyPrecedence INTEGER,
  @i_ignoreRecentCyclesWithNoIndex INTEGER = 0,
  @i_skipSynthFull INTEGER = 0,
  @i_isIndexingV2 INTEGER = 0,
  @i_inputXml xml = ''
AS
  DECLARE @r_resultSetId INTEGER;
  DECLARE @r_afileId INTEGER;
  DECLARE @r_commCellId INTEGER;
  DECLARE @r_appId INTEGER;
  DECLARE @r_agroupId INTEGER;
  DECLARE @r_fileType INTEGER;
  DECLARE @r_createTime INTEGER;
  DECLARE @r_jobId INTEGER;
  DECLARE @r_mediaAgentId INTEGER;
  DECLARE @r_mediaAgentVersion VARCHAR(4);
  DECLARE @r_idxCacheSoftState INTEGER;
  DECLARE @r_archFileFlag INTEGER;
  DECLARE @r_isRunningJob INTEGER;
  DECLARE @r_isAged INTEGER;
  DECLARE @r_VMGUID VARCHAR(2048);
  DECLARE @r_fullCycleNum INTEGER;
DECLARE @i2_appType INTEGER
DECLARE @i2_clientId INTEGER
DECLARE @i2_backupSetId INTEGER
DECLARE @i2_appId INTEGER
DECLARE @i2_fromTime INTEGER
DECLARE @i2_ToTime INTEGER
DECLARE @i2_copyPrecedence INTEGER
DECLARE @i2_ignoreRecentCyclesWithNoIndex INTEGER
DECLARE @i2_skipSynthFull INTEGER
DECLARE @i2_inputXml xml
DECLARE @i2_isIndexingV2 INTEGER
SET @i2_appType = @i_appType
SET @i2_clientId = @i_clientId
SET @i2_backupSetId = @i_backupSetId
SET @i2_appId = @i_appId
SET @i2_fromTime = @i_fromTime
SET @i2_ToTime = @i_ToTime
SET @i2_copyPrecedence = @i_copyPrecedence
SET @i2_ignoreRecentCyclesWithNoIndex = @i_ignoreRecentCyclesWithNoIndex
SET @i2_skipSynthFull = @i_skipSynthFull
SET @i2_inputXml = @i_inputXml
SET @i2_isIndexingV2 = @i_isIndexingV2
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE @enableEndUserErase int = 0
	SELECT @enableEndUserErase = value FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'EnableEndUserErase'
	DECLARE @enableFSEndUserErase int = 0
	SELECT @enableFSEndUserErase = value FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'EnableFSEndUserErase'
	DECLARE @includeAgedData int = 0
	SELECT @includeAgedData = value FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'ShowAgedDataForBrowseAndRecovery'
	--
	-- check for file-system apptype for end-user-erase feature
	DECLARE @isFileSystem int = 0, @shouldConsiderLogAfileAsData int = 0
	SELECT
		@isFileSystem = CASE WHEN G.groupName IN ('APPGRP_W2KFileSystem', 'APPGRP_UnixFileSystem') THEN 1 ELSE 0 END,
		@shouldConsiderLogAfileAsData = CASE WHEN G.groupName IN  ('APPGRP_ORACLE', 'APPGRP_SAP_HANA', 'APPGRP_INFORMIX') THEN 1 ELSE 0 END
		FROM APP_Application A WITH (NOLOCK)
		INNER JOIN APP_iDAType I WITH (NOLOCK) ON A.appTypeId = I.type
		INNER JOIN APP_AppTypeGroupAssoc IG WITH (NOLOCK) ON I.type = IG.appTypeId
		INNER JOIN APP_AppTypeGroup G WITH (NOLOCK) ON IG.appGroupId = G.appTypeGroupId AND IG.typeOfGroup = G.typeOfGroup
		WHERE A.backupSet = @i2_backupSetId
		AND G.groupName IN ('APPGRP_W2KFileSystem', 'APPGRP_UnixFileSystem', 'APPGRP_ORACLE', 'APPGRP_SAP_HANA', 'APPGRP_INFORMIX')
	--
	if object_id('tempdb.dbo.#tblJobs') is not null DROP TABLE #tblJobs
	CREATE TABLE #tblJobs (jobId int, commcellId int, primary key (jobId, commcellId))
	if object_id('tempdb.dbo.#tblAFile') is not null DROP TABLE #tblAFile
	CREATE TABLE #tblAFile (
		id INT, commCellId INT, appId INT,archGroupId INT, fileType INT, cTime INT, jobId INT, fullCycleNum int, indexAFPriority int, flags int, AFCflags int)
	if object_id('tempdb.dbo.#tblResultSetAfiles') is not null DROP TABLE #tblResultSetAfiles
	CREATE TABLE #tblResultSetAfiles (
		returnOrder int, id INT, commCellId INT, appId INT,
		archGroupId INT, fileType INT, cTime INT, jobId INT, flags INT,
		isRunningJob INT, AFCflags INT, VMGUID VARCHAR(2048), fullCycleNum INT)
	if object_id('tempdb.dbo.#tblJobInfo') is not null DROP TABLE #tblJobInfo
	CREATE TABLE #tblJobInfo (
		jobId INT, commCellId INT, appId INT, bkpLevel INT, fullCycleNum INT, jobStartTime INT)
	/*
	Note the difference in behavior if input job list is sent-
	If we have an input job list we need to send the exact index archive files of the job in the 3rd result set and in the 1st result set,
	send the index archive files of the last job in the cycle
	Expected format for input xml. For now only jobId is being passed and only one jobId is expected as per current indexing requirement.
	'<InputParam>
		<JobList>
			<Job id="1234" commcellId = "2"/>
		</JobList>
	</InputParam>'
	*/
	IF @i2_inputXml.exist('/InputParam/JobList/Job') = 1
	BEGIN
		--Populate the exact jobs and the last jobs in cycle
		DECLARE @tempXmlJobs table(jobId int, commcellId int)
		INSERT INTO @tempXmlJobs
		SELECT r.value('@id','int'), r.value('@commcellId','int')
		FROM @i2_inputXml.nodes('/InputParam/JobList/Job') AS x(r)
		INSERT INTO #tblJobs
		SELECT jobId, commcellId FROM @tempXmlJobs
		UNION
		SELECT jobId, commcellId FROM
		(
			SELECT JBKP2.jobId, JBKP2.commcellId, row_number() OVER(partition by JBKP2.appId, JBKP2.fullCycleNum order by JBKP2.servStartDate desc) as rn
			FROM @tempXmlJobs J
			INNER JOIN JMBkpStats JBKP1 WITH(NOLOCK) ON J.jobId = JBKP1.jobId AND J.commcellId = JBKP1.commcellId
			INNER JOIN JMBkpStats JBKP2 WITH(NOLOCK) ON JBKP1.appId = JBKP2.appId AND JBKP1.fullCycleNum = JBKP2.fullCycleNum AND JBKP2.status IN (1, 3, 14)
		) A
		WHERE rn = 1
		UNION
		SELECT jobId, commcellId FROM --DR jobs if any
		(
			SELECT JBKP2.jobId, JBKP2.commcellId, row_number() OVER(partition by JBKP2.appId, JBKP2.fullCycleNum order by JBKP2.servStart desc) as rn
			FROM @tempXmlJobs J
			INNER JOIN JMAdminJobStatsTable JBKP1 WITH(NOLOCK) ON J.jobId = JBKP1.jobId AND J.commcellId = JBKP1.commcellId
			INNER JOIN JMAdminJobStatsTable JBKP2 WITH(NOLOCK) ON JBKP1.appId = JBKP2.appId AND JBKP1.fullCycleNum = JBKP2.fullCycleNum AND JBKP2.status IN (1, 3, 14)
		) A
		WHERE rn = 1
	END
	ELSE
	BEGIN
      DECLARE @appIdsToCheck TABLE (appId INT, primary key(appId))
      IF (@i2_appId > 0)
      BEGIN
		  INSERT INTO @appIdsToCheck VALUES(@i2_appId)
		  IF @i2_inputXml.exist('/InputParam/AppIdPST') = 1
		  BEGIN
   			INSERT INTO @appIdsToCheck
			SELECT r.value('@id','int')
			FROM @i2_inputXml.nodes('/InputParam/AppIdPST') AS x(r)
			WHERE r.value('@id','int') <> @i2_appId
		  END
      END
	  ELSE IF (@i2_backupSetId > 0)
		  INSERT INTO @appIdsToCheck SELECT id FROM APP_Application WITH (NOLOCK) WHERE backupSet=@i2_backupSetId
	  ELSE IF (@i2_clientId > 0)
		  INSERT INTO @appIdsToCheck SELECT id FROM APP_Application WITH (NOLOCK) WHERE clientId=@i2_clientId AND (@i2_appType = 0 OR appTypeId=@i2_appType)
	  --Get IdxAppType
	  DECLARE @idxAppType INT = @i2_appType
	  DECLARE @inputAppId INT = @i2_appId
	  DECLARE @errorCode INT = 0
	  SELECT TOP 1 @inputAppId = appId FROM @appIdsToCheck
	  EXEC AppGetIndexingAppType @i2_appType, @inputAppId, @idxAppType OUT, @errorCode OUT
	  --Ignore DDB Backup subclients unless input specfically requests for it
	  DECLARE @DDBSubClientPropCheckSum INT = CHECKSUM(N'DDB Backup')
	  IF(@i2_appId <= 0)
		  DELETE T1
		  FROM @appIdsToCheck T1 INNER JOIN App_SubClientProp T2 WITH(NOLOCK) ON T1.appId = T2.componentNameId
		  WHERE T2.cs_attrName = @DDBSubClientPropCheckSum AND T2.attrName = 'DDB Backup' AND T2.attrType = 2 AND T2.attrVal > 0 AND T2.modified = 0
IF @i2_appType = 137
	  BEGIN
		  -- Get the latest completed job which has the index archFile.
		  INSERT INTO #tblJobs
		  SELECT TOP 1 AF.jobId, AF.commcellId
		  FROM ArchFile AF WITH (NOLOCK)
WHERE AF.appId in (SELECT appId FROM @appIdsToCheck) AND AF.cTime <= @i2_ToTime AND AF.cTime >= @i2_fromTime AND AF.isValid = 1 AND AF.fileType=2
		  AND AF.jobId NOT IN(SELECT jobId FROM JMBkpJobInfo(NOLOCK) WHERE appId IN(SELECT appId FROM @appIdsToCheck))
		  ORDER BY AF.ctime DESC
	  END
	  ELSE
	  BEGIN
		  -- if indexingV2 consider only jobs with valid data afiles
		  INSERT INTO #tblJobs
		  SELECT distinct AF.jobId, AF.commcellId
		  FROM ArchFile AF WITH (NOLOCK)
		  WHERE AF.appId in (SELECT appId FROM @appIdsToCheck) AND AF.cTime <= @i2_ToTime AND AF.cTime >= @i2_fromTime AND AF.isValid = 1
			AND (
				@i2_isIndexingV2 = 0
OR @shouldConsiderLogAfileAsData = 1 AND AF.fileType in (1, 4)
OR AF.fileType = 1
				)
	  END
    END
	--If VSA V2 parent browse, then pick jobs of associated VMs
  IF @i2_inputXml.exist('/InputParam/VSAV2ParentBrowse') = 1
  BEGIN
  	INSERT INTO #tblJobs
  	SELECT DISTINCT JDL.childJobId, JDL.commcellId
  	FROM JMJobDataLink JDL WITH (NOLOCK), #tblJobs TJ, ArchFile AF WITH (NOLOCK)
  	WHERE JDL.parentJobId = TJ.jobId
		AND		JDL.commCellId = TJ.commCellId
AND		JDL.linkType IN (7, 8)
  	AND		AF.jobId = JDL.childJobId
  	AND		AF.commcellId = JDL.commcellId
  	AND		AF.isValid = 1
  	AND 	(
				@i2_isIndexingV2 = 0
OR @shouldConsiderLogAfileAsData = 1 AND AF.fileType in (1, 4)
OR AF.fileType = 1
			)
  END
    /*
    INSERT INTO #tblAFile
		SELECT	distinct AF.id, AF.commCellId, AF.appId, AF.archGroupId, AF.fileType, AF.cTime, AF.jobId, -1,
CASE WHEN AF.fileType IN (6, 34, 8, 2) THEN AGC.copy
		     ELSE 0 END
		FROM	archFile AF WITH (NOLOCK)
		INNER JOIN #tblJobs TJ ON TJ.jobId = AF.jobId AND TJ.commcellId = AF.commcellId
		INNER JOIN archFileCopy AFC WITH (NOLOCK) ON AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId
INNER JOIN ArchGroupCopy AGC WITH (NOLOCK) ON AFC.archCopyId = AGC.id AND AGC.type <> 5
WHERE fileType in (1, 4, 2, 6, 8, 34)
AND AF.isValid = 1 AND AFC.isValid = 1 AND (@includeAgedData > 0 OR AFC.flags & 256 = 0)
AND ((@i2_copyPrecedence = -1 AND AGC.id = (SELECT defaultCopy FROM archGroup WITH (NOLOCK) WHERE id = AGC.archGroupId))
OR @i2_copyPrecedence = 0
     				OR @i2_copyPrecedence = AGC.copy)
    */
IF @i2_appType = 137
	BEGIN
IF(@i2_copyPrecedence = -1)
			INSERT INTO #tblAFile
			SELECT	top 1 AF.id, AF.commCellId, AF.appId, AF.archGroupId, AF.fileType, AF.cTime, AF.jobId, -1,
CASE WHEN AF.fileType IN (6, 34, 8, 2) THEN AGC.copy
					ELSE 0 END, AF.flags, AFC.flags
			FROM	#tblJobs TJ
			INNER JOIN archFile AF WITH (NOLOCK) ON TJ.jobId = AF.jobId AND TJ.commcellId = AF.commcellId
			INNER JOIN archFileCopy AFC WITH (NOLOCK) ON AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId
INNER JOIN ArchGroupCopy AGC WITH (NOLOCK) ON AFC.archCopyId = AGC.id AND AGC.type <> 5
			INNER JOIN ArchGroup AG WITH(NOLOCK) ON AGC.archGroupId = AG.id
WHERE fileType in (2)
				AND AF.isValid = 1 AND AFC.isValid = 1
AND (@includeAgedData > 0 OR AFC.flags & 256 = 0)
AND (lastchunknumber > 0 OR AF.flags & 2 = 2)
				AND AGC.id = AG.defaultCopy
				OPTION(FORCE ORDER)
ELSE IF(@i_copyPrecedence = -4)  -- -4
			INSERT INTO #tblAFile
			SELECT top 1 AF.id, AF.commCellId, AF.appId, AF.archGroupId, AF.fileType, AF.cTime, AF.jobId, -1,
CASE WHEN AF.fileType IN (6, 34, 8, 2) THEN AGC.copy
					ELSE 0 END,  AF.flags, AFC.flags
			FROM	#tblJobs TJ
			INNER JOIN archFile AF WITH (NOLOCK) ON TJ.jobId = AF.jobId AND TJ.commcellId = AF.commcellId
			INNER JOIN archFileCopy AFC WITH (NOLOCK) ON AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId
INNER JOIN ArchGroupCopy AGC WITH (NOLOCK) ON AFC.archCopyId = AGC.id AND AGC.type <> 5
WHERE fileType in (2)
				AND AF.isValid = 1 AND AFC.isValid = 1
AND (@includeAgedData > 0 OR AFC.flags & 256 = 0)
AND (lastchunknumber > 0 OR AF.flags & 2 = 2)
				AND AGC.isSnapCopy = 0
				OPTION(FORCE ORDER)
ELSE IF(@i_copyPrecedence = -5)  -- -5
			INSERT INTO #tblAFile
			SELECT top 1 AF.id, AF.commCellId, AF.appId, AF.archGroupId, AF.fileType, AF.cTime, AF.jobId, -1,
CASE WHEN AF.fileType IN (6, 34, 8, 2) THEN AGC.copy
					ELSE 0 END,  AF.flags, AFC.flags
			FROM	#tblJobs TJ
			INNER JOIN archFile AF WITH (NOLOCK) ON TJ.jobId = AF.jobId AND TJ.commcellId = AF.commcellId
			INNER JOIN archFileCopy AFC WITH (NOLOCK) ON AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId
INNER JOIN ArchGroupCopy AGC WITH (NOLOCK) ON AFC.archCopyId = AGC.id AND AGC.type <> 5
			INNER JOIN ArchGroup AG WITH(NOLOCK) ON AGC.archGroupId = AG.id
WHERE fileType in (2)
				AND AF.isValid = 1 AND AFC.isValid = 1
AND (@includeAgedData > 0 OR AFC.flags & 256 = 0)
AND (lastchunknumber > 0 OR AF.flags & 2 = 2)
				AND AGC.id = AG.defaultSnapCopy AND AGC.isSnapCopy = 1
				OPTION(FORCE ORDER)
		ELSE
			INSERT INTO #tblAFile
			SELECT	top 1 AF.id, AF.commCellId, AF.appId, AF.archGroupId, AF.fileType, AF.cTime, AF.jobId, -1,
CASE WHEN AF.fileType IN (6, 34, 8, 2) THEN AGC.copy
					ELSE 0 END,  AF.flags, AFC.flags
			FROM	#tblJobs TJ
			INNER JOIN archFile AF WITH (NOLOCK) ON TJ.jobId = AF.jobId AND TJ.commcellId = AF.commcellId
			INNER JOIN archFileCopy AFC WITH (NOLOCK) ON AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId
INNER JOIN ArchGroupCopy AGC WITH (NOLOCK) ON AFC.archCopyId = AGC.id AND AGC.type <> 5
WHERE fileType in (2)
				AND AF.isValid = 1 AND AFC.isValid = 1
AND (@includeAgedData > 0 OR AFC.flags & 256 = 0)
AND (lastchunknumber > 0 OR AF.flags & 2 = 2)
AND (@i2_copyPrecedence = 0 OR @i2_copyPrecedence = AGC.copy)
				OPTION(FORCE ORDER)
	END
	ELSE
	BEGIN
IF(@i2_copyPrecedence = -1)
			INSERT INTO #tblAFile
			SELECT	distinct AF.id, AF.commCellId, AF.appId, AF.archGroupId, AF.fileType, AF.cTime, AF.jobId, -1,
CASE WHEN AF.fileType IN (6, 34, 8, 2) THEN AGC.copy
					ELSE 0 END, AF.flags, AFC.flags
			FROM	#tblJobs TJ
			INNER JOIN archFile AF WITH (NOLOCK) ON TJ.jobId = AF.jobId AND TJ.commcellId = AF.commcellId
			INNER JOIN archFileCopy AFC WITH (NOLOCK) ON AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId
INNER JOIN ArchGroupCopy AGC WITH (NOLOCK) ON AFC.archCopyId = AGC.id AND AGC.type <> 5
			INNER JOIN ArchGroup AG WITH(NOLOCK) ON AGC.archGroupId = AG.id
WHERE fileType in (1, 4, 2, 6, 8, 34)
				AND AF.isValid = 1 AND AFC.isValid = 1
AND (@includeAgedData > 0 OR AFC.flags & 256 = 0)
AND (lastchunknumber > 0 OR AF.flags & 2 = 2 OR @idxAppType = 200115)
				AND AGC.id = AG.defaultCopy
				OPTION(FORCE ORDER)
ELSE IF(@i_copyPrecedence = -4)  -- -4
			INSERT INTO #tblAFile
			SELECT	distinct AF.id, AF.commCellId, AF.appId, AF.archGroupId, AF.fileType, AF.cTime, AF.jobId, -1,
CASE WHEN AF.fileType IN (6, 34, 8, 2) THEN AGC.copy
					ELSE 0 END, AF.flags, AFC.flags
			FROM	#tblJobs TJ
			INNER JOIN archFile AF WITH (NOLOCK) ON TJ.jobId = AF.jobId AND TJ.commcellId = AF.commcellId
			INNER JOIN archFileCopy AFC WITH (NOLOCK) ON AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId
INNER JOIN ArchGroupCopy AGC WITH (NOLOCK) ON AFC.archCopyId = AGC.id AND AGC.type <> 5
WHERE fileType in (1, 4, 2, 6, 8, 34)
				AND AF.isValid = 1 AND AFC.isValid = 1
AND (@includeAgedData > 0 OR AFC.flags & 256 = 0)
AND (lastchunknumber > 0 OR AF.flags & 2 = 2 OR @idxAppType = 200115)
				AND AGC.isSnapCopy = 0
				OPTION(FORCE ORDER)
ELSE IF(@i2_copyPrecedence = -5)  -- -5
			INSERT INTO #tblAFile
			SELECT	distinct AF.id, AF.commCellId, AF.appId, AF.archGroupId, AF.fileType, AF.cTime, AF.jobId, -1,
CASE WHEN AF.fileType IN (6, 34, 8, 2) THEN AGC.copy
					ELSE 0 END, AF.flags, AFC.flags
			FROM	#tblJobs TJ
			INNER JOIN archFile AF WITH (NOLOCK) ON TJ.jobId = AF.jobId AND TJ.commcellId = AF.commcellId
			INNER JOIN archFileCopy AFC WITH (NOLOCK) ON AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId
INNER JOIN ArchGroupCopy AGC WITH (NOLOCK) ON AFC.archCopyId = AGC.id AND AGC.type <> 5
			INNER JOIN ArchGroup AG WITH(NOLOCK) ON AGC.archGroupId = AG.id
WHERE fileType in (1, 4, 2, 6, 8, 34)
				AND AF.isValid = 1 AND AFC.isValid = 1
AND (@includeAgedData > 0 OR AFC.flags & 256 = 0)
AND (lastchunknumber > 0 OR AF.flags & 2 = 2 OR @idxAppType = 200115)
				AND AGC.id = AG.defaultSnapCopy AND AGC.isSnapCopy = 1
				OPTION(FORCE ORDER)
		ELSE
			INSERT INTO #tblAFile
			SELECT	distinct AF.id, AF.commCellId, AF.appId, AF.archGroupId, AF.fileType, AF.cTime, AF.jobId, -1,
CASE WHEN AF.fileType IN (6, 34, 8, 2) THEN AGC.copy
					ELSE 0 END,  AF.flags, AFC.flags
			FROM	#tblJobs TJ
			INNER JOIN archFile AF WITH (NOLOCK) ON TJ.jobId = AF.jobId AND TJ.commcellId = AF.commcellId
			INNER JOIN archFileCopy AFC WITH (NOLOCK) ON AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId
INNER JOIN ArchGroupCopy AGC WITH (NOLOCK) ON AFC.archCopyId = AGC.id AND AGC.type <> 5
WHERE fileType in (1, 4, 2, 6, 8, 34)
				AND AF.isValid = 1 AND AFC.isValid = 1
AND (@includeAgedData > 0 OR AFC.flags & 256 = 0)
AND (lastchunknumber > 0 OR AF.flags & 2 = 2 OR @idxAppType = 200115)
AND (@i2_copyPrecedence = 0 OR @i2_copyPrecedence = AGC.copy)
				OPTION(FORCE ORDER)
	END
	--Check jobId match in JMBkpStats if not found check in JMAdminJobStatsTable (DR jobs)
	UPDATE #tblAFile
	SET fullCycleNum = JBKP.fullCycleNum
	FROM #tblAFile A INNER JOIN JMBkpStats JBKP WITH(NOLOCK) ON A.jobId = JBKP.jobId AND A.commCellId = JBKP.commCellId
	IF EXISTS(SELECT 1 FROM #tblAFile WHERE fullCycleNum = -1)
		UPDATE #tblAFile
		SET fullCycleNum = JBKP.fullCycleNum
		FROM #tblAFile A INNER JOIN JMAdminJobStatsTable JBKP WITH(NOLOCK) ON A.jobId = JBKP.jobId AND A.commCellId = JBKP.commCellId
		WHERE A.fullCycleNum = -1
	IF (@i2_ignoreRecentCyclesWithNoIndex <> 0)
	BEGIN
		--Completed jobs only
		DELETE #tblAFile
		FROM	#tblAFile A
		WHERE NOT exists (SELECT * from JMJobDataStats WITH (NOLOCK) where jobId = A.jobId and commCellId = A.commCellId)
	END
	ELSE
	BEGIN
		-- i_ignoreRecentCyclesWithNoIndex is used to include running jobs (Indexing V2 requirement for early stubbing)
		UPDATE #tblAFile
		SET fullCycleNum = A1.maxFullNum
		FROM (
		SELECT MAX(CASE WHEN A.FULLCYCLENUM =-1 THEN 0 ELSE A.FULLCYCLENUM END) AS maxFullNum, appId
		from #tblAFile A GROUP BY appId
		) A1 INNER JOIN #tblAFile A2 ON A1.appId = A2.appId
		WHERE A2.fullCycleNum = -1
	END
	--Safe check to ignore archive files that do not have valid fullCycleNum though this case is unlikely to happen
	DELETE #tblAFile WHERE fullCycleNum = -1
	/*
	If @i2_ignoreRecentCyclesWithNoIndex is set we will consider only archive files upto the cycle which has index
	If @i2_fromTime = 0 latest browse, then only last cycle considered
	Example:
	cycle 1: data  AF1
			 index AF2
	cycle 2: data  AF3
			 index AF4
	cycle 3: data  AF5
	cycle 4: data  AF6
	If @i2_fromTime = 0 AND @i2_ignoreRecentCyclesWithNoIndex = 0
		Except AF6 others will be deleted in below query
	If @i2_fromTime = 0 AND @i2_ignoreRecentCyclesWithNoIndex > 0
		Except AF3, AF4 others will be deleted in below query
	If @i2_fromTime > 0 AND @i2_ignoreRecentCyclesWithNoIndex = 0
		Nothing will be deleted in below query
	If @i2_fromTime > 0 AND @i2_ignoreRecentCyclesWithNoIndex > 0
		Except AF1, AF2, AF3, AF4 others will be deleted in below query
	 */
	IF (@i2_fromTime = 0 AND @i2_ignoreRecentCyclesWithNoIndex = 0)
	BEGIN
		DELETE #tblAFile
		FROM #tblAFile A INNER JOIN
		(SELECT appId, MAX(fullCycleNum) maxFullCycleNum FROM #tblAFile GROUP BY appId) B
		ON A.appId = B.appId AND A.fullCycleNum <> B.maxFullCycleNum
	END
	ELSE IF(@i2_ignoreRecentCyclesWithNoIndex > 0)
	BEGIN
		DELETE #tblAFile
		FROM #tblAFile A INNER JOIN
			(SELECT appId, MAX(fullCycleNum) maxFullCycleNum
		 	 FROM #tblAFile
		 	 WHERE indexAFPriority > 0 GROUP BY appId) B
			ON 	A.appId = B.appId
				AND  ((@i2_fromTime = 0 AND A.fullCycleNum <> B.maxFullCycleNum)
						OR (@i2_fromTime > 0 AND A.fullCycleNum > B.maxFullCycleNum))
	END
	/*If @i2_skipSynthFull is set then process the following code of skipping synthfulls*/
	IF (@i2_skipSynthFull > 0)
	BEGIN
		INSERT INTO #tblJobInfo
		SELECT JM.jobId, JM.commCellId, JM.appId, JM.bkpLevel, JM.fullCycleNum, JM.servStartDate
		FROM JMBkpStats JM WITH (NOLOCK), #tblAFile T
		WHERE T.jobId = JM.jobId AND T.commCellId = JM.commCellId
		AND T.appId = JM.appId
		-- IF @i2_skipSynthFull = 1 then Skip all synthetic fulls (Normal Fulls should always be included)
		IF (@i2_skipSynthFull = 1)
		BEGIN
			-- Delete all AFs belonging to the synthfull.
			DELETE #tblAFile
			FROM #tblAFile TAF, #tblJobInfo TJ
			WHERE TAF.jobId = TJ.jobId
			AND TAF.commCellId = TJ.commCellId
			AND TAF.appId = TJ.appId
			AND TJ.bkpLevel IN (64, 128) -- SYNTHETIC_FULL, SYNTHETIC_FULL_AND_INCR
		END
		-- IF @i2_skipSynthFull = 2 then Include first Full/SynthFull and then skip all subsequent synthetic fulls. (Normal Fulls should always be included)
		IF (@i2_skipSynthFull = 2)
		BEGIN
			--There is atleast 1 full job in this range before a synthfull, so skip all synthfulls
			-- else if no full job then do not skip first synth full, skip rest
			DELETE #tblAFile
			FROM #tblAFile TAF INNER JOIN #tblJobInfo TJ ON TAF.appId = TJ.appId AND TAF.jobId = TJ.jobId AND TAF.commcellId= TJ.commcellId
			LEFT OUTER JOIN
			(
			SELECT appId, jobId, commcellId, row_number() OVER(partition by appId order by jobStartTime asc) as rn
			FROM #tblJobInfo
			WHERE bkpLevel IN (1, 64, 128, 1024, 32768)
			) T
			ON TAF.appId = T.appId AND TAF.jobId = T.jobId AND TAF.commcellId = T.commcellId AND T.rn = 1
			WHERE TJ.bkpLevel IN (64, 128) AND T.jobId is null
		END
	END
	/*
	Here we return the last index archive file in each cycle.
	I'm using a row_number and assigning row number for each group of (appId,fullCycleNum) by the order of cTime desc, indexAFPriority asc, id desc
	and selecting the rows with row_num = 1 so that I'll get the last index AF for each cycle
	*/
	INSERT INTO #tblResultSetAfiles
	SELECT 1, id, commCellId, appId, archGroupId, fileType, cTime, jobId, flags, 0, AFCflags, '', 0
	FROM
	(
	SELECT id, commcellId, appId, archGroupId, fileType, cTime, jobId, flags, AFCflags, row_number() OVER(partition by appId, fullCycleNum order by cTime desc, indexAFPriority asc, id desc) as rn
	FROM #tblAFile
	WHERE indexAFPriority <> 0  --fileType in (CVA_DATATYPE_INDEX, CVA_DATATYPE_SNAPMETADATA, CVA_DATATYPE_DB_INDEX, CVA_DATATYPE_INDEX_REPLACED)
	) A
	WHERE rn = 1
	/*
	Get all the data archive files
	*/
	INSERT INTO #tblResultSetAfiles
	SELECT 2, id, commCellId, appId, archGroupId, fileType, cTime, jobId, flags, 0, AFCflags, '', fullCycleNum
	from #tblAFile WHERE indexAFPriority = 0   --fileType in (CVA_DATATYPE_DATA, CVA_DATATYPE_LOGS)
	/*
	Here we return all the index archive files of all the jobs in the cycles selected but per job we return only one index archive file
	so here my row_number will do a partition by appId, jobId, commcellId and order by cTime desc, indexAFPriority asc, id desc and I'll pick the
	rows with row_number = 1 so only one index AF will be returned per (appId,jobId,commcellId) group
	*/
	INSERT INTO #tblResultSetAfiles
	SELECT 3, id, commCellId, appId, archGroupId, fileType, cTime, jobId, flags, 0, AFCflags, '', 0
	FROM
	(
	SELECT id, commcellId, appId, archGroupId, fileType, cTime, jobId, flags, AFCflags, row_number() OVER(partition by appId, jobId, commcellId order by cTime desc, indexAFPriority asc, id desc) as rn
	FROM #tblAFile
	WHERE indexAFPriority <> 0 --fileType in (CVA_DATATYPE_INDEX, CVA_DATATYPE_SNAPMETADATA, CVA_DATATYPE_DB_INDEX, CVA_DATATYPE_INDEX_REPLACED)
	) A
	WHERE rn = 1
	-- Updating the archive file belongs to running job or not
	UPDATE TMP
	SET TMP.isRunningJob = 1
	FROM #tblResultSetAfiles TMP
	INNER JOIN JMJobInfo JM ON JM.jobId = TMP.jobId AND JM.commcellId = TMP.commcellId
  -- If VSA V2 parent browse, then update the VMGUID of VM subclients
  IF @i2_inputXml.exist('/InputParam/VSAV2ParentBrowse') = 1
  BEGIN
		--First try to find GUID from App_VMProp
		UPDATE TMP
		SET TMP.VMGUID = VMP.attrVal
		FROM #tblResultSetAfiles TMP INNER JOIN JMJobDataLink JDL WITH(NOLOCK) ON TMP.jobId = JDL.childJobId AND TMP.commcellId = JDL.commcellId
		INNER JOIN App_Application App WITH(NOLOCK) ON JDL.childAppId = App.Id
		INNER JOIN App_VMProp VMP WITH(NOLOCK) ON JDL.parentJobId = VMP.jobId AND JDL.commcellId = VMP.commcellId AND App.clientId = VMP.VMClientId
WHERE JDL.linkType IN (7, 8)
		AND VMP.attrName = N'vmGUID'
		/*
		To be honest the below query may be not needed as I assume App_VMProp entries should exist always for a valid job,
		but since VSA requirements change I'm leaving below query as a backup in case App_VMProp entries are removed as part of cleanup
		*/
		IF EXISTS(SELECT 1 FROM #tblResultSetAfiles WHERE VMGUID IS NULL OR LEN(VMGUID) = 0)
		BEGIN
	  		--GUID gets updated for a VM client and so modified timestamp is set on previous GUID. Pick GUID based on the job time we have for a VM.
			UPDATE TMP
			SET TMP.VMGUID = C.attrVal
			FROM #tblResultSetAfiles TMP, APP_Application A WITH (NOLOCK), APP_ClientProp C WITH (NOLOCK)
WHERE TMP.appId IN (SELECT DISTINCT childAppId FROM JMJobDataLink WITH (NOLOCK) WHERE linkType IN (7, 8))
			AND	TMP.appId = A.id
			AND A.clientId = C.componentNameId
			AND C.attrName = N'Virtual Machine Instance UUID'
			AND	TMP.cTime >= C.created AND (TMP.cTime < C.modified OR C.modified = 0)
			AND (TMP.VMGUID IS NULL OR LEN(TMP.VMGUID) = 0)
		END
	END
	--If input job list is given this resultset should contain only index archive files of the input jobs
	IF EXISTS (SELECT 1 FROM @tempXmlJobs)
	BEGIN
		DELETE #tblResultSetAfiles
		FROM #tblResultSetAfiles RES LEFT OUTER JOIN @tempXmlJobs J ON RES.jobId = J.jobId AND RES.commCellId = J.commcellId
		WHERE RES.returnOrder = 3 AND J.jobId IS NULL
	END
	/*Now find the MA and version - Following int ArchiveManagerCS::getRegularOrBCDIndexMediaAgent logic*/
	DECLARE @tblAppIdMaIdList table(appId int, maId int, maVersion varchar(4), idxCacheSoftState int)
	DECLARE @appIdTemp int = 0
	INSERT @tblAppIdMaIdList
	SELECT distinct appId, 0, '', 0
	FROM #tblResultSetAfiles
	DECLARE appIdListCursor CURSOR FOR
	SELECT appId FROM @tblAppIdMaIdList
	OPEN appIdListCursor
	FETCH NEXT FROM appIdListCursor INTO @appIdTemp
	WHILE(@@FETCH_STATUS = 0)
	BEGIN
		-- TODO: check Backupset properties to verify that EndUserErase is enabled
		IF (((@isFileSystem = 0 AND @enableEndUserErase = 1) OR (@isFileSystem = 1 AND @enableFSEndUserErase = 1))
			AND EXISTS(SELECT attrVal FROM APP_SubClientProp WITH (NOLOCK) WHERE AttrName = 'EndUser Erase Enabled' AND componentNameId = @appIdTemp AND attrVal = '1'))
		BEGIN
				DECLARE @dataPathErasetbl table(dpId int, errCode int, warningBitMask int)
				declare @indexingAppId int
				declare @defaultCopyId int
				declare @indexingClientId int
				declare @eraseManagementMaId int
				select @indexingClientId=clientId from APP_Application WITH (NOLOCK) where id=@appIdTemp
                -- 512 == CV_STATUS_ERASE_BACKUP
				select @indexingAppId=id from APP_Application WITH (NOLOCK) where clientId=@indexingClientId and (subclientStatus & 512)<>0
				select @defaultCopyId=defaultCopy from archGroup ag WITH (NOLOCK), APP_Application app WITH (NOLOCK) where app.clientId=@indexingClientId and (app.subclientStatus & 512)<>0 and ag.id=app.dataArchGrpID
				INSERT @dataPathErasetbl
					 EXEC MMS2GetPreferredDataPath 0,0,@defaultCopyId,@indexingClientId,@indexingAppId, 0, 1
				select @eraseManagementMaId=ClientId from MMDrivePool DPool WITH(READUNCOMMITTED), @dataPathErasetbl DP where DPool.DrivePoolId = DP.dpId
				DELETE FROM @dataPathErasetbl
				UPDATE @tblAppIdMaIdList
				SET maId = @eraseManagementMaId, maVersion = c.release
				FROM APP_Client a WITH (NOLOCK) INNER JOIN simAllGalaxyRel c WITH(NOLOCK) ON a.releaseId = c.id and a.id = @eraseManagementMaId
				WHERE appId = @appIdTemp
		END
		ELSE
		BEGIN
			DECLARE @clientId int
			SET @clientId = 0
			DECLARE @copyId int
			SET @copyId = 0
			DECLARE @retCodeTemp int
			DECLARE @dataPathtbl table(dpId int, errCode int, warningBitMask int)
			DECLARE	@copyForAppIdTbl table(retCode int, archGrpId int, copyId int, clientId int)
			--There should only be one row returned
			INSERT @copyForAppIdTbl
			EXEC GetCopyForRegularOrBCDIndexMA @appIdTemp, @i2_copyPrecedence
			SELECT @retCodeTemp = retCode FROM @copyForAppIdTbl
			IF @retCodeTemp = 0	--Stored proc success
				SELECT @clientId = clientId, @copyId = copyId FROM @copyForAppIdTbl
			ELSE	 		--Stored proc failed
			BEGIN
				DELETE FROM @copyForAppIdTbl
				FETCH NEXT FROM appIdListCursor INTO @appIdTemp
				CONTINUE
			END
			DECLARE @drivePoolId int
			SET @drivePoolId = 0
			IF @copyId > 0
			BEGIN
				INSERT @dataPathtbl
				EXEC MMS2GetPreferredDataPath 0,0,@copyId,@clientId,@appIdTemp, 0 , 1
				SELECT TOP 1 @drivePoolId = dpId FROM @dataPathtbl
			END
			IF(@drivePoolId = 0)
			BEGIN
				DECLARE @l_archFileId int = 0
				DECLARE @l_archFileCommcellId int = 0
				DECLARE @l_archCopyId int = 0
				DECLARE @l_VolumeId int = 0
				DECLARE @l_errorCode int = 0
				--Try to fetch the drivepoolid from ArchFileCopy
				SELECT top 1 @drivePoolId = AFC.drivePoolId, @l_archFileId = AFC.archFileId, @l_archFileCommcellId = AFC.commcellId, @l_archCopyId = AFC.archCopyId
				FROM ArchFileCopy AFC WITH(NOLOCK) INNER JOIN ArchFile AF WITH(NOLOCK) ON AFC.ArchFileId = AF.id AND AFC.CommcellId = AF.CommcellId
				INNER JOIN ArchGroupCopy AGC WITH(NOLOCK) ON AFC.ArchCopyId = AGC.id
				WHERE AF.appId = @appIdTemp AND ((AGC.copy = @i2_copyPrecedence AND @i2_copyPrecedence > 0) OR @i2_copyPrecedence = 0)
AND AF.isValid = 1 AND AFC.isValid = 1 AND AF.fileType IN (2, 6) AND AGC.type <> 5
				ORDER BY AGC.copy ASC, AF.cTime DESC
				IF(@drivePoolId = 0)
				BEGIN
					SELECT top 1 @l_VolumeId = AC.VolumeId
					FROM ArchChunkMapping ACM WITH(NOLOCK) INNER JOIN ArchChunk AC WITH(NOLOCK) ON ACM.ArchChunkId = AC.id
					AND ACM.ChunkCommcellId = AC.CommcellId
					WHERE ACM.ArchFileId = @l_archFileId AND ACM.CommcellId = @l_archFileCommcellId AND ACM.ArchCopyId = @l_archCopyId AND ACM.ChunkNumber = 1
					IF(@l_VolumeId > 0)
					BEGIN
						DECLARE @tblMA_DP TABLE (
					    mmErrorCode         integer,
mediaAgentName      varchar(1024),
					    clientId            integer,
					    nasClientId         integer,
					    clientReleaseId     integer,
filerName           varchar(1024),
					    hostId              integer,
					    drivepoolId         integer,
					    drivepoolType       integer,
					    libraryId           integer,
					    libraryTypeId       integer,
					    libraryAttribute    integer,
libraryName         varchar(128),
libraryAliasName    varchar(128),
barCode             varchar(256),
					    volumeId            integer,
					    mediaLocation       integer,
					    jobOpType           integer,
					    failureType         integer)
						INSERT  INTO @tblMA_DP
		    			EXEC    @l_errorCode = MMS2GetMAAndDPForVolume @l_volumeId, 0, 0, 0, 0, 0
		    			IF @l_errorCode = 0
		    				SELECT @drivePoolId = ISNULL(drivePoolId, 0) FROM @tblMA_DP
					END
					IF(@drivePoolId = 0)
						SELECT @drivePoolId = ISNULL(CAST(value AS int),0) FROM GxGlobalParam WITH(NOLOCK) WHERE name = 'BrowseMediaAgentDPArchMgr'
				END
			END
			UPDATE @tblAppIdMaIdList
			SET maId = b.id, maVersion = c.release
			FROM MMDrivePool a WITH(NOLOCK) inner join APP_Client b WITH(NOLOCK) ON a.DrivePoolId = @drivePoolId AND @drivePoolId > 0 AND a.ClientId = b.id AND b.id > 1
			INNER JOIN simAllGalaxyRel c WITH(NOLOCK) ON b.releaseId = c.id
			WHERE appId = @appIdTemp
			DELETE FROM @dataPathtbl
			DELETE FROM @copyForAppIdTbl
		END
		FETCH NEXT FROM appIdListCursor INTO @appIdTemp
	END
    UPDATE @tblAppIdMaIdList
    SET idxCacheSoftState = 1
    FROM @tblAppIdMaIdList maList INNER JOIN MMHost ma WITH(NOLOCK) ON maList.maId = ma.clientId
WHERE ma.MMHostEnabled = 1 AND (ma.MMHostSoftState = 1 OR (ma.OfflineReason = 7 AND (ma.Attribute & 32768) > 0) )
    AND EXISTS (SELECT 1 from APP_ClientProp clientProp WITH(NOLOCK) where clientProp.componentNameId = ma.ClientId and clientProp.attrName='Idx: cache enabled' and clientProp.attrVal='1')
    IF EXISTS(SELECT 1 FROM @tblAppIdMaIdList WHERE idxCacheSoftState = 0)
		UPDATE @tblAppIdMaIdList
		SET idxCacheSoftState = 1
		FROM @tblAppIdMaIdList maList INNER JOIN MMHost ma WITH(NOLOCK) ON maList.maId = ma.clientId
		INNER JOIN IdxAccessPath ap WITH(NOLOCK) ON ma.ClientId = ap.clientId
		INNER JOIN IdxCache cache WITH(NOLOCK) ON ap.IdxCacheId = cache.IdxCacheId
WHERE ma.MMHostEnabled = 1 AND (ma.MMHostSoftState = 1 OR (ma.OfflineReason = 7 AND (ma.Attribute & 32768) > 0) ) AND cache.IdxCacheType = 1 AND
		ap.enabled = 1 AND ap.softState = 1 AND cache.enabled = 1 AND cache.softState = 1 AND
		NOT EXISTS (SELECT 1 FROM APP_ClientProp clientProp WITH(NOLOCK) WHERE clientProp.componentNameId = ma.ClientId and clientProp.attrName='Idx: cache enabled')
	IF OBJECT_ID('tempdb..#tempResSet') IS NOT NULL --For AppGetIndexDetails SP
	BEGIN
		TRUNCATE TABLE #tempResSet;
INSERT INTO #tempResSet SELECT a.returnOrder, a.id, a.commCellId, a.appId, a.archGroupId, a.fileType, a.cTime, a.jobId, b.maId, b.maVersion, b.idxCacheSoftState, a.flags, a.isRunningJob, CASE WHEN (a.AFCFlags & 256) > 0 THEN 1 ELSE 0 END, a.VMGUID
		FROM #tblResultSetAfiles a	INNER JOIN @tblAppIdMaIdList b ON a.appId = b.appId
		ORDER BY returnOrder, appId, cTime, fileType;
	END
	ELSE
SELECT a.returnOrder, a.id, a.commCellId, a.appId, a.archGroupId, a.fileType, a.cTime, a.jobId, b.maId, b.maVersion, b.idxCacheSoftState, a.flags, a.isRunningJob, CASE WHEN (a.AFCFlags & 256) > 0 THEN 1 ELSE 0 END, a.VMGUID, a.fullCycleNum
		FROM #tblResultSetAfiles a	INNER JOIN @tblAppIdMaIdList b ON a.appId = b.appId
		ORDER BY returnOrder, appId, cTime, fileType;
GO

IF EXISTS (select * from GxQscripts where name = 'archFileByTimeSuperBrowse')
	delete from GxQscripts where name = 'archFileByTimeSuperBrowse'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileByTimeSuperBrowse')
	delete from GXDBVersions where aliasname = 'archFileByTimeSuperBrowse'
GO

insert into GXDBVersions values(2, 'archFileByTimeSuperBrowse',  'v1.26.2.35.4.1', 'archFileByTimeSuperBrowse', 'v1.26.2.35.4.1')
GO

