

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileByTimeForE2K.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc.  The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileByTimeForE2K.sp,v $ $Id: archFileByTimeForE2K.sp,v 1.5.204.2 2018/03/22 01:18:01 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archFileByTimeForE2K <<<'

IF EXISTS (select * from sysobjects where name='archFileByTimeForE2K')
	drop procedure archFileByTimeForE2K
IF EXISTS (select * from GxQscripts where name='archFileByTimeForE2K')
	delete from GxQscripts where name = 'archFileByTimeForE2K'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileByTimeForE2K')
	delete from GXDBVersions where aliasname = 'archFileByTimeForE2K'
GO
print '... Creating Procedure: archFileByTimeForE2K'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archFileByTimeForE2K
  @i_appId integer,
  @i_archFileName NVARCHAR(2048),
  @i_afterTime integer,
  @i_beforeTime integer,
  @i_copyPrec integer,
  @i_includeAgedData integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @r_afileId integer
  DECLARE @r_commCellId integer
  DECLARE @r_fileName NVARCHAR(2048)
  DECLARE @r_createTime integer
  DECLARE @r_backupLevel integer
  DECLARE @r_jobId integer
  DECLARE @r_physicalSize bigint
  DECLARE @r_agroupId integer
  DECLARE @r_copyId integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE  @tblAFile	TABLE (id int, name NVARCHAR(2048), commCellId int, archGroupId int, cTime int, jobId int, backupLevel int)
DECLARE  @tblAFCopy	TABLE (archFileId int, commCellId int, physicalSize bigint, copy int)
INSERT	INTO @tblAFile
SELECT	id, name, commCellId, archGroupId, cTime, jobId, backupLevel
FROM 	archFile
WHERE	appId = @i_appId AND isValid = 1 AND cTime >= @i_afterTime AND cTime <= @i_beforeTime
	AND name LIKE '%' + @i_archFileName + '%'
INSERT	INTO @tblAFCopy
SELECT	AFC.archFileId, AFC.commCellId, AFC.physicalSize, MIN(AGC.copy) AS copy
FROM	@tblAFile AF, archFileCopy AFC, archGroupCopy AGC
WHERE	AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId
	AND AFC.isValid > 0 AND AFC.archCopyId = AGC.id
	AND AGC.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
AND ( (@i_copyPrec = -1 AND AGC.id IN (SELECT defaultCopy FROM archGroup))
OR @i_copyPrec = 0
		OR @i_copyPrec = AGC.copy)
	AND (@i_includeAgedData <> 0 OR (AFC.flags & 256) = 0)
GROUP BY AFC.archFileId, AFC.commCellId, AFC.physicalSize
SELECT	AF.id, AF.commCellId, AF.name, AF.cTime, AF.backupLevel, AF.jobId, AFC.physicalSize, AF.archGroupId, AGC.id
FROM	@tblAFile AF, @tblAFCopy AFC, archGroupCopy AGC
WHERE	AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId
	AND AF.archGroupId = AGC.archGroupId AND AFC.copy = AGC.copy
ORDER BY AF.cTime DESC
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archFileByTimeForE2K')
	delete from GxQscripts where name = 'archFileByTimeForE2K'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileByTimeForE2K')
	delete from GXDBVersions where aliasname = 'archFileByTimeForE2K'
GO

insert into GXDBVersions values(2, 'archFileByTimeForE2K',  '00010005020400020000', 'archFileByTimeForE2K', '00010005020400020000')
GO

