

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileByTimeDiagnose.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc.  The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileByTimeDiagnose.sp,v $ $Id: archFileByTimeDiagnose.sp,v 1.5.210.2 2018/03/22 01:04:52 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archFileByTimeDiagnose <<<'

IF EXISTS (select * from sysobjects where name='archFileByTimeDiagnose')
	drop procedure archFileByTimeDiagnose
IF EXISTS (select * from GxQscripts where name='archFileByTimeDiagnose')
	delete from GxQscripts where name = 'archFileByTimeDiagnose'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileByTimeDiagnose')
	delete from GXDBVersions where aliasname = 'archFileByTimeDiagnose'
GO
print '... Creating Procedure: archFileByTimeDiagnose'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archFileByTimeDiagnose
  @i_backupSetId integer,
  @i_appId integer,
  @i_fileType integer,
  @i_cutTime integer,
  @i_afterOrBefore integer,
  @i_completedJobOnly integer,
  @i_copyPrecedence integer,
  @i_includeAgedData integer,
  @i_includeReplacedIndex integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_returnCode integer
  DECLARE @o_archFileId integer
  DECLARE @o_commCellId integer
  DECLARE @o_archGroupId integer
  DECLARE @o_archCopyId integer
  DECLARE @o_createTime integer
  DECLARE @o_jobId integer
  DECLARE @o_backupLevel integer
  DECLARE @o_appId integer
  DECLARE @o_clientName varchar(256)
  DECLARE @o_appTypeName varchar(256)
  DECLARE @o_backupSetName varchar(256)
  DECLARE @o_subclientName varchar(256)
  DECLARE @o_archGroupName varchar(256)
  DECLARE @o_archCopyName varchar(256)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
CREATE TABLE #tblAFile (
	id INT, commCellId INT, archGroupId INT, appId INT, fileType INT, cTime INT, jobId INT, backupLevel INT,
	PRIMARY KEY (id, commCellId))
CREATE TABLE #tblAFCopy (
	archFileId INT, commCellId INT, archCopyId INT, flags INT, isValid INT, physicalSize bigint,
	PRIMARY KEY (archFileId, commCellId, archCopyId))
DECLARE	@l_error	INT
DECLARE	@l_rowcount	INT
SET @o_returnCode	= 0
SET @o_archFileId	= 0
SET @o_commCellId	= 0
SET @o_archGroupId	= 0
SET @o_archCopyId	= 0
SET @o_createTime	= 0
SET @o_jobId		= 0
SET @o_backupLevel	= 0
SET @o_appId		= @i_appId
IF @i_appId > 0
	INSERT INTO #tblAFile
	SELECT	id, commCellId, archGroupId, appId, fileType, cTime, jobId, backupLevel
	FROM	archFile
	WHERE	appId = @i_appId AND isValid = 1
ELSE
IF @i_backupSetId > 0
	INSERT INTO #tblAFile
	SELECT	AF.id, AF.commCellId, AF.archGroupId, AF.appId, AF.fileType, AF.cTime, AF.jobId, AF.backupLevel
	FROM	archFile AF, APP_Application APP
	WHERE	AF.appId = APP.id AND APP.backupSet = @i_backupSetId AND isValid = 1
SELECT	@l_error = @@ERROR, @l_rowcount = @@ROWCOUNT
IF	@l_error <> 0	GOTO FINISH
IF	@l_rowcount = 0
BEGIN
	IF @i_appId > 0
SET	@o_returnCode = 40
	ELSE
SET	@o_returnCode = 41
	GOTO FINISH
END
SELECT	TOP 1 @o_archFileId = id, @o_commCellId = commCellId, @o_archGroupId = archGroupId,
		@o_createTime = cTime, @o_jobId = jobId, @o_backupLevel = backupLevel, @o_appId = appId
FROM	#tblAFile
ORDER	BY cTime DESC
IF @i_fileType > 0
BEGIN
IF	@i_fileType = 2 AND @i_includeReplacedIndex <> 0
		DELETE	#tblAFile
WHERE	fileType NOT IN (2, 34)
	ELSE
		DELETE	#tblAFile
		WHERE	fileType <> @i_fileType
	IF	NOT EXISTS (SELECT * FROM #tblAFile)
	BEGIN
SET	@o_returnCode = 42
		GOTO FINISH
	END
	SELECT	TOP 1 @o_archFileId = id, @o_commCellId = commCellId, @o_archGroupId = archGroupId,
			@o_createTime = cTime, @o_jobId = jobId, @o_backupLevel = backupLevel, @o_appId = appId
	FROM	#tblAFile
	ORDER	BY cTime DESC
END
IF	@i_afterOrBefore = 0
BEGIN
	DELETE	#tblAFile
	WHERE	cTime > @i_cutTime
	IF	NOT EXISTS (SELECT * FROM #tblAFile)
	BEGIN
SET	@o_returnCode = 43
		GOTO FINISH
	END
END
ELSE
BEGIN
	DELETE	#tblAFile
	WHERE	cTime <= @i_cutTime
	IF	NOT EXISTS (SELECT * FROM #tblAFile)
	BEGIN
SET	@o_returnCode = 44
		GOTO FINISH
	END
END
SELECT	TOP 1 @o_archFileId = id, @o_commCellId = commCellId, @o_archGroupId = archGroupId,
		@o_createTime = cTime, @o_jobId = jobId, @o_backupLevel = backupLevel, @o_appId = appId
FROM	#tblAFile
ORDER	BY cTime DESC
IF	@i_completedJobOnly <> 0
BEGIN
	DELETE	#tblAFile
	WHERE	NOT EXISTS (
			SELECT	jobId
			FROM	JMJobDataStats
			WHERE	jobId = #tblAFile.jobId AND commCellId = #tblAFile.commCellId
				AND archGrpId = #tblAFile.archGroupId)
	SELECT	@l_error = @@ERROR, @l_rowcount = @@ROWCOUNT
	IF	@l_error <> 0	GOTO FINISH
	IF	NOT EXISTS (SELECT * FROM #tblAFile)
	BEGIN
SET	@o_returnCode = 43
		GOTO FINISH
	END
END
INSERT INTO #tblAFCopy
SELECT	AFC.archFileId, AFC.commCellId, AFC.archCopyId, AFC.flags, AFC.isValid, AFC.physicalSize
FROM	#tblAFile AF, archFileCopy AFC
WHERE	AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId
SELECT	@l_error = @@ERROR, @l_rowcount = @@ROWCOUNT
IF	@l_error <> 0	GOTO FINISH
IF	NOT EXISTS (SELECT * FROM #tblAFCopy)
BEGIN
	IF	@i_afterOrBefore = 0
SET	@o_returnCode = 43
	ELSE
SET	@o_returnCode = 44
	GOTO FINISH
END
SELECT	TOP 1 @o_archFileId = AF.id, @o_commCellId = AF.commCellId,
		@o_archGroupId = AF.archGroupId, @o_archCopyId = AFC.archCopyId,
		@o_createTime = AF.cTime, @o_jobId = AF.jobId,
		@o_backupLevel = AF.backupLevel, @o_appId = AF.appId
FROM	#tblAFile AF, #tblAFCopy AFC
WHERE	AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId
ORDER	BY AF.cTime DESC, AFC.isValid DESC
IF	@i_includeAgedData = 0
BEGIN
	DELETE	#tblAFCopy
WHERE	(flags & 256) = 256
	IF	NOT EXISTS (SELECT * FROM #tblAFCopy)
	BEGIN
SET	@o_returnCode = 45
		GOTO FINISH
	END
	SELECT	TOP 1 @o_archFileId = AF.id, @o_commCellId = AF.commCellId,
			@o_archGroupId = AF.archGroupId, @o_archCopyId = AFC.archCopyId,
			@o_createTime = AF.cTime, @o_jobId = AF.jobId,
			@o_backupLevel = AF.backupLevel, @o_appId = AF.appId
	FROM	#tblAFile AF, #tblAFCopy AFC
	WHERE	AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId
	ORDER	BY AF.cTime DESC, AFC.isValid DESC
END
IF	@i_copyPrecedence > 0 AND NOT EXISTS (
	SELECT	*
	FROM	#tblAFCopy AFC, archGroupCopy AGC
	WHERE	AGC.id = AFC.archCopyId AND AGC.copy = @i_copyPrecedence)
BEGIN
	IF NOT EXISTS (SELECT * FROM archGroupCopy
		WHERE	archGroupId IN (
				(SELECT	DISTINCT archGroupId FROM archGroupCopy
				WHERE	id IN (SELECT DISTINCT archCopyId FROM #tblAFCopy)))
			AND copy = @i_copyPrecedence)
SET	@o_returnCode = 56
	ELSE
SET	@o_returnCode = 46
	GOTO FINISH
END
-- Ususally We should get to here since this procedure will only be run
-- when no archive file was returned by some Archive Manager's function.
-- Maybe some parameter is not same as in the previous Archive Manager's
-- function call or some case has not been covered in this procedure!!!
SET	@o_returnCode = 47
FINISH:
IF	@o_archCopyId > 0
BEGIN
	SELECT	@o_returnCode, @o_archFileId, @o_commCellId,
			@o_archGroupId, @o_archCopyId, @o_createTime,
			@o_jobId, @o_backupLevel, @o_appId,
			(SELECT name FROM APP_client WHERE id = A.clientId),
			(SELECT name FROM APP_iDAType WHERE type = A.appTypeId),
			(SELECT name FROM APP_backupSetName WHERE id = A.backupSet),
			A.subclientName,
			(SELECT name FROM archGroup WHERE id = @o_archGroupId),
			(SELECT name FROM archGroupCopy WHERE id = @o_archCopyId)
	FROM	APP_application A
	WHERE	id = @o_appId
END
ELSE
IF	@o_archFileId > 0
	SELECT	@o_returnCode, @o_archFileId, @o_commCellId,
			@o_archGroupId, @o_archCopyId, @o_createTime,
			@o_jobId, @o_backupLevel, @o_appId,
			(SELECT name FROM APP_client WHERE id = A.clientId),
			(SELECT name FROM APP_iDAType WHERE type = A.appTypeId),
			(SELECT name FROM APP_backupSetName WHERE id = A.backupSet),
			A.subclientName,
			(SELECT name FROM archGroup WHERE id = @o_archGroupId),	''
	FROM	APP_application A
	WHERE	id = @o_appId
ELSE
IF	@o_appId > 0
	SELECT	@o_returnCode, @o_archFileId, @o_commCellId,
			@o_archGroupId, @o_archCopyId, @o_createTime,
			@o_jobId, @o_backupLevel, @o_appId,
			(SELECT name FROM APP_client WHERE id = A.clientId),
			(SELECT name FROM APP_iDAType WHERE type = A.appTypeId),
			(SELECT name FROM APP_backupSetName WHERE id = A.backupSet),
			A.subclientName, '', ''
	FROM	APP_application A
	WHERE	id = @o_appId
ELSE
IF	@i_backupSetId > 0
	SELECT	@o_returnCode, @o_archFileId, @o_commCellId,
			@o_archGroupId, @o_archCopyId, @o_createTime,
			@o_jobId, @o_backupLevel, @o_appId,
			(SELECT name FROM APP_client WHERE id = A.clientId),
			(SELECT name FROM APP_iDAType WHERE type = A.appTypeId),
			(SELECT name FROM APP_backupSetName WHERE id = @i_backupSetId),
			'',	'',	''
	FROM	(SELECT	TOP 1 clientId, appTypeId
			FROM	APP_application
			WHERE	backupSet = @i_backupSetId) A
ELSE
	SELECT	@o_returnCode, @o_archFileId, @o_commCellId,
			@o_archGroupId, @o_archCopyId, @o_createTime,
			@o_jobId, @o_backupLevel, @o_appId,
			'',	'',	'',	'',	'',	''
DROP TABLE #tblAFile
DROP TABLE #tblAFCopy
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archFileByTimeDiagnose')
	delete from GxQscripts where name = 'archFileByTimeDiagnose'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileByTimeDiagnose')
	delete from GXDBVersions where aliasname = 'archFileByTimeDiagnose'
GO

insert into GXDBVersions values(2, 'archFileByTimeDiagnose',  '00010005021000020000', 'archFileByTimeDiagnose', '00010005021000020000')
GO

