

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileByTime.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc.  The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileByTime.sp,v $ $Id: archFileByTime.sp,v 1.18.54.6 2018/11/14 19:28:18 prasanthm Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archFileByTime')
BEGIN
	print '>>> Drop Stored Procedure: archFileByTime <<<'
	drop procedure archFileByTime
END
IF EXISTS (select * from GxQscripts where name='archFileByTime')
	delete from GxQscripts where name = 'archFileByTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileByTime')
	delete from GXDBVersions where aliasname = 'archFileByTime'
GO
print '... Creating Procedure: archFileByTime'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archFileByTime
  @i_backupSetId integer,
  @i_appId integer,
  @i_fileType integer,
  @i_cutTime integer,
  @i_afterOrBefore integer,
  @i_completedJobOnly integer,
  @i_copyPrecedence integer,
  @i_includeAgedData integer,
  @i_includeReplacedIndex integer,
  @i_countBCDForIndex integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @r_afileId integer
  DECLARE @r_commCellId integer
  DECLARE @r_agroupId integer
  DECLARE @r_copyId integer
  DECLARE @r_fileType integer
  DECLARE @r_createTime integer
  DECLARE @r_jobId integer
  DECLARE @r_backupLevel integer
  DECLARE @r_physicalSize bigint
  DECLARE @r_logicalSize bigint
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF @i_afterOrBefore = 0 AND @i_cutTime <= 0
	SET  @i_cutTime = 0x7FFFFFFF
DECLARE @retRows table(AFId int, commcellId int, archGroupId int, copyId int, fileType int, cTime int, jobId int, bkpLevel int, physicalSize int, logicalSize int)
--This is a special option added for synth. full. Added this MMConfig param, so we will turn it off by default and enable it only for specific customers who wants a change in existing behavior
IF(@i_copyPrecedence = -3 AND NOT EXISTS (SELECT 1 from MMConfigs WITH(NOLOCK) where name = 'ARMGR_CONFIG_ALLOW_CVA_COPY_CLASSIC_PRIMARY_AND_PRECEDENCE_ANY' and value > 0))
SET @i_copyPrecedence = 0
IF	@i_appId > 0 AND (@i_includeAgedData & 2) <> 0
BEGIN
	IF @i_completedJobOnly = 0
	BEGIN
IF @i_copyPrecedence = -3
		BEGIN
			INSERT INTO @retRows
			SELECT	TOP 1 AF.id, AF.commCellId, AF.archGroupId, AFC.archCopyId, AF.fileType, AF.cTime, AF.jobId, AF.backupLevel, AFC.physicalSize, AFC.logicalSize
			FROM	archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
			WHERE	AF.appId = @i_appId AND AF.isValid = 1
				AND (@i_fileType = 0
OR @i_fileType = 2 AND (AF.fileType IN (2, 34)
OR @i_countBCDForIndex = 1 AND AF.fileType = 6)
					OR @i_fileType = AF.fileType)
				AND ((@i_afterOrBefore = 0 AND AF.cTime <= @i_cutTime) OR (@i_afterOrBefore <> 0 AND AF.cTime > @i_cutTime))
				AND AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId AND AFC.archCopyId = AGC.id AND AF.archGroupId = AGC.archGroupId
AND AFC.isValid > 0 AND (((@i_includeAgedData & 1) <> 0 AND AF.fileType != 6) OR (AFC.flags & 256) = 0)
				AND	AGC.archGroupId = AG.id
				AND AGC.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
				AND AGC.id = AG.defaultCopy
			IF @@ROWCOUNT > 0
			BEGIN
				SELECT * FROM @retRows
				ORDER BY cTime DESC
				RETURN
			END
			ELSE --Let us fall back to other copies
SET @i_copyPrecedence = 0
		END
		SELECT	TOP 1 AF.id, AF.commCellId, AF.archGroupId, AFC.archCopyId, AF.fileType, AF.cTime, AF.jobId, AF.backupLevel, AFC.physicalSize, AFC.logicalSize
		FROM	archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
		WHERE	AF.appId = @i_appId AND AF.isValid = 1
			AND (@i_fileType = 0
OR @i_fileType = 2 AND (AF.fileType IN (2, 34)
OR @i_countBCDForIndex = 1 AND AF.fileType = 6)
				OR @i_fileType = AF.fileType)
			AND ((@i_afterOrBefore = 0 AND AF.cTime <= @i_cutTime) OR (@i_afterOrBefore <> 0 AND AF.cTime > @i_cutTime))
			AND AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId AND AFC.archCopyId = AGC.id AND AF.archGroupId = AGC.archGroupId
AND AFC.isValid > 0 AND (((@i_includeAgedData & 1) <> 0 AND AF.fileType != 6) OR (AFC.flags & 256) = 0)
			AND	AGC.archGroupId = AG.id
			AND AGC.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
AND (@i_copyPrecedence = -1 AND AGC.id = AG.defaultCopy
OR @i_copyPrecedence = -4 AND AGC.isSnapCopy = 0
OR @i_copyPrecedence = -5 AND AGC.id = AG.defaultSnapCopy AND AGC.isSnapCopy = 1
OR @i_copyPrecedence = 0
				OR @i_copyPrecedence = AGC.copy)
		ORDER BY AF.cTime DESC, AGC.copy ASC
	END
	ELSE
	BEGIN
IF @i_copyPrecedence = -3
		BEGIN
			INSERT INTO @retRows
			SELECT	TOP 1 AF.id, AF.commCellId, AF.archGroupId, AFC.archCopyId, AF.fileType, AF.cTime, AF.jobId, AF.backupLevel, AFC.physicalSize, AFC.logicalSize
			FROM	archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK), JMJobDataStats J WITH (NOLOCK)
			WHERE	AF.appId = @i_appId AND AF.isValid = 1
				AND (@i_fileType = 0
OR @i_fileType = 2 AND (AF.fileType IN (2, 34)
OR @i_countBCDForIndex = 1 AND AF.fileType = 6)
					OR @i_fileType = AF.fileType)
				AND ((@i_afterOrBefore = 0 AND AF.cTime <= @i_cutTime) OR (@i_afterOrBefore <> 0 AND AF.cTime > @i_cutTime))
				AND AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId AND AFC.archCopyId = AGC.id AND AF.archGroupId = AGC.archGroupId
AND AFC.isValid > 0 AND (((@i_includeAgedData & 1) <> 0 AND AF.fileType != 6) OR (AFC.flags & 256) = 0)
				AND	AGC.archGroupId = AG.id
				AND AGC.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
				AND AGC.id = AG.defaultCopy
				AND J.jobId = AF.jobId AND J.commCellId = AF.commCellId
			IF @@ROWCOUNT > 0
			BEGIN
				SELECT * FROM @retRows
				ORDER BY cTime DESC
				RETURN
			END
			ELSE --Let us fall back to other copies
SET @i_copyPrecedence = 0
		END
		SELECT	TOP 1 AF.id, AF.commCellId, AF.archGroupId, AFC.archCopyId, AF.fileType, AF.cTime, AF.jobId, AF.backupLevel, AFC.physicalSize, AFC.logicalSize
		FROM	archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK), JMJobDataStats J WITH (NOLOCK)
		WHERE	AF.appId = @i_appId AND AF.isValid = 1
			AND (@i_fileType = 0
OR @i_fileType = 2 AND (AF.fileType IN (2, 34)
OR @i_countBCDForIndex = 1 AND AF.fileType = 6)
				OR @i_fileType = AF.fileType)
			AND ((@i_afterOrBefore = 0 AND AF.cTime <= @i_cutTime) OR (@i_afterOrBefore <> 0 AND AF.cTime > @i_cutTime))
			AND AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId AND AFC.archCopyId = AGC.id AND AF.archGroupId = AGC.archGroupId
AND AFC.isValid > 0 AND (((@i_includeAgedData & 1) <> 0 AND AF.fileType != 6) OR (AFC.flags & 256) = 0)
			AND	AGC.archGroupId = AG.id
			AND AGC.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
AND (@i_copyPrecedence = -1 AND AGC.id = AG.defaultCopy
OR @i_copyPrecedence = -4 AND AGC.isSnapCopy = 0
OR @i_copyPrecedence = -5 AND AGC.id = AG.defaultSnapCopy AND AGC.isSnapCopy = 1
OR @i_copyPrecedence = 0
				OR @i_copyPrecedence = AGC.copy)
			AND J.jobId = AF.jobId AND J.commCellId = AF.commCellId
		ORDER BY AF.cTime DESC, AGC.copy ASC
END
END
ELSE
BEGIN
	DECLARE @tblAFile TABLE (
		id INT, commCellId INT, archGroupId INT, fileType INT, cTime INT, jobId INT, backupLevel INT)
	IF @i_appId > 0
		INSERT INTO @tblAFile
		SELECT	id, commCellId, archGroupId, fileType, cTime, jobId, backupLevel
		FROM	archFile WITH (NOLOCK)
		WHERE	appId = @i_appId
			AND (@i_fileType = 0
OR @i_fileType = 2 AND (fileType IN (2, 34)
OR @i_countBCDForIndex = 1 AND fileType = 6)
				OR @i_fileType = fileType)
			AND ((@i_afterOrBefore = 0 AND cTime <= @i_cutTime) OR (@i_afterOrBefore <> 0 AND cTime > @i_cutTime))
			AND isValid = 1
	ELSE
	IF @i_backupSetId > 0
		INSERT INTO @tblAFile
		SELECT	id, commCellId, archGroupId, fileType, cTime, jobId, backupLevel
		FROM	archFile WITH (NOLOCK)
		WHERE	appId IN (SELECT id FROM APP_Application WITH (NOLOCK) WHERE backupSet = @i_backupSetId)
			AND (@i_fileType = 0
OR @i_fileType = 2 AND (fileType IN (2, 34)
OR @i_countBCDForIndex = 1 AND fileType = 6)
				OR @i_fileType = fileType)
			AND ((@i_afterOrBefore = 0 AND cTime <= @i_cutTime) OR (@i_afterOrBefore <> 0 AND cTime > @i_cutTime))
			AND isValid = 1
	ELSE
		INSERT INTO @tblAFile
		SELECT	id, commCellId, archGroupId, fileType, cTime, jobId, backupLevel
		FROM	archFile WITH (NOLOCK)
		WHERE	(@i_fileType = 0
OR @i_fileType = 2 AND (fileType IN (2, 34)
OR @i_countBCDForIndex = 1 AND fileType = 6)
				OR @i_fileType = fileType)
			AND ((@i_afterOrBefore = 0 AND cTime <= @i_cutTime) OR (@i_afterOrBefore <> 0 AND cTime > @i_cutTime))
			AND isValid = 1
	IF @i_completedJobOnly <> 0
		DELETE	FROM @tblAFile
		FROM	@tblAFile AS A
		WHERE	NOT EXISTS (SELECT * FROM JMJobDataStats WITH (NOLOCK) WHERE jobId = A.jobId AND commCellId = A.commCellId)
IF (@i_fileType <> 2 OR @i_includeReplacedIndex = 0)
	BEGIN
DELETE FROM @tblAFile WHERE fileType IN (33, 34)
	END
		IF @i_afterOrBefore = 0
	BEGIN
IF @i_copyPrecedence = -3
		BEGIN
			INSERT INTO @retRows
			SELECT a.id, a.commCellId, a.archGroupId, b.archCopyId, a.fileType, a.cTime, a.jobId, a.backupLevel, b.physicalSize, b.logicalSize
			FROM   @tblAFile a, archFileCopy b WITH (NOLOCK), archGroupCopy c WITH (NOLOCK)
			WHERE  a.id = b.archFileId AND a.commCellId = b.commCellId AND b.archCopyId = c.id AND a.archGroupId = c.archGroupId
AND b.isValid > 0 AND (((@i_includeAgedData & 1) <> 0 AND a.fileType != 6) OR (b.flags & 256) = 0)
			AND c.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
			AND c.id = (SELECT defaultCopy FROM archGroup WITH (NOLOCK) WHERE id = c.archGroupId)
			IF @@ROWCOUNT > 0
			BEGIN
				SELECT * FROM @retRows
				ORDER BY cTime DESC
				RETURN
			END
			ELSE --Let us fall back to other copies
SET @i_copyPrecedence = 0
		END
			SELECT a.id, a.commCellId, a.archGroupId, b.archCopyId, a.fileType, a.cTime, a.jobId, a.backupLevel, b.physicalSize, b.logicalSize
			FROM   @tblAFile a, archFileCopy b WITH (NOLOCK), archGroupCopy c WITH (NOLOCK)
			WHERE  a.id = b.archFileId AND a.commCellId = b.commCellId AND b.archCopyId = c.id AND a.archGroupId = c.archGroupId
AND b.isValid > 0 AND (((@i_includeAgedData & 1) <> 0 AND a.fileType != 6) OR (b.flags & 256) = 0)
			AND c.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
AND ((@i_copyPrecedence = -1 AND c.id = (SELECT defaultCopy FROM archGroup WITH (NOLOCK) WHERE id = c.archGroupId))
OR @i_copyPrecedence = -4 AND c.isSnapCopy = 0
OR @i_copyPrecedence = -5 AND c.id = (SELECT defaultSnapCopy FROM archGroup WITH (NOLOCK) WHERE id = c.archGroupId) AND c.isSnapCopy = 1
OR @i_copyPrecedence = 0
				OR @i_copyPrecedence = c.copy)
		ORDER BY a.cTime DESC, c.copy ASC
	END
	ELSE
	IF @i_afterOrBefore <> 0
	BEGIN
IF @i_copyPrecedence = -3
	BEGIN
			INSERT INTO @retRows
			SELECT a.id, a.commCellId, a.archGroupId, b.archCopyId, a.fileType, a.cTime, a.jobId, a.backupLevel, b.physicalSize, b.logicalSize
			FROM   @tblAFile a, archFileCopy b WITH (NOLOCK), archGroupCopy c WITH (NOLOCK)
			WHERE  a.id = b.archFileId AND a.commCellId = b.commCellId AND b.archCopyId = c.id AND a.archGroupId = c.archGroupId
AND b.isValid > 0 AND (((@i_includeAgedData & 1) <> 0 AND a.fileType != 6) OR (b.flags & 256) = 0)
			AND c.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
			AND c.id = (SELECT defaultCopy FROM archGroup WITH (NOLOCK) WHERE id = c.archGroupId)
			IF @@ROWCOUNT > 0
			BEGIN
				SELECT * FROM @retRows
				ORDER BY cTime ASC
				RETURN
			END
			ELSE --Let us fall back to other copies
SET @i_copyPrecedence = 0
		END
			SELECT a.id, a.commCellId, a.archGroupId, b.archCopyId, a.fileType, a.cTime, a.jobId, a.backupLevel, b.physicalSize, b.logicalSize
			FROM   @tblAFile a, archFileCopy b WITH (NOLOCK), archGroupCopy c WITH (NOLOCK)
			WHERE  a.id = b.archFileId AND a.commCellId = b.commCellId AND b.archCopyId = c.id AND a.archGroupId = c.archGroupId
AND b.isValid > 0 AND (((@i_includeAgedData & 1) <> 0 AND a.fileType != 6) OR (b.flags & 256) = 0)
			AND c.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
AND ((@i_copyPrecedence = -1 AND c.id = (SELECT defaultCopy FROM archGroup WITH (NOLOCK) WHERE id = c.archGroupId))
OR @i_copyPrecedence = -4 AND c.isSnapCopy = 0
OR @i_copyPrecedence = -5 AND c.id = (SELECT defaultSnapCopy FROM archGroup WITH (NOLOCK) WHERE id = c.archGroupId) AND c.isSnapCopy = 1
OR @i_copyPrecedence = 0
				OR @i_copyPrecedence = c.copy)
			ORDER BY a.cTime ASC, c.copy ASC
	END
END
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archFileByTime')
	delete from GxQscripts where name = 'archFileByTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileByTime')
	delete from GXDBVersions where aliasname = 'archFileByTime'
GO

insert into GXDBVersions values(2, 'archFileByTime',  '00010018005400060000', 'archFileByTime', '00010018005400060000')
GO

