

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileByNameTime.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc.  The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileByNameTime.sp,v $ $Id: archFileByNameTime.sp,v 1.6.204.2 2018/03/22 01:11:08 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archFileByNameTime <<<'

IF EXISTS (select * from sysobjects where name='archFileByNameTime')
	drop procedure archFileByNameTime
IF EXISTS (select * from GxQscripts where name='archFileByNameTime')
	delete from GxQscripts where name = 'archFileByNameTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileByNameTime')
	delete from GXDBVersions where aliasname = 'archFileByNameTime'
GO
print '... Creating Procedure: archFileByNameTime'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archFileByNameTime
  @i_appId integer,
  @i_backupsetId integer,
  @i_instanceId integer,
  @i_clientId integer,
  @i_fileName NVARCHAR(2048),
  @i_beforeTime integer,
  @i_copyPrecedence integer,
  @i_includeAgedData integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @r_afileId integer
  DECLARE @r_commCellId integer
  DECLARE @r_agroupId integer
  DECLARE @r_copyId integer
  DECLARE @r_createTime integer
  DECLARE @r_backupLevel integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @tblAFile TABLE (
	id INT, commCellId INT, archGroupId INT, cTime INT, backupLevel INT)
DECLARE	@l_clientId int
DECLARE @l_appTypeId int
DECLARE @l_instanceId int
DECLARE @l_filename nvarchar(2048)
DECLARE @l_instName varchar(2048)
IF	(@i_fileName like '%.onconfig' OR @i_fileName like '%.oncfg' OR @i_fileName like '%.ixbar')
BEGIN
	SELECT	@l_clientId = clientId, @l_appTypeId = appTypeId, @l_instanceId = instance
	FROM	APP_application WITH (NOLOCK)
	WHERE	@i_clientId > 0 AND @i_instanceId > 0 AND clientId = @i_clientId AND instance = @i_instanceId
		 OR @i_appId > 0 AND id = @i_appId
IF	@l_appTypeId = 3
	BEGIN
		SELECT	@l_instName = name
		FROM	APP_InstanceName WITH (NOLOCK)
		WHERE	id = @l_instanceId
		SET @l_filename = @l_instName +
			(case	when @i_fileName like '%.onconfig'	then '.onconfig'
					when @i_fileName like '%.oncfg'		then '.oncfg'
					when @i_fileName like '%.ixbar'		then '.ixbar'	end)
		IF	@i_fileName = (CAST(@l_instanceId AS nvarchar(8)) + '.' + @l_filename)
			SET @i_fileName = @l_filename
	END
END
IF @i_appId > 0
	INSERT INTO @tblAFile
	SELECT	id, commCellId, archGroupId, cTime, backupLevel
	FROM	archFile WITH (NOLOCK)
	WHERE	appId = @i_appId
		AND cs_afname = CHECKSUM(@i_fileName) AND name = @i_fileName
		AND isValid = 1 AND cTime <= @i_beforeTime
ELSE IF @i_backupsetId > 0
	INSERT INTO @tblAFile
	SELECT	id, commCellId, archGroupId, cTime, backupLevel
	FROM	archFile WITH (NOLOCK)
	WHERE	appId IN (SELECT id FROM APP_Application WITH (NOLOCK) WHERE backupSet = @i_backupsetId)
		AND cs_afname = CHECKSUM(@i_fileName) AND name = @i_fileName
		AND isValid = 1 AND cTime <= @i_beforeTime
ELSE IF @i_clientId > 0
	INSERT INTO @tblAFile
	SELECT	 id, commCellId, archGroupId, cTime, backupLevel
	FROM	archFile WITH (NOLOCK)
	WHERE	appId IN (SELECT id FROM APP_Application WITH (NOLOCK) WHERE clientId = @i_clientId
						AND (@i_instanceId = 0 OR instance = @i_instanceId))
		AND cs_afname = CHECKSUM(@i_fileName) AND name = @i_fileName
		AND isValid = 1 AND cTime <= @i_beforeTime
ELSE
	INSERT INTO @tblAFile
	SELECT	id, commCellId, archGroupId, cTime, backupLevel
	FROM	archFile WITH (NOLOCK)
	WHERE	cs_afname = CHECKSUM(@i_fileName) AND name = @i_fileName
		AND isValid = 1 AND cTime <= @i_beforeTime
SELECT	a.id, a.commCellId, a.archGroupId, b.archCopyId, a.cTime, a.backupLevel
FROM	@tblAFile a, archFileCopy b WITH (NOLOCK), archGroupCopy c WITH (NOLOCK)
WHERE	a.id = b.archFileId AND a.commCellId = b.commCellId
	AND a.archGroupId = c.archGroupId AND b.archCopyId = c.id
	AND b.isValid > 0 AND (@i_includeAgedData <> 0 OR (b.flags & 256) = 0)
	AND c.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
AND ( (@i_copyPrecedence = -1 AND c.id IN (SELECT defaultCopy FROM archGroup WITH (NOLOCK)))
OR @i_copyPrecedence = 0
		OR @i_copyPrecedence = c.copy )
ORDER BY a.cTime DESC, c.copy ASC
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archFileByNameTime')
	delete from GxQscripts where name = 'archFileByNameTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileByNameTime')
	delete from GXDBVersions where aliasname = 'archFileByNameTime'
GO

insert into GXDBVersions values(2, 'archFileByNameTime',  '00010006020400020000', 'archFileByNameTime', '00010006020400020000')
GO

