

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileByNameJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc.  The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileByNameJob.sp,v $ $Id: archFileByNameJob.sp,v 1.6.86.6 2020/02/25 11:28:26 prasanthm Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archFileByNameJob')
BEGIN
	print '>>> Drop Stored Procedure: archFileByNameJob <<<'
	drop procedure archFileByNameJob
END
IF EXISTS (select * from GxQscripts where name='archFileByNameJob')
	delete from GxQscripts where name = 'archFileByNameJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileByNameJob')
	delete from GXDBVersions where aliasname = 'archFileByNameJob'
GO
print '... Creating Procedure: archFileByNameJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archFileByNameJob
  @inAppId integer,
  @inAfileName NVARCHAR(2048),
  @inCommCellId integer,
  @inJobId integer,
  @inCopyPrec integer,
  @includeAgedData integer,
  @inClientId integer,
  @inInstanceId integer,
  @inAfileId integer,
  @inFromTime BIGINT = 0,
  @inToTime BIGINT = 0
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @r_archFileId integer
  DECLARE @r_commCellId integer
  DECLARE @r_archGroupId integer
  DECLARE @r_archCopyId integer
  DECLARE @r_archFileFlags integer
  DECLARE @r_archFileCopyFlags integer
  DECLARE @r_streamNum integer
  DECLARE @r_jobId integer
  DECLARE @r_cTime integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#tblAFile') IS NOT NULL DROP TABLE #tblAFile
CREATE TABLE #tblAFile	 (archFileId int, commCellId int, archGroupId int, flags int, jobId int, cTime int, Primary key(archFileId, commCellId))
IF OBJECT_ID('tempdb.dbo.#tblAFCopy') IS NOT NULL DROP TABLE #tblAFCopy
CREATE TABLE #tblAFCopy (archFileId int, copyId int, streamNum int, flags int, Primary key(archFileId, copyId))
IF @inAfileId != 0
BEGIN
	INSERT INTO #tblAFile
	SELECT id, commCellId, archGroupId, flags, jobId, cTime
	FROM archFile WITH (READUNCOMMITTED)
	WHERE id = @inAfileId
	AND commCellId = @inCommCellId
	AND isValid = 1
END
ELSE
BEGIN
IF @inJobId != 0
	INSERT	INTO #tblAFile
	SELECT	id, commCellId, archGroupId, flags, jobId, cTime
	FROM	archFile WITH (READUNCOMMITTED)
	WHERE	jobId = @inJobId AND commCellId = @inCommCellId
		AND name = @inAfileName AND isValid = 1
ELSE
IF @inAppId != 0
	INSERT	INTO #tblAFile
	SELECT	id, commCellId, archGroupId, flags, jobId, cTime
	FROM	archFile WITH (READUNCOMMITTED)
	WHERE	appId = @inAppId
		AND cs_afname = CHECKSUM(@inAfileName) AND name = @inAfileName
		AND isValid = 1
		AND ((@inFromTime = 0 OR cTime >= @inFromTime) AND (@inToTime = 0 OR cTime <= @inToTime))
ELSE
IF (@inInstanceId != 0) OR (@inClientId != 0)
	INSERT INTO #tblAFile
	SELECT AF.id, AF.commCellId, AF.archGroupId, AF.flags, AF.jobId, AF.cTime
	FROM archFile AF WITH (READUNCOMMITTED),
		APP_Application APP WITH (READUNCOMMITTED)
	WHERE AF.appId = APP.id
		AND APP.clientId = @inClientId
		AND ((APP.instance = @inInstanceId) OR (@inInstanceId = 0))
		AND AF.cs_afname = CHECKSUM(@inAfileName) AND AF.name = @inAfileName
		AND AF.isValid = 1
		AND ((@inFromTime = 0 OR AF.cTime >= @inFromTime) AND (@inToTime = 0 OR AF.cTime <= @inToTime))
ELSE
	INSERT	INTO #tblAFile
	SELECT	id, commCellId, archGroupId, flags, jobId, cTime
	FROM	archFile WITH (READUNCOMMITTED)
	WHERE	cs_afname = CHECKSUM(@inAfileName) AND name = @inAfileName
		AND isValid = 1
		AND ((@inFromTime = 0 OR cTime >= @inFromTime) AND (@inToTime = 0 OR cTime <= @inToTime))
END
IF EXISTS (SELECT 1 FROM APP_CommCell WHERE type > 1)
BEGIN
DELETE	#tblAFile
FROM	#tblAFile AF, APP_CommCell CC WITH (READUNCOMMITTED)
WHERE	CC.id = AF.commCellId AND CC.type > 1
END
INSERT	INTO #tblAFCopy
SELECT	a.archFileId, b.archCopyId, b.streamNum, b.flags
FROM	#tblAFile a, archFileCopy b WITH (READUNCOMMITTED)
WHERE	a.archFileId = b.archFileId AND a.commCellId = b.commCellId
	AND b.isValid = 1 AND (@includeAgedData <> 0 OR (b.flags & 256) = 0)
SELECT	a.archFileId, a.commCellId, a.archGroupId, b.copyId, a.flags, b.flags, b.streamNum, a.jobId, a.cTime
FROM	#tblAFile a
inner join #tblAFCopy b on a.archFileId = b.archFileId
inner join archGroupCopy c WITH (READUNCOMMITTED) on c.id = b.copyId AND c.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
inner join archGroup AG WITH (READUNCOMMITTED) on c.archGroupId = AG.id
WHERE ( (@inCopyPrec = -1 AND c.id = AG.defaultCopy)
OR @inCopyPrec = 0
		OR @inCopyPrec = c.copy)
GROUP	BY a.archGroupId, a.commCellId, b.copyId, a.archFileId, a.flags, b.flags, b.streamNum, a.jobId, a.cTime
ORDER	BY a.cTime desc
IF OBJECT_ID('tempdb.dbo.#tblAFile') IS NOT NULL DROP TABLE #tblAFile
IF OBJECT_ID('tempdb.dbo.#tblAFCopy') IS NOT NULL DROP TABLE #tblAFCopy
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archFileByNameJob')
	delete from GxQscripts where name = 'archFileByNameJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileByNameJob')
	delete from GXDBVersions where aliasname = 'archFileByNameJob'
GO

insert into GXDBVersions values(2, 'archFileByNameJob',  '00010006008600060000', 'archFileByNameJob', '00010006008600060000')
GO

