

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFileByName.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc.  The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFileByName.sp,v $ $Id: archFileByName.sp,v 1.15.42.7 2020/10/15 04:27:06 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archFileByName')
BEGIN
	print '>>> Drop Stored Procedure: archFileByName <<<'
	drop procedure archFileByName
END
IF EXISTS (select * from GxQscripts where name='archFileByName')
	delete from GxQscripts where name = 'archFileByName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileByName')
	delete from GXDBVersions where aliasname = 'archFileByName'
GO
print '... Creating Procedure: archFileByName'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archFileByName
  @i_fileName NVARCHAR(2048),
  @i_appId integer,
  @i_instanceId integer,
  @i_clientId integer,
  @i_copyPrecedence integer,
  @i_includeAgedData integer,
  @i_matchClient integer,
  @i_matchByPattern integer,
  @i_flags integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @r_archFileId integer
  DECLARE @r_jobId integer
  DECLARE @r_commCellId integer
  DECLARE @r_appId integer
  DECLARE @r_appType integer
  DECLARE @r_creationTime integer
  DECLARE @r_archGroupId integer
  DECLARE @r_archCopyId integer
  DECLARE @r_streamNum integer
  DECLARE @r_mediaGroupId integer
  DECLARE @r_archFileName NVARCHAR(2048)
  DECLARE @r_offSet bigint
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE  @tblArchFileByName TABLE (archFileId int, archFileName NVARCHAR(2048), jobId int, commCellId int, archGroupId int, appId int, appTypeId int, cTime int, offset bigint)
DECLARE	@l_clientId int
DECLARE @l_appTypeId int
DECLARE @l_instanceId int
DECLARE @l_filename nvarchar(2048)
DECLARE @l_instName varchar(2048)
IF	(@i_fileName like '%.onconfig' OR @i_fileName like '%.oncfg' OR @i_fileName like '%.ixbar')
BEGIN
	SELECT	@l_clientId = clientId, @l_appTypeId = appTypeId, @l_instanceId = instance
	FROM	APP_application WITH (NOLOCK)
	WHERE	@i_clientId > 0 AND @i_instanceId > 0 AND clientId = @i_clientId AND instance = @i_instanceId
		 OR @i_appId > 0 AND id = @i_appId
IF	@l_appTypeId = 3
	BEGIN
		SELECT	@l_instName = name
		FROM	APP_InstanceName WITH (NOLOCK)
		WHERE	id = @l_instanceId
		SET @l_filename = @l_instName +
			(case	when @i_fileName like '%.onconfig'	then '.onconfig'
					when @i_fileName like '%.oncfg'		then '.oncfg'
					when @i_fileName like '%.ixbar'		then '.ixbar'	end)
		IF	@i_fileName = (CAST(@l_instanceId AS nvarchar(8)) + '.' + @l_filename)
			SET @i_fileName = @l_filename
	END
END
IF @i_appId <> 0
BEGIN
	IF @i_matchByPattern  = 0
		INSERT INTO @tblArchFileByName
		SELECT	id, name, jobId, commCellId, archGroupId, @i_appId,
				(SELECT appTypeId FROM APP_Application WITH (NOLOCK) WHERE id = @i_appId), cTime, 0
		FROM	archFile WITH (NOLOCK)
		WHERE	appId = @i_appId
			AND isValid = 1
			AND cs_afname = CHECKSUM(@i_fileName) AND name = @i_fileName
	ELSE
		INSERT INTO @tblArchFileByName
		SELECT	id, name, jobId, commCellId, archGroupId, @i_appId,
				(SELECT appTypeId FROM APP_Application WITH (NOLOCK) WHERE id = @i_appId), cTime, 0
		FROM	archFile WITH (NOLOCK)
		WHERE	appId = @i_appId
			AND isValid = 1 AND name like @i_fileName
END
IF @i_clientId <> 0 AND NOT EXISTS (SELECT * FROM @tblArchFileByName)
BEGIN
	DECLARE @tblAppId TABLE(appId int, clientId int, appTypeId int, instanceId int)
	INSERT INTO @tblAppId
	SELECT id, clientId, appTypeId, instance
	FROM   APP_application WITH (NOLOCK)
	WHERE  clientId = @i_clientId AND (@i_instanceId = 0 OR instance = @i_instanceId)
IF EXISTS (SELECT * FROM @tblAppId WHERE appTypeId = 22)
	BEGIN
		IF @i_matchByPattern = 0
			INSERT	INTO @tblArchFileByName
			SELECT	DISTINCT a.id, a.name, a.jobId, a.commCellId, a.archGroupId, a.appId, b.appTypeId, a.cTime, 0
			FROM	archFile a WITH (NOLOCK), @tblAppId b, archFileOracle c WITH (NOLOCK)
			WHERE	c.clientId = b.clientId AND c.instanceId = b.instanceId
			AND c.archFileName = @i_fileName AND a.appId = b.appId
				AND a.id = c.archFileId AND a.commCellId = c.commCellId
				AND a.isValid = 1
				AND a.cs_afname = CHECKSUM(@i_fileName) AND a.name = @i_fileName
		ELSE
			INSERT	INTO @tblArchFileByName
			SELECT	DISTINCT a.id,  a.name, a.jobId, a.commCellId, a.archGroupId, a.appId, b.appTypeId, a.cTime, 0
			FROM	archFile a WITH (NOLOCK), @tblAppId b, archFileOracle c WITH (NOLOCK)
			WHERE	c.clientId = b.clientId AND c.instanceId = b.instanceId
				AND c.archFileName like @i_fileName
				AND a.appId = b.appId
				AND a.id = c.archFileId AND a.commCellId = c.commCellId
				AND a.isValid = 1
				AND a.name like @i_fileName
	END
	ELSE
	IF EXISTS (SELECT * FROM @tblAppId)
	BEGIN
		IF @i_matchByPattern = 0
			INSERT	INTO @tblArchFileByName
			SELECT	a.id, a.name, a.jobId, a.commCellId, a.archGroupId, b.appId, b.appTypeId, a.cTime, 0
			FROM	archFile a WITH (NOLOCK), @tblAppId b
			WHERE	a.appId = b.appId
				AND a.isValid = 1
				AND a.cs_afname = CHECKSUM(@i_fileName) AND a.name = @i_fileName
		ELSE
			INSERT	INTO @tblArchFileByName
			SELECT	a.id, a.name, a.jobId, a.commCellId, a.archGroupId, b.appId, b.appTypeId, a.cTime, 0
			FROM	archFile a WITH (NOLOCK), @tblAppId b
			WHERE	a.appId = b.appId
				AND a.isValid = 1
				AND a.name like @i_fileName
	END
END
IF ((@i_flags & 8192 /*CVA_FETCH_AFLIST_FOR_JOB_BY_AFNAME*/) > 0)
BEGIN
	--insert all the AFs that belong to this jobId
	INSERT INTO @tblArchFileByName
	SELECT a.id, a.name, a.jobId, a.commCellId, a.archGroupId, b.appId, b.appTypeId, a.cTime, 0
	FROM archFile a WITH (NOLOCK),
			(SELECT DISTINCT jobId, commCellId, appId, appTypeId
				FROM @tblArchFileByName) b
	WHERE a.jobId = b.jobId
	AND a.commCellId = b.commCellId
	AND NOT EXISTS (SELECT 1 FROM @tblArchFileByName WHERE archFileId = a.id and commcellId = a.commcellId)
END
IF NOT EXISTS (SELECT * FROM @tblArchFileByName)
BEGIN
	IF @i_matchByPattern  = 0
		INSERT INTO @tblArchFileByName
		SELECT	a.id, a.name, a.jobId, a.commCellId, a.archGroupId, a.appId, b.appTypeId, a.cTime, 0
		FROM	archFile a WITH (NOLOCK), APP_Application b WITH (NOLOCK)
		WHERE	a.appId = b.id
			AND (@i_matchClient = 0 OR @i_clientId > 0 AND b.clientId = @i_clientId)
			AND a.isValid = 1
			AND a.cs_afname = CHECKSUM(@i_fileName) AND a.name = @i_fileName
	ELSE
		INSERT INTO @tblArchFileByName
		SELECT	a.id, a.name, a.jobId, a.commCellId, a.archGroupId, a.appId, b.appTypeId, a.cTime, 0
		FROM	archFile a WITH (NOLOCK), APP_Application b WITH (NOLOCK)
		WHERE	a.appId = b.id
			AND (@i_matchClient = 0 OR @i_clientId > 0 AND b.clientId = @i_clientId)
			AND a.isValid = 1
			AND a.name like @i_fileName
END
DECLARE @l_aFileCount int = 0
SELECT @l_aFileCount = count(*) FROM @tblArchFileByName
IF (@l_aFileCount = 0 AND (@i_flags & (16384 /*CVA_FETCH_AFLIST_BY_BKP_PIECE_NAME*/)) > 0)
BEGIN
	INSERT INTO @tblArchFileByName
	SELECT	AF.id, AFO.backupPiece, AF.jobId, AF.commCellId, AF.archGroupId, AF.appId, A.appTypeId, AF.cTime, AFO.offSet
	FROM	archFile AF WITH (NOLOCK), archFileOracleBackupPiece AFO WITH (NOLOCK), APP_Application A WITH (NOLOCK)
	WHERE	AF.id = AFO.archFileId
		AND AF.CommCellId = AFO.CommCellId
		AND AF.isValid = 1
		AND AFO.cs_backupPiece = CHECKSUM(@i_fileName) AND AFO.backupPiece = @i_fileName
		AND AF.appId = A.id
		AND (@i_matchClient = 0 OR @i_clientId > 0 AND A.clientId = @i_clientId)
	SELECT @l_aFileCount = count(*) FROM @tblArchFileByName
END
--IF NOT EXISTS (SELECT * FROM @tblArchFileByName)
IF @l_aFileCount = 0
SELECT -1, CAST (49 AS Integer), 0, 0, 0, 0, 0, 0, 0, 0, '', 0
ELSE IF (@i_flags & 2048 > 0) AND @l_aFileCount > 1 -- #define CVA_FAIL_FOR_DUPLICATE_AFNAMES  (1 << 11)
SELECT -1, CAST (149 AS Integer), 0, 0, 0, 0, 0, 0, 0, 0, '', 0
ELSE
BEGIN
	/*
	Checking CVA_COPY_PRECEDENCE_ANY because that is the only case here that can have multiple copies.
	If new copy precedence inputs are accepted here that can result in multiple copies, add that here in the IF clause and make query change as well as required.
	*/
IF(@i_flags & 32768 > 0 AND @i_copyPrecedence = 0)
	BEGIN
		/*Partition by unique archive files, set rownumber in the order of copy precedence and fetch top row for each archive file*/
		SELECT archFileId, jobId, commCellId, appId, appTypeId, cTime, archGroupId, archCopyId, streamNum, mediaGroupId, archFileName, offSet
		FROM
		(
			SELECT TAF.archFileId, TAF.jobId, TAF.commCellId, TAF.appId, TAF.appTypeId, TAF.cTime, TAF.archGroupId, AFC.archCopyId,
			AFC.streamNum, ISNULL(AST.mediaGroupId, 0) "mediaGroupId", TAF.archFileName, TAF.offSet,
			ROW_NUMBER() OVER (PARTITION BY TAF.archFileId, TAF.commCellId ORDER BY AGC.copy ASC) rn
			FROM   @tblArchFileByName TAF
			INNER JOIN archFileCopy AFC WITH (NOLOCK) ON TAF.archFileId = AFC.archFileId AND TAF.commCellId = AFC.commCellId
			INNER JOIN ArchGroupCopy AGC WITH(NOLOCK) ON AFC.archCopyId = AGC.id
			/*Snap archive files do not have streamnum set, so this has to be LOJ*/
			LEFT OUTER JOIN archStream AST WITH (NOLOCK) ON AFC.archCopyId = AST.archGroupCopyId AND AFC.streamNum = AST.stream
WHERE AFC.isValid > 0 AND (@i_includeAgedData <> 0 OR (AFC.flags & 256) = 0)
AND AGC.type <> 5 -- SELECT only non-transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
		) T
		WHERE T.rn = 1
		ORDER BY cTime DESC
	END
	ELSE
	BEGIN
		SELECT TAF.archFileId, TAF.jobId, TAF.commCellId, TAF.appId, TAF.appTypeId, TAF.cTime, TAF.archGroupId, AFC.archCopyId,
		AFC.streamNum, ISNULL(AST.mediaGroupId, 0) "mediaGroupId", TAF.archFileName, TAF.offSet
		FROM @tblArchFileByName TAF
		INNER JOIN archFileCopy AFC WITH (NOLOCK) ON TAF.archFileId = AFC.archFileId AND TAF.commCellId = AFC.commCellId
		INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AFC.archCopyId = AGC.id
		/*Snap archive files do not have streamnum set, so this has to be LOJ*/
		LEFT OUTER JOIN archStream AST WITH (NOLOCK) ON AFC.archCopyId = AST.archGroupCopyId AND AFC.streamNum = AST.stream
		INNER JOIN archGroup AG WITH (NOLOCK) ON TAF.archGroupId = AG.id
WHERE AFC.isValid > 0 AND (@i_includeAgedData <> 0 OR (AFC.flags & 256) = 0)
AND AGC.type <> 5 -- SELECT only non-transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
AND ( (@i_copyPrecedence = -1 AND AGC.id = AG.defaultCopy)
OR @i_copyPrecedence = 0
		OR @i_copyPrecedence = AGC.copy)
		ORDER BY TAF.cTime DESC, AGC.copy ASC
	END
END
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archFileByName')
	delete from GxQscripts where name = 'archFileByName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileByName')
	delete from GXDBVersions where aliasname = 'archFileByName'
GO

insert into GXDBVersions values(2, 'archFileByName',  '00010015004200070000', 'archFileByName', '00010015004200070000')
GO

