

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFLAIndexingTotalDataSize.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFLAIndexingTotalDataSize.sp,v $ $Id: archFLAIndexingTotalDataSize.sp,v 1.2.88.1 2018/03/20 19:43:51 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archFLAIndexingTotalDataSize <<<'

IF EXISTS (select * from sysobjects where name='archFLAIndexingTotalDataSize')
	drop procedure archFLAIndexingTotalDataSize
IF EXISTS (select * from GxQscripts where name='archFLAIndexingTotalDataSize')
	delete from GxQscripts where name = 'archFLAIndexingTotalDataSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFLAIndexingTotalDataSize')
	delete from GXDBVersions where aliasname = 'archFLAIndexingTotalDataSize'
GO
print '... Creating Procedure: archFLAIndexingTotalDataSize'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archFLAIndexingTotalDataSize
  @i_archGroupId int,
  @i_copyId int
AS
  DECLARE @o_totalDataSize bigint;
SET NOCOUNT ON
DECLARE	@tblDataSize TABLE
(
	archCopyId int,
	streamNum int,
	mediaGroupId int,
	commCellId int,
	archChunkId bigint,
	physicalSize bigint
)
DECLARE	@tblDataSizeAdjust	TABLE
(
	archCopyId int,
	streamNum int,
	mediaGroupId int,
	commCellId int,
	physicalSize bigint
)
INSERT	INTO
	@tblDataSizeAdjust
SELECT
	A.archCopyId, A.streamNum, A.mediaGroupId, A.commCellId, SUM(R.physicalOffset - A.physicalOffset)
FROM
	archFLAIndexingAF A, archFLAIndexingRestart R
WHERE
	A.archGroupId = @i_archGroupId
	AND (@i_copyId = 0 OR A.archCopyId = @i_copyId)
	AND A.archFileId = R.archFileId AND A.commCellId = R.commCellId
	AND A.physicalOffset < R.physicalOffset AND (A.physicalOffset + A.physicalSize) >= R.physicalOffset
GROUP BY
	A.archCopyId, A.streamNum, A.mediaGroupId, A.commCellId
INSERT	INTO
	@tblDataSize
SELECT
	archCopyId, streamNum, mediaGroupId, commCellId, MIN(archChunkId), SUM(physicalSize)
FROM
	archFLAIndexingAF
WHERE
	archGroupId = @i_archGroupId
	AND (@i_copyId = 0 OR archCopyId = @i_copyId)
GROUP BY
	archCopyId, streamNum, mediaGroupId, commCellId
UPDATE
	@tblDataSize
SET
	physicalSize = (A.physicalSize - B.physicalSize)
FROM
	@tblDataSize A, @tblDataSizeAdjust B
WHERE
	A.archCopyId = B.archCopyId AND A.streamNum = B.streamNum
select sum(physicalSize) from @tblDataSize
GO

IF EXISTS (select * from GxQscripts where name = 'archFLAIndexingTotalDataSize')
	delete from GxQscripts where name = 'archFLAIndexingTotalDataSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFLAIndexingTotalDataSize')
	delete from GXDBVersions where aliasname = 'archFLAIndexingTotalDataSize'
GO

insert into GXDBVersions values(2, 'archFLAIndexingTotalDataSize',  '00010002008800010000', 'archFLAIndexingTotalDataSize', '00010002008800010000')
GO

