

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFLAIndexingSetStream.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchFLAIndexingSetStream.sp,v $ $Id: ArchFLAIndexingSetStream.sp,v 1.2.88.1 2018/03/20 19:56:10 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archFLAIndexingSetStream')
BEGIN
	print '>>> Drop Stored Procedure: archFLAIndexingSetStream <<<'
	drop procedure archFLAIndexingSetStream
END
IF EXISTS (select * from GxQscripts where name='archFLAIndexingSetStream')
	delete from GxQscripts where name = 'archFLAIndexingSetStream'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFLAIndexingSetStream')
	delete from GXDBVersions where aliasname = 'archFLAIndexingSetStream'
GO
print '... Creating Procedure: archFLAIndexingSetStream'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archFLAIndexingSetStream
  @i_archGroupId int,
  @i_archCopyId int,
  @i_streamNum int,
  @i_maxConcurrency int
AS
  DECLARE @o_error integer;
  DECLARE @o_errorString varchar(1024);
SET NOCOUNT ON
BEGIN TRAN archFLASetStream_tran
	DECLARE	@errVal	INTEGER
	DECLARE	@errStr	VARCHAR(1024)
	SET @errVal = 0
	SET @errStr = 'NO ERROR'
	-- Ensure no chunks is present for the stream before assigning a new segment
	IF	@i_streamNum > 0 AND EXISTS (SELECT * FROM ArchFLAIndexingAF WITH (NOLOCK)
						WHERE archGroupId = @i_archGroupId and (@i_archCopyId = 0 or archCopyId = @i_archCopyId)
						AND streamNum = @i_streamNum and segmentId > 0)
	begin
		GOTO CX_EXIT
	end
	DECLARE @tblSegmentStream TABLE
	(
		streamNum integer,
		segmentId integer
	)
	DECLARE @max_streamNum	INTEGER
	IF @i_maxConcurrency > 0
		SET @max_streamNum = @i_maxConcurrency
	ELSE
		SELECT
			@max_streamNum = maxStreams
		FROM
			archGroup WITH (NOLOCK)
		WHERE
			id = @i_archGroupId
	DECLARE @streamNum		INTEGER
	DECLARE @nextStream		INTEGER
	SET @nextStream = 0
	SET @streamNum = 1
	IF	@i_streamNum > 0
	BEGIN
		SET @streamNum = @i_streamNum
	END
	INSERT INTO
		@tblSegmentStream
	SELECT DISTINCT
		streamNum, segmentId
	FROM
		ArchFLAIndexingAF WITH (NOLOCK)
	WHERE
		archGroupId = @i_archGroupId
		and (@i_archCopyId = 0 or archCopyId = @i_archCopyId)
		and archCopyId not in (select id from ArchGroupCopy where isSnapCopy = 1)
		and segmentId > 0
	WHILE 1 = 1
	BEGIN
		IF NOT EXISTS (SELECT * FROM @tblSegmentStream WHERE streamNum = 0)
			BREAK
		IF EXISTS (SELECT * FROM @tblSegmentStream WHERE streamNum = @streamNum)
			SET @nextStream = 1
		IF @nextStream > 0
		BEGIN
			IF	@i_streamNum > 0
				BREAK
			SET @streamNum = @streamNum + 1
			IF @streamNum > @max_streamNum
				BREAK
			SET @nextStream = 0
			CONTINUE
		END
		DECLARE @t_segmentId INTEGER
		SET @t_segmentId = (SELECT MIN(segmentId) FROM @tblSegmentStream WHERE streamNum = 0)
		IF @t_segmentId IS NOT null
		BEGIN
				UPDATE @tblSegmentStream SET streamNum = @streamNum WHERE segmentId = @t_segmentId
				UPDATE
					archFLAIndexingAF
				SET
					streamNum = @streamNum
				FROM
					archFLAIndexingAF
				WHERE
					segmentId = @t_segmentId
					AND archGroupId = @i_archGroupId
				SELECT @errVal = @@ERROR
				IF @errVal <> 0
				BEGIN
						SET @errStr = 'Failed to update StreamNum for archive files in ArchFLAIndexingAF: DB error!'
						GOTO CX_EXIT_ERROR
				END
				CONTINUE
		END
		SET @nextStream = 1
	END
CX_EXIT:
	SET @errStr = 'All streams are assigned for copy with max stream: [' + convert(varchar(10), @max_streamNum) + ']'
	COMMIT TRAN archFLASetStream_tran
	SELECT 0, ''
	RETURN
CX_EXIT_ERROR:
	ROLLBACK TRAN archFLASetStream_tran
	SELECT @errVal, @errStr
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'archFLAIndexingSetStream')
	delete from GxQscripts where name = 'archFLAIndexingSetStream'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFLAIndexingSetStream')
	delete from GXDBVersions where aliasname = 'archFLAIndexingSetStream'
GO

insert into GXDBVersions values(2, 'archFLAIndexingSetStream',  '00010002008800010000', 'archFLAIndexingSetStream', '00010002008800010000')
GO

