

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFLAIndexingPrune.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFLAIndexingPrune.sp,v $ $Id: archFLAIndexingPrune.sp,v 1.3.88.2 2018/03/20 19:46:10 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archFLAIndexingPrune <<<'

IF EXISTS (select * from sysobjects where name='archFLAIndexingPrune')
	drop procedure archFLAIndexingPrune
IF EXISTS (select * from GxQscripts where name='archFLAIndexingPrune')
	delete from GxQscripts where name = 'archFLAIndexingPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFLAIndexingPrune')
	delete from GXDBVersions where aliasname = 'archFLAIndexingPrune'
GO
print '... Creating Procedure: archFLAIndexingPrune'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archFLAIndexingPrune
  @i_dummy integer
AS
  DECLARE @retVal integer;
  DECLARE @numRow integer;
SET NOCOUNT ON
declare @err int
declare @now int
declare @indexedFlag int
declare @retentionDays int
select @err = 0, @now = dbo.GetUnixTime(GETUTCDATE()), @indexedFlag = (32 + 64 + 128)
select	@retentionDays = cast([value]as int) from GXGlobalParam where name = 'FlaRetentionDays'
if @retentionDays is null set @retentionDays = 30
create table #ExpiredCIAF
(
	archFileId INT,
	commCellId INT,
	cloudId INT
)
insert into #ExpiredCIAF(archFileId, commCellId, cloudId)
select
	AF.archFileId, AF.commCellId, AF.cloudId
from
	archFLAIndexingInfo AF WITH (NOLOCK)
where
	AF.flags & @indexedFlag <> 0
AND AF.flags & 256 = 0
	AND AF.indexTime < (@now - 24 * 60 * 60 * @retentionDays)
	AND AF.cloudId > 0
select @retVal = @@error, @numRow = @@rowcount
if @retVal = 0 AND @numRow > 0
begin
	insert into archFLAIndexingAged(archFileId, commCellId, cloudId, appId, pruneType, agedFlag)
	select
EAF.archFileId, EAF.commCellId, EAF.cloudId, A.appId, 4, 0
	from  #ExpiredCIAF EAF
	inner join
		archFile A
	on
		A.id = EAF.archFileId and A.commCellId = EAF.commCellId
	--
	select @retVal = @@error, @numRow = @@rowcount
	--
	if @retVal = 0 and @numRow > 0
	begin
update archFLAIndexingInfo set flags = (archFLAIndexingInfo.flags | 256) from #ExpiredCIAF T
		where archFLAIndexingInfo.archFileId = T.archFileId and archFLAIndexingInfo.commCellId = T.commCellId
	end
	--
	select @retVal = @@ERROR, @numRow = @@ROWCOUNT
end
CX_EXIT:
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archFLAIndexingPrune')
	delete from GxQscripts where name = 'archFLAIndexingPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFLAIndexingPrune')
	delete from GXDBVersions where aliasname = 'archFLAIndexingPrune'
GO

insert into GXDBVersions values(2, 'archFLAIndexingPrune',  '00010003008800020000', 'archFLAIndexingPrune', '00010003008800020000')
GO

