

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFLAIndexingInsert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFLAIndexingInsert.sp,v $ $Id: archFLAIndexingInsert.sp,v 1.15.12.9 2020/06/06 02:48:50 cliu Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archFLAIndexingInsert')
BEGIN
	print '>>> Drop Stored Procedure: archFLAIndexingInsert <<<'
	drop procedure archFLAIndexingInsert
END
IF EXISTS (select * from GxQscripts where name='archFLAIndexingInsert')
	delete from GxQscripts where name = 'archFLAIndexingInsert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFLAIndexingInsert')
	delete from GXDBVersions where aliasname = 'archFLAIndexingInsert'
GO
print '... Creating Procedure: archFLAIndexingInsert'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archFLAIndexingInsert
  @i_archGroupId int,
  @i_endBefore int,
  @i_srcCopyId int,
  @i_srcStream int,
  @i_CIJobId int
AS
  DECLARE @retVal integer;
SET NOCOUNT ON
declare @rollback bit
set @rollback = 0
DECLARE	@tblAPP	TABLE
(
	appId int,
	appTypeId int,
	clientId int,
	hasErasedData int
)
DECLARE	@tblClient TABLE
(
	clientId int,
	needPassPhrase int
)
IF object_id('tempdb.dbo.#tblAFC') IS NOT null DROP TABLE #tblAFC
CREATE TABLE #tblAFC
(
	jobId int, appId int, backupStartTime int, backupEndTime int, fullCycleNum int,
	archFileId int, commCellId int, archCopyId int, streamNum int, lastChunkNumber int,
	encKeyType int, encRSA int, flags int, isMag int, copyPrec int,
	PRIMARY KEY (archFileId, commCellId, archCopyId)
)
IF object_id('tempdb.dbo.#tblAFChunk') IS NOT null DROP TABLE #tblAFChunk
CREATE TABLE #tblAFChunk
(
	acCommCellId int, archChunkId bigint, afCommCellId int, archFileId int, archCopyId int, chunkNumber int,
	physicalOffset bigint, logicalOffset bigint, physicalSize bigint, logicalSize bigint,
	fileMarkerNo int, chunkCreateTime int, chunkVersion int, chunkPhysicalSize bigint, chunkLogicalSize bigint,
chunkHwEncKey varchar(114),
	volumeId int, mediaId int, mediaGroupId int, RecordingFormatId int,
	PRIMARY KEY (acCommCellId, archChunkId, afCommCellId, archFileId)
)
DECLARE	@tblCopyMA TABLE
(
	CopyId int,
	HostClientId int
)
DECLARE	@tblJobTimes TABLE (jobId int,commCellId int, archCopyId int, jobCopiedTime int)
DECLARE	@CIJobStartTime INT
SET @CIJobStartTime  = 0
SELECT @CIJobStartTime = jobStartTime FROM JMJobInfo WITH (NOLOCK) WHERE jobId = @i_CIJobId
INSERT	INTO @tblCopyMA
SELECT	DISTINCT CopyId, HostClientId
FROM	MMDataPath WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
WHERE	MMDataPath.CopyId = AGC.id AND AGC.archGroupId = @i_archGroupId AND AGC.isSnapCopy = 0
AND AGC.type <> 5
-- Exclude copies which do not have a datapath for Windows MA. Only Content Indexing on a Windows Media Agent is supported.
DELETE	@tblCopyMA
FROM	@tblCopyMA MA, APP_Client CLNT WITH (NOLOCK), simOperatingSystem SOS WITH (NOLOCK)
WHERE	CLNT.id = MA.HostClientId
	AND SOS.id = CLNT.simOperatingSystemId
	AND SOS.type <> 'Windows'
IF	NOT EXISTS (SELECT * FROM @tblCopyMA) SET @retVal = 68
IF	@retVal <> 0 GOTO FINISH
declare @l_cloudId int = null
declare @sourceMediaAgentId int = null
Declare @indexServerClientId int = cast(dbo.GetJobOption(@i_CIJobId, 2101836446) as int)
set @retVal = @@ERROR
if @retVal <> 0 or @indexServerClientId is null or @indexServerClientId = 0 GOTO FINISH
 IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
		CREATE TABLE #getIndexServers
            (     serverURL NVARCHAR(512),
                  clientId INT,
                  clientName NVARCHAR(256),
                  cloudId INT,
                  hostName NVARCHAR(256),
                  basePort INT,
                  engineName  NVARCHAR(256),
                  serverType INT,
                  indexServerClientId INT,
                  internalCloudName NVARCHAR(256)
            )
EXEC DM2GetIndexServers 'Data Analytics', @indexServerClientId
SELECT TOP 1 @l_cloudId = cloudId, @sourceMediaAgentId=ClientId  FROM #getIndexServers WHERE indexServerClientId = @indexServerClientId
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL    DROP TABLE #getIndexServers
set @retVal = @@ERROR
if @retVal <> 0 or @l_cloudId is null or @l_cloudId = 0 GOTO FINISH
IF @i_srcStream > 0
BEGIN
	-- @i_srcStream is greater than 0 when we are populating skipped chunks. This happens once the archive file
	-- has been processed and now we are looking to process skipped chunks
	delete archFLAIndexingAF where archGroupId = @i_archGroupId and streamNum = @i_srcStream
END
ELSE
BEGIN
	-- FLA job is starting for the first time or is getting resumed.
	delete archFLAIndexingAF where archGroupId = @i_archGroupId
END
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Job selection
DECLARE @startTime INT
DECLARE @endTime INT
SET @startTime = dbo.GetOptionInt(719854938, @i_CIJobId, 0, 0)
SET @endTime = dbo.GetOptionInt(1221394249 , @i_CIJobId, 0, 0)
IF	@endTime = 0 SET @endTime = 0x7FFFFFFF
-- Job selection of FLA
-- Within each Client-computer, for each sub-client, we need to pick the last cycle.
-- Logic: For each subClient, get the last full and all incrementals after the last full.
-- First get the list of clients
declare @clientComputers table
(
	clientId int
)
insert into @clientComputers(clientId)
select cast(value as xml).value('(/clients/@clientId)[1]', 'int') from  dbo.GetJobOptionList (@i_CIJobId, 1810277523)
-- Next resolve the actua iDA typa based on job option
declare @iDATypes table
(
	typeId int
)
declare @idaTypeValue int = null
select @idaTypeValue = dbo.GetJobOption(@i_CIJobId, 900055445)
-- Exchange Email Data
if (@idaTypeValue = 0 or @idaTypeValue = 2)
begin
	insert into @iDATypes(typeId)
	select distinct i.type from APP_AppTypeGroupAssoc a inner join APP_AppTypeGroup g on g.appTypeGroupId = a.appGroupId
	inner join APP_iDAType i on i.type = a.appTypeId
	where g.groupName in ('APPGRP_ExchangeMailboxArchiver', 'APPGRP_ExchangeComplainceArchiver', 'APPGRP_ExchangeMailbox', 'APPGRP_MS_EXCHANGE','APPGRP_XchangeDB')
	order by i.type
end
-- File System Data
if (@idaTypeValue = 1 or @idaTypeValue = 2)
begin
    insert into @iDATypes(typeId)
    select distinct i.type from APP_AppTypeGroupAssoc a inner join APP_AppTypeGroup g on g.appTypeGroupId = a.appGroupId
    inner join APP_iDAType i on i.type = a.appTypeId
    where g.groupName in ('APPGRP_FileSystemLikeIDA')
    and ( i.ccpType in (33 /*CV_APPTYPE_WINDOWS_FILESYSTEM*/, 58 /*CV_APPTYPE_MS_FILE_ARCHIVER*/, 63 /*CV_APPTYPE_APPLEMAC_FS*/)
    or i.type = 63 )
    order by i.type
end
-- Remove App-types we don't want to support
delete @iDATypes where typeId in (67 /*CV_APPTYPE_MS_EXCHANGE_ARCHIVER*/, 68 /*UNUSED_CV_APPTYPE_68*/)
-- Now select the subclient which match the clients and the selected iDATATypes
IF object_id('tempdb.dbo.#SubClientFullJobs') IS NOT null drop table #SubClientFullJobs
create table #SubClientFullJobs
(
	commCellId int,
	appId int,
	jobId int
)
--
insert into #SubClientFullJobs(commCellId, appId, jobId)
select jbs.commCellId, jbs.appId, max(jbs.jobId)
from
	JMBkpStats jbs WITH (NOLOCK)
inner join
	APP_Application a WITH (NOLOCK)
on
	a.id = jbs.appId
inner join
	@clientComputers c
on
	c.clientId = a.clientId
inner join
	@iDATypes i
on
	i.typeId = a.appTypeId
where
  jbs.opType not in ( 60 )  -- Skip Backup Copy Jobs
  and jbs.dataArchGrpId = @i_archGroupId -- Current Storage Policy Only
  and dbo.IsBackupLevelFull(jbs.bkpLevel) = 1
  and jbs.status NOT IN (2, 4, 9)	--(FAIL, KILLED, DROPPED)
  and ((a.subclientStatus & 0x2) <> 0x2	--uninstalled
		or a.origCCId >2)
  and (a.subclientStatus & 0x4) <> 0x4	--deleted
group by
  jbs.commCellId, jbs.appId
-- Finally select the jobs
IF object_id('tempdb.dbo.#tblQualifiedJobs') IS NOT null drop table #tblQualifiedJobs
create table #tblQualifiedJobs
(
	jobId int,
	commcellId int
)
--
insert into #tblQualifiedJobs(jobId, commcellId)
select
	j.jobId, j.commCellId
from
	JMBkpStats j WITH (NOLOCK)
inner join #SubClientFullJobs s
on
  j.jobId > S.JobId and j.CommCellId = S.CommCellid and s.appId = j.appId
where
  j.bkpLevel in (0x2 /*INCR*/, 0x100 /*INCR_NOTRUC*/)
  and j.opType not in ( 60 )  -- Skip Backup Copy Jobs
union
select jobId, commCellId from #SubClientFullJobs
DROP TABLE #SubClientFullJobs
--
declare @debug bit
declare @afcCount int
set @debug = 0
--
INSERT INTO #tblAFC(jobId, appId, backupStartTime, backupEndTime, fullCycleNum, archFileId, commCellId,
		    archCopyId, streamNum, lastChunkNumber, encKeyType, encRSA, flags, isMag, copyPrec)
SELECT
	AF.jobId, AF.appId, 0, 0, 0,
	AFC.archFileId, AFC.commCellId, AFC.archCopyId, AFC.streamNum,
	AFC.lastChunkNumber, AFC.encKeyType, AFC.encRSA, AFC.flags, 0, 0
FROM
	archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK), #tblQualifiedJobs QJ
WHERE
AF.archGroupId = @i_archGroupId AND AF.fileType = 1
	AND AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId
AND AFC.isValid > 0 AND AFC.flags & 256 = 0
	AND AFC.archCopyId IN (SELECT DISTINCT CopyId FROM @tblCopyMA)
	and AF.jobId = QJ.jobId AND AF.commCellId = QJ.commcellId
	--AND AF.flags & (CVA_AF_SNAP_DATA_FLAG + CVA_AF_CI_REQUIRED_FLAG + CVA_AF_CI_PARTIAL_FLAG) <> 0
--
if @debug = 1 begin
	select @afcCount = count(*) from #tblAFC
	print 'tblAFC has ' + cast(@afcCount as varchar(15)) + 'records'
end
drop table #tblQualifiedJobs
-- We need to skip data that has already been analyzed before.
delete #tblAFC from #tblAFC afc
inner join
	archFLAIndexingInfo info with (NOLOCK)
on
	info.archFileId = afc.archFileId and info.commCellId = afc.commCellId
and (info.flags & (64 + 256 + 128)) > 0
--
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
if @debug = 1 begin
	select @afcCount = count(*) from #tblAFC
	print 'tblAFC has ' + cast(@afcCount as varchar(15)) + 'records after removing previously analyzed data'
end
-- Filter out Silo subclients
DELETE	#tblAFC
FROM	archGroupCopy C WITH (NOLOCK)
WHERE	appId = C.siloAppId AND C.archGroupId = @i_archGroupId
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
if @debug = 1 begin
	select @afcCount = count(*) from #tblAFC
	print 'tblAFC has ' + cast(@afcCount as varchar(15)) + 'records after filtering SILO subclients'
end
--Delete all the chunks on transitive copy
DELETE	#tblAFC
FROM	#tblAFC AFC, archGroupCopy AGC WITH (NOLOCK)
WHERE	AFC.archCopyId = AGC.id
		AND	AGC.type = 5 -- KEEP only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
if @debug = 1 begin
	select @afcCount = count(*) from #tblAFC
	print 'tblAFC has ' + cast(@afcCount as varchar(15)) + 'records after deleting chunks on transitive copy'
end
-- Filter out DDB backup, IndexBackup subclients
INSERT INTO @tblAPP
SELECT	APP.id, APP.appTypeId, APP.clientId, 0
FROM	(SELECT DISTINCT appId FROM #tblAFC) AFC,
		APP_Application APP WITH (NOLOCK)
WHERE	APP.id = AFC.appId AND APP.subclientName NOT IN ('DDBBackup', 'IndexBackup'	)
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Remove encrypted archive files which need user pass phrase for decrypting the key
INSERT	INTO @tblClient
SELECT	DISTINCT clientId, 0
FROM	#tblAFC AFC, @tblAPP APP
WHERE	AFC.encKeyType > 0 AND (AFC.encRSA & 1) > 0
	AND AFC.appId = APP.appId
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
UPDATE	@tblClient
SET		needPassPhrase = CONVERT(int, b.attrVal)
FROM	@tblClient a, APP_ClientProp b
WHERE	b.ComponentNameId = a.clientId
	AND b.attrName = N'Encrypt: restoreAccess'
	AND b.modified = 0
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
DELETE	#tblAFC
FROM	#tblAFC AFC, @tblAPP APP, @tblClient CL
WHERE	AFC.encKeyType > 0 AND (AFC.encRSA & 1) > 0
	AND AFC.appId = APP.appId
	AND APP.clientId = CL.clientId
	AND CL.needPassPhrase = 1
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
if @debug = 1 begin
	select @afcCount = count(*) from #tblAFC
	print 'tblAFC has ' + cast(@afcCount as varchar(15)) + 'records after removing encrypted archive files'
end
-- Filter out files which are going to be aged
DELETE #tblAFC FROM #tblAFC a INNER JOIN archFLAIndexingAged G
on G.archFileId = a.archFileId and G.commCellId = a.commCellId
--
if @debug = 1 begin
	select @afcCount = count(*) from #tblAFC
	print 'tblAFC has ' + cast(@afcCount as varchar(15)) + 'records after removing aged files'
end
--
-- Erase Migrated Data has been done for the subclient
UPDATE	@tblAPP SET hasErasedData = 2
FROM	@tblAPP APP, archFile AF WITH (NOLOCK)
WHERE	AF.appId = APP.appId
AND AF.fileType = 34
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Erase Backup Data has been done for the client & apptype
UPDATE	@tblAPP SET hasErasedData = 2
FROM	@tblAPP T, APP_Application A WITH (NOLOCK),
		(SELECT	DISTINCT appId
		FROM	archFile WITH (NOLOCK)
WHERE	archGroupId = @i_archGroupId AND fileType = 5) B
WHERE	T.clientId = A.clientId AND T.appTypeId = A.appTypeId
	AND A.id = B.appId
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
INSERT INTO #tblAFChunk
SELECT	ACM.chunkCommCellId, ACM.archChunkId, ACM.commCellId,  ACM.archFileId, ACM.archCopyId, ACM.chunkNumber,
		ACM.physicalOffset, ACM.logicalOffset, ACM.physicalSize, ACM.logicalSize,
		AC.fileMarkerNo, AC.createTime, AC.version, AC.physicalSize, AC.logicalSize, AC.hwEncKey,
		V.volumeId, V.mediaId, V.mediaGroupId, V.RecordingFormatId
FROM	#tblAFC AFC, archChunkMapping ACM WITH (NOLOCK), archChunk AC WITH (NOLOCK), MMVolume V WITH (NOLOCK)
WHERE	ACM.archFileId = AFC.archFileId AND ACM.commCellId = AFC.commCellId AND ACM.archCopyId = AFC.archCopyId
	AND ACM.physicalSize > 0 AND AFC.lastChunkNumber > 0
	AND AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId
	AND V.volumeId = AC.volumeId
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Adjust hwEncKey based on media
UPDATE	R
SET		chunkHwEncKey = M.hwEncKey
FROM	#tblAFChunk R WITH (READUNCOMMITTED), MMMedia M WITH (READUNCOMMITTED), ArchChunk chunk WITH (READUNCOMMITTED)
WHERE	R.MediaId = M.MediaId
		AND R.chunkHwEncKey = ''
		AND M.MediaTypeId != 10001
		AND R.ArchChunkId = chunk.Id
		AND	R.acCommCellId = chunk.CommCellId
AND chunk.flags & 1048576 > 0
IF @i_srcCopyId = 0
BEGIN
	-- Prefer non-encrypted archive files
	DELETE	#tblAFC
	FROM	#tblAFC a,
			(SELECT archFileId, commCellId FROM #tblAFC WHERE encKeyType = 0) b
	WHERE	a.archFileId = b.archFileId AND a.commCellId = b.commCellId AND a.encKeyType <> 0
	SET @retVal = @@ERROR
	IF	@retVal <> 0 GOTO FINISH
	UPDATE	#tblAFC
	SET		isMag = 1
	FROM	#tblAFC AFC,
			(SELECT DISTINCT archFileId, afCommCellId, archCopyId FROM #tblAFChunk WHERE RecordingFormatId = 10001) ACM
	WHERE	ACM.archFileId = AFC.archFileId AND ACM.afCommCellId = AFC.commCellId AND ACM.archCopyId = AFC.archCopyId
	SET @retVal = @@ERROR
	IF	@retVal <> 0 GOTO FINISH
	-- Prefer magnetic archive files
	DELETE	#tblAFC
	FROM	#tblAFC a,
			(SELECT archFileId, commCellId FROM #tblAFC WHERE isMag = 1) b
	WHERE	a.archFileId = b.archFileId AND a.commCellId = b.commCellId AND a.isMag = 0
	SET @retVal = @@ERROR
	IF	@retVal <> 0 GOTO FINISH
	UPDATE	#tblAFC
	SET		copyPrec = AGC.copy
	FROM	#tblAFC AFC, archGroupCopy AGC WITH (NOLOCK)
	WHERE	AFC.archCopyId = AGC.id
	SET @retVal = @@ERROR
	IF	@retVal <> 0 GOTO FINISH
	-- Apply copy precedence
	DELETE	#tblAFC
	FROM	#tblAFC a,
			(SELECT archFileId, commCellId, MIN(copyPrec) AS copyPrec FROM #tblAFC GROUP BY archFileId, commCellId) b
	WHERE	a.archFileId = b.archFileId AND a.commCellId = b.commCellId AND a.copyPrec > b.copyPrec
	SET @retVal = @@ERROR
	IF	@retVal <> 0 GOTO FINISH
END
-- Remove chunks which are in exported tape media
--
if object_id('tempdb..#ChunksInExportedTapes') is not null
drop table #ChunksInExportedTapes
create table #ChunksInExportedTapes
(
	acCommCellId 	int,
	archChunkId 	bigint,
	afCommCellId 	int,
	archFileId 		int,
	PRIMARY KEY (acCommCellId, archChunkId, afCommCellId, archFileId)
);
insert into #ChunksInExportedTapes (ac.acCommCellId, ac.archChunkId, ac.afCommCellId, ac.archFileId)
select
	acCommCellId, archChunkId, afCommCellId, archFileId
from #tblAFChunk ac
inner join
	MMVolume v with (nolock)
on
	v.VolumeId = ac.VolumeId
inner join
	MMMedia m with (nolock)
on
	m.MediaId = v.MediaId
where
v.RecordingFormatId <> 10001 -- Filter out magnetic media i.e. keep only tape media
		and m.MediaLocation = 3 /* LOCATION_SHELF */
--
delete #tblAFChunk from #tblAFChunk AC
inner join #ChunksInExportedTapes CE on CE.acCommCellId = AC.acCommCellId and CE.archChunkId = AC.archChunkId
and CE.afCommCellId = AC.afCommCellId and CE.archFileId = AC.archFileId
--
--
UPDATE	#tblAFC
SET		backupStartTime = BKP.servStartDate,
		backupEndTime = A.cTime, -- TODO: CR: Do we need this info for FLA also?
		fullCycleNum = BKP.fullCycleNum
FROM	#tblAFC AFC, JMBkpStats BKP WITH (NOLOCK),
		(SELECT AF.jobId, AF.commCellId, MAX(AF.cTime)as cTime FROM archFile AF WITH (NOLOCK), #tblAFC T
WHERE AF.jobId = T.jobId AND AF.commCellId = T.commCellId AND AF.fileType = 2 and AF.isValid = 1
		GROUP BY AF.jobId, AF.commCellId) A
WHERE	BKP.jobId = AFC.jobId AND BKP.commCellId = AFC.commCellId
AND A.jobId = AFC.jobId AND A.commCellId = AFC.commCellId
SET @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
begin transaction
	set @rollback = 1
	-- This may contain duplicate archFileId and commCellId records so either use distinct or group by.
	declare @archFileIds table
	(
		archFileId int,
		commCellId int
	)
	INSERT	INTO archFLAIndexingAF(archGroupId, clientId, appType, appId, fullCycleNum, backupJobId, backupStartTime, backupEndTime, archChunkId,
	archFileId, commCellId, archCopyId, streamNum, encKeyType, archFileCopyFlags, lastChunkNumber, chunkNumber, physicalOffset, logicalOffset,
	physicalSize, logicalSize, volumeId, mediaId, mediaGroupId, fileMarkerNo, chunkCreateTime, chunkVersion, chunkPhysicalSize, chunkLogicalSize,
	chunkHwEncKey, extraFlags, segmentId, adminJobId, chunkCommCellId)
	OUTPUT
		INSERTED.archFileId, INSERTED.commCellId
	INTO
		@archFileIds
	SELECT
		@i_archGroupId, APP.clientId, APP.appTypeId, AFC.appId, AFC.fullCycleNum, AFC.jobId, AFC.backupStartTime, AFC.backupEndTime, ACM.archChunkId,
		AFC.archFileId, AFC.commCellId, AFC.archCopyId, AFC.streamNum, AFC.encKeyType, AFC.flags, AFC.lastChunkNumber, ACM.chunkNumber,
		ACM.physicalOffset, ACM.logicalOffset, ACM.physicalSize, ACM.logicalSize, ACM.volumeId, ACM.mediaId, ACM.mediaGroupId, ACM.fileMarkerNo,
ACM.chunkCreateTime, ACM.chunkVersion, ACM.chunkPhysicalSize, ACM.chunkLogicalSize, ACM.chunkHwEncKey, APP.hasErasedData + 16,
		0, @i_CIJobId, ACM.acCommCellId
	FROM	#tblAFC AFC
	INNER JOIN #tblAFChunk ACM
	ON
		ACM.archFileId = AFC.archFileId
		AND ACM.afCommCellId = AFC.commCellId
		AND ACM.archCopyId = AFC.archCopyId
	INNER JOIN
		@tblAPP APP
	ON
		AFC.appId = APP.appId
	WHERE
		(@i_srcStream = 0 OR AFC.streamNum = @i_srcStream)
	--	and (@i_endBefore = 0 OR AFC.backupEndTime <= @i_endBefore)
	set @retVal = @@ERROR
	if @retVal <> 0 GOTO FINISH
	DROP TABLE #tblAFC
	DROP TABLE #tblAFChunk
	-- filter out exisitng archives file if any
	delete @archFileIds from @archFileIds afids
	inner join archFLAIndexingInfo info WITH (NOLOCK)
	on info.archFileId = afids.archFileId and info.commCellId = afids.commCellId
	--
	INSERT INTO archFLAIndexingInfo(archFileId, commCellId, pushedItemCount, flags, indexTime, cloudId)
SELECT ids.archFileId, ids.commCellId, 0, 16, NULL, @l_cloudId FROM @archFileIds ids group by ids.archFileId, ids.commCellId
	--
	set @retVal = @@ERROR
	if @retVal <> 0 GOTO FINISH
	--
	-- Redo content indexing for partially content indexed AFs when cloudId is changed
	delete archFLAIndexingRestart where archGroupId = @i_archGroupId and cloudId <> @l_cloudId
	set @retVal = @@ERROR
	if @retVal <> 0 GOTO FINISH
	--
	-- Delete chunks in which contents have been indexed
	delete archFLAIndexingAF from archFLAIndexingAF AF, archFLAIndexingRestart R
	where AF.archGroupId = @i_archGroupId AND AF.archFileId = R.archFileId AND AF.commCellId = R.commCellId
and (R.status = 2 OR
((AF.appType <> 13 AND ((AF.physicalOffset + AF.physicalSize) < R.physicalOffset)) OR
(AF.appType = 13 AND ((AF.logicalOffset + AF.logicalSize) < R.physicalOffset)))) -- NAS needs without archive headers which is the LOGICAL SIZE & OFFSET.
	--
	set @retVal = @@ERROR
	if @retVal = 0 set @rollback = 0 else goto FINISH
commit transaction
FINISH:
	if @rollback = 1 rollback transaction
	SELECT @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'archFLAIndexingInsert')
	delete from GxQscripts where name = 'archFLAIndexingInsert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFLAIndexingInsert')
	delete from GXDBVersions where aliasname = 'archFLAIndexingInsert'
GO

insert into GXDBVersions values(2, 'archFLAIndexingInsert',  '00010015001200090000', 'archFLAIndexingInsert', '00010015001200090000')
GO

