

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFLAIndexingGetNext.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFLAIndexingGetNext.sp,v $ $Id: archFLAIndexingGetNext.sp,v 1.3.88.3 2018/03/20 19:55:46 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archFLAIndexingGetNext <<<'

IF EXISTS (select * from sysobjects where name='archFLAIndexingGetNext')
	drop procedure archFLAIndexingGetNext
IF EXISTS (select * from GxQscripts where name='archFLAIndexingGetNext')
	delete from GxQscripts where name = 'archFLAIndexingGetNext'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFLAIndexingGetNext')
	delete from GXDBVersions where aliasname = 'archFLAIndexingGetNext'
GO
print '... Creating Procedure: archFLAIndexingGetNext'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archFLAIndexingGetNext
  @i_archCopyId int,
  @i_streamNum int,
  @i_volumeId int,
  @i_numOfChunks int
AS
  DECLARE @o_appId integer;
  DECLARE @o_appType integer;
  DECLARE @o_clientId integer;
  DECLARE @o_fullCycleNum integer;
  DECLARE @o_backupJobId integer;
  DECLARE @o_backupStartTime integer;
  DECLARE @o_backupEndTime integer;
  DECLARE @o_archChunkId bigint;
  DECLARE @o_archFileId integer;
  DECLARE @o_commCellId integer;
  DECLARE @o_archCopyId integer;
  DECLARE @o_streamNum integer;
  DECLARE @o_fileType integer;
  DECLARE @o_archFileCopyFlags integer;
  DECLARE @o_encType integer;
  DECLARE @o_lastChunkNumber integer;
  DECLARE @o_chunkNumber integer;
  DECLARE @o_physicalOffset bigint;
  DECLARE @o_logicalOffset bigint;
  DECLARE @o_physicalSize bigint;
  DECLARE @o_logicalSize bigint;
  DECLARE @o_volumeId integer;
  DECLARE @o_mediaId integer;
  DECLARE @o_mediaGroupId integer;
  DECLARE @o_fileMarkerNo integer;
  DECLARE @o_chunkCreateTime integer;
  DECLARE @o_chunkVersion integer;
  DECLARE @o_chunkPhysicalSize bigint;
  DECLARE @o_chunkLogicalSize bigint;
  DECLARE @o_chunkHwEncKey varchar(2048);
  DECLARE @o_extraFlags integer;
  DECLARE @o_startPhysicalOffset bigint;
SET NOCOUNT ON
DECLARE @tblNextChunks TABLE
(
	archChunkId bigint,
	commCellId int
)
DECLARE @tblAFChunk TABLE
(
	archGroupId			integer,
	clientId			integer,
	appType				integer,
	appId				integer,
	fullCycleNum		integer,
	backupJobId			integer,
	backupStartTime		integer,
	backupEndTime		integer,
	archChunkId			bigint,
	archFileId			integer,
	commCellId			integer,
	archCopyId			integer,
	streamNum			integer,
	encKeyType			integer,
	archFileCopyFlags	integer,
	lastChunkNumber		integer,
	chunkNumber			integer,
	physicalOffset		bigint,
	logicalOffset		bigint,
	physicalSize		bigint,
	logicalSize			bigint,
	volumeId			integer,
	mediaId				integer,
	mediaGroupId		integer,
	fileMarkerNo		integer,
	chunkCreateTime		integer,
	chunkVersion		integer,
	chunkPhysicalSize	bigint,
	chunkLogicalSize	bigint,
chunkHwEncKey		varchar(2048),
	extraFlags			integer,
	segmentId			integer,
	primary key (archChunkId, archFileId, commCellId)
)
--
DECLARE	@l_error	INT
DECLARE	@l_rowcount	INT
DECLARE	@l_nAFChunk	INT
--
-- FIX MR 88825 Infinite Loop Fix.
-- delete archFLAIndexingAF from archFLAIndexingAged CIA where	CIA.appId = archFLAIndexingAF.appId
-- and CIA.commCellId = archFLAIndexingAF.commCellId and CIA.archFileId = archFLAIndexingAF.archFileId
--
INSERT	INTO
	@tblAFChunk
SELECT
	archGroupId, clientId, appType, appId, fullCycleNum, backupJobId, backupStartTime, backupEndTime, archChunkId,
	archFileId, commCellId, archCopyId, streamNum, encKeyType, archFileCopyFlags, lastChunkNumber, chunkNumber, physicalOffset, logicalOffset,
	physicalSize, logicalSize, volumeId, mediaId, mediaGroupId, fileMarkerNo, chunkCreateTime, chunkVersion, chunkPhysicalSize, chunkLogicalSize,
	chunkHwEncKey, extraFlags, segmentId
FROM
	archFLAIndexingAF WITH (NOLOCK)
WHERE
	volumeId = @i_volumeId
	AND	archCopyId = @i_archCopyId
	AND	streamNum = @i_streamNum
--
-- We cannot pick chunks from a different volume. Also, if previous chunks are present in a
-- different volume, then we should not pick these chunks as chunks for an archive file should
-- be processed in order.
-- Chunks for an archive file should be processed in order (asc). If the lower chunk numbers
-- of this AF exsits in another volume, we should process them first before processing the
-- chunks in this volume.
DELETE
	@tblAFChunk
FROM
	@tblAFChunk a, archFLAIndexingAF b WITH (NOLOCK)
WHERE
	a.archFileId = b.archFileId AND a.commCellId = b.commCellId
	AND a.volumeId <> b.volumeId AND a.chunkNumber > b.chunkNumber
-- Removed the archfiles that need to be deleted
DELETE
	@tblAFChunk
FROM
	@tblAFChunk a, archFLAIndexingAged b WITH (NOLOCK)
WHERE
	a.archFileId = b.archFileId AND a.commCellId = b.commCellId
	AND b.agedFlag = 0
--
INSERT INTO
	@tblNextChunks
SELECT
 	DISTINCT TOP(@i_numOfChunks) archChunkId, commCellId
FROM
	@tblAFChunk
ORDER BY
	archChunkId
IF @@ERROR = 0 AND @@ROWCOUNT > 0
BEGIN
	SELECT
		a.appId, a.appType, a.clientId, a.fullCycleNum, a.backupJobId, a.backupStartTime, a.backupEndTime,
		a.archChunkId, a.archFileId, a.commCellId, a.archCopyId,
a.streamNum, 1, a.archFileCopyFlags, a.encKeyType, a.lastChunkNumber,
		a.chunkNumber, a.physicalOffset, a.logicalOffset, a.physicalSize, a.logicalSize,
		a.volumeId, a.mediaId, a.mediaGroupId, a.fileMarkerNo,
		a.chunkCreateTime, a.chunkVersion, a.chunkPhysicalSize, a.chunkLogicalSize, a.chunkHwEncKey, a.extraFlags,
		ISNULL((SELECT	physicalOffset FROM archFLAIndexingRestart WHERE archFileId = a.archFileId AND commCellId = a.commCellId), a.physicalOffset)
	FROM
		@tblNextChunks b, archFLAIndexingAF a
	WHERE
		a.archChunkId = b.archChunkId AND a.commCellId = b.commCellId
	ORDER BY
		a.archChunkId, a.archFileId
	DELETE
		archFLAIndexingAF
	FROM
		@tblNextChunks b, archFLAIndexingAF a
	WHERE
		a.archChunkId = b.archChunkId AND a.commCellId = b.commCellId
END
ELSE
BEGIN
	SELECT
		TOP 1 a.appId, a.appType, a.clientId, a.fullCycleNum, a.backupJobId, a.backupStartTime, a.backupEndTime,
		a.archChunkId, a.archFileId, a.commCellId, a.archCopyId,
a.streamNum, 1, a.archFileCopyFlags, a.encKeyType, a.lastChunkNumber,
		a.chunkNumber, a.physicalOffset, a.logicalOffset, a.physicalSize, a.logicalSize,
		a.volumeId, a.mediaId, a.mediaGroupId, a.fileMarkerNo,
		a.chunkCreateTime, a.chunkVersion, a.chunkPhysicalSize, a.chunkLogicalSize, a.chunkHwEncKey, a.extraFlags, -1
	FROM
		archFLAIndexingAF a WITH (NOLOCK)
	WHERE
		a.volumeId = @i_volumeId
		AND NOT EXISTS (SELECT * FROM archFLAIndexingAged WITH (NOLOCK) WHERE ArchFileId = a.archFileId AND CommCellId = a.CommcellId AND AgedFlag = 0)
	ORDER BY
		a.archChunkId, a.archFileId
END
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archFLAIndexingGetNext')
	delete from GxQscripts where name = 'archFLAIndexingGetNext'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFLAIndexingGetNext')
	delete from GXDBVersions where aliasname = 'archFLAIndexingGetNext'
GO

insert into GXDBVersions values(2, 'archFLAIndexingGetNext',  '00010003008800030000', 'archFLAIndexingGetNext', '00010003008800030000')
GO

