

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFLAIndexingGetFirst.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFLAIndexingGetFirst.sp,v $ $Id: archFLAIndexingGetFirst.sp,v 1.2.88.1 2018/03/20 19:52:28 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archFLAIndexingGetFirst <<<'

IF EXISTS (select * from sysobjects where name='archFLAIndexingGetFirst')
	drop procedure archFLAIndexingGetFirst
IF EXISTS (select * from GxQscripts where name='archFLAIndexingGetFirst')
	delete from GxQscripts where name = 'archFLAIndexingGetFirst'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFLAIndexingGetFirst')
	delete from GXDBVersions where aliasname = 'archFLAIndexingGetFirst'
GO
print '... Creating Procedure: archFLAIndexingGetFirst'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archFLAIndexingGetFirst
  @i_archGroupId int,
  @i_copyId int,
  @i_stream int
AS
  DECLARE @o_archCopyId integer;
  DECLARE @o_streamNum integer;
  DECLARE @o_mediaGroupId integer;
  DECLARE @o_commCellId integer;
  DECLARE @o_archChunkId bigint;
  DECLARE @o_totalPhysicalSize bigint;
SET NOCOUNT ON
DECLARE	@tblDataSize TABLE
(
	archCopyId int,
	streamNum int,
	mediaGroupId int,
	commCellId int,
	archChunkId bigint,
	physicalSize bigint
)
DECLARE	@tblDataSizeAdjust	TABLE
(
	archCopyId int,
	streamNum int,
	mediaGroupId int,
	commCellId int,
	physicalSize bigint
)
-- Since we don't pickup up partial chunks and want to go back to the start of the partial chunk,
-- we should adjust the size accordingly.
INSERT	INTO
	@tblDataSizeAdjust
SELECT
	A.archCopyId, A.streamNum, A.mediaGroupId, A.commCellId, SUM(R.physicalOffset - A.physicalOffset)
FROM
	archFLAIndexingAF A, archFLAIndexingRestart R
WHERE
	A.archGroupId = @i_archGroupId
	AND (@i_copyId = 0 OR A.archCopyId = @i_copyId)
	AND (@i_stream = 0 AND streamNum > 0 OR @i_stream > 0 AND @i_stream = streamNum)
	AND A.archFileId = R.archFileId AND A.commCellId = R.commCellId
	AND A.physicalOffset < R.physicalOffset AND (A.physicalOffset + A.physicalSize) >= R.physicalOffset
GROUP BY
	A.archCopyId, A.streamNum, A.mediaGroupId, A.commCellId
BEGIN
	-- Totalling up the physical size to be processed per stream. One copy might be part of more than one stream.
	INSERT	INTO
		@tblDataSize
	SELECT
		archCopyId, streamNum, mediaGroupId, commCellId, MIN(archChunkId), SUM(physicalSize)
	FROM
		archFLAIndexingAF
	WHERE
		archGroupId = @i_archGroupId
		AND (@i_copyId = 0 OR archCopyId = @i_copyId)
		AND (@i_stream = 0 AND streamNum > 0 OR @i_stream > 0 AND @i_stream = streamNum)
		AND (@i_stream = 0 OR @i_stream > 0  /* AND NOT EXISTS (SELECT * FROM archContentIndexingAged WHERE ArchFileId = archContentIndexingAF.archFileId AND CommCellId = archContentIndexingAF.CommcellId AND AgedFlag = 0) */)
	GROUP BY
		archCopyId, streamNum, mediaGroupId, commCellId
END
UPDATE
	@tblDataSize
SET
	physicalSize = (A.physicalSize - B.physicalSize)
FROM
	@tblDataSize A
INNER JOIN
	@tblDataSizeAdjust B
ON
	A.archCopyId = B.archCopyId
	AND A.streamNum = B.streamNum
SELECT
	archCopyId, streamNum, mediaGroupId, commCellId, archChunkId, physicalSize
FROM
	@tblDataSize
ORDER BY
	archCopyId, streamNum, mediaGroupId, commCellId
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archFLAIndexingGetFirst')
	delete from GxQscripts where name = 'archFLAIndexingGetFirst'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFLAIndexingGetFirst')
	delete from GXDBVersions where aliasname = 'archFLAIndexingGetFirst'
GO

insert into GXDBVersions values(2, 'archFLAIndexingGetFirst',  '00010002008800010000', 'archFLAIndexingGetFirst', '00010002008800010000')
GO

