

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archFLAIndexingAgeBulk.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archFLAIndexingAgeBulk.sp,v $ $Id: archFLAIndexingAgeBulk.sp,v 1.2.88.3 2019/10/11 16:34:18 pkrishnan Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archFLAIndexingAgeBulk')
BEGIN
	print '>>> Drop Stored Procedure: archFLAIndexingAgeBulk <<<'
	drop procedure archFLAIndexingAgeBulk
END
IF EXISTS (select * from GxQscripts where name='archFLAIndexingAgeBulk')
	delete from GxQscripts where name = 'archFLAIndexingAgeBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFLAIndexingAgeBulk')
	delete from GXDBVersions where aliasname = 'archFLAIndexingAgeBulk'
GO
print '... Creating Procedure: archFLAIndexingAgeBulk'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archFLAIndexingAgeBulk
  @i_archGroupId int,
  @i_commCellId int,
  @i_appId int,
  @i_pruneType int,
  @i_agedFlag int
AS
  DECLARE @retVal integer;
set nocount on
declare @error int
set @error = 0
-- If deleting a specific subclient
if(@i_appId <> 0)
begin
	insert into archFLAIndexingAged(archFileId, commCellId, cloudId, appId, pruneType, agedFlag)
	select
		top 1 0, @i_commCellId, E.cloudId, @i_appId, @i_pruneType, @i_agedFlag
	from
		archFLAIndexingInfo E with(nolock)
	inner join
		archFile A with(nolock)
	on
		E.archFileId = A.id and E.commCellId = A.commCellId
	where
		E.commCellId = @i_commCellId and A.appId = @i_appId
	--
	set @error = @@ERROR
	--delete from restart table for CI
	DELETE R
	FROM archcontentindexingrestart R (NOLOCK)
	JOIN archFile A (NOLOCK) ON A.id = R.archfileId
	WHERE A.commCellId = @i_commCellId and A.appId = @i_appId
	--prune CI data
	insert into archContentIndexingAged (archFileId, commCellId, cloudId, appId, pruneType, agedFlag, jobId)
SELECT A.id, A.commCellId, A.cloudId, @i_appId, 2, @i_agedFlag, A.jobId
	FROM archFile A with (nolock)
WHERE A.commCellId = @i_commCellId and A.appId = @i_appId AND A.fileType = 1  AND (A.flags & (32 + 64)) > 0
	--
	set @error = @@ERROR
end
else if(@i_archGroupId <> 0)
begin
	insert into archFLAIndexingAged(archFileId, commCellId, cloudId, appId, pruneType, agedFlag)
	select
		0, @i_commCellId, E.cloudId, A.appId, @i_pruneType, @i_agedFlag
	from
		archFLAIndexingInfo E with (nolock)
	inner join
		archFile A with (nolock)
	on
		E.archFileId = A.id and E.commCellId = A.commCellId
	where
		E.commCellId = @i_commCellId and A.archGroupId = @i_archGroupId
	group by
		A.appId, E.cloudId
	having
		COUNT(A.appId) > 0
	--
	set @error = @@ERROR
end
set nocount off
select @error
GO

IF EXISTS (select * from GxQscripts where name = 'archFLAIndexingAgeBulk')
	delete from GxQscripts where name = 'archFLAIndexingAgeBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFLAIndexingAgeBulk')
	delete from GXDBVersions where aliasname = 'archFLAIndexingAgeBulk'
GO

insert into GXDBVersions values(2, 'archFLAIndexingAgeBulk',  '00010002008800030000', 'archFLAIndexingAgeBulk', '00010002008800030000')
GO

