

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archDisallowMultipleJobForCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archDisallowMultipleJobForCopy.sp,v $ $Id: archDisallowMultipleJobForCopy.sp,v 1.8.54.3 2018/09/04 10:33:58 chandru Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archDisallowMultipleJobForCopy <<<'

IF EXISTS (select * from sysobjects where name='archDisallowMultipleJobForCopy')
	drop procedure archDisallowMultipleJobForCopy
IF EXISTS (select * from GxQscripts where name='archDisallowMultipleJobForCopy')
	delete from GxQscripts where name = 'archDisallowMultipleJobForCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDisallowMultipleJobForCopy')
	delete from GXDBVersions where aliasname = 'archDisallowMultipleJobForCopy'
GO
print '... Creating Procedure: archDisallowMultipleJobForCopy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archDisallowMultipleJobForCopy
  @i_now integer
AS
  DECLARE @retVal integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
/* This temp table must be created and populated by caller before calling this stored procedure
CREATE TABLE #ToBeDisabledJob (
	jobId INT, archGrpId INT, archGrpCopyId INT, dataType INT, commCellId INT,
	PRIMARY KEY (jobId, archGrpCopyId, dataType, commCellId))
*/
	SET	@retVal = 0
	DECLARE @rowCount INT
	SET			@rowCount = 0
	DECLARE @tblJobCopyToSet TABLE (jobId INT, archGrpCopyId INT, commCellId INT, dataType INT, sourceCopyId INT, toBeSet INT)
	DECLARE @tblCopyToSet TABLE (copyId INT, sourceCopyId INT, defaultCopyId INT, archGroupId INT, flags INT, dedupeFlags INT, maxMultiplex INT, isSnapCopy INT, isMirrorCopy INT)
	DECLARE @tblMatSrcCopy TABLE ( archGroupId INT, sourceCopyId INT)
	DECLARE @SpCopyListCursor1Flag INT
	SET 		@SpCopyListCursor1Flag = 0
	DECLARE	@curArchGrpId			INT
	DECLARE	@curArchGrpCopyId	INT
	INSERT INTO @tblMatSrcCopy
	SELECT a.id, (CASE b.sourceCopyId WHEN 0 THEN a.defaultSnapCopy ELSE b.sourceCopyId END)
	FROM	archGroup a WITH (NOLOCK), archMaterializeSnapshotProp b WITH (NOLOCK), archGroupCopy c WITH (NOLOCK)
	WHERE	a.id = b.archGroupId
	AND		a.id = c.archGroupId
	AND		c.id = (CASE b.sourceCopyId WHEN 0 THEN a.defaultSnapCopy ELSE b.sourceCopyId END)
	AND		c.isSnapCopy > 0
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	DECLARE	SpCopyListCursor1 CURSOR STATIC FOR
			SELECT	DISTINCT archGrpId, archGrpCopyId
			FROM	#ToBeDisabledJob
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	SET		@SpCopyListCursor1Flag = 1
	OPEN	SpCopyListCursor1
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	FETCH	NEXT
	FROM SpCopyListCursor1
	INTO	@curArchGrpId, @curArchGrpCopyId
	SET	@retVal	=	@@ERROR
	IF	@retVal != 0 GOTO CX_EXIT
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		IF EXISTS (SELECT * FROM #ToBeDisabledJob WHERE archGrpCopyId = @curArchGrpCopyId)
		BEGIN
			DELETE 	@tblCopyToSet
			SET	@retVal	=	@@ERROR
			IF	@retVal != 0 GOTO CX_EXIT
			DELETE 	@tblJobCopyToSet
			SET	@retVal	=	@@ERROR
			IF	@retVal != 0 GOTO CX_EXIT
			INSERT INTO @tblCopyToSet
			EXEC ArchDestinationCopyList @curArchGrpCopyId
			SET	@retVal	=	@@ERROR
			IF	@retVal != 0 GOTO CX_EXIT
			INSERT	INTO @tblJobCopyToSet
			SELECT	DISTINCT J.jobId, J.archGrpCopyId, J.commCellId, J.dataType, C.sourceCopyId, 0
			FROM		JMJobDataStats J, @tblCopyToSet C, #ToBeDisabledJob T
			WHERE		T.archGrpCopyId = @curArchGrpCopyId
			AND			J.jobId = T.JobId
			AND 		J.commCellId = T.commCellId
			AND			J.archGrpCopyId = C.copyId
			AND			J.dataType = T.dataType
			AND 		J.status IN (101, 102, 103)
AND 		(J.disabled & 1) = 0
			AND 		C.copyId <> @curArchGrpCopyId
			SET	@retVal	=	@@ERROR
			IF	@retVal != 0 GOTO CX_EXIT
			INSERT	INTO @tblJobCopyToSet
			SELECT  DISTINCT T.JobId, T.archGrpCopyId, T.commCellId, T.dataType, 0, 1
			FROM 		#ToBeDisabledJob T
			WHERE		T.archGrpCopyId = @curArchGrpCopyId
			SELECT	@retVal	=	@@ERROR, @rowCount = @@ROWCOUNT
			IF	@retVal != 0 GOTO CX_EXIT
			WHILE @rowCount > 0
			BEGIN
				UPDATE	@tblJobCopyToSet
				SET 		toBeSet = 1
				FROM 		(SELECT JobId, archGrpCopyId, commCellId, dataType FROM @tblJobCopyToSet WHERE toBeSet = 1) T, @tblJobCopyToSet T1
				WHERE		T1.toBeSet = 0
				AND 		T1.sourceCopyId = T.archGrpCopyId
				AND 		T1.jobId = T.jobId
				AND 		T1.commCellId = T.commCellId
				AND 		T1.dataType = T.dataType
				SELECT	@retVal	=	@@ERROR, @rowCount = @@ROWCOUNT
				IF	@retVal != 0 GOTO CX_EXIT
			END
			UPDATE 	JMJobDataStats
SET		disabled = (J.disabled | 1), modifiedTime = @i_now
			FROM	JMJobDataStats J, @tblJobCopyToSet T
			WHERE	J.jobId = T.jobId
			AND 	J.commCellId = T.commCellId
			AND 	J.archGrpCopyId = T.archGrpCopyId
			AND		J.dataType = T.dataType
AND 	(J.disabled & 1) = 0
			AND 	T.toBeSet = 1
			SET	@retVal	=	@@ERROR
			IF	@retVal != 0 GOTO CX_EXIT
			-- Disable Materialization if the Source Copy job is aged or disabled for Copy
			UPDATE 	JMJobSnapShotStats
SET		disabled = (JS.disabled | 1)
			FROM	JMJobSnapShotStats JS, JMJobDataStats JDS WITH (NOLOCK), @tblJobCopyToSet T, @tblMatSrcCopy SC
			WHERE	JDS.jobId = T.jobId
			AND 	JDS.commCellId = T.commCellId
			AND 	JDS.archGrpCopyId = T.archGrpCopyId
			AND		JDS.dataType = T.dataType
			AND 	T.toBeSet = 1
			AND		JDS.archGrpId = SC.archGroupId
			AND		JDS.archGrpCopyId = SC.sourceCopyId
AND		((JDS.status = 1000) OR (JDS.disabled & 256 > 0) OR ((JDS.STATUS <> 100) AND (JDS.disabled & 1 > 0)))
			AND		JDS.jobId = JS.jobId
			AND 	JDS.commCellId = JS.commCellId
			--AND		JDS.dataType = JS.dataType
AND 	(JS.disabled & 1) = 0
			AND		JS.materializationStatus IN (101, 102, 103)
			SET	@retVal	=	@@ERROR
			IF	@retVal != 0 GOTO CX_EXIT
		END
		FETCH	NEXT
		FROM SpCopyListCursor1
		INTO	@curArchGrpId, @curArchGrpCopyId
		SET	@retVal	=	@@ERROR
		IF	@retVal != 0 GOTO CX_EXIT
	END
CX_EXIT:
	IF @SpCopyListCursor1Flag = 1
	BEGIN
		CLOSE				SpCopyListCursor1
		DEALLOCATE	SpCopyListCursor1
	END
	-- SELECT @retVal -- Cannot select as it is being called from another stored procedure
	RETURN @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'archDisallowMultipleJobForCopy')
	delete from GxQscripts where name = 'archDisallowMultipleJobForCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDisallowMultipleJobForCopy')
	delete from GXDBVersions where aliasname = 'archDisallowMultipleJobForCopy'
GO

insert into GXDBVersions values(2, 'archDisallowMultipleJobForCopy',  '00010008005400030000', 'archDisallowMultipleJobForCopy', '00010008005400030000')
GO

