

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archDisallowJobForCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archDisallowJobForCopy.sp,v $ $Id: archDisallowJobForCopy.sp,v 1.22.2.8 2018/09/04 10:33:43 chandru Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archDisallowJobForCopy <<<'

IF EXISTS (select * from sysobjects where name='archDisallowJobForCopy')
	drop procedure archDisallowJobForCopy
IF EXISTS (select * from GxQscripts where name='archDisallowJobForCopy')
	delete from GxQscripts where name = 'archDisallowJobForCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDisallowJobForCopy')
	delete from GXDBVersions where aliasname = 'archDisallowJobForCopy'
GO
print '... Creating Procedure: archDisallowJobForCopy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archDisallowJobForCopy
  @i_jobId integer,
  @i_commCellId integer,
  @i_copyId integer,
  @i_now integer,
  @i_ignoreRunningJobs integer = 0,
  @i_isGuiOption integer = 0
AS
  DECLARE @retVal integer;
  DECLARE @o_spname varchar(288);
  DECLARE @o_copyname varchar(128);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET	@retVal = 0
DECLARE @l_archGroupId INT = 0
DECLARE @l_isSnapCopy INT = 0
DECLARE @l_defCopyId INT = 0
DECLARE @l_defSnapCopyId INT = 0
DECLARE @tblJobCopyToSet TABLE (jobId INT, archGrpCopyId INT, commCellId INT, sourceCopyId INT, toBeSet INT)
DECLARE @tblCopyToSet TABLE (copyId INT, sourceCopyId INT, defaultCopyId INT, archGroupId INT, flags INT, dedupeFlags INT, maxMultiplex INT, isSnapCopy INT, isMirrorCopy INT)
BEGIN TRY
	SELECT @l_archGroupId = archGroupId, @l_isSnapCopy = isSnapCopy
	FROM archGroupCopy WHERE id = @i_copyId
	SELECT @l_defCopyId = defaultCopy, @l_defSnapCopyId = defaultSnapCopy
	FROM archGroup WHERE id = @l_archGroupId
	INSERT INTO @tblCopyToSet
	EXEC ArchDestinationCopyList @i_copyId
	-- PrasadNara: MR#82789
	-- DO NOT DISALLOW JOB when auxiliary copy, data verification, offline content indexing
	-- or media refresh jobs are running for the storage policy or destination copies.
	-- 13, 104-AUXCOPY, 31-ARCHIVECHECK, 53-OFFLINECONTENTINDEX, 57-ONLINECONTENTINDEX, 74-MEDIAREFRESHING, 60-SNAPTOTAPE
/*
	IF (@i_ignoreRunningJobs = 0)
	BEGIN
		DECLARE	@tblOpType TABLE (opType INT)
		INSERT	INTO @tblOpType
		SELECT	DISTINCT B.opType
		FROM	JMAdminJobInfoTable B WITH (NOLOCK), JMJobInfo J WITH (NOLOCK)
		WHERE	B.jobId = J.jobId
		AND		B.commCellId = @i_commCellId
		AND		(B.opType IN (53, 57, 74) OR (B.opType IN (13, 104) AND J.state NOT IN (5, 15))OR (B.opType = 31 AND B.CloudId = 0))
		AND 	EXISTS
					(
						SELECT 	A.optionId
						FROM 		dbo.GetAllJobOptions(B.JobId) A
WHERE 	A.optionId = 140008 AND A.value = CAST(@l_archGroupId AS CHAR(10))
AND	( dbo.GetJobOption(B.JobId, 140009) = '0'
OR dbo.GetJobOption(B.JobId, 140009) IN ( SELECT CAST(copyId AS CHAR(10)) FROM @tblCopyToSet))
									OR
A.optionId = 229570007 AND A.value IN (SELECT CAST(S.SIDBStoreId AS CHAR(12))
																			 FROM @tblCopyToSet TC, archCopySIDBStore S WITH (NOLOCK)
																			 WHERE	TC.CopyId = S.CopyId)
				)
		IF 	EXISTS (SELECT * FROM @tblOpType WHERE opType = 13 OR opType = 104)
				AND	EXISTS (SELECT * FROM JMJobDataStats WITH (NOLOCK)
											WHERE	jobId = @i_jobId
											AND 	commCellId = @i_commCellId
											AND 	status IN (101, 102, 103)
AND 	(disabled & (1|256)) = 0
										)
				OR	EXISTS (SELECT * FROM @tblOpType WHERE opType = 31)
				AND	(EXISTS (SELECT * FROM JMJobDataStats WITH (NOLOCK)
											WHERE	jobId = @i_jobId
											AND 	commCellId = @i_commCellId
											AND 	archGrpCopyId IN (SELECT copyId FROM @tblCopyToSet)
											AND		status = 100
											AND 	archCheckStatus IN (3, 4)
AND 	(disabled & 256) = 0
										)
					OR EXISTS (	SELECT *
								FROM	archChunkToVerify V WITH (NOLOCK), JMJobInfo J WITH (NOLOCK)
								WHERE	J.opType = 31
										AND J.jobId = V.adminJobId
										AND V.backupJobId = @i_JobId
										AND V.commCellId = @i_commCellId
										AND V.archCopyId = @i_copyId)
					OR EXISTS (	SELECT *
								FROM	archChunkToVerifyHistory V WITH (NOLOCK), JMJobInfo J WITH (NOLOCK)
								WHERE	J.opType = 31
										AND J.jobId = V.adminJobId
										AND V.backupJobId = @i_JobId
										AND V.commCellId = @i_commCellId
										AND V.archCopyId = @i_copyId))
				OR	EXISTS (SELECT * FROM @tblOpType WHERE opType IN (53, 57))
				AND EXISTS (SELECT * FROM archContentIndexingRules WITH (NOLOCK)
											WHERE	archGroupId = @l_archGroupId
											AND 	(CASE WHEN sourceCopyId = 0 THEN @l_defCopyId ELSE sourceCopyId END) = @i_copyId
										)
				AND	EXISTS (SELECT * FROM archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
											WHERE	AF.jobId = @i_jobId
											AND 	AF.commCellId = @i_commCellId
											AND		AF.id = AFC.archFileId
											AND		AF.commCellId = AFC.commCellId
											AND 	AFC.archCopyId = @i_copyId
AND 	(AFC.flags & 256) = 0
AND 	(AF.flags & (16|32)) <> 0)
				OR	EXISTS (SELECT * FROM @tblOpType WHERE opType = 74)
				AND	EXISTS (SELECT * FROM JMJobDataStats WITH (NOLOCK)
											WHERE	jobId = @i_jobId
											AND 	commCellId = @i_commCellId
											AND 	archGrpCopyId IN (SELECT copyId FROM @tblCopyToSet)
AND 	(disabled & 256) = 0
										)
		BEGIN
SET @retVal = 98
			GOTO CX_EXIT
		END
	END
*/
	-- The source copy will be source of Mirror copy if source copy is Mirror Copy
	WHILE EXISTS(SELECT T.sourceCopyId FROM @tblCopyToSet T, archGroupCopy AGC WITH (NOLOCK)
				WHERE	T.sourceCopyId = AGC.id AND AGC.isSnapCopy > 0 AND AGC.isMirrorCopy > 0)
	BEGIN
		UPDATE	@tblCopyToSet
		SET 	sourceCopyId = CASE WHEN AGC.sourceCopyId > 0 THEN AGC.sourceCopyId
                            ELSE (SELECT defaultSnapCopy FROM archGroup WITH (NOLOCK) WHERE id = AGC.archGroupId) END
		FROM	@tblCopyToSet T, archGroupCopy AGC WITH (NOLOCK)
		WHERE	T.sourceCopyId = AGC.id
		AND		AGC.isSnapCopy > 0
		AND		AGC.isMirrorCopy > 0
	END
	INSERT	INTO @tblJobCopyToSet
	SELECT	DISTINCT J.jobId, J.archGrpCopyId, J.commCellId, C.sourceCopyId, 0
	FROM	JMJobDataStats J, @tblCopyToSet C
	WHERE	J.jobId = @i_jobId AND J.archGrpCopyId = C.copyId AND J.commCellId = @i_commCellId
AND J.status <> 100 AND (J.disabled & 1) = 0 AND C.copyId <> @i_copyId
	INSERT	INTO @tblJobCopyToSet
	SELECT	@i_jobId, @i_copyId, @i_commCellId, 0, 1
	WHILE @@ROWCOUNT > 0
		UPDATE	@tblJobCopyToSet SET toBeSet = 1
		WHERE	toBeSet = 0 AND sourceCopyId IN (SELECT archGrpCopyId FROM @tblJobCopyToSet WHERE toBeSet = 1)
	UPDATE 	JMJobDataStats
SET		disabled = (J.disabled | 1 | CASE WHEN @i_isGuiOption = 1 THEN 32768 ELSE 0 END ), modifiedTime = @i_now
	FROM	JMJobDataStats J, @tblJobCopyToSet T
	WHERE	J.jobId = T.jobId AND J.archGrpCopyId = T.archGrpCopyId AND J.commCellId = T.commCellId
AND (J.disabled & 1) = 0 AND T.toBeSet = 1
	-- Disable Defered Catalog if the Source Copy job is aged or disabled for Copy
	DECLARE	@l_defCatSrcCopyId INT = 0
	IF	@l_isSnapCopy = 1
		SELECT	@l_defCatSrcCopyId = sourceCopyId FROM ArchDeferredCatalogProp WHERE archGroupId = @l_archGroupId
	IF	@l_defCatSrcCopyId = 0
		SET	@l_defCatSrcCopyId = @l_defSnapCopyId
	IF	@i_copyId = @l_defCopyId
	OR	@i_copyId = @l_defCatSrcCopyId
	OR	(@i_copyId = @l_defSnapCopyId AND @l_defCatSrcCopyId <> @l_defSnapCopyId
		 OR EXISTS (SELECT * FROM @tblCopyToSet WHERE copyId = @l_defCatSrcCopyId AND sourceCopyId = @i_copyId))
		AND NOT EXISTS (SELECT * FROM JMJobDataStats WHERE jobId = @i_jobId AND commCellId = @i_commCellId
AND archGrpCopyId = @l_defCatSrcCopyId AND (disabled & 256) = 0
AND (status = 100 OR status IN (101, 102, 103) AND (disabled & 1) = 0))
	BEGIN
		UPDATE	JMJobSnapDeferredCatalogStats
SET		disabled = (disabled | 1)
		WHERE	jobId = @i_jobId AND commCellId = @i_commCellId
AND catalogStatus IN (101, 102, 103) AND (disabled & 1) = 0
	END
	-- Disable Materialization if the Source Copy job is aged or disabled for Copy
	DECLARE	@l_snapToTapeSrcCopyId INT = 0
	IF	@l_isSnapCopy = 1
		SELECT	@l_snapToTapeSrcCopyId = sourceCopyId FROM archMaterializeSnapshotProp WHERE archGroupId = @l_archGroupId
	IF	@l_snapToTapeSrcCopyId = 0
		SET	@l_snapToTapeSrcCopyId = @l_defSnapCopyId
	IF	@i_copyId = @l_defCopyId
	OR	@i_copyId = @l_snapToTapeSrcCopyId
	OR	(@i_copyId = @l_defSnapCopyId AND @l_snapToTapeSrcCopyId <> @l_defSnapCopyId
		 OR EXISTS (SELECT * FROM @tblCopyToSet WHERE copyId = @l_snapToTapeSrcCopyId AND sourceCopyId = @i_copyId))
		AND NOT EXISTS (SELECT * FROM JMJobDataStats WHERE jobId = @i_jobId AND commCellId = @i_commCellId
AND archGrpCopyId = @l_snapToTapeSrcCopyId AND (disabled & 256) = 0
AND (status = 100 OR status IN (101, 102, 103) AND (disabled & 1) = 0))
	BEGIN
		UPDATE	JMJobSnapshotStats
SET		disabled = (disabled | 1)
		WHERE	jobId = @i_jobId AND commCellId = @i_commCellId
AND materializationStatus IN (101, 102, 103) AND (disabled & 1) = 0
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET	@retVal = (SELECT ERROR_NUMBER())
END CATCH
CX_EXIT:
IF OBJECT_ID('tempdb..#tmpResutSetForArchDisAllowJobForCopy') IS NOT NULL
BEGIN
	IF EXISTS	(SELECT * FROM	@tblJobCopyToSet
			WHERE	toBeSet = 1	and	archGrpCopyId <> @i_copyId)
			INSERT #tmpResutSetForArchDisAllowJobForCopy
			SELECT @retVal,	CONVERT(varchar(288),AG.name),CONVERT(varchar(128),AGC.name)
			FROM	@tblJobCopyToSet T,	ArchGroupCopy	AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
			WHERE	T.toBeSet = 1	and	T.archGrpCopyId	<>	@i_copyId
			and AGC.id = T.archGrpCopyId AND AG.id = AGC.archGroupId
	ELSE
			INSERT #tmpResutSetForArchDisAllowJobForCopy
			SELECT @retVal,	NULL, NULL
END
ELSE
BEGIN
	IF EXISTS	(SELECT * FROM	@tblJobCopyToSet
			WHERE	toBeSet = 1	and	archGrpCopyId <> @i_copyId)
			SELECT @retVal,	CONVERT(varchar(288),AG.name),CONVERT(varchar(128),AGC.name)
			FROM	@tblJobCopyToSet T,	ArchGroupCopy	AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
			WHERE	T.toBeSet = 1	and	T.archGrpCopyId	<>	@i_copyId
			and AGC.id = T.archGrpCopyId AND AG.id = AGC.archGroupId
	ELSE
			SELECT @retVal,	NULL, NULL
END
--SELECT @retVal,	NULL, NULL
RETURN @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'archDisallowJobForCopy')
	delete from GxQscripts where name = 'archDisallowJobForCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDisallowJobForCopy')
	delete from GXDBVersions where aliasname = 'archDisallowJobForCopy'
GO

insert into GXDBVersions values(2, 'archDisallowJobForCopy',  '00010022000200080000', 'archDisallowJobForCopy', '00010022000200080000')
GO

