

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archDisallowCopyByCopyID.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archDisallowCopyByCopyID.sp,v $ $Id: archDisallowCopyByCopyID.sp,v 1.15.12.7 2020/03/24 00:59:06 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archDisallowCopyByCopyID')
BEGIN
	print '>>> Drop Stored Procedure: archDisallowCopyByCopyID <<<'
	drop procedure archDisallowCopyByCopyID
END
IF EXISTS (select * from GxQscripts where name='archDisallowCopyByCopyID')
	delete from GxQscripts where name = 'archDisallowCopyByCopyID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDisallowCopyByCopyID')
	delete from GXDBVersions where aliasname = 'archDisallowCopyByCopyID'
GO
print '... Creating Procedure: archDisallowCopyByCopyID'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archDisallowCopyByCopyID
  @i_copyId integer,
  @i_startTime integer,
  @i_endTime integer,
  @i_userId integer,
  @i_flags integer
AS
  DECLARE @nRows integer;
SET NOCOUNT ON
DECLARE @l_now integer
SET @l_now = dbo.GetUnixTime(GETUTCDATE())
SET	@nRows = 0
IF OBJECT_ID ('tempdb.dbo.#tblJobCopyToSet') IS NOT NULL DROP TABLE #tblJobCopyToSet
CREATE TABLE #tblJobCopyToSet(
		jobId INT, archGrpCopyId INT, commCellId INT, sourceCopyId INT, noSource INT, disabled INT,
		PRIMARY KEY (jobId, archGrpCopyId, commCellId))
IF OBJECT_ID ('tempdb.dbo.#tblJobs') IS NOT NULL DROP TABLE #tblJobs
CREATE TABLE #tblJobs (jobId INT)
DECLARE	@tblCopyToSet	TABLE (
		copyId INT, sourceCopyId INT, defaultCopyId INT, archGroupId INT, flags INT, dedupeFlags INT, maxMultiplex INT, isSnapCopy INT, isMirrorCopy INT, SIBlockSize INT)
DECLARE	@tblCopyToSetDest	TABLE (
		copyId INT, sourceCopyId INT, defaultCopyId INT, archGroupId INT, flags INT, dedupeFlags INT, maxMultiplex INT, isSnapCopy INT, isMirrorCopy INT)
DECLARE	@tblMatSrcCopy	TABLE (
		archGroupId INT, sourceCopyId INT)
INSERT INTO @tblMatSrcCopy
SELECT a.id, (CASE b.sourceCopyId WHEN 0 THEN a.defaultSnapCopy ELSE b.sourceCopyId END)
FROM	archGroup a WITH (NOLOCK), archMaterializeSnapshotProp b WITH (NOLOCK), archGroupCopy c WITH (NOLOCK)
WHERE	a.id = b.archGroupId
AND		a.id = c.archGroupId
AND		c.id = (CASE b.sourceCopyId WHEN 0 THEN a.defaultSnapCopy ELSE b.sourceCopyId END)
AND		c.isSnapCopy > 0
INSERT	INTO #tblJobCopyToSet
SELECT	DISTINCT J.jobId, J.archGrpCopyId, J.commCellId, 0, 1, 0
FROM	JMJobDataStats J WITH (NOLOCK)
WHERE	J.archGrpCopyId = @i_copyId
	AND J.status IN (101, 102, 103)
AND J.disabled & (1+256) = 0
IF @@ERROR = 0 AND @@ROWCOUNT > 0
BEGIN
	IF (@i_startTime > 0)
	BEGIN
		UPDATE	#tblJobCopyToSet
		SET		disabled = 1
		FROM	#tblJobCopyToSet T, JMBkpStats B
		WHERE	B.jobId = T.jobId AND B.commCellId = T.commCellId AND B.servStartDate < @i_startTime
		UPDATE	#tblJobCopyToSet
		SET		disabled = 1
		FROM	#tblJobCopyToSet T, JMAdminJobStatsTable B
		WHERE	B.jobId = T.jobId AND B.commCellId = T.commCellId AND B.servStart < @i_startTime
	END
	IF (@i_endTime < 2147483647)
	BEGIN
		UPDATE	#tblJobCopyToSet
		SET		disabled = 1
		FROM	#tblJobCopyToSet T, JMBkpStats B
		WHERE	B.jobId = T.jobId AND B.commCellId = T.commCellId AND B.servStartDate >= @i_endTime
				AND disabled = 0
		UPDATE	#tblJobCopyToSet
		SET		disabled = 1
		FROM	#tblJobCopyToSet T, JMAdminJobStatsTable B
		WHERE	B.jobId = T.jobId AND B.commCellId = T.commCellId AND B.servStart >= @i_endTime
				AND disabled = 0
	END
	INSERT INTO @tblCopyToSet
	EXEC ArchSourceCopyList @i_copyId
	UPDATE	#tblJobCopyToSet SET sourceCopyId = (SELECT DISTINCT sourceCopyId FROM @tblCopyToSet WHERE copyId = @i_copyId)
	INSERT	INTO #tblJobCopyToSet
	SELECT	J.jobId, J.archGrpCopyId, J.commCellId, C.sourceCopyId,
			MAX(case when J.status = 100 then 0 else 1 end), 0
	FROM	#tblJobCopyToSet T, JMJobDataStats J,
			(SELECT copyId, sourceCopyId FROM @tblCopyToSet WHERE copyId <> @i_copyId) C
	WHERE	J.jobId = T.jobId AND J.commCellId = T.commCellId AND J.archGrpCopyId = C.copyId
		AND T.disabled = 0
		AND J.status IN (100, 101, 102, 103)
AND J.disabled & (1+256) = 0
	GROUP BY J.jobId, J.archGrpCopyId, J.commCellId, C.sourceCopyId
	-- Filter out jobs available in source copy
	WHILE @@ERROR = 0 AND @@ROWCOUNT > 0
	BEGIN
		UPDATE	#tblJobCopyToSet SET noSource = 0
		FROM	#tblJobCopyToSet A,
				(SELECT jobId, archGrpCopyId, commCellId FROM #tblJobCopyToSet WHERE noSource = 0 AND disabled = 0) B
		WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId
			AND A.sourceCopyId = B.archGrpCopyId
			AND A.noSource = 1 AND disabled = 0
	END
	DELETE	FROM #tblJobCopyToSet WHERE archGrpCopyId <> @i_copyId OR noSource = 0 AND disabled = 0
	UPDATE	#tblJobCopyToSet SET disabled = 1 WHERE disabled = 0
	DELETE	FROM @tblCopyToSet
	INSERT INTO @tblCopyToSetDest
	EXEC ArchDestinationCopyList @i_copyId
	INSERT	INTO #tblJobCopyToSet
	SELECT	J.jobId, J.archGrpCopyId, J.commCellId, C.sourceCopyId, 0,
			MAX(case when J.status = 100 then 0 else 1 end)
	FROM	#tblJobCopyToSet T, JMJobDataStats J,
			(SELECT copyId, sourceCopyId FROM @tblCopyToSetDest WHERE copyId <> @i_copyId) C
	WHERE	J.jobId = T.jobId AND J.commCellId = T.commCellId AND J.archGrpCopyId = C.copyId
		AND J.status IN (100, 101, 102, 103)
AND J.disabled & (1+256) = 0
	GROUP BY J.jobId, J.archGrpCopyId, J.commCellId, C.sourceCopyId
	-- Filter out jobs available in source copy
	WHILE @@ERROR = 0 AND @@ROWCOUNT > 0
	BEGIN
		UPDATE	#tblJobCopyToSet SET disabled = 0
		FROM	#tblJobCopyToSet A,
				(SELECT jobId, archGrpCopyId, commCellId FROM #tblJobCopyToSet WHERE disabled = 0) B
		WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId AND A.sourceCopyId = B.archGrpCopyId
			AND A.disabled = 1
	END
	DELETE	FROM #tblJobCopyToSet WHERE disabled = 0
	UPDATE	JMJobDataStats
SET		disabled = (J.disabled | 1), modifiedTime = @l_now
	FROM	JMJobDataStats J, #tblJobCopyToSet T
	WHERE	J.jobId = T.jobId AND J.archGrpCopyId = T.archGrpCopyId AND J.commCellId = T.commCellId
	SET	@nRows = @@ROWCOUNT
	-- Disable Materialization if the Source Copy job is aged or disabled for Copy
	UPDATE 	JMJobSnapShotStats
SET		disabled = (JS.disabled | 1)
	FROM	JMJobSnapShotStats JS, JMJobDataStats JDS WITH (NOLOCK), #tblJobCopyToSet T, @tblMatSrcCopy SC
	WHERE	JDS.jobId = T.jobId
	AND		JDS.commCellId = T.commCellId
	AND		JDS.archGrpCopyId = T.archGrpCopyId
	AND		JDS.archGrpId = SC.archGroupId
	AND		JDS.archGrpCopyId = SC.sourceCopyId
AND		((JDS.status = 1000) OR (JDS.disabled & 256 > 0) OR ((JDS.STATUS <> 100) AND (JDS.disabled & 1 > 0)))
	AND		JDS.jobId = JS.jobId
	AND 	JDS.commCellId = JS.commCellId
	-- AND		JDS.dataType = JS.dataType
AND 	(JS.disabled & 1) = 0
	AND		JS.materializationStatus IN (101, 102, 103)
	IF (@nRows > 0 AND @i_flags & 1 > 0 AND @i_userId > 0) --Audit
	BEGIN
		--Variables for audit
		DECLARE @opMsgId 			INTEGER
		DECLARE @opEvMsgId 		INTEGER
		DECLARE @opId 				INTEGER
		DECLARE @paramMsgId 	INTEGER
		DECLARE @JobList 			VARCHAR(MAX)
		DECLARE @archGroupId integer
		DECLARE @curArchGrpCopyId integer
		DECLARE @GUISPName NVARCHAR(256)
		SET			@GUISPName = ''
		DECLARE @GUICopyName NVARCHAR(256)
		SET			@GUICopyName = ''
		SELECT @archGroupId = archGroupId FROM ArchGroupCopy WITH(NOLOCK) WHERE id = @i_copyId
		-- Set Gui Audit Operation
SET @opMsgId = (21 | (CAST(POWER(2, 24) AS BIGINT) * 84))
		EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userId, 17, @archGroupId, @opEvMsgId OUTPUT, @opId OUTPUT
		-- Set Gui Audit Parameter - Storage Policy Name
		SELECT @GUISPName = name FROM ArchGroup WITH (NOLOCK) WHERE Id = @archGroupId
SET @paramMsgId = (26 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParamData @opId, @GUISPName, 0
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		DECLARE CopyListCursor CURSOR FOR
		SELECT distinct archGrpCopyId FROM #tblJobCopyToSet
		OPEN CopyListCursor
		FETCH NEXT FROM CopyListCursor INTO @curArchGrpCopyId
		WHILE (@@FETCH_STATUS = 0)
		BEGIN
			-- Set Gui Audit Parameter - Copy Name
			SELECT @GUICopyName = name FROM ArchGroupCopy WITH (NOLOCK) WHERE Id = @curArchGrpCopyId
SET @paramMsgId = (27 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParamData @opId, @GUICopyName, 0
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
			WHILE EXISTS (SELECT TOP 1 1 FROM #tblJobCopyToSet WHERE archGrpCopyId = @curArchGrpCopyId)
			BEGIN
				TRUNCATE TABLE #tblJobs
				;WITH CTE
				AS (
					SELECT TOP 5000 *
					FROM 	#tblJobCopyToSet
					WHERE 	archGrpCopyId = @curArchGrpCopyId
					ORDER BY jobId
				)
				DELETE FROM CTE
				OUTPUT DELETED.JobId INTO #tblJobs
				-- Set Gui Audit Parameter - Job List
				SET @JobList = null
				SELECT @JobList = COALESCE(@JobList + ',', '') + CONVERT(VARCHAR(36), JobId)
				FROM 		(SELECT DISTINCT JobId FROM #tblJobs) T
SET @paramMsgId = (3 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParamData @opId, @JobList, 1
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
			END
			FETCH NEXT FROM CopyListCursor INTO @curArchGrpCopyId
		END
        CLOSE CopyListCursor
        DEALLOCATE CopyListCursor
	END
END
SELECT @nRows
IF OBJECT_ID ('tempdb.dbo.#tblJobCopyToSet') IS NOT NULL DROP TABLE #tblJobCopyToSet
IF OBJECT_ID ('tempdb.dbo.#tblJobs') IS NOT NULL DROP TABLE #tblJobs
GO

IF EXISTS (select * from GxQscripts where name = 'archDisallowCopyByCopyID')
	delete from GxQscripts where name = 'archDisallowCopyByCopyID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDisallowCopyByCopyID')
	delete from GXDBVersions where aliasname = 'archDisallowCopyByCopyID'
GO

insert into GXDBVersions values(2, 'archDisallowCopyByCopyID',  '00010015001200070000', 'archDisallowCopyByCopyID', '00010015001200070000')
GO

