

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archDeleteVSAParentAF.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archDeleteVSAParentAF.sp,v $ $Id: archDeleteVSAParentAF.sp,v 1.1.4.2 2020/01/05 03:50:02 bheemesh Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archDeleteVSAParentAF')
BEGIN
	print '>>> Drop Stored Procedure: archDeleteVSAParentAF <<<'
	drop procedure archDeleteVSAParentAF
END
IF EXISTS (select * from GxQscripts where name='archDeleteVSAParentAF')
	delete from GxQscripts where name = 'archDeleteVSAParentAF'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeleteVSAParentAF')
	delete from GXDBVersions where aliasname = 'archDeleteVSAParentAF'
GO
print '... Creating Procedure: archDeleteVSAParentAF'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archDeleteVSAParentAF
  @i_disableOnly INTEGER
AS
  DECLARE @retVal INTEGER;
  DECLARE @retStr VARCHAR(1024);
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE		@archiveFileXML		XML
	DECLARE		@retCode		INTEGER
	SET				@retCode		= 0
	DECLARE		@rowCount		INTEGER
	SET				@rowCount		= 0
	DECLARE @retCodeTbl TABLE
	(
		retCode			INTEGER,
		retString		NVARCHAR(MAX)
	)
	IF OBJECT_ID('tempdb.dbo.#VSAParentAppId') IS NOT NULL DROP TABLE #VSAParentAppId
	CREATE TABLE #VSAParentAppId(
		appId 			INTEGER
		Primary Key (appId)
	)
	IF OBJECT_ID('tempdb.dbo.#VSAParentAFList') IS NOT NULL DROP TABLE #VSAParentAFList
	CREATE TABLE #VSAParentAFList(
		archFileId 		INTEGER,
		commCellId 		INTEGER,
		JobId					INTEGER,
		Primary Key 	(archFileId, commCellId)
	)
	CREATE INDEX Idx_tmpVSAParentAFList_1 ON #VSAParentAFList (JobId, commCellId)
	IF OBJECT_ID('tempdb.dbo.#VSAParentAFToDelete') IS NOT NULL DROP TABLE #VSAParentAFToDelete
	CREATE TABLE #VSAParentAFToDelete(
		archFileId 		INTEGER,
		commCellId 		INTEGER,
		JobId					INTEGER,
		Primary Key 	(archFileId, commCellId)
	)
	CREATE INDEX Idx_tmpVSAParentAFToDelete_1 ON #VSAParentAFToDelete (JobId, commCellId)
	--Get all VSA V2 Parent subclients
	INSERT INTO #VSAParentAppId
	SELECT DISTINCT parentAppId
	FROM JMJobDataLink WITH (NOLOCK)
WHERE	linkType IN (7, 8)
	SELECT	@retVal = @@ERROR, @rowCount = @@ROWCOUNT
	IF	@retVal != 0
	BEGIN
		SET @retStr = 'Failed to retrieve VSA V2 Parent subclients.'
		GOTO CX_EXIT
	END
	IF @rowCount = 0
		GOTO CX_EXIT
	INSERT INTO #VSAParentAFList
	SELECT AF.id, AF.commCellId, AF.jobId
	FROM archFile AF WITH (NOLOCK), #VSAParentAppId T
	WHERE AF.appId = T.appId
	SELECT	@retVal = @@ERROR, @rowCount = @@ROWCOUNT
	IF	@retVal != 0
	BEGIN
		SET @retStr = 'Failed to retrieve VSA V2 Parent archive files.'
		GOTO CX_EXIT
	END
	IF @rowCount = 0
		GOTO CX_EXIT
	--Mark all the VSA V2 parent jobs as disabled for Aux Copy
	UPDATE JMJobDataStats
SET disabled = disabled | (1 + 8192)
	FROM 	JMJobDataStats JDS, #VSAParentAFList T
	WHERE	JDS.jobId = T.jobId
	AND		JDS.commCellId = T.commCellId
AND 	JDS.disabled & 1 = 0
	SET	@retVal = @@ERROR
	IF	@retVal != 0
	BEGIN
		SET @retStr = 'Failed to mark job(s) disabled for aux copy.'
		GOTO CX_EXIT
	END
	--Mark all the VSA V2 parent jobs as disabled for Backup Copy
	UPDATE	JMJobSnapShotStats
SET		disabled = J.disabled | 1, unPickReason = 14
	FROM	JMJobSnapShotStats J, #VSAParentAFList T
	WHERE	J.jobId = T.jobId
	AND		J.commCellId = T.commCellId
	AND 	J.disabled & 1 = 0
	SET	@retVal = @@ERROR
	IF	@retVal != 0
	BEGIN
		SET @retStr = 'Failed to mark job(s) disabled for aux copy.'
		GOTO CX_EXIT
	END
	--Delete the archive files and jobs
	IF @i_disableOnly = 0
	BEGIN
		WHILE EXISTS (SELECT TOP (1) * FROM #VSAParentAFList)
		BEGIN
			INSERT INTO #VSAParentAFToDelete
			SELECT TOP (5000) archFileId, commCellId, jobId
			FROM #VSAParentAFList
			SET	@retVal = @@ERROR
			IF	@retVal != 0
			BEGIN
				SET @retStr = 'Failed to get archive files to prune.'
				GOTO CX_EXIT
			END
			--Generate input XML to send list of archive files to prune
			SET @archiveFileXML = (	SELECT archFileInfo.archFileId AS archFileId, archFileInfo.commCellId AS commCelld
															FROM #VSAParentAFToDelete archFileInfo
															FOR	 XML AUTO, ROOT('GalaxyOperations_PruneArchiveFiles')
														)
			SET	@retVal = @@ERROR
			IF	@retVal != 0
			BEGIN
				SET @retStr = 'Failed to generate XML for archive files to prune.'
				GOTO CX_EXIT
			END
			--Prune the archive files
			IF @archiveFileXML IS NOT NULL
			BEGIN
EXEC @retVal = archDeleteArchiveFiles @archiveFileXML, 2048, 0
				IF	(@@ERROR != 0 OR @retVal != 0)
				BEGIN
					SET @retStr = 'Failed to prune VSA V2 Parent archive files.'
					GOTO CX_EXIT
				END
			END
			--Delete JMJobDataStats entries if marked deletedFromMedia (status = 1000)
			DELETE JMJobDataStats
			FROM JMJobDataStats JDS, #VSAParentAFToDelete D
			WHERE JDS.jobId = D.jobId
			AND		JDS.commCellId = D.commCellId
AND		JDS.disabled & 256 > 0
			AND		JDS.status = 1000
			SET	@retVal = @@ERROR
			IF	@retVal != 0
			BEGIN
				SET @retStr = 'Failed to delete VSA V2 Parent Job Info.'
				GOTO CX_EXIT
			END
			DELETE #VSAParentAFList
			FROM #VSAParentAFList T, #VSAParentAFToDelete D
			WHERE T.archFileId = D.archFileId
			AND		T.commCellId = AFL.commCellId
			SET	@retVal = @@ERROR
			IF	@retVal != 0
			BEGIN
				SET @retStr = 'Failed to process archive files to prune.'
				GOTO CX_EXIT
			END
			TRUNCATE TABLE #VSAParentAFToDelete
		END
	END
	SET @retStr = 'VSA V2 Parent archive files pruned successfully.'
CX_EXIT:
       IF OBJECT_ID('tempdb.dbo.#VSAParentAppId') IS NOT NULL DROP TABLE #VSAParentAppId
       IF OBJECT_ID('tempdb.dbo.#VSAParentAFList') IS NOT NULL DROP TABLE #VSAParentAFList
       IF OBJECT_ID('tempdb.dbo.#VSAParentAFToDelete') IS NOT NULL DROP TABLE #VSAParentAFToDelete
       select @retVal, @retStr
       RETURN @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'archDeleteVSAParentAF')
	delete from GxQscripts where name = 'archDeleteVSAParentAF'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeleteVSAParentAF')
	delete from GXDBVersions where aliasname = 'archDeleteVSAParentAF'
GO

insert into GXDBVersions values(2, 'archDeleteVSAParentAF',  '00010001000400020000', 'archDeleteVSAParentAF', '00010001000400020000')
GO

