

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archDeleteSnapArchiveFiles.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archDeleteSnapArchiveFiles.sp,v $ $Id: archDeleteSnapArchiveFiles.sp,v 1.6.54.3 2018/12/27 16:41:21 vikashkumar Exp $";
--  +========================================================================+
--  | Stored Proc:  archDeleteSnapArchiveFiles()
--  |
--  | Description:  Delete the SnapShot archive files
--	|
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archDeleteSnapArchiveFiles')
BEGIN
	print '>>> Drop Stored Procedure: archDeleteSnapArchiveFiles <<<'
	drop procedure archDeleteSnapArchiveFiles
END
IF EXISTS (select * from GxQscripts where name='archDeleteSnapArchiveFiles')
	delete from GxQscripts where name = 'archDeleteSnapArchiveFiles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeleteSnapArchiveFiles')
	delete from GXDBVersions where aliasname = 'archDeleteSnapArchiveFiles'
GO
print '... Creating Procedure: archDeleteSnapArchiveFiles'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archDeleteSnapArchiveFiles
  @i_xmlText XML
AS
  DECLARE @retVal INTEGER;
  DECLARE @SMVolumeId INTEGER;
  DECLARE @MMErrCode INTEGER;
  DECLARE @retStr VARCHAR(1024);
DECLARE @tblSMVolume TABLE (SMVolumeId INT)
INSERT	INTO @tblSMVolume
SELECT R.ref.value('.', 'int')
FROM @i_xmlText.nodes('/archDeleteSnapArchiveFiles/SMVolumeId') R(ref)
--- CODE BELOW HERE IS FROM AppInsertProp.spb  ----------
	-- BEGIN TRANSACTION PRUNESNAP
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE	@agedTime 			DATETIME
	SET 		@agedTime = GetUTCDate()
	DECLARE	@agedUnixTime 	INTEGER
	SET 		@agedUnixTime = dbo.GetUnixTime(@agedTime)
	DECLARE	@retCode				INTEGER
	DECLARE @magneticBytes	BIGINT
	DECLARE	@rowCnt INTEGER
	SET			@rowCnt	= 0
	SET	@retVal = 0
	SET @MMErrCode = 0
	DECLARE @tblVolCopyInfo TABLE (SMVolumeId INT, CopyId INT, MountStatus INT, PruneFlags INT, archGroupId INT)
	DECLARE @tblRtn TABLE (retVal INT, SMVolId INT, MMErrCode INT, retStr VARCHAR(1024))
	DECLARE @tblBCDIndexAF TABLE(
			jobId int, commCellId int, fileType int, copyId int, flags int
			primary key (jobId, commCellId, fileType, copyId) )
	DECLARE @tblJobsWithBCDIndex TABLE(
			jobId int, commCellId int, fileType int, copyId int, flags int
			primary key (jobId, commCellId, fileType, copyId) )
	DECLARE @tblCopy TABLE (
		archGroupId 	INT,
		archCopyId		INT,
		primaryCopyId INT,
		sourceCopyId	INT,
		isSnapCopy		INT,
		isMirrorCopy	INT,
		matSrcCopyId	INT,
		defCatSrcCopyId INT
	)
	CREATE TABLE #ToBeAgedAFC (
		archFileId INT,
		commCellId INT,
		archCopyId INT,
		PRIMARY KEY (archFileId, commCellId, archCopyId))
	CREATE TABLE #ToBeAgedJobs (
		jobId 			INT,
		commCellId 	INT,
		archCopyId 	INT,
		fileType 		INT,
		isPrunable 	INT
		PRIMARY KEY (jobId, commCellId, archCopyId, fileType))
	IF NOT EXISTS (SELECT * FROM @tblSMVolume)
		GOTO CX_EXIT
	INSERT	INTO  @tblVolCopyInfo
	SELECT	VOL.SMVolumeId, VOL.CopyId, VOL.MountStatus, VOL.PruneFlags, 0
	FROM	@tblSMVolume TMP INNER JOIN SMVolume VOL (NOLOCK) ON TMP.SMVolumeId = VOL.SMVolumeId
	IF @@ROWCOUNT = 0
	BEGIN
SET @MMErrCode = 60210
		SET @retStr = 'Volume does not exist.'
		GOTO CX_EXIT
	END
	UPDATE	TMP
	SET		archGroupId = AGC.archGroupId
	FROM	@tblVolCopyInfo TMP
			INNER JOIN archGroupCopy AGC (NOLOCK) ON TMP.CopyId = AGC.id
	/*
	*/
IF EXISTS (SELECT * FROM @tblVolCopyInfo WHERE MountStatus <> 99)
		BEGIN
			INSERT	INTO @tblRtn
SELECT	0, SMVolumeId, 60217, 'Cannot delete volume from the DB because the snapshot has not yet been deleted from the filer.'
			FROM	@tblVolCopyInfo
WHERE	MountStatus <> 99
			GOTO CX_EXIT
		END
	-- DO NOT PRUNE Snap on Mirror Copy. Prune it with primary Snap Copy
	IF EXISTS ( SELECT AGC.*
							FROM @tblVolCopyInfo TMP
							INNER JOIN archGroupCopy AGC WITH (NOLOCK)
							ON AGC.id = TMP.CopyId
							AND AGC.isSnapCopy > 0
							AND	AGC.isMirrorCopy > 0
	)
	BEGIN
		INSERT	INTO @tblRtn
SELECT	0, TMP.SMVolumeId, 21001, 'Cannot prune snap volumes on Mirror Copy.'
		FROM	@tblVolCopyInfo TMP
				INNER JOIN archGroupCopy AGC WITH (NOLOCK)
					ON AGC.id = TMP.CopyId
					AND AGC.isSnapCopy > 0
					AND	AGC.isMirrorCopy > 0
		GOTO CX_EXIT
	END
	INSERT INTO @tblCopy
	SELECT DISTINCT AG.id, AGC.id, (CASE AGC.isSnapCopy WHEN 0 THEN AG.defaultCopy ELSE AG.defaultSnapCopy END), AGC.sourceCopyId, AGC.isSnapCopy, AGC.isMirrorCopy, 0, 0
	FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK), @tblVolCopyInfo TMP
	WHERE	AG.id = TMP.archGroupId
	AND		AG.id = AGC.archGroupId
	SET	@retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
SET @MMErrCode = 21003
		SET @retStr = 'Failed to retrieve source copies.'
		GOTO CX_EXIT
	END
	-- The source copy will be source of Mirror copy if source copy is Mirror Copy
	WHILE EXISTS(SELECT T.sourceCopyId FROM @tblCopy T, archGroupCopy AGC WITH (NOLOCK) WHERE	T.sourceCopyId = AGC.id AND AGC.isSnapCopy > 0 AND AGC.isMirrorCopy > 0)
	BEGIN
		UPDATE	@tblCopy
		SET 	sourceCopyId = AGC.sourceCopyId
		FROM	@tblCopy T, archGroupCopy AGC WITH (NOLOCK)
		WHERE	T.sourceCopyId = AGC.id
		AND		AGC.isSnapCopy > 0
		AND		AGC.isMirrorCopy > 0
		SET	@retVal = @@ERROR
		IF	@retVal <> 0
		BEGIN
SET @MMErrCode = 21003
			SET @retStr = 'Failed to retrieve source copies.'
			GOTO CX_EXIT
		END
	END
	-- The source copy will be primary copy if source copy is not defined
	UPDATE	@tblCopy
	SET 	sourceCopyId = primaryCopyId
	WHERE	sourceCopyId = 0
	SET	@retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
SET @MMErrCode = 21003
		SET @retStr = 'Failed to retrieve source copies.'
		GOTO CX_EXIT
	END
	-- create a temp table for archGroup to hold the defaultsnapcopyId , archGroupCopyId
	UPDATE	@tblCopy
	SET matSrcCopyId = CASE WHEN t.isMirrorCopy = 1
									THEN t.sourceCopyId
								ELSE t.archCopyId
						END
	FROM @tblCopy t, archMaterializeSnapshotProp b WITH (NOLOCK)
	WHERE t.archGroupId = b.archGroupId
	AND (( b.sourceCopyId = 0 AND  t.archCopyId = t.primaryCopyId) OR (b.sourceCopyId > 0 AND t.archCopyId = b.sourceCopyId))
	AND t.isSnapCopy > 0
	UPDATE	@tblCopy
	SET defCatSrcCopyId = CASE WHEN t.isMirrorCopy = 1
									THEN t.sourceCopyId
								ELSE t.archCopyId
						END
	FROM @tblCopy t, ArchDeferredCatalogProp b WITH (NOLOCK)
	WHERE t.archGroupId = b.archGroupId
	AND (( b.sourceCopyId = 0 AND  t.archCopyId = t.primaryCopyId) OR (b.sourceCopyId > 0 AND t.archCopyId = b.sourceCopyId))
	AND t.isSnapCopy > 0
	-- Get archive files of SNAP to be pruned
	INSERT	INTO #ToBeAgedAFC
	SELECT	DISTINCT AFC.archFileId, AFC.commCellId, AFC.archCopyId
	FROM	archFileCopy AFC WITH (NOLOCK), SMVolume SS WITH (NOLOCK), @tblVolCopyInfo TMP
	WHERE	AFC.archFileId = SS.archFileId
	AND 	AFC.commCellId = SS.commCellId
	AND 	AFC.archCopyId = SS.copyId
	AND		SS.SMVolumeId = TMP.SMVolumeId
AND		AFC.flags & 256 = 256
	SELECT	@retVal = @@ERROR, @rowCnt = @@ROWCOUNT
	IF	@retVal <> 0
	BEGIN
SET @MMErrCode = 21003
		SET @retStr = 'Failed to retrieve archive files.'
		GOTO CX_EXIT
	END
	-- Get archive files of Mirror Snap Copy if the copy is source of Mirror Snap Copy
	INSERT	INTO #ToBeAgedAFC
	SELECT	DISTINCT T.archFileId, T.commCellId, C.archCopyId
	FROM	#ToBeAgedAFC T, @tblCopy C
	WHERE	C.sourceCopyId = T.archCopyId
	AND 	C.isSnapCopy > 0
	AND 	C.isMirrorCopy > 0
	SET	@retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
SET @MMErrCode = 21003
		SET @retStr = 'Failed to retrieve archive files on Mirror Copy.'
		GOTO CX_EXIT
	END
	DELETE	TMP
	FROM	#ToBeAgedAFC TMP
			LEFT OUTER JOIN archFileCopy AFC (NOLOCK) ON TMP.archFileId = AFC.archFileId
				AND TMP.archCopyId = AFC.archCopyId AND TMP.commCellId = AFC.commCellId
	WHERE	AFC.archFileId IS NULL
	-- Get jobs of SNAP to be pruned
	INSERT	INTO #ToBeAgedJobs
	SELECT	DISTINCT AF.jobId, AF.commCellId, T.archCopyId, AF.fileType, 1
	FROM	archFile AF with (NOLOCK), #ToBeAgedAFC T
	WHERE	T.archFileId = AF.id
	AND 	T.commCellId = AF.commCellId
	SET	@retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
SET @MMErrCode = 21003
		SET @retStr = 'Failed to retrieve jobs.'
		GOTO CX_EXIT
	END
--	IF @rowCnt > 0
	BEGIN
		EXEC @retCode = archFileDeleteViaTable 0, @magneticBytes OUTPUT
		SET	@retVal = @@ERROR
		IF	@retVal = 0	SET	@retVal = @retCode
		IF	@retVal <> 0
		BEGIN
SET @MMErrCode = 21003
			SET @retStr = 'Failed to prune archive files.'
			GOTO CX_EXIT
		END
	END
	-- If this is called for delete, then delete all the volumes that are still present in the CS DB.
	-- When the archFileCopy is not present, the SM* table entries are not deleted
IF EXISTS (SELECT 1 FROM @tblVolCopyInfo TMP INNER JOIN SMVolume VOL (NOLOCK) ON TMP.SMVolumeId = VOL.SMVolumeId WHERE VOL.MountStatus = 99)
	BEGIN
		IF object_id('tempdb.dbo.#ToBeDeletedVols') IS NOT null DROP TABLE #ToBeDeletedVols
		CREATE TABLE #ToBeDeletedVols (
				SMVolumeId integer,
				ArchFileId integer,
				CommCellId integer,
				CopyId integer,
				primary key (SMVolumeId, ArchFileId, CommCellId, CopyId)
		)
		INSERT INTO #ToBeDeletedVols
		SELECT DISTINCT VOL.SMVolumeId, VOL.ArchFileId, VOL.CommCellId, VOL.CopyId
		FROM	@tblVolCopyInfo TMP INNER JOIN SMVolume VOL (NOLOCK) ON VOL.SMVolumeId = TMP.SMVolumeId
		DELETE	TMP
		FROM	#ToBeDeletedVols TMP
				INNER JOIN SMVolume VOL (NOLOCK) ON VOL.ReserveField1 = TMP.SMVolumeId
				INNER JOIN archGroupCopy AGC (NOLOCK) ON AGC.id = VOL.CopyId
				AND AGC.isSnapCopy = 1 AND AGC.isMirrorCopy = 1
		DECLARE @resultTable TABLE(retCode INT)
		INSERT INTO @resultTable
		EXEC MM_SMDeleteVolSnaps 2, 0
		IF object_id('tempdb.dbo.#ToBeDeletedVols') IS NOT null DROP TABLE #ToBeDeletedVols
	END
	-- Mark Jobs as NOT PRUNABLE if there are NON-AGED valid archive files
	UPDATE	#ToBeAgedJobs
	SET isPrunable = 0
	FROM #ToBeAgedJobs T, archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
	WHERE	T.jobId = AF.jobId
	AND		T.commCellId = AF.commCellId
	AND 	AF.id = AFC.archFileId
	AND 	AF.commCellId = AFC.commCellId
	AND		T.archCopyId = AFC.archCopyId
	AND		T.fileType = AF.fileType
AND		AFC.flags & 256 = 0
	SET	@retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
SET @MMErrCode = 21003
		SET @retStr = 'Failed to mark jobs as non-prunable.'
		GOTO CX_EXIT
	END
	INSERT INTO @tblBCDIndexAF
	SELECT 	DISTINCT JDS.jobId, JDS.commCellId, JDS.dataType, JDS.archGrpCopyId, 0
	FROM 		JMJobDataStats JDS WITH (NOLOCK), #ToBeAgedJobs T
	WHERE		JDS.jobId = T.jobId
	AND			JDS.commCellId = T.commCellId
AND 		JDS.dataType IN (6)
	AND			JDS.archGrpCopyId = T.archCopyId
	AND			T.isPrunable = 1
AND			JDS.disabled & 256 = 256
	SELECT 	@retVal = @@ERROR
	IF		@retVal <> 0
	BEGIN
SET @MMErrCode = 21003
		SET @retStr = 'Failed to get BCD Index Archive Files.'
		GOTO CX_EXIT
	END
	INSERT INTO @tblJobsWithBCDIndex
SELECT 	DISTINCT JDS.jobId, JDS.commCellId, JDS.dataType, JDS.archGrpCopyId, JDS.disabled & 256
	FROM 		JMJobDataStats JDS WITH (NOLOCK), @tblBCDIndexAF TT
	WHERE		JDS.jobId = TT.jobId
	AND			JDS.commCellId = TT.commCellId
AND 		JDS.dataType IN (1, 4)
	AND			JDS.archGrpCopyId = TT.copyId
	SELECT 	@retVal = @@ERROR
	IF		@retVal <> 0
	BEGIN
SET @MMErrCode = 21003
		SET @retStr = 'Failed to get Jobs with BCD Index Archive Files.'
		GOTO CX_EXIT
	END
	UPDATE  @tblJobsWithBCDIndex
SET 		flags = 256
	FROM 		@tblJobsWithBCDIndex TT, #ToBeAgedJobs T
	WHERE		TT.jobId = T.jobId
	AND			TT.commCellId = T.commCellId
	AND 		TT.fileType = T.fileType
	AND			TT.copyId = T.archCopyId
	AND			T.isPrunable = 1
	SELECT 	@retVal = @@ERROR
	IF		@retVal <> 0
	BEGIN
SET @MMErrCode = 21003
		SET @retStr = 'Failed to set flags on Jobs with BCD Index Archive Files.'
		GOTO CX_EXIT
	END
	UPDATE  @tblBCDIndexAF
	SET 		flags = ISNULL(T.flags, 256)
FROM 		@tblBCDIndexAF TT LEFT OUTER JOIN (	SELECT jobId, commCellId, copyId, MIN(flags & 256) AS flags
																							FROM @tblJobsWithBCDIndex
																							GROUP BY jobId, commCellId, copyId) T
	ON			TT.jobId = T.jobId
	AND			TT.commCellId = T.commCellId
	AND			TT.copyId = T.copyId
	SELECT 	@retVal = @@ERROR
	IF		@retVal <> 0
	BEGIN
SET @MMErrCode = 21003
		SET @retStr = 'Failed to set flags on BCD Index Archive Files.'
		GOTO CX_EXIT
	END
	INSERT INTO #ToBeAgedJobs
	SELECT DISTINCT jobId, commCellId, copyId, fileType, 1
	FROM 	@tblBCDIndexAF T
WHERE T.flags & 256 = 256
	SELECT 	@retVal = @@ERROR
	IF		@retVal <> 0
	BEGIN
SET @MMErrCode = 21003
		SET @retStr = 'Failed to get prunable BCD Index Archive Files.'
		GOTO CX_EXIT
	END
	-- Clean the temp table
	DELETE #ToBeAgedAFC
	-- Get the rest of the archive files of prunable Jobs (Index AF)
	INSERT	INTO #ToBeAgedAFC
	SELECT	DISTINCT AFC.archFileId, AFC.commCellId, AFC.archCopyId
	FROM	#ToBeAgedJobs T, archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
	WHERE	T.jobId = AF.jobId
	AND		T.commCellId = AF.commCellId
	AND 	AF.id = AFC.archFileId
	AND 	AF.commCellId = AFC.commCellId
	AND		T.archCopyId = AFC.archCopyId
	AND		T.isPrunable = 1
AND		(((T.fileType = 1) AND (AF.fileType NOT IN (4, 6))) OR ((T.fileType <> 1) AND (T.fileType = AF.fileType)))
AND		AFC.flags & 256 = 256
	SELECT	@retVal = @@ERROR, @rowCnt = @@ROWCOUNT
	IF	@retVal <> 0
	BEGIN
SET @MMErrCode = 21003
		SET @retStr = 'Failed to retrieve archive files.'
		GOTO CX_EXIT
	END
--	IF @rowCnt > 0 -- this will all snaps not associated with archive files to be cleaned up
	BEGIN
		EXEC @retCode = archFileDeleteViaTable 0, @magneticBytes OUTPUT
		SET	@retVal = @@ERROR
		IF	@retVal = 0	SET	@retVal = @retCode
		IF	@retVal <> 0
		BEGIN
SET @MMErrCode = 21003
			SET @retStr = 'Failed to prune archive files.'
			GOTO CX_EXIT
		END
	END
	WHILE EXISTS (SELECT *	FROM #ToBeAgedJobs T1
							INNER JOIN @tblCopy COPY
								ON T1.archCopyId = COPY.sourceCopyId AND COPY.isMirrorCopy = 1 AND T1.isPrunable = 1
							LEFT OUTER JOIN #ToBeAgedJobs T2 ON T2.jobId = T1.jobId AND T2.commCellId = T1.commCellId AND T2.archCopyId = COPY.archCopyId AND T1.fileType = T2.fileType
							WHERE T2.jobId IS NULL)
	BEGIN
		INSERT	INTO #ToBeAgedJobs
		SELECT	DISTINCT T1.jobid, T1.commCellId, COPY.archCopyId, T1.fileType, 1
		FROM	#ToBeAgedJobs T1
				INNER JOIN @tblCopy COPY ON T1.archCopyId = COPY.sourceCopyId AND COPY.isMirrorCopy = 1 AND T1.isPrunable = 1
				LEFT OUTER JOIN #ToBeAgedJobs T2 ON T2.jobId = T1.jobId AND T2.commCellId = T1.commCellId AND T2.archCopyId = COPY.archCopyId AND T1.fileType = T2.fileType
							WHERE T2.jobId IS NULL
		SET	@retVal = @@ERROR
		IF	@retVal <> 0
		BEGIN
SET @MMErrCode = 21003
			SET @retStr = 'Failed to retrieve jobs on Mirror copy.'
			GOTO CX_EXIT
		END
	END
	UPDATE JMJobSnapDeferredCatalogStats
SET 	Disabled = JS.Disabled | 1, unPickReason = 11
	FROM	#ToBeAgedJobs T INNER JOIN JMJobSnapDeferredCatalogStats JS ON T.jobId = JS.jobId AND T.commCellId = JS.commCellId
	INNER JOIN @tblCopy SC ON SC.defCatSrcCopyId = T.archCopyId
	WHERE (JS.Disabled & 1) = 0	AND	JS.catalogStatus IN (101, 102, 103) AND T.isPrunable = 1
	SET	@retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
SET @MMErrCode = 21003
		SET @retStr = 'Failed to disable the job for Deferred Catalogue Operation.'
		GOTO CX_EXIT
	END
	UPDATE JMJobSnapshotStats WITH (PAGLOCK)
SET 	Disabled = JS.Disabled | 1, unPickReason = 11
	FROM	#ToBeAgedJobs T INNER JOIN JMJobSnapshotStats JS ON T.jobId = JS.jobId AND T.commCellId = JS.commCellId
	INNER JOIN @tblCopy SC ON SC.matSrcCopyId = T.archCopyId
	WHERE (JS.Disabled & 1) = 0	AND	JS.materializationStatus IN (101, 102, 103) AND T.isPrunable = 1
	SET	@retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
SET @MMErrCode = 21003
		SET @retStr = 'Failed to disable the job for Move To Media Operation.'
		GOTO CX_EXIT
	END
	-- Mark jobs as aged
	UPDATE	JMJobDataStats WITH (PAGLOCK)
SET		status = 1000, disabled = (JDS.disabled | 256), agedBy = (JDS.agedBy | 16777216),
			mediaDeletedTime = @agedUnixTime, modifiedTime = @agedUnixTime
	FROM	#ToBeAgedJobs T, JMJobDataStats JDS
	WHERE	JDS.jobId = T.jobId
	AND 	JDS.commCellId = T.commCellId
	AND		JDS.archGrpCopyId = T.archCopyId
AND		(((T.fileType = 1) AND (JDS.dataType NOT IN (4, 6))) OR ((T.fileType <> 1) AND (T.fileType = JDS.dataType)))
	AND		T.isPrunable = 1
	AND 	JDS.status <> 1000
	SET @retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
SET @MMErrCode = 21003
		SET @retStr = 'Failed to update JMJobDataStats.'
		GOTO CX_EXIT
	END
	ELSE
	BEGIN
		SET	@retVal = 0
		SET	@MMErrCode = 0
		SET @retStr = 'Snap volumes pruned successfully.'
	END
	UPDATE	JMJobDataStats WITH (PAGLOCK)
SET		disabled = (JDS.disabled | 16384)
	FROM	#ToBeAgedJobs T, JMJobDataStats JDS, APP_Application APP
	WHERE	JDS.jobId = T.jobId
	AND 	JDS.commCellId = T.commCellId
	AND		JDS.archGrpCopyId = T.archCopyId
	AND		APP.id = JDS.appId
	AND		T.fileType = JDS.dataType
	AND		T.isPrunable = 0
AND		APP.appTypeId = 13
	SET @retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
SET @MMErrCode = 21003
		SET @retStr = 'Failed to update JMJobDataStats.'
		GOTO CX_EXIT
	END
	ELSE
	BEGIN
		SET	@retVal = 0
		SET	@MMErrCode = 0
		SET @retStr = 'Snap volumes pruned successfully.'
	END
CX_EXIT:
	DROP TABLE #ToBeAgedAFC
	DROP TABLE #ToBeAgedJobs
	IF EXISTS (SELECT * FROM @tblRtn)
		SELECT @retVal, SMVolId, MMErrCode, retStr FROM @tblRtn
	ELSE
		SELECT @retVal, 0, @MMErrCode, @retStr
	RETURN @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'archDeleteSnapArchiveFiles')
	delete from GxQscripts where name = 'archDeleteSnapArchiveFiles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeleteSnapArchiveFiles')
	delete from GXDBVersions where aliasname = 'archDeleteSnapArchiveFiles'
GO

insert into GXDBVersions values(2, 'archDeleteSnapArchiveFiles',  '00010006005400030000', 'archDeleteSnapArchiveFiles', '00010006005400030000')
GO

