

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archDeleteSILOArchiveFiles.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archDeleteSILOArchiveFiles.sp,v $ $Id: archDeleteSILOArchiveFiles.sp,v 1.14.66.3 2018/11/03 03:12:24 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archDeleteSILOArchiveFiles')
BEGIN
	print '>>> Drop Stored Procedure: archDeleteSILOArchiveFiles <<<'
	drop procedure archDeleteSILOArchiveFiles
END
IF EXISTS (select * from GxQscripts where name='archDeleteSILOArchiveFiles')
	delete from GxQscripts where name = 'archDeleteSILOArchiveFiles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeleteSILOArchiveFiles')
	delete from GXDBVersions where aliasname = 'archDeleteSILOArchiveFiles'
GO
print '... Creating Procedure: archDeleteSILOArchiveFiles'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archDeleteSILOArchiveFiles
  @i_SIDBStoreId INTEGER,
  @i_commCellId INTEGER,
  @i_dummy INTEGER
AS
  DECLARE @retVal INTEGER;
  DECLARE @retStr NVARCHAR(1024);
	BEGIN TRANSACTION PRUNESILO
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE	@agedTime 			DATETIME
	SET 		@agedTime = GetUTCDate()
	DECLARE	@agedUnixTime 	INTEGER
	SET 		@agedUnixTime = dbo.GetUnixTime(@agedTime)
	DECLARE	@retCode				INTEGER
	DECLARE @magneticBytes	BIGINT
	DECLARE	@rowCnt INTEGER
	SET			@rowCnt	= 0
	DECLARE	@DaysToKeepDanglingSILOArchives INTEGER
	SET			@DaysToKeepDanglingSILOArchives = -1
	DECLARE	@timeToPruneDanglingSILOArchives INTEGER
	SET			@timeToPruneDanglingSILOArchives = -1
	CREATE TABLE #ToBeAgedAFC (
		archFileId INT,
		commCellId INT,
		archCopyId INT,
		PRIMARY KEY (archFileId, commCellId, archCopyId))
	CREATE TABLE #ToBeAgedDanglingAFC (
		archFileId INT,
		commCellId INT,
		archCopyId INT,
		JobId			 INT,
		appId			 INT,
		cTime			 INT,
		PRIMARY KEY (archFileId, commCellId, archCopyId))
	CREATE TABLE #ToBeAgedJobs (
		jobId 			INT,
		commCellId 	INT,
		archCopyId 	INT,
		fileType 		INT,
		isPrunable 	INT
		PRIMARY KEY (jobId, commCellId, archCopyId, fileType))
	CREATE	TABLE #PrunableSiloVolumeList (
			SIDBStoreId 			INT,
			volumeId 					INT,
			commCellId				INT,
			volumeFlags				INT,
			volumeAttributes	INT,
			SiloStatus				INT
			PRIMARY KEY (SIDBStoreId, VolumeId))
	-- DO NOT PRUNE ACTIVE SIDBStoreId (All SIDBStoreId that exists in archGroupCopy table are still active)
IF EXISTS (SELECT * FROM archCopySIDBStore CS WITH (READUNCOMMITTED) WHERE CS.SIDBStoreId = @i_SIDBStoreID AND ((CS.Flags & 4) > 0))
	BEGIN
		SET	@retVal = -1
		SET @retStr = 'SIDBStoreId [' + CONVERT(VARCHAR(12), @i_SIDBStoreId) + '] is active.'
		GOTO CX_EXIT
	END
	-- Get all volumes for SIDBStoreId
	INSERT INTO #PrunableSiloVolumeList
	SELECT DISTINCT V.SIDBStoreId, V.VolumeId, (CASE WHEN V.OrigCcCommCellId > 0 THEN V.OrigCcCommCellId ELSE 2 END), V.volumeFlags, V.Attributes, V.SiloStatus
	FROM MMVolume V WITH (NOLOCK)
	WHERE	V.SIDBStoreId = @i_SIDBStoreId
	AND		(CASE WHEN V.OrigCcCommCellId > 0 THEN V.OrigCcCommCellId ELSE 2 END) = @i_commCellId
	SELECT	@retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to retrieve prunable SILO Volume List.'
		GOTO CX_EXIT
	END
	-- DO NOT PRUNE SIDBStoreId with any Non-Recyclable volumes
	IF EXISTS (SELECT * FROM #PrunableSiloVolumeList PSVL WHERE PSVL.volumeFlags <> 6)
	BEGIN
		SET	@retVal = -2
		SET @retStr = 'SIDBStoreId [' + CONVERT(VARCHAR(12), @i_SIDBStoreId) + '] has some Non-Recyclable volumes.'
		GOTO CX_EXIT
	END
	-- DO NOT PRUNE SIDBStoreId with volumes still referenced in archChunk table
	IF EXISTS (SELECT PSVL.* FROM #PrunableSiloVolumeList PSVL, archChunk AC WITH (NOLOCK) WHERE PSVL.volumeId = AC.VolumeId)
	BEGIN
		SET	@retVal = -3
		SET @retStr = 'SIDBStoreId [' + CONVERT(VARCHAR(12), @i_SIDBStoreId) + '] has some volumes referenced in archChunk table.'
		GOTO CX_EXIT
	END
	-- DO NOT PRUNE SIDBStoreId with volumes that are not deleted off disk yet.
IF EXISTS (SELECT * FROM #PrunableSiloVolumeList PSVL WHERE (PSVL.volumeAttributes & 2) = 0)
	BEGIN
		SET	@retVal = -4
		SET @retStr = 'SIDBStoreId [' + CONVERT(VARCHAR(12), @i_SIDBStoreId) + '] has some volumes that are not deleted off disk.'
		GOTO CX_EXIT
	END
	-- DO NOT PRUNE SIDBStoreId if the SILO tape backup job is currently running for that store
	IF EXISTS (SELECT *
						 FROM #PrunableSiloVolumeList PSVL, archCopySIDBStore ACSS WITH (NOLOCK),
						 archGroupCopy AGC WITH (NOLOCK), JMJobInfo JI WITH (NOLOCK),
						 JMBkpJobInfo BJI WITH (NOLOCK), JMJobOptions JO WITH (NOLOCK)
						 WHERE 	PSVL.SIDBStoreId = ACSS.SIDBStoreId
						 AND		PSVL.commCellId = ACSS.CommCellId
						 AND		ACSS.CopyId = AGC.id
						 AND		AGC.siloAppId = BJI.applicationId
						 AND		BJI.jobId = JI.jobId
						 AND		BJI.commcellId = JI.commCellId
						 AND		JI.opType = 4
						 AND		JI.jobId = JO.jobId
						 AND		JI.commcellId = JO.commCellId
						 AND		JO.attributeId = 21
						 AND		JO.attributeValueInt = PSVL.SIDBStoreId)
	BEGIN
		SET	@retVal = -5
		SET @retStr = 'SIDBStoreId [' + CONVERT(VARCHAR(12), @i_SIDBStoreId) + '] has tape backup job currently running.'
		GOTO CX_EXIT
	END
	-- Prune dangling SILO archive files based on configurable days
	-- Set to -1 by default to disable and prune based on timestamp
	SELECT @DaysToKeepDanglingSILOArchives = isnull(value, -1)
	FROM MMConfigs
	WHERE name = 'DA_CONFIG_DAYS_TO_KEEP_DANGLING_SILO_ARCHIVE_FILES'
	SELECT	@retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to retrieve configuration values.'
		GOTO CX_EXIT
	END
	IF @DaysToKeepDanglingSILOArchives > -1 AND @DaysToKeepDanglingSILOArchives < 30
	BEGIN
		SET @DaysToKeepDanglingSILOArchives = 30
	END
	IF @DaysToKeepDanglingSILOArchives < -1
	BEGIN
		SET @DaysToKeepDanglingSILOArchives = -1
	END
	IF @DaysToKeepDanglingSILOArchives > -1
	BEGIN
		SET	@timeToPruneDanglingSILOArchives = dbo.getUnixTime(GETUTCDATE()) - @DaysToKeepDanglingSILOArchives * 24 * 3600
	END
	-- Get archive files of prunable SILO
	INSERT	INTO #ToBeAgedAFC
	SELECT	DISTINCT AFC.archFileId, AFC.commCellId, AFC.archCopyId
	FROM	archFileCopy AFC WITH (NOLOCK), archFileSiloVolume AFSV WITH (NOLOCK), #PrunableSiloVolumeList PSVL
	WHERE	AFC.archFileId = AFSV.archFileId
	AND 	AFC.commCellId = AFSV.commCellId
	AND 	AFSV.siloVolumeId = PSVL.volumeId
	AND		AFSV.commCellId = PSVL.commCellId
	SELECT	@retVal = @@ERROR, @rowCnt = @@ROWCOUNT
	IF	@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to retrieve archive files.'
		GOTO CX_EXIT
	END
	-- Get archive files of SILO jobs not in archFileSiloVolume
	INSERT INTO #ToBeAgedDanglingAFC
	SELECT DISTINCT AFC.archFileId, AFC.commCellId, AFC.archCopyId, AF.jobId, AF.appId, AF.cTime
	FROM archFileCopy AFC WITH (NOLOCK)
		INNER JOIN archFile AF WITH (NOLOCK)
			ON 	AFC.archFileId = AF.id
			AND AFC.commCellId = AF.commCellId
		LEFT OUTER JOIN archFileSiloVolume AFSV WITH (NOLOCK)
			ON AF.id = AFSV.archFileId
			AND AF.commCellId = AFSV.commCellId
	WHERE AFSV.archFileId IS NULL
	AND AF.appId IN (SELECT SiloAppId FROM archGroupCopy WITH (NOLOCK) WHERE SiloAppId > 0)
	AND AF.fileType = 1
	SELECT	@retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to retrieve dangling archive files.'
		GOTO CX_EXIT
	END
	-- Remove dangling archive files from running SILO Job
	DELETE	#ToBeAgedDanglingAFC
	FROM	#ToBeAgedDanglingAFC T, JMJobInfo J WITH (NOLOCK)
	WHERE	T.jobId = J.jobId
	AND		T.commCellId = J.commCellId
	SELECT	@retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to remove dangling archive files of running SILO job.'
		GOTO CX_EXIT
	END
	-- Remove dangling archive files if NOT prunable
	DELETE	#ToBeAgedDanglingAFC
	FROM	#ToBeAgedDanglingAFC T, (SELECT AGC.siloAppId AS siloAppId, MIN(SS.CreatedTime) AS oldestSIDBTime
																		FROM archGroupCopy AGC WITH (NOLOCK), archCopySIDBStore ACS WITH (NOLOCK), IdxSIDBStore SS WITH (NOLOCK)
																		WHERE AGC.id = ACS.CopyId
																		AND	  ACS.SIDBStoreId = SS.SIDBStoreId
																		AND	  ACS.CommCellId = SS.CommCellId
																		AND	  AGC.siloAppId > 0
																		GROUP BY AGC.siloAppId) TMP
	WHERE T.appId = TMP.siloAppId
	AND 	(
					(@DaysToKeepDanglingSILOArchives = -1 AND T.cTime >= TMP.oldestSIDBTime)
					OR
					(@DaysToKeepDanglingSILOArchives > -1 AND T.cTime >= @timeToPruneDanglingSILOArchives AND T.cTime >= TMP.oldestSIDBTime)
				)
	SELECT	@retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to remove dangling archive files that are not prunable.'
		GOTO CX_EXIT
	END
	INSERT	INTO #ToBeAgedAFC
	SELECT	DISTINCT T.archFileId, T.commCellId, T.archCopyId
	FROM	#ToBeAgedDanglingAFC T
	SELECT	@retVal = @@ERROR, @rowCnt = @rowCnt + @@ROWCOUNT
	IF	@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to append dangling archive files.'
		GOTO CX_EXIT
	END
	-- Get jobs of prunable SILO
	INSERT	INTO #ToBeAgedJobs
	SELECT	DISTINCT AF.jobId, AF.commCellId, T.archCopyId, AF.fileType, 1
	FROM	archFile AF with (NOLOCK), #ToBeAgedAFC T
	WHERE	T.archFileId = AF.id
	AND 	T.commCellId = AF.commCellId
	SET	@retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to retrieve jobs.'
		GOTO CX_EXIT
	END
	IF @rowCnt > 0
	BEGIN
		-- Mark archive files and chunks as aged so that they get logged in prunning log tables
		UPDATE	archFileCopy WITH (PAGLOCK)
SET		flags = (AFC.flags | 256), agedBy = (agedBy | 4194304), modifiedTime = @agedUnixTime
		FROM	#ToBeAgedAFC T, archFileCopy AFC
		WHERE	AFC.archFileId = T.archFileId
		AND 	AFC.commCellId = T.commCellId
		AND 	AFC.archCopyId = T.archCopyId
AND 	AFC.flags & 256 = 0
		SET	@retVal = @@ERROR
		IF	@retVal <> 0
		BEGIN
			SET @retStr = 'Failed to prune archive files.'
			GOTO CX_EXIT
		END
		UPDATE	archChunkMapping WITH (PAGLOCK)
SET		flags = (ACM.flags | 256), agedBy = (agedBy | 4194304), modifiedTime = @agedUnixTime
		FROM	#ToBeAgedAFC T, archChunkMapping ACM
		WHERE	ACM.archFileId = T.archFileId
		AND 	ACM.commCellId = T.commCellId
		AND 	ACM.archCopyId = T.archCopyId
AND 	ACM.flags & 256 = 0
		SET	@retVal = @@ERROR
		IF	@retVal <> 0
		BEGIN
			SET @retStr = 'Failed to prune chunks.'
			GOTO CX_EXIT
		END
		EXEC @retCode = archFileDeleteViaTable 0, @magneticBytes OUTPUT
		SET	@retVal = @@ERROR
		IF	@retVal = 0	SET	@retVal = @retCode
		IF	@retVal <> 0
		BEGIN
			SET @retStr = 'Failed to delete archive files.'
			GOTO CX_EXIT
		END
	END
	-- Mark Jobs as not prunable if there are archive files referenced in archFileSiloVolume
	UPDATE	#ToBeAgedJobs
	SET isPrunable = 0
	FROM #ToBeAgedJobs T, archFile AF WITH (NOLOCK), archFileSiloVolume AFSV WITH (NOLOCK)
	WHERE	T.jobId = AF.jobId
	AND		T.commCellId = AF.commCellId
	AND 	AF.id = AFSV.archFileId
	AND 	AF.commCellId = AFSV.commCellId
	SET	@retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to mark jobs as non-prunable.'
		GOTO CX_EXIT
	END
	-- Clean the temp table
	DELETE #ToBeAgedAFC
	-- Get the rest of the archive files of prunable Jobs (Index AF)
	INSERT	INTO #ToBeAgedAFC
	SELECT	DISTINCT AFC.archFileId, AFC.commCellId, AFC.archCopyId
	FROM	#ToBeAgedJobs T, archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
	WHERE	T.jobId = AF.jobId
	AND		T.commCellId = AF.commCellId
	AND		T.isPrunable = 1
	AND 	AF.id = AFC.archFileId
	AND 	AF.commCellId = AFC.commCellId
	SELECT	@retVal = @@ERROR, @rowCnt = @@ROWCOUNT
	IF	@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to retrieve archive files.'
		GOTO CX_EXIT
	END
	IF @rowCnt > 0
	BEGIN
		-- Mark archive files and chunks as aged so that they get logged in prunning log tables
		UPDATE	archFileCopy WITH (PAGLOCK)
SET		flags = (AFC.flags | 256), agedBy = (agedBy | 4194304), modifiedTime = @agedUnixTime
		FROM	#ToBeAgedAFC T, archFileCopy AFC
		WHERE	AFC.archFileId = T.archFileId
		AND 	AFC.commCellId = T.commCellId
		AND 	AFC.archCopyId = T.archCopyId
AND 	AFC.flags & 256 = 0
		SET	@retVal = @@ERROR
		IF	@retVal <> 0
		BEGIN
			SET @retStr = 'Failed to prune archive files.'
			GOTO CX_EXIT
		END
		UPDATE	archChunkMapping WITH (PAGLOCK)
SET		flags = (ACM.flags | 256), agedBy = (agedBy | 4194304), modifiedTime = @agedUnixTime
		FROM	#ToBeAgedAFC T, archChunkMapping ACM
		WHERE	ACM.archFileId = T.archFileId
		AND 	ACM.commCellId = T.commCellId
		AND 	ACM.archCopyId = T.archCopyId
AND 	ACM.flags & 256 = 0
		SET	@retVal = @@ERROR
		IF	@retVal <> 0
		BEGIN
			SET @retStr = 'Failed to prune chunks.'
			GOTO CX_EXIT
		END
		EXEC @retCode = archFileDeleteViaTable 0, @magneticBytes OUTPUT
		SET	@retVal = @@ERROR
		IF	@retVal = 0	SET	@retVal = @retCode
		IF	@retVal <> 0
		BEGIN
			SET @retStr = 'Failed to delete archive files.'
			GOTO CX_EXIT
		END
	END
	-- Mark jobs as aged on all copies and fileTypes
	UPDATE	JMJobDataStats WITH (PAGLOCK)
SET		status = 1000, disabled = (JDS.disabled | 256), agedBy = (agedBy | 4194304),
				agedTime = @agedUnixTime, mediaDeletedTime = @agedUnixTime, modifiedTime = @agedUnixTime
	FROM	#ToBeAgedJobs T, JMJobDataStats JDS
	WHERE	JDS.jobId = T.jobId
	AND 	JDS.commCellId = T.commCellId
	AND		T.isPrunable = 1
	AND 	JDS.status <> 1000
	SET @retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to update JMJobDataStats.'
		GOTO CX_EXIT
	END
	UPDATE	JMBkpStats WITH (PAGLOCK)
	SET		dataStatus = 2, agedTime = (CASE WHEN BKP.agedTime = 0 THEN @agedUnixTime ELSE BKP.agedTime END),
			mediaDeletedTime = @agedUnixTime, modifiedTime = @agedUnixTime
	FROM	JMBkpStats BKP, #ToBeAgedJobs T
	WHERE	BKP.jobId = T.jobId
	AND 	BKP.commCellId = T.commCellId
	AND		T.isPrunable = 1
	AND 	BKP.dataStatus <> 2
	SET @retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to update JMBkpStats.'
		GOTO CX_EXIT
	END
	-- Reset Volumes in Drive
	UPDATE 	MMDrive WITH (PAGLOCK)
	SET			VolumeId = 0, CurrentFileMarker = -1, FileMarkerCacheType = 0, LastUseTime = @agedUnixTime
	FROM	#PrunableSiloVolumeList PSVL, MMDrive D
	WHERE	PSVL.volumeId = D.volumeId
	SET @retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to reset Volumes in Drive.'
		GOTO CX_EXIT
	END
	-- Reset MediaGroupId
	UPDATE 	MMVolume WITH (PAGLOCK)
	SET			MediaGroupId = 0
	FROM	#PrunableSiloVolumeList PSVL, MMVolume V
	WHERE	PSVL.volumeId = V.volumeId
	SET @retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to reset MediaGroupId.'
		GOTO CX_EXIT
	END
	-- Delete the MMDeletedAF entries for these volumes
	DELETE MMDeletedAF WITH (PAGLOCK)
	FROM	#PrunableSiloVolumeList PSVL, MMDeletedAF DAF
	WHERE	PSVL.volumeId = DAF.volumeId
	SET @retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to delete MMDeletedAF entries for prunable volumes.'
		GOTO CX_EXIT
	END
	-- Delete the volumes
	DELETE MMVolume WITH (PAGLOCK)
	FROM	#PrunableSiloVolumeList PSVL, MMVolume V
	WHERE	PSVL.volumeId = V.volumeId
	SET @retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to delete volumes.'
		GOTO CX_EXIT
	END
	-- Mark the SILO aged.
	UPDATE IdxSIDBStore WITH (PAGLOCK)
SET flags = (flags | 256)
	WHERE SIDBStoreId = @i_SIDBStoreId
	AND	CommCellId = @i_commCellId
	SET @retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to set Aged flag for SIDBStoreId [' + CONVERT(VARCHAR(12), @i_SIDBStoreId) + ']'
		GOTO CX_EXIT
	END
	ELSE
	BEGIN
		SET	@retVal = 0
		SET @retStr = 'SIDBStoreId [' + CONVERT(VARCHAR(12), @i_SIDBStoreId) + '] pruned successfully.'
	END
CX_EXIT:
	DROP TABLE #ToBeAgedAFC
	DROP TABLE #ToBeAgedDanglingAFC
	DROP TABLE #ToBeAgedJobs
	DROP TABLE #PrunableSiloVolumeList
	IF @retVal = 0
		COMMIT TRANSACTION PRUNESILO
	ELSE
		ROLLBACK TRANSACTION PRUNESILO
	SELECT @retVal, @retStr
	RETURN @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'archDeleteSILOArchiveFiles')
	delete from GxQscripts where name = 'archDeleteSILOArchiveFiles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeleteSILOArchiveFiles')
	delete from GXDBVersions where aliasname = 'archDeleteSILOArchiveFiles'
GO

insert into GXDBVersions values(2, 'archDeleteSILOArchiveFiles',  '00010014006600030000', 'archDeleteSILOArchiveFiles', '00010014006600030000')
GO

