

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archDeleteOracleCCArchiveFiles.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archDeleteOracleCCArchiveFiles.sp,v $ $Id: archDeleteOracleCCArchiveFiles.sp,v 1.10.66.3 2019/12/21 21:47:53 hkapadia Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archDeleteOracleCCArchiveFiles')
BEGIN
	print '>>> Drop Stored Procedure: archDeleteOracleCCArchiveFiles <<<'
	drop procedure archDeleteOracleCCArchiveFiles
END
IF EXISTS (select * from GxQscripts where name='archDeleteOracleCCArchiveFiles')
	delete from GxQscripts where name = 'archDeleteOracleCCArchiveFiles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeleteOracleCCArchiveFiles')
	delete from GXDBVersions where aliasname = 'archDeleteOracleCCArchiveFiles'
GO
print '... Creating Procedure: archDeleteOracleCCArchiveFiles'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archDeleteOracleCCArchiveFiles
  @i_archFileId INTEGER,
  @i_commCellId INTEGER,
  @i_dummy INTEGER
AS
  DECLARE @retVal INTEGER;
  DECLARE @retStr VARCHAR(1024);
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	BEGIN TRAN ORACLECCTRAN
	DECLARE	@agedTime 			DATETIME
	SET 		@agedTime = GetUTCDate()
	DECLARE	@agedUnixTime 	INTEGER
	SET 		@agedUnixTime = dbo.GetUnixTime(@agedTime)
	DECLARE	@retCode				INTEGER
	DECLARE @magneticBytes	BIGINT
	DECLARE	@rowCnt INTEGER
	SET			@rowCnt	= 0
	DECLARE @tblBCDIndexAF TABLE(
			jobId int, commCellId int, fileType int, copyId int, flags int
			primary key (jobId, commCellId, fileType, copyId) )
	DECLARE @tblJobsWithBCDIndex TABLE(
			jobId int, commCellId int, fileType int, copyId int, flags int
			primary key (jobId, commCellId, fileType, copyId) )
	DECLARE @tblMatSrcCopy TABLE ( archGroupId INT, sourceCopyId INT)
	DECLARE @tblArchFileCopy TABLE(
			archFileId int, commCellId int, fileType int, copyId int, jobId int
			primary key (archFileId, commCellId, copyId) )
	CREATE TABLE #ToBeAgedAFC (
		archFileId INT,
		commCellId INT,
		archCopyId INT,
		PRIMARY KEY (archFileId, commCellId, archCopyId))
	CREATE TABLE #ToBeAgedJobs (
		jobId 			INT,
		commCellId 	INT,
		archCopyId 	INT,
		fileType 		INT,
		isPrunable 	INT
		PRIMARY KEY (jobId, commCellId, archCopyId, fileType))
	INSERT INTO @tblMatSrcCopy
	SELECT a.id, (CASE b.sourceCopyId WHEN 0 THEN a.defaultSnapCopy ELSE b.sourceCopyId END)
	FROM	archGroup a WITH (NOLOCK), archMaterializeSnapshotProp b WITH (NOLOCK), archGroupCopy c WITH (NOLOCK)
	WHERE	a.id = b.archGroupId
	AND		a.id = c.archGroupId
	AND		c.id = (CASE b.sourceCopyId WHEN 0 THEN a.defaultSnapCopy ELSE b.sourceCopyId END)
	AND		c.isSnapCopy > 0
	SET	@retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to retrieve materialization source copies.'
		GOTO CX_EXIT
	END
	-- Get archive files to be pruned
	-- DO NOT PRUNE archive files on WORM copy
	INSERT	INTO #ToBeAgedAFC
	SELECT	AFC.archFileId, AFC.commCellId, AFC.archCopyId
	FROM	archFileCopy AFC WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
	WHERE	AFC.archFileId = @i_archFileId
	AND 	AFC.commCellId = @i_commCellId
	AND		AFC.archCopyId = AGC.id
AND		(AGC.flags & 16777216) = 0
	SELECT	@retVal = @@ERROR, @rowCnt = @@ROWCOUNT
	IF	@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to retrieve archive files.'
		GOTO CX_EXIT
	END
	-- Get job of archive file to be pruned
	INSERT	INTO #ToBeAgedJobs
	SELECT	DISTINCT AF.jobId, AF.commCellId, T.archCopyId, AF.fileType, 1
	FROM	archFile AF with (NOLOCK), #ToBeAgedAFC T
	WHERE	T.archFileId = AF.id
	AND 	T.commCellId = AF.commCellId
	SET	@retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to retrieve jobs.'
		GOTO CX_EXIT
	END
	-- If Snap job is not moved to media, then disable move to media operation for FORCE PRUNE else return error
	IF EXISTS ( SELECT T.*
							FROM #ToBeAgedJobs T, JMJobSnapshotStats JS WITH (NOLOCK), @tblMatSrcCopy SC
							WHERE T.jobId = JS.jobId
							AND		T.commCellId = JS.commCellId
							AND		T.archCopyId = SC.sourceCopyId
							AND  	(JS.Disabled & 1) = 0
							AND 	JS.materializationStatus in (101, 102, 103)
	)
	BEGIN
		UPDATE JMJobSnapshotStats WITH (PAGLOCK)
		SET 	Disabled = JS.Disabled | 1
		FROM JMJobSnapshotStats JS, #ToBeAgedJobs T
		WHERE T.jobId = JS.jobId
		AND		T.commCellId = JS.commCellId
		AND  	(JS.Disabled & 1) = 0
		AND 	JS.materializationStatus in (101, 102, 103)
		SET	@retVal = @@ERROR
		IF	@retVal <> 0
		BEGIN
			SET @retStr = 'Failed to disable the job for Move To Media Operation.'
			GOTO CX_EXIT
		END
	END
	IF @rowCnt > 0
	BEGIN
/*
		-- Mark archive files and chunks as aged so that they get logged in prunning log tables
		UPDATE	archFileCopy WITH (PAGLOCK)
SET		flags = (AFC.flags | 256), agedBy = (AFC.agedBy | 8388608), modifiedTime = @agedUnixTime
		FROM	#ToBeAgedAFC T, archFileCopy AFC
		WHERE	AFC.archFileId = T.archFileId
		AND 	AFC.commCellId = T.commCellId
		AND 	AFC.archCopyId = T.archCopyId
AND 	AFC.flags & 256 = 0
		SET	@retVal = @@ERROR
		IF	@retVal <> 0
		BEGIN
			SET @retStr = 'Failed to prune archive files.'
			GOTO CX_EXIT
		END
		UPDATE	archChunkMapping WITH (PAGLOCK)
SET		flags = (ACM.flags | 256), agedBy = (ACM.agedBy | 8388608), modifiedTime = @agedUnixTime
		FROM	#ToBeAgedAFC T, archChunkMapping ACM
		WHERE	ACM.archFileId = T.archFileId
		AND 	ACM.commCellId = T.commCellId
		AND 	ACM.archCopyId = T.archCopyId
AND 	ACM.flags & 256 = 0
		SET	@retVal = @@ERROR
		IF	@retVal <> 0
		BEGIN
			SET @retStr = 'Failed to prune chunks.'
			GOTO CX_EXIT
		END
*/
		--Age the archive files first
EXEC @retCode = archFileSetAgedViaTable 8388608, @agedUnixTime
		SET	@retVal = @@ERROR
		IF	@retVal = 0	SET	@retVal = @retCode
		IF	@retVal <> 0
		BEGIN
			SET @retStr = 'Failed to age the archive files.'
			GOTO CX_EXIT
		END
		EXEC @retCode = archFileDeleteViaTable 0, @magneticBytes OUTPUT
		SET	@retVal = @@ERROR
		IF	@retVal = 0	SET	@retVal = @retCode
		IF	@retVal <> 0
		BEGIN
			SET @retStr = 'Failed to delete archive files.'
			GOTO CX_EXIT
		END
	END
	-- Mark Jobs as NOT PRUNABLE if there are NON-AGED valid archive files
	UPDATE	#ToBeAgedJobs
	SET isPrunable = 0
	FROM #ToBeAgedJobs T, archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
	WHERE	T.jobId = AF.jobId
	AND		T.commCellId = AF.commCellId
	AND 	AF.id = AFC.archFileId
	AND 	AF.commCellId = AFC.commCellId
	--AND		AFC.isValid = 1			-- DO NOT check isValid flag on archFileCopy table due to aux copy creating archive files with isValid = 0
	AND		AF.isValid = 1
	AND		T.archCopyId = AFC.archCopyId
	AND		T.fileType = AF.fileType
AND		AFC.flags & 256 = 0
	SET	@retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to mark jobs as non-prunable.'
		GOTO CX_EXIT
	END
	INSERT INTO @tblBCDIndexAF
	SELECT 	DISTINCT JDS.jobId, JDS.commCellId, JDS.dataType, JDS.archGrpCopyId, 0
	FROM 		JMJobDataStats JDS WITH (NOLOCK), #ToBeAgedJobs T
	WHERE		JDS.jobId = T.jobId
	AND			JDS.commCellId = T.commCellId
AND 		JDS.dataType IN (6)
	AND			JDS.archGrpCopyId = T.archCopyId
	AND			T.isPrunable = 1
	UNION
	SELECT 	DISTINCT JDS.jobId, JDS.commCellId, JDS.dataType, JDS.archGrpCopyId, 0
	FROM 		JMJobDataStats JDS WITH (NOLOCK), #ToBeAgedJobs T, archFile AF WITH (NOLOCK)
	WHERE		JDS.jobId = T.jobId
	AND			JDS.commCellId = T.commCellId
	AND			JDS.archGrpCopyId = T.archCopyId
	AND			JDS.jobId = AF.jobId
	AND			JDS.commCellId = AF.commCellId
	AND			JDS.dataType = AF.fileType
AND 		AF.fileType IN (2)
AND			(AF.flags & (4 | 4096)) > 0
	AND			T.isPrunable = 1
	SELECT 	@retVal = @@ERROR
	IF		@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to get BCD Index Archive Files.'
		GOTO CX_EXIT
	END
	INSERT INTO @tblJobsWithBCDIndex
SELECT 	DISTINCT JDS.jobId, JDS.commCellId, JDS.dataType, JDS.archGrpCopyId, JDS.disabled & 256
	FROM 		JMJobDataStats JDS WITH (NOLOCK), @tblBCDIndexAF TT
	WHERE		JDS.jobId = TT.jobId
	AND			JDS.commCellId = TT.commCellId
AND 		JDS.dataType IN (1, 4)
	AND			JDS.archGrpCopyId = TT.copyId
	SELECT 	@retVal = @@ERROR
	IF		@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to get Jobs with BCD Index Archive Files.'
		GOTO CX_EXIT
	END
	UPDATE  @tblJobsWithBCDIndex
SET 		flags = 256
	FROM 		@tblJobsWithBCDIndex TT, #ToBeAgedJobs T
	WHERE		TT.jobId = T.jobId
	AND			TT.commCellId = T.commCellId
	AND 		TT.fileType = T.fileType
	AND			TT.copyId = T.archCopyId
	AND			T.isPrunable = 1
	SELECT 	@retVal = @@ERROR
	IF		@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to set flags on Jobs with BCD Index Archive Files.'
		GOTO CX_EXIT
	END
	UPDATE  @tblBCDIndexAF
	SET 		flags = ISNULL(T.flags, 256)
FROM 		@tblBCDIndexAF TT LEFT OUTER JOIN (	SELECT jobId, commCellId, copyId, MIN(flags & 256) AS flags
																							FROM @tblJobsWithBCDIndex
																							GROUP BY jobId, commCellId, copyId) T
	ON			TT.jobId = T.jobId
	AND			TT.commCellId = T.commCellId
	AND			TT.copyId = T.copyId
	SELECT 	@retVal = @@ERROR
	IF		@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to set flags on BCD Index Archive Files.'
		GOTO CX_EXIT
	END
	-- Clean the temp table
	DELETE #ToBeAgedAFC
	-- Get the rest of the archive files of prunable Jobs (Index AF)
	INSERT	INTO @tblArchFileCopy
	SELECT	DISTINCT AFC.archFileId, AFC.commCellId, AF.fileType, AFC.archCopyId, AF.jobId
	FROM	#ToBeAgedJobs T, archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
	WHERE	T.jobId = AF.jobId
	AND		T.commCellId = AF.commCellId
	AND 	AF.id = AFC.archFileId
	AND 	AF.commCellId = AFC.commCellId
	AND		T.archCopyId = AFC.archCopyId
	AND		T.isPrunable = 1
AND		(((T.fileType = 1) AND (AF.fileType NOT IN (4, 6))) OR ((T.fileType <> 1) AND (T.fileType = AF.fileType)))
	SELECT	@retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to retrieve archive files.'
		GOTO CX_EXIT
	END
	-- DO NOT Prune Regular Index Archive File created after Snap movement to media, if either Data or Log is NOT Aged
	DELETE @tblArchFileCopy
	FROM @tblArchFileCopy TT, @tblBCDIndexAF BCD
	WHERE TT.jobId = BCD.jobId
	AND TT.commCellId = BCD.commCellId
	AND TT.fileType = BCD.fileType
	AND TT.copyId = BCD.copyId
	SELECT 	@retVal = @@ERROR
	IF		@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to remove unprunable BCD Index Archive Files.'
		GOTO CX_EXIT
	END
	-- Get prunable BCD/Regular Index Archive File created after Snap movement to media
	INSERT	INTO @tblArchFileCopy
	SELECT	DISTINCT AFC.archFileId, AFC.commCellId, AF.fileType, AFC.archCopyId, AF.jobId
	FROM	archFile AF WITH (NOLOCK), @tblBCDIndexAF BCD, archFileCopy AFC WITH (NOLOCK)
	WHERE	AF.jobId = BCD.jobId
	AND		AF.commCellId = BCD.commCellId
	AND		AF.fileType = BCD.fileType
	AND 	AF.id = AFC.archFileId
	AND 	AF.commCellId = AFC.commCellId
	AND		BCD.copyId = AFC.archCopyId
	AND		(BCD.flags & 256) = 256
	SELECT 	@retVal = @@ERROR
	IF		@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to get prunable BCD Index Archive Files.'
		GOTO CX_EXIT
	END
	INSERT INTO #ToBeAgedAFC
	SELECT DISTINCT T.archFileId, T.commCellId, T.copyId
	FROM 	@tblArchFileCopy T
	SELECT	@retVal = @@ERROR, @rowCnt = @@ROWCOUNT
	IF	@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to retrieve archive files.'
		GOTO CX_EXIT
	END
	IF @rowCnt > 0
	BEGIN
/*
		-- Mark archive files and chunks as aged so that they get logged in prunning log tables
		UPDATE	archFileCopy WITH (PAGLOCK)
SET		flags = (AFC.flags | 256), agedBy = (AFC.agedBy | 8388608), modifiedTime = @agedUnixTime
		FROM	#ToBeAgedAFC T, archFileCopy AFC
		WHERE	AFC.archFileId = T.archFileId
		AND 	AFC.commCellId = T.commCellId
		AND 	AFC.archCopyId = T.archCopyId
AND 	AFC.flags & 256 = 0
		SET	@retVal = @@ERROR
		IF	@retVal <> 0
		BEGIN
			SET @retStr = 'Failed to prune archive files.'
			GOTO CX_EXIT
		END
		UPDATE	archChunkMapping WITH (PAGLOCK)
SET		flags = (ACM.flags | 256), agedBy = (ACM.agedBy | 8388608), modifiedTime = @agedUnixTime
		FROM	#ToBeAgedAFC T, archChunkMapping ACM
		WHERE	ACM.archFileId = T.archFileId
		AND 	ACM.commCellId = T.commCellId
		AND 	ACM.archCopyId = T.archCopyId
AND 	ACM.flags & 256 = 0
		SET	@retVal = @@ERROR
		IF	@retVal <> 0
		BEGIN
			SET @retStr = 'Failed to prune chunks.'
			GOTO CX_EXIT
		END
*/
		--Age the archive files first
EXEC @retCode = archFileSetAgedViaTable 8388608, @agedUnixTime
		SET	@retVal = @@ERROR
		IF	@retVal = 0	SET	@retVal = @retCode
		IF	@retVal <> 0
		BEGIN
			SET @retStr = 'Failed to age the archive files.'
			GOTO CX_EXIT
		END
		EXEC @retCode = archFileDeleteViaTable 0, @magneticBytes OUTPUT
		SET	@retVal = @@ERROR
		IF	@retVal = 0	SET	@retVal = @retCode
		IF	@retVal <> 0
		BEGIN
			SET @retStr = 'Failed to prune archive files.'
			GOTO CX_EXIT
		END
	END
	-- Update prunable status
	UPDATE #ToBeAgedJobs
	SET isPrunable = 1
	FROM #ToBeAgedJobs TT, @tblArchFileCopy T
	WHERE T.jobid = TT.jobId
	AND		T.commCellId = TT.commCellId
	AND		T.copyId = TT.archCopyId
	AND		T.fileType = TT.fileType
	SET	@retVal = @@ERROR
	IF	@retVal = 0	SET	@retVal = @retCode
	IF	@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to populate prunable archive files.'
		GOTO CX_EXIT
	END
	-- Get all the fileType to be updated in JM table
	INSERT INTO #ToBeAgedJobs
	SELECT T.jobId, T.commCellId, T.copyId, T.fileType, 1
	FROM @tblArchFileCopy T
	WHERE NOT EXISTS (SELECT * FROM #ToBeAgedJobs TT WITH (NOLOCK)
						WHERE T.jobid = TT.jobId
						AND		T.commCellId = TT.commCellId
						AND		T.copyId = TT.archCopyId
						AND		T.fileType = TT.fileType)
	SET	@retVal = @@ERROR
	IF	@retVal = 0	SET	@retVal = @retCode
	IF	@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to populate prunable archive files.'
		GOTO CX_EXIT
	END
	-- Mark jobs as aged
	UPDATE	JMJobDataStats WITH (PAGLOCK)
SET		status = 1000, disabled = (JDS.disabled | 256), agedBy = (JDS.agedBy | 8388608),
			agedTime = @agedUnixTime, mediaDeletedTime = @agedUnixTime, modifiedTime = @agedUnixTime
	FROM	#ToBeAgedJobs T, JMJobDataStats JDS
	WHERE	JDS.jobId = T.jobId
	AND 	JDS.commCellId = T.commCellId
	AND		JDS.archGrpCopyId = T.archCopyId
	AND		JDS.dataType = T.fileType
	AND		T.isPrunable = 1
	AND 	JDS.status <> 1000
	SET @retVal = @@ERROR
	IF	@retVal <> 0
	BEGIN
		SET @retStr = 'Failed to update JMJobDataStats.'
		GOTO CX_EXIT
	END
	ELSE
	BEGIN
		SET	@retVal = 0
		SET @retStr = 'ArchFileId[' + CONVERT(VARCHAR(12), @i_archFileId) + '], CommCellId[' + CONVERT(VARCHAR(12), @i_commCellId) + '] pruned successfully.'
	END
CX_EXIT:
	DROP TABLE #ToBeAgedAFC
	DROP TABLE #ToBeAgedJobs
	IF @retVal <> 0
		ROLLBACK TRAN ORACLECCTRAN
	ELSE
		COMMIT TRAN ORACLECCTRAN
	SELECT @retVal, @retStr
	RETURN @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'archDeleteOracleCCArchiveFiles')
	delete from GxQscripts where name = 'archDeleteOracleCCArchiveFiles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeleteOracleCCArchiveFiles')
	delete from GXDBVersions where aliasname = 'archDeleteOracleCCArchiveFiles'
GO

insert into GXDBVersions values(2, 'archDeleteOracleCCArchiveFiles',  '00010010006600030000', 'archDeleteOracleCCArchiveFiles', '00010010006600030000')
GO

