

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archDeleteOldestJobOnAppCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   04/26/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archDeleteOldestJobOnAppCopy.sp,v $ $Id: archDeleteOldestJobOnAppCopy.sp,v 1.1.2.4 2018/03/22 01:18:43 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archDeleteOldestJobOnAppCopy <<<'

IF EXISTS (select * from sysobjects where name='archDeleteOldestJobOnAppCopy')
	drop procedure archDeleteOldestJobOnAppCopy
IF EXISTS (select * from GxQscripts where name='archDeleteOldestJobOnAppCopy')
	delete from GxQscripts where name = 'archDeleteOldestJobOnAppCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeleteOldestJobOnAppCopy')
	delete from GXDBVersions where aliasname = 'archDeleteOldestJobOnAppCopy'
GO
print '... Creating Procedure: archDeleteOldestJobOnAppCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archDeleteOldestJobOnAppCopy
  @i_appId integer,
  @i_copyId integer,
  @i_dataType integer,
  @i_flags integer,
  @i_dummy integer
AS
  DECLARE @o_retVal INTEGER;
  DECLARE @o_errorString VARCHAR(1024);
  DECLARE @o_skippedCode INTEGER;
  DECLARE @o_prunedJobIdList VARCHAR(MAX);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- @i_flags = 0		Skip jobs that are manually retained or extended retained or pending backup copy or pending aux copy
-- @i_flags = 1 	Include jobs that are manually retained
-- @i_flags = 2 	Include jobs that are extended retained
-- @i_flags = 4 	Include jobs that are pending backup copy
-- @i_flags = 8 	Include jobs that are pending aux copy
DECLARE @rowCount INTEGER
SET			@rowCount = 0
DECLARE @userId   INTEGER
SET 		@userId 	= 1
SET 		@o_retVal 					= 0
SET 		@o_errorString 			= ''
SET 		@o_skippedCode 			= 0
SET 		@o_prunedJobIdList	= ''
DECLARE @considerInactiveCopy 	INTEGER
SET 		@considerInactiveCopy 	= 1
DECLARE @l_archGrpId	INTEGER
SET			@l_archGrpId	= 0
DECLARE @l_copyId	INTEGER
SET			@l_copyId	= 0
DECLARE	@jobsToPruneXML XML
DECLARE	@tblCopySource TABLE(
	CopyId 					int,
	sourceCopyId 		int,
	isActive 				int,
	primaryCopy 		int,
	isMirrorCopy		int,
	Primary Key (CopyId)
	)
DECLARE @tblMatSrcCopy TABLE (
	archGroupId INT,
	sourceCopyId INT
)
if object_id('tempdb.dbo.#tmpRetVal') is not null DROP TABLE #tmpRetVal
CREATE TABLE #tmpRetVal(
	retVal					INTEGER,
	errorString			VARCHAR(1024),
	skippedCode			INTEGER,
	prunedJobIdList	VARCHAR(MAX)
)
if object_id('tempdb.dbo.#tmpJobsToProcess') is not null DROP TABLE #tmpJobsToProcess
CREATE  TABLE #tmpJobsToProcess (
     jobId						INTEGER,
     commCellId				INTEGER,
     dataType					INTEGER,
     archGroupId			INTEGER,
     archCopyId				INTEGER,
     jobStartDate			INTEGER,
     auxCopystatus		INTEGER,
     manualRet				INTEGER,
     extendedRet			INTEGER,
     auxCopydisabled	INTEGER,
     isAuxCopyPending INTEGER,
     isBkpCopyPending INTEGER,
     )
CREATE INDEX Idx_tmpJobsToProcess_1 ON #tmpJobsToProcess (jobId, archCopyId, dataType, commcellId)
CREATE INDEX Idx_tmpJobsToProcess_2 ON #tmpJobsToProcess (jobStartDate)
if object_id('tempdb.dbo.#tmpJobsToPrune') is not null DROP TABLE #tmpJobsToPrune
CREATE  TABLE #tmpJobsToPrune (
     jobId						INTEGER,
     commCellId				INTEGER,
     dataType					INTEGER,
     archGroupId			INTEGER,
     archCopyId				INTEGER
)
-- Get Storage Policy Id
SELECT @l_archGrpId = archGroupId FROM archGroupCopy WITH (NOLOCK) WHERE id = @i_copyId
SET @o_retVal = @@ERROR
IF (@o_retVal != 0) GOTO ERROR_EXIT
-- Get source copy information
INSERT	INTO @tblCopySource
SELECT	AGC.id, AGC.sourceCopyId, AGC.isActive, CASE AGC.isSnapCopy WHEN 0 THEN AG.defaultCopy ELSE AG.defaultSnapCopy END, AGC.isMirrorCopy
FROM	archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
WHERE	AGC.archGroupId = AG.id
AND		AG.id = @l_archGrpId
SET @o_retVal = @@ERROR
IF (@o_retVal != 0) GOTO ERROR_EXIT
-- The source copy will be source of Mirror copy if source copy is Mirror Copy
WHILE EXISTS(SELECT T.sourceCopyId FROM @tblCopySource T, archGroupCopy AGC WITH (NOLOCK) WHERE	T.sourceCopyId = AGC.id AND AGC.isSnapCopy > 0 AND AGC.isMirrorCopy > 0)
BEGIN
	UPDATE	@tblCopySource
	SET 	sourceCopyId = AGC.sourceCopyId
	FROM	@tblCopySource T, archGroupCopy AGC WITH (NOLOCK)
	WHERE	T.sourceCopyId = AGC.id
	AND		AGC.isSnapCopy > 0
	AND		AGC.isMirrorCopy > 0
	SET @o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO ERROR_EXIT
END
-- The source copy will be primary copy if no source copy defined
UPDATE	@tblCopySource
SET 	sourceCopyId = primaryCopy
WHERE	sourceCopyId = 0
SET @o_retVal = @@ERROR
IF (@o_retVal != 0) GOTO ERROR_EXIT
SET @l_copyId = @i_copyId
SET @o_retVal = @@ERROR
IF (@o_retVal != 0) GOTO ERROR_EXIT
-- Get source copy if input copy is mirror
SELECT @l_copyId = sourceCopyId FROM @tblCopySource WHERE copyId = @i_copyId AND isMirrorCopy > 0
SET @o_retVal = @@ERROR
IF (@o_retVal != 0) GOTO ERROR_EXIT
--Get list of jobs to process
INSERT INTO #tmpJobsToProcess
SELECT JDS.jobId, JDS.commCellId, @i_dataType, JDS.archGrpId, JDS.archGrpCopyId,
			 JBKP.servStartDate, MAX(JDS.status),
MAX(JDS.disabled & 2), MAX(JDS.retentionFlags),
MAX(JDS.disabled & 1), 0, 0
FROM JMJobDataStats JDS WITH (NOLOCK), JMBkpStats JBKP WITH (NOLOCK)
WHERE JDS.appId = @i_appId
AND		JDS.archGrpCopyId = @l_copyId
AND		JDS.jobId = JBKP.jobId
AND		JDS.commcellId = JBKP.commcellId
AND 	JDS.status != 1000
AND 	JDS.disabled & 256 = 0
AND		((@i_dataType = 0) OR (@i_dataType = 1 AND JDS.dataType != 4) OR (@i_dataType = 4 AND JDS.dataType = 4))
GROUP	BY JDS.jobId, JDS.commCellId, JDS.archGrpId, JDS.archGrpCopyId, JBKP.servStartDate
SET @o_retVal = @@ERROR
IF (@o_retVal != 0) GOTO ERROR_EXIT
--Check for pending backup copy
IF (@i_flags & 4) = 0
BEGIN
	INSERT INTO @tblMatSrcCopy
	SELECT AG.id, (CASE P.sourceCopyId WHEN 0 THEN AG.defaultSnapCopy ELSE P.sourceCopyId END)
	FROM	archGroup AG WITH (NOLOCK), archMaterializeSnapshotProp P WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
	WHERE	AG.id = @l_archGrpId
	AND		AG.id = P.archGroupId
	AND		AG.id = AGC.archGroupId
	AND		AGC.id = (CASE P.sourceCopyId WHEN 0 THEN AG.defaultSnapCopy ELSE P.sourceCopyId END)
	AND		AGC.isSnapCopy > 0
	SET @o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO ERROR_EXIT
	-- Set Materialization Source Copy as source of Mirror copy, if materialization Source Copy is Mirror Copy
	WHILE EXISTS(SELECT T.sourceCopyId FROM @tblMatSrcCopy T, archGroupCopy AGC WITH (NOLOCK) WHERE	T.sourceCopyId = AGC.id AND AGC.isSnapCopy > 0 AND AGC.isMirrorCopy > 0)
	BEGIN
		UPDATE @tblMatSrcCopy
		SET sourceCopyId = (CASE AGC.sourceCopyId WHEN 0 THEN AG.defaultSnapCopy ELSE AGC.sourceCopyId END)
		FROM	@tblMatSrcCopy T, archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
		WHERE	T.sourceCopyId = AGC.id
		AND		T.archGroupId = AGC.archGroupId
		AND		AGC.archGroupId = AG.id
		AND		AGC.isSnapCopy > 0
		AND		AGC.isMirrorCopy > 0
		SET @o_retVal = @@ERROR
		IF (@o_retVal != 0) GOTO ERROR_EXIT
	END
	UPDATE	#tmpJobsToProcess
	SET 	isBkpCopyPending = 1
	FROM	#tmpJobsToProcess TMP, @tblMatSrcCopy S, JMJobSnapShotStats JS WITH (NOLOCK)
	WHERE	TMP.jobId = JS.jobId
	AND 	TMP.commCellId = JS.commCellId
	AND 	TMP.archCopyId = S.sourceCopyId
AND 	(JS.disabled & 1) = 0
	AND 	JS.materializationStatus in (101, 102, 103)
AND		(JS.flags & 1) = 0
	SET @o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO ERROR_EXIT
END
--Check for pending aux copy
IF (@i_flags & 8) = 0
BEGIN
	-- Get the configurable value DA_CONFIG_CONSIDER_INACTIVE_COPY_FOR_AUX_COPY_CHECK
	SELECT @considerInactiveCopy = isnull(value, 0)
	FROM mmconfigs WITH (NOLOCK)
	WHERE name = 'DA_CONFIG_CONSIDER_INACTIVE_COPY_FOR_AUX_COPY_CHECK'
	SET @o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO ERROR_EXIT
	-- Check whether to consider the inactive copy for Aux Copy check or not
	IF @considerInactiveCopy = 0
	BEGIN
		-- Do not consider inactive copy for Aux Copy Check
		DELETE	FROM @tblCopySource
		WHERE		copyId = sourceCopyId
		OR 			isActive = 0
		SET @o_retVal = @@ERROR
		IF (@o_retVal != 0) GOTO ERROR_EXIT
	END
	--Get jobs on other copies to check for pending aux copy
	INSERT INTO #tmpJobsToProcess
	SELECT TMP.jobId, TMP.commCellId, TMP.dataType, TMP.archGroupId, JDS.archGrpCopyId,
				 TMP.jobStartDate, MAX(JDS.status),
MAX(JDS.disabled & 2), MAX(JDS.retentionFlags),
MAX(JDS.disabled & 1), 0, 0
	FROM #tmpJobsToProcess TMP, JMJobDataStats JDS WITH (NOLOCK)
	WHERE TMP.jobId = JDS.jobId
	AND		TMP.commCellId = JDS.commCellId
	AND		TMP.archGroupId = JDS.archGrpId
	AND		JDS.archGrpCopyId != @l_copyId
	GROUP	BY TMP.jobId, TMP.commCellId, TMP.dataType, TMP.archGroupId, JDS.archGrpCopyId, TMP.jobStartDate
	SET @o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO ERROR_EXIT
	UPDATE	TMP
	SET 	isAuxCopyPending = 1
	FROM	#tmpJobsToProcess TMP, @tblCopySource S, #tmpJobsToProcess T
	WHERE	TMP.jobId = T.jobId
	AND 	TMP.commCellId = T.commCellId
	AND 	TMP.archCopyId = S.sourceCopyId
	AND 	S.copyId = T.archCopyId
	AND 	TMP.auxCopydisabled = 0
	AND 	T.auxCopydisabled = 0
	AND 	T.auxCopystatus in (101, 102, 103)
	SET @o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO ERROR_EXIT
	UPDATE	TMP
	SET 	isAuxCopyPending = 1
	FROM	#tmpJobsToProcess TMP, @tblCopySource S, #tmpJobsToProcess T
	WHERE	TMP.jobId = T.jobId
	AND 	TMP.commCellId = T.commCellId
	AND 	TMP.archCopyId = S.copyId
	AND 	S.sourceCopyId = T.archCopyId
	AND 	TMP.auxCopydisabled = 0
	AND 	T.auxCopydisabled = 0
	AND 	TMP.auxCopystatus in (101, 102, 103)
	SET @o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO ERROR_EXIT
END
INSERT INTO #tmpJobsToPrune
SELECT TOP 1 JobId AS JobId, CommCellId AS commCellId, dataType AS fileType, archGroupId AS archGrpId, archCopyId AS archGrpCopyId
FROM #tmpJobsToProcess AS JobInfo
WHERE archCopyId = @l_copyId
AND		auxCopystatus != 101
AND	 (
				(((@i_flags & 1) > 0) OR ((@i_flags & 1) = 0 AND (manualRet = 0)))
				AND
				(((@i_flags & 2) > 0) OR ((@i_flags & 2) = 0 AND (extendedRet = 0)))
				AND
				(((@i_flags & 4) > 0) OR ((@i_flags & 4) = 0 AND (isBkpCopyPending = 0)))
				AND
				(((@i_flags & 8) > 0) OR ((@i_flags & 8) = 0 AND (isAuxCopyPending = 0)))
		 )
ORDER BY jobStartDate
SELECT @o_retVal = @@ERROR, @rowCount = @@ROWCOUNT
IF (@o_retVal != 0) GOTO ERROR_EXIT
IF (@rowCount > 0)
BEGIN
	SELECT TOP 1 @userId = id FROM UMUsers WITH (NOLOCK) WHERE name = 'Administrator'
	SET @o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO ERROR_EXIT
	SET @jobsToPruneXML = CAST(('<GalaxyOperations_PruneJobs>' +
	                              CAST ((SELECT JobId AS JobId, CommCellId AS commCellId, dataType AS fileType, archGroupId AS archGrpId, archCopyId AS archGrpCopyId, (1 + 128) AS ignoreCheckFlags
	                                     FROM #tmpJobsToPrune AS JobInfo
	                                     FOR XML AUTO) AS NVARCHAR(MAX)) +
	                            '</GalaxyOperations_PruneJobs>') AS XML)
	SET @o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO ERROR_EXIT
	EXEC deleteMultipleBackupByJobCopy @userId, @jobsToPruneXML
	SET @o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO ERROR_EXIT
	SELECT TOP 1 @o_retVal = retVal, @o_errorString = errorString, @o_skippedCode = skippedCode, @o_prunedJobIdList = prunedJobIdList
	FROM #tmpRetVal
	IF (@o_retVal != 0) GOTO ERROR_EXIT
END
ELSE
BEGIN
	SET @o_retVal = 0
	SET @o_errorString = 'No jobs to delete'
	SET	@o_skippedCode = 0
	SET @o_prunedJobIdList = ''
END
ERROR_EXIT:
	if object_id('tempdb.dbo.#tmpJobsToProcess') is not null DROP TABLE #tmpJobsToProcess
	if object_id('tempdb.dbo.#tmpJobsToPrune') is not null DROP TABLE #tmpJobsToPrune
	if object_id('tempdb.dbo.#tmpRetVal') is not null DROP TABLE #tmpRetVal
	IF (@o_retVal != 0)
	BEGIN
		IF (LEN(@o_errorString) = 0)
		BEGIN
			SET @o_errorString = 'Failed to get job(s) to delete'
			SET	@o_skippedCode = 0
			SET @o_prunedJobIdList = ''
		END
	END
	IF object_id('tempdb.dbo.#tmparchDeleteOldestJobOnAppCopyResult') is not null
	BEGIN
		INSERT INTO #tmparchDeleteOldestJobOnAppCopyResult
		SELECT @o_retVal, @o_errorString, @o_skippedCode, @o_prunedJobIdList
	END
	ELSE
	BEGIN
		SELECT @o_retVal, @o_errorString, @o_skippedCode, @o_prunedJobIdList
	END
	RETURN @o_retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'archDeleteOldestJobOnAppCopy')
	delete from GxQscripts where name = 'archDeleteOldestJobOnAppCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeleteOldestJobOnAppCopy')
	delete from GXDBVersions where aliasname = 'archDeleteOldestJobOnAppCopy'
GO

insert into GXDBVersions values(2, 'archDeleteOldestJobOnAppCopy',  '00010001000200040000', 'archDeleteOldestJobOnAppCopy', '00010001000200040000')
GO

