

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archDeleteInvalidChunks.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archDeleteInvalidChunks.sp,v $ $Id: archDeleteInvalidChunks.sp,v 1.27.50.8 2018/09/26 17:13:19 hkapadia Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archDeleteInvalidChunks <<<'

IF EXISTS (select * from sysobjects where name='archDeleteInvalidChunks')
	drop procedure archDeleteInvalidChunks
IF EXISTS (select * from GxQscripts where name='archDeleteInvalidChunks')
	delete from GxQscripts where name = 'archDeleteInvalidChunks'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeleteInvalidChunks')
	delete from GXDBVersions where aliasname = 'archDeleteInvalidChunks'
GO
print '... Creating Procedure: archDeleteInvalidChunks'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archDeleteInvalidChunks
  @i_volumeId integer,
  @i_storeId integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @errorCode integer;
SET NOCOUNT ON
IF object_id('tempdb.dbo.#tempChunk') IS NOT NULL DROP TABLE #tempChunk
IF object_id('tempdb.dbo.#tempAFChunk') IS NOT NULL DROP TABLE #tempAFChunk
CREATE TABLE #tempChunk	(id bigint, commCellId int, volumeId int, RecordingFormatId int, MediaSideId int, SIDBStoreId int, cclip varchar(255))
CREATE TABLE #tempAFChunk (archChunkId bigint, acCommcellId int, archFileId int, afCommcellId int, archCopyId int, chunkNumber int, SIDBStoreId int)
--
-- Check if DA is enabled before proceeding
--
declare @l_isDAEnabled integer
IF NOT (@i_volumeId = 0 AND @i_storeId > 0) -- Vol = 0 and Store > 0 is called by recon stored proc so skip DA enabled check
BEGIN
    set @l_isDAEnabled = dbo.isDataAgingActivityEnabled (2)
    if (@l_isDAEnabled = 0)
    begin
set @errorCode = -1000
	GOTO FINISH
    end
END
DECLARE @daysToKeepInvalidChunks integer
SET			@daysToKeepInvalidChunks = 3
DECLARE @daysToKeepDanglingChunks integer
SET			@daysToKeepDanglingChunks = 30
DECLARE @hoursToCleanupDanglingChunks integer
SET			@hoursToCleanupDanglingChunks = 168
DECLARE @LastDanglingChunksCleanupTime integer
SET			@LastDanglingChunksCleanupTime = 0
DECLARE @EnableVolumeBasedDanglingChunksCleanup integer
SET			@EnableVolumeBasedDanglingChunksCleanup = 0
SELECT	@daysToKeepInvalidChunks = value
FROM	MMConfigs WITH (NOLOCK)
WHERE	name = 'DA_CONFIG_DAYS_TO_KEEP_INVALID_CHUNKS'
SELECT	@errorCode = @@ERROR
IF @errorCode <> 0 GOTO FINISH
SELECT	@daysToKeepDanglingChunks = value
FROM	MMConfigs WITH (NOLOCK)
WHERE	name = 'DA_CONFIG_DAYS_TO_KEEP_DANGLING_CHUNKS'
SELECT	@errorCode = @@ERROR
IF @errorCode <> 0 GOTO FINISH
SELECT	@hoursToCleanupDanglingChunks = value
FROM	MMConfigs WITH (NOLOCK)
WHERE	name = 'DA_CONFIG_INTERVAL_IN_HOURS_TO_PROCESS_DANGLING_CHUNKS'
SELECT	@errorCode = @@ERROR
IF @errorCode <> 0 GOTO FINISH
SELECT	@EnableVolumeBasedDanglingChunksCleanup = value
FROM	MMConfigs WITH (NOLOCK)
WHERE	name = 'DA_CONFIG_ENABLE_VOLUME_BASED_DANGLING_CHUNK_CLEANUP'
SELECT	@errorCode = @@ERROR
IF @errorCode <> 0 GOTO FINISH
SELECT	@LastDanglingChunksCleanupTime = value
FROM	MMConfigs WITH (NOLOCK)
WHERE	name = 'DA_CONFIG_LAST_TIMESTAMP_TO_PROCESS_DANGLING_CHUNKS'
SELECT	@errorCode = @@ERROR
IF @errorCode <> 0 GOTO FINISH
IF @daysToKeepDanglingChunks < 7
	SET @daysToKeepDanglingChunks = 7
IF @hoursToCleanupDanglingChunks <= 0
	SET @hoursToCleanupDanglingChunks = -1
IF @hoursToCleanupDanglingChunks > 0 AND @hoursToCleanupDanglingChunks < 6
	SET @hoursToCleanupDanglingChunks = 6
IF @LastDanglingChunksCleanupTime < 0
	SET @LastDanglingChunksCleanupTime = 0
DECLARE @now integer
SET			@now = dbo.GetUnixTime(GetUTCDate())
DECLARE @olderThan integer
SET			@olderThan = @now - @daysToKeepInvalidChunks*24*60*60
DECLARE @pruneTimeDanglingChunks integer
SET			@pruneTimeDanglingChunks = @now - @daysToKeepDanglingChunks*24*60*60
DECLARE @rowNumber INT
IF	@i_storeId > 0
BEGIN
	INSERT	INTO #tempChunk
	SELECT	C.id, C.commCellId, C.volumeId, V.RecordingFormatId, V.MediaSideId, V.SIDBStoreId, C.cclip
	FROM	archChunk C WITH (NOLOCK) INNER JOIN MMVolume V WITH (NOLOCK) ON C.volumeId = V.VolumeId
			LEFT OUTER JOIN MMResource R WITH (NOLOCK) ON R.volumeId = V.VolumeId
	WHERE	V.SIDBStoreId = @i_storeId
			AND C.physicalSize = 0
			AND C.logicalSize = 0
			AND R.VolumeId IS NULL
	INSERT	INTO #tempChunk
	SELECT	AC.id, AC.commCellId, AC.volumeId, V.RecordingFormatId, V.MediaSideId, V.SIDBStoreId, AC.cclip
	FROM	archChunk AC WITH (NOLOCK) INNER JOIN MMVolume V WITH (NOLOCK) ON AC.volumeId = V.VolumeId
			LEFT OUTER JOIN MMResource R WITH (NOLOCK) ON R.volumeId = V.VolumeId
			LEFT OUTER JOIN archChunkMapping ACM WITH (NOLOCK) ON AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId
	WHERE	AC.volumeId = @i_volumeid
			AND	AC.physicalSize > 0
			AND AC.logicalSize > 0
			AND R.VolumeId IS NULL
			AND ACM.archChunkId IS NULL
END
ELSE
IF	@i_volumeId <= 0
	-- Only delete invalid magnetic chunks here. Invalid non-magnetic chunks will be deleted when volumes become recyclable.
	INSERT	INTO #tempChunk
	SELECT	C.id, C.commCellId, C.volumeId, V.RecordingFormatId, V.MediaSideId, V.SIDBStoreId, C.cclip
	FROM	archChunk C WITH (NOLOCK)
		INNER JOIN MMVolume V WITH (NOLOCK)
		ON	C.volumeId = V.VolumeId
			AND V.RecordingFormatId = 10001	-- Volume is magnetic
		LEFT OUTER JOIN MMResource R WITH (NOLOCK)
		ON	R.volumeId = V.VolumeId
	WHERE	C.physicalSize = 0 AND C.logicalSize = 0 AND C.createTime < @olderThan
		AND R.VolumeId IS NULL
ELSE
IF	@i_volumeId NOT IN (SELECT volumeId FROM MMResource WITH (NOLOCK))
	INSERT INTO #tempChunk
	SELECT	C.id, C.commCellId, C.volumeId, V.RecordingFormatId, V.MediaSideId, V.SIDBStoreId, C.cclip
	FROM	archChunk C WITH (NOLOCK)
		INNER JOIN MMVolume V WITH (NOLOCK)
		ON	C.volumeId = V.VolumeId
	WHERE	C.volumeId = @i_volumeId
		AND C.physicalSize = 0 AND C.logicalSize = 0 AND C.createTime < @olderThan
SELECT	@errorCode = @@ERROR, @rowNumber = @@ROWCOUNT
IF @errorCode <> 0 GOTO FINISH
--Delete all dangling chunks that are older than @pruneTimeDanglingChunks for specific volume
IF (@i_VolumeId > 0 AND @EnableVolumeBasedDanglingChunksCleanup > 0)
BEGIN
	INSERT INTO #tempChunk
	SELECT	AC.id, AC.commCellId, AC.volumeId, V.RecordingFormatId, V.MediaSideId, V.SIDBStoreId, AC.cclip
	FROM archChunk AC INNER JOIN MMVolume V WITH (NOLOCK)
	ON AC.volumeId = V.VolumeId
	LEFT OUTER JOIN MMResource R WITH (NOLOCK)
	ON	R.volumeId = V.VolumeId
	LEFT OUTER JOIN archChunkMapping ACM WITH (NOLOCK)
	ON AC.id = ACM.archChunkId
	AND AC.commCellId = ACM.chunkCommCellId
	WHERE AC.volumeId = @i_volumeid
	AND	AC.physicalSize > 0
	AND AC.logicalSize > 0
	AND AC.createTime < @pruneTimeDanglingChunks
	AND R.VolumeId IS NULL
	AND ACM.archChunkId IS NULL
	SELECT	@errorCode = @@ERROR, @rowNumber = @rowNumber + @@ROWCOUNT
	IF @errorCode <> 0 OR @rowNumber = 0 GOTO FINISH
END
--Delete only if not executed in last @hoursToCleanupDanglingChunks hours
IF (@hoursToCleanupDanglingChunks > 0 AND @i_VolumeId = 0 AND @i_storeId = 0)
BEGIN
	IF ((@now - @LastDanglingChunksCleanupTime) > (@hoursToCleanupDanglingChunks * 3600))
	BEGIN
		UPDATE	MMConfigs
		SET value = @now
		WHERE	name = 'DA_CONFIG_LAST_TIMESTAMP_TO_PROCESS_DANGLING_CHUNKS'
		SELECT	@errorCode = @@ERROR
		IF @errorCode <> 0 GOTO FINISH
		INSERT INTO #tempChunk
		SELECT	AC.id, AC.commCellId, AC.volumeId, V.RecordingFormatId, V.MediaSideId, V.SIDBStoreId, AC.cclip
		FROM archChunk AC INNER JOIN MMVolume V WITH (NOLOCK)
		ON AC.volumeId = V.VolumeId
		LEFT OUTER JOIN MMResource R WITH (NOLOCK)
		ON	R.volumeId = V.VolumeId
		LEFT OUTER JOIN archChunkMapping ACM WITH (NOLOCK)
		ON AC.id = ACM.archChunkId
		AND AC.commCellId = ACM.chunkCommCellId
		WHERE AC.physicalSize > 0
		AND AC.logicalSize > 0
		AND AC.createTime < @pruneTimeDanglingChunks
		AND R.VolumeId IS NULL
		AND ACM.archChunkId IS NULL
		SELECT	@errorCode = @@ERROR, @rowNumber = @rowNumber + @@ROWCOUNT
		IF @errorCode <> 0 OR @rowNumber = 0 GOTO FINISH
	END
END
--DO NOT delete chunks that are numbered chunks since they are auto-committed chunks and may have valid data
DELETE #tempChunk
FROM #tempChunk T, archChunkMapping ACM WITH (NOLOCK)
WHERE T.id = ACM.archChunkId
AND	  T.commCellId = ACM.chunkCommCellId
AND 	ACM.chunkNumber > 0
SELECT	@errorCode = @@ERROR
IF @errorCode <> 0 GOTO FINISH
IF EXISTS (SELECT id FROM #tempChunk WHERE SIDBStoreId > 0)
BEGIN
	INSERT	INTO #tempAFChunk
	SELECT	b.archChunkId, b.chunkCommcellId, b.archFileId, b.commCellId, b.archCopyId, b.chunkNumber, a.SIDBStoreId
	FROM	#tempChunk a, archChunkMapping b WITH (NOLOCK)
	WHERE	a.id = b.archChunkId AND a.commCellId = b.chunkCommCellId
	SELECT	@errorCode = @@ERROR
	IF @errorCode <> 0 GOTO FINISH
	INSERT  INTO archFileSubStore (archFileId, commCellId, SIDBStoreId, SIDBSubStoreId, primaryObjects, secondaryObjects, flags)
	SELECT	DISTINCT TAC.archFileId, TAC.afCommCellId, TAC.SIDBStoreId, 0, 0, 0, 0
	FROM	#tempAFChunk TAC LEFT OUTER JOIN archFileSubStore
									ON	archFileSubStore.archFileId = TAC.archFileId
										AND archFileSubStore.commCellId = TAC.afCommCellId
										AND archFileSubStore.SIDBStoreId = TAC.SIDBStoreId
	WHERE	archFileSubStore.archFileId IS NULL
	SELECT	@errorCode = @@ERROR
	IF @errorCode <> 0 GOTO FINISH
	-- Mark the CVA_AFSS_INVALID_CHUNKS_EXISTED flag on archFileSubStore table
	UPDATE	archFileSubStore
	SET		flags = archFileSubStore.flags | 1   --CVA_AFSS_INVALID_CHUNKS_EXISTED
	FROM	#tempAFChunk TAC
	WHERE	archFileSubStore.archFileId = TAC.archFileId
			AND archFileSubStore.commCellId = TAC.afCommCellId
			AND archFileSubStore.SIDBStoreId = TAC.SIDBStoreId
	SELECT	@errorCode = @@ERROR
	IF @errorCode <> 0 GOTO FINISH
	-- Filter out archive files that have valid chunks.
	DELETE	#tempAFChunk
	FROM	#tempAFChunk a, archChunkMapping b WITH (NOLOCK)
	WHERE	a.archFileId = b.archFileId AND a.afCommcellId = b.commCellId AND a.archCopyId = b.archCopyId AND b.chunkNumber > 0
	SELECT	@errorCode = @@ERROR
	IF @errorCode <> 0 GOTO FINISH
	DELETE	#tempAFChunk
	FROM	#tempAFChunk T, archFile AF, JMJobInfo J
	WHERE	T.afCommcellId = AF.commCellId AND T.archFileId = AF.id
		AND AF.commCellId = J.commCellId AND AF.jobId = J.jobId
	SELECT	@errorCode = @@ERROR
	IF @errorCode <> 0 GOTO FINISH
	-- Delete the chunks if they are currently being copied
	DELETE	#tempAFChunk
	FROM	#tempAFChunk T, archChunkToCopy AF WITH (NOLOCK)
	WHERE	T.afCommcellId = AF.commCellId AND T.archFileId = AF.archFileId AND T.archCopyId = AF.destCopyId
	SELECT	@errorCode = @@ERROR
	IF @errorCode <> 0 GOTO FINISH
	-- Delete the chunks if they are currently sent for copying
	DELETE	#tempAFChunk
	FROM	#tempAFChunk T, archChunkToCopyHistory AF WITH (NOLOCK), JMJobInfo J WITH (NOLOCK)
	WHERE	T.afCommcellId = AF.commCellId AND T.archFileId = AF.archFileId AND T.archCopyId = AF.destCopyId
			AND AF.adminJobId = J.jobID
	SELECT	@errorCode = @@ERROR
	IF @errorCode <> 0 GOTO FINISH
	-- Delete the chunks if they are currently sent for copying
	DELETE	#tempAFChunk
	FROM	#tempAFChunk T, ArchChunkToReplicate AF WITH (NOLOCK), JMJobInfo J WITH (NOLOCK)
	WHERE	T.afCommcellId = AF.commCellId AND T.archFileId = AF.archFileId AND T.archCopyId = AF.destCopyId
			AND AF.adminJobId = J.jobID
	SELECT	@errorCode = @@ERROR
	IF @errorCode <> 0 GOTO FINISH
	--Set AgedBy column before deleting so that AgedBy value will get into ArchFileCopyPruningLogs
	UPDATE 	archFileCopy
SET flags = (flags | 256), agedBy = (agedBy | cast(2147483648 as bigint))
	FROM	#tempAFChunk a, archFileCopy b WITH (NOLOCK)
	WHERE	a.archFileId = b.archFileId
	AND a.afCommCellId = b.commCellId
	AND a.archCopyId = b.archCopyId
	AND b.isValid = 0
	SELECT	@errorCode = @@ERROR
	IF @errorCode <> 0 GOTO FINISH
	--ArchChunkMapping will be deleted on cascade if ArchFileCopy id deleted
	--So Set AgedBy column before deleting so that AgedBy value will get into ArchChunkMappingPruningLogs
	UPDATE 	archChunkMapping
SET flags = (c.flags | 256), agedBy = (c.agedBy | cast(2147483648 as bigint))
	FROM	#tempAFChunk a, archFileCopy b WITH (NOLOCK), archChunkMapping c
	WHERE	a.archFileId = b.archFileId
	AND a.afCommCellId = b.commCellId
	AND a.archCopyId = b.archCopyId
	AND c.archFileId = b.archFileId
	AND c.commCellId = b.commCellId
	AND c.archCopyId = b.archCopyId
	AND b.isValid = 0
	SELECT	@errorCode = @@ERROR
	IF @errorCode <> 0 GOTO FINISH
	-- Delete the archive files which have no valid chunk then delete the invalid chunks on cascade
	DELETE	archFileCopy
	FROM	#tempAFChunk a, archFileCopy b WITH (NOLOCK)
	WHERE	a.archFileId = b.archFileId
	AND a.afCommcellId = b.commCellId
	AND a.archCopyId = b.archCopyId
  AND b.isValid = 0
	SELECT	@errorCode = @@ERROR
	IF @errorCode <> 0 GOTO FINISH
END
INSERT	INTO MMDeletedAF
SELECT	ISNULL(ACM.archFileId, case when C.SIDBStoreId = 0 then 0 else 0x7FFFFFFF end),
		C.volumeId, 0, 0, ISNULL(ACM.archCopyId, 0), C.cclip, 0, C.id, MP.MountPathId, C.SIDBStoreId, ISNULL(afCommcellId, 0), @now, 0, 0, 0, 0, 0, C.commCellId
FROM	#tempChunk C
		INNER JOIN MMMountPath MP WITH (NOLOCK) ON C.MediaSideId = MP.MediaSideId
		LEFT OUTER JOIN #tempAFChunk ACM WITH (NOLOCK) ON ACM.archChunkId = C.id AND ACM.acCommcellId = C.commCellId
WHERE	C.RecordingFormatId = 10001
SELECT	@errorCode = @@ERROR
IF @errorCode <> 0 GOTO FINISH
--Set AgedBy column before deleting so that AgedBy value will get into ArchChunkMappingPruningLogs
UPDATE 	archChunkMapping
SET flags = (flags | 256), agedBy = (agedBy | cast(2147483648 as bigint))
FROM	archChunkMapping a, #tempChunk b
WHERE	a.archChunkId = b.id
AND a.chunkCommCellId = b.commCellId
AND a.physicalSize = 0
AND a.logicalSize = 0
SELECT	@errorCode = @@ERROR
IF @errorCode <> 0 GOTO FINISH
DELETE	archChunkMapping
FROM	archChunkMapping a, #tempChunk b
WHERE	a.archChunkId = b.id
AND a.chunkCommCellId = b.commCellId
AND a.physicalSize = 0
AND a.logicalSize = 0
SELECT	@errorCode = @@ERROR
IF @errorCode <> 0 GOTO FINISH
--Set AgedBy column before deleting so that AgedBy value will get into ArchChunkPruningLogs
UPDATE 	archChunk
SET flags = (flags | 256), agedBy = (agedBy | cast(2147483648 as bigint))
FROM	archChunk a, #tempChunk b
WHERE	a.id = b.id
AND a.commCellId = b.commCellId
SELECT	@errorCode = @@ERROR
IF @errorCode <> 0 GOTO FINISH
DELETE	archChunk WITH(PAGLOCK)
FROM	archChunk a, #tempChunk b
WHERE	a.id = b.id
AND a.commCellId = b.commCellId
SELECT	@errorCode = @@ERROR
FINISH:
IF OBJECT_ID('tempdb..#retValTemp') IS NOT NULL
BEGIN
	INSERT INTO #retValTemp
	SELECT @errorCode
END
ELSE
SELECT	@errorCode
IF object_id('tempdb.dbo.#tempChunk') IS NOT NULL DROP TABLE #tempChunk
IF object_id('tempdb.dbo.#tempAFChunk') IS NOT NULL DROP TABLE #tempAFChunk
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'archDeleteInvalidChunks')
	delete from GxQscripts where name = 'archDeleteInvalidChunks'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeleteInvalidChunks')
	delete from GXDBVersions where aliasname = 'archDeleteInvalidChunks'
GO

insert into GXDBVersions values(2, 'archDeleteInvalidChunks',  '00010027005000080000', 'archDeleteInvalidChunks', '00010027005000080000')
GO

