

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archDeleteIndexingAFOnDeletingBackupSet.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- Proc should be called when deleting a backupset in order to delete the indexing archFiles which belong to that backupset.
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archDeleteIndexingAFOnDeletingBackupSet <<<'

IF EXISTS (select * from sysobjects where name='archDeleteIndexingAFOnDeletingBackupSet')
	drop procedure archDeleteIndexingAFOnDeletingBackupSet
IF EXISTS (select * from GxQscripts where name='archDeleteIndexingAFOnDeletingBackupSet')
	delete from GxQscripts where name = 'archDeleteIndexingAFOnDeletingBackupSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeleteIndexingAFOnDeletingBackupSet')
	delete from GXDBVersions where aliasname = 'archDeleteIndexingAFOnDeletingBackupSet'
GO
print '... Creating Procedure: archDeleteIndexingAFOnDeletingBackupSet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archDeleteIndexingAFOnDeletingBackupSet
  @i_backupSetGUID NVARCHAR(2048),
  @i_dummy INTEGER
AS
  DECLARE @retVal INTEGER = 0;
  DECLARE @retStr VARCHAR(1024) = '';
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	IF OBJECT_ID('tempdb.dbo.#IndexingAFToPrune') IS NOT NULL DROP TABLE #IndexingAFToPrune
	IF OBJECT_ID('tempdb.dbo.#IndexingAppId') IS NOT NULL DROP TABLE #IndexingAppId
	CREATE TABLE #IndexingAFToPrune(
		archFileId 		INTEGER,
		commCellId 		INTEGER,
		JobId					INTEGER,
		fileType			INTEGER
		Primary Key (archFileId, commCellId)
	)
	CREATE TABLE #IndexingAppId(
		appId 		INTEGER
		Primary Key (appId)
	)
	DECLARE		@archiveFileXML		XML
	--Gel all Indexing subclients
	INSERT INTO #IndexingAppId
	SELECT DISTINCT componentNameId
	FROM App_SubclientProp WITH (NOLOCK)
	WHERE	attrName = N'Index SubClient'
	AND		attrVal = '1'
	AND		modified = 0
	SET	@retVal = @@ERROR
	IF	@retVal != 0
	BEGIN
		SET @retStr = 'Failed to retrieve indexing subclients.'
		GOTO CX_EXIT
	END
	INSERT INTO #IndexingAFToPrune
	SELECT	AF.id, AF.commCellId, AF.jobId, AF.fileType
	FROM	archFile AF WITH (NOLOCK) , #IndexingAppId I
	WHERE	I.appId = AF.appId
		AND	(AF.name LIKE 'IdxCheckPoint_'+@i_backupSetGUID+'%'
								OR
			AF.name LIKE 'IdxLiveLogs_'+@i_backupSetGUID+'%')
	SET	@retVal = @@ERROR
	IF	@retVal != 0
	BEGIN
		SET @retStr = 'Failed to retrieve archive files to prune.'
		GOTO CX_EXIT
	END
	--Generate input XML to send list of archive files to prune
	SET @archiveFileXML = (	SELECT archFileInfo.archFileId AS archFileId, archFileInfo.commCellId AS commCelld
													FROM #IndexingAFToPrune archFileInfo
													FOR	 XML AUTO, ROOT('GalaxyOperations_PruneArchiveFiles')
												)
	SET	@retVal = @@ERROR
	IF	@retVal != 0
	BEGIN
		SET @retStr = 'Failed to generate XML for archive files to prune.'
		GOTO CX_EXIT
	END
	--Prune the archive files
	IF @archiveFileXML IS NOT NULL
	BEGIN
EXEC @retVal = archDeleteArchiveFiles @archiveFileXML, 1048576, 0
		IF	(@@ERROR != 0 OR @retVal != 0)
		BEGIN
			SET @retStr = 'Failed to prune indexing archive files.'
			GOTO CX_EXIT
		END
		ELSE
		BEGIN
			SET @retStr = 'Indexing archive files pruned successfully.'
			GOTO CX_EXIT
		END
	END
	ELSE
	BEGIN
		SET	@retVal = 0
		SET @retStr = 'No archive files to prune.'
		GOTO CX_EXIT
	END
CX_EXIT:
		IF OBJECT_ID('tempdb.dbo.#IndexingAFToPrune') IS NOT NULL DROP TABLE #IndexingAFToPrune
		IF OBJECT_ID('tempdb.dbo.#IndexingAppId') IS NOT NULL DROP TABLE #IndexingAppId
		select @retVal, @retStr
		RETURN @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'archDeleteIndexingAFOnDeletingBackupSet')
	delete from GxQscripts where name = 'archDeleteIndexingAFOnDeletingBackupSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeleteIndexingAFOnDeletingBackupSet')
	delete from GXDBVersions where aliasname = 'archDeleteIndexingAFOnDeletingBackupSet'
GO

insert into GXDBVersions values(2, 'archDeleteIndexingAFOnDeletingBackupSet',  '00000000000000000000', 'archDeleteIndexingAFOnDeletingBackupSet', '00000000000000000000')
GO

