

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archDeleteForeignJobs.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archDeleteForeignJobs.sp,v $ $Id: archDeleteForeignJobs.sp,v 1.9.56.2 2018/03/22 00:55:47 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archDeleteForeignJobs <<<'

IF EXISTS (select * from sysobjects where name='archDeleteForeignJobs')
	drop procedure archDeleteForeignJobs
IF EXISTS (select * from GxQscripts where name='archDeleteForeignJobs')
	delete from GxQscripts where name = 'archDeleteForeignJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeleteForeignJobs')
	delete from GXDBVersions where aliasname = 'archDeleteForeignJobs'
GO
print '... Creating Procedure: archDeleteForeignJobs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archDeleteForeignJobs
  @i_dummy INTEGER
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @tblJobToDelete TABLE(
		jobId int,
		commCellId int,
		copyId int,
		primary key (jobId, commCellId, copyId)
		)
DECLARE @tblJobAged TABLE(
		jobId int,
		commCellId int,
		agedTime int,
		mediaDeletedTime int,
		primary key (jobId, commCellId)
		)
DECLARE @tblVolume table (
		SMVolumeId integer,
		ArchFileId integer,
		JobId integer,
		CommCellId integer,
		CopyId integer
		)
DECLARE @tblSnap table (
		SMSnapId integer
		)
DECLARE	@errCode	INT
SET		@errCode	= 0
DECLARE @currentTime INTEGER
SET @currentTime = dbo.GetUnixTime(GETUTCDATE())
BEGIN TRY
	BEGIN TRANSACTION
		insert into @tblJobToDelete
		select distinct jobId, commCellId, copyId
		from archForeignJobCopyToDelete WITH (NOLOCK)
		insert into @tblJobToDelete
		select distinct a.JobId, a.CommCellId, a.CopyId
		from SMVolume a WITH (NOLOCK), JMPreparedJob b WITH (NOLOCK), archForeignJobCopyToDelete c WITH (NOLOCK)
		where a.JobId = b.preparedJobId and a.CommCellId = b.preparedJobCCId
		and b.JobId = c.JobId and b.CommCellId = c.CommCellId
		insert into @tblVolume
		select a.SMVolumeId, a.ArchFileId, a.JobId, a.CommCellId, a.CopyId
		from SMVolume a WITH (NOLOCK), @tblJobToDelete b
		where a.JobId = b.JobId and a.CommCellId = b.CommCellId
		insert into @tblSnap
		select a.SMSnapId
		from SMVolSnapMap a WITH (NOLOCK), @tblVolume b
		where a.SMVolumeId = b.SMVolumeId
		delete from SMVolSnapMap
		where SMVolumeId in (select SMVolumeId from @tblVolume)
		delete SMMetaData
		from SMMetaData a, @tblVolume b
where a.RefType = 1
		and a.RefId = b.SMVolumeId
		delete SMMetaData
		from SMMetaData a, @tblSnap b
where a.RefType = 2
		and a.RefId = b.SMSnapId
		delete SMMetaData
		from SMMetaData a, SMVolSnapMap b, @tblVolume c
		where a.MetaDataId = b.MetaDataId
		and b.SMVolumeId = c.SMVolumeId
		delete from SMSnap
		where SMSnapId in (select SMSnapId from @tblSnap)
update SMVolume set PruneFlags = 6
		where SMVolumeId in (select SMVolumeId from @tblVolume)
		delete from SMVolume
		where SMVolumeId in (select SMVolumeId from @tblVolume)
		DELETE	edcJobIdMap
		FROM	edcJobIdMap a, @tblJobToDelete b
		WHERE	a.newJobId = b.JobId AND a.MergedCCId = b.CommCellId
		DELETE	jmPreparedJob
		FROM	jmPreparedJob a, @tblJobToDelete b
		WHERE	a.JobId = b.JobId AND a.CommCellId = b.CommCellId
		DELETE	jmJobSnapShotStats
		FROM	jmJobSnapShotStats a, @tblJobToDelete b
		WHERE	a.JobId = b.JobId AND a.CommCellId = b.CommCellId
		AND		a.materializationStatus <> 100
		DELETE	archFileCopy
		FROM	archFileCopy AFC, archFile AF WITH (NOLOCK), @tblVolume V
		WHERE	AFC.archFileId = AF.id
		AND 	AFC.commCellId = AF.commCellId
		AND 	AFC.archCopyId = V.copyId
		AND 	AF.jobId = V.jobId
		AND 	AF.commCellId = V.commCellId
		DELETE	archFileCopy
		FROM	archFileCopy AFC, archFile AF WITH (NOLOCK), @tblJobToDelete D
		WHERE	AFC.archFileId = AF.id
		AND 	AFC.commCellId = AF.commCellId
		AND 	(D.copyId = 0 OR AFC.archCopyId = D.copyId)
		AND 	AF.jobId = D.jobId
		AND 	AF.commCellId = D.commCellId
		--Delete archive files from archVSAAppAFLink table before deleting from archFile table
		DELETE	archVSAAppAFLink
		FROM archVSAAppAFLink AFL
		INNER JOIN archFile AF WITH (NOLOCK)
			ON AF.id = AFL.childAFId AND AF.commCellId = AFL.commCellId
		INNER JOIN @tblJobToDelete T
			ON AF.jobId = T.jobId AND AF.commCellId = T.commCellId
		LEFT OUTER JOIN archFileCopy AFC
			ON AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId
		WHERE	AFC.archFileId IS NULL
		DELETE	archVSAAppAFLink
		FROM archVSAAppAFLink AFL
		INNER JOIN archFile AF WITH (NOLOCK)
			ON AF.id = AFL.ParentIndexAFId AND AF.commCellId = AFL.commCellId
		INNER JOIN @tblJobToDelete T
			ON AF.jobId = T.jobId AND AF.commCellId = T.commCellId
		LEFT OUTER JOIN archFileCopy AFC
			ON AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId
		WHERE	AFC.archFileId IS NULL
		DELETE	archFile
		FROM	archFile AF
				INNER JOIN @tblJobToDelete T ON AF.jobId = T.jobId AND AF.commCellId = T.commCellId
				LEFT OUTER JOIN archFileCopy AFC ON AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId
		WHERE	AFC.archFileId IS NULL
		-- Update the status to deleted from media
		UPDATE	JMJobDataStats
SET 	disabled = (disabled | 256),
				status = 1000,
				agedTime = @currentTime,
				mediaDeletedTime = @currentTime,
agedBy = (agedBy | 1048576)
		FROM	 JMJobDataStats J, @tblJobToDelete D
		WHERE	J.jobId = D.jobId
		AND 	J.commCellId = D.commCellId
		AND 	(D.copyId = 0 OR J.archGrpCopyId = D.copyId)
		-- Filter out jobs with data not aged
		DELETE	@tblJobToDelete
		FROM	@tblJobToDelete A, JMJobDataStats B WITH (NOLOCK)
		WHERE	A.jobId = B.jobId
		AND 	A.commCellId = B.commCellId
		AND		B.status in (2, 3, 100, 102, 103)
AND		(B.disabled & 256) = 0
		-- Get agedTime for aged jobs
		INSERT	INTO @tblJobAged
		SELECT	T.jobId, T.commCellId, isnull(max(B.agedTime), @currentTime), isnull(max(B.mediaDeletedTime), @currentTime)
		FROM	@tblJobToDelete T left outer join JMJobDataStats B WITH (NOLOCK)
		ON		T.jobId = B.jobId
		AND 	T.commCellId = B.commCellId
		GROUP	BY T.jobId, T.commCellId
		-- Reset mediaDeletedTime for jobs still have data on media
		UPDATE	@tblJobAged
		SET 	mediaDeletedTime = 0
		FROM	@tblJobAged A, JMJobDataStats B WITH (NOLOCK)
		WHERE	A.jobId = B.jobId
		AND 	A.commCellId = B.commCellId
		AND		B.status in (2, 3, 100, 102, 103)
		-- Update job histories for aged job
		UPDATE	JMBkpStats
		SET		modifiedTime = @currentTime,
				agedTime = B.agedTime,
				mediaDeletedTime = B.mediaDeletedTime,
				dataStatus = CASE B.mediaDeletedTime WHEN 0 THEN 1 ELSE 2 END
		FROM	JMBkpStats A, @tblJobAged B
		WHERE	A.jobId = B.jobId
		AND 	A.commCellId = B.commCellId
		AND   (			A.agedTime <> B.agedTime
						OR 	A.mediaDeletedTime <> B.mediaDeletedTime
						OR 	A.dataStatus <> (CASE B.mediaDeletedTime WHEN 0 THEN 1 ELSE 2 END)
					)
		UPDATE	JMAdminJobStatsTable
		SET		dataStatus = CASE B.mediaDeletedTime WHEN 0 then 1 ELSE 2 END
		FROM	JMAdminJobStatsTable A, @tblJobAged B
		WHERE	A.jobId = B.jobId
		AND 	A.commCellId = B.commCellId
		AND 	A.dataStatus <> (CASE B.mediaDeletedTime WHEN 0 THEN 1 ELSE 2 END)
		DELETE	FROM archForeignJobCopyToDelete
	COMMIT TRANSACTION
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET	@errCode = ERROR_NUMBER()
	ROLLBACK TRANSACTION
END CATCH
SELECT	@errCode
RETURN	@errCode
GO

IF EXISTS (select * from GxQscripts where name = 'archDeleteForeignJobs')
	delete from GxQscripts where name = 'archDeleteForeignJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeleteForeignJobs')
	delete from GXDBVersions where aliasname = 'archDeleteForeignJobs'
GO

insert into GXDBVersions values(2, 'archDeleteForeignJobs',  '00010009005600020000', 'archDeleteForeignJobs', '00010009005600020000')
GO

