

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archDeleteExtraChunks.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archDeleteExtraChunks.sp,v $ $Id: archDeleteExtraChunks.sp,v 1.18.60.9 2019/11/08 23:16:58 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archDeleteExtraChunks')
BEGIN
	print '>>> Drop Stored Procedure: archDeleteExtraChunks <<<'
	drop procedure archDeleteExtraChunks
END
IF EXISTS (select * from GxQscripts where name='archDeleteExtraChunks')
	delete from GxQscripts where name = 'archDeleteExtraChunks'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeleteExtraChunks')
	delete from GXDBVersions where aliasname = 'archDeleteExtraChunks'
GO
print '... Creating Procedure: archDeleteExtraChunks'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archDeleteExtraChunks
  @i_archFileId integer,
  @i_commCellId integer,
  @i_validBytes bigint
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_retVal integer;
SET NOCOUNT ON
SET @o_retVal = 0
IF	@i_validBytes < 0
	SET	@i_validBytes = 0
IF object_id('tempdb.dbo.#tblACM') IS NOT null DROP TABLE #tblACM
IF object_id('tempdb.dbo.#tblAC') IS NOT null DROP TABLE #tblAC
CREATE TABLE #tblACM(
	archChunkId			bigint,
	chunkCommcellId	int,
	archCopyId			int,
	chunkNumber			int,
	physicalOffset		bigint,
	logicalOffset		bigint,
	physicalSize		bigint,
	logicalSize			bigint,
	diffBytes			bigint,
	unCompSize			bigint,
	primary key 		(archChunkId, chunkCommcellId),
	)
CREATE INDEX Idx_tblACM_1 ON #tblACM (archCopyId)
CREATE TABLE #tblAC(
	archChunkId			bigint,
	chunkCommcellId	int,
	archCopyId			int,
	cclip				varchar(255),
	physicalSize		bigint,
	VolumeId			int,
	SIDBStoreId			int,
	MediaSideId			int,
	recordingFormat		int,
	primary key 		(archChunkId, chunkCommcellId),
	)
INSERT	INTO #tblACM
SELECT	archChunkId, chunkCommcellId, archCopyId, chunkNumber, physicalOffset, logicalOffset, physicalSize, logicalSize,
		(logicalOffset + logicalSize - @i_validBytes), unCompSize
FROM	archChunkMapping WITH (READUNCOMMITTED)
WHERE	archFileId = @i_archFileId AND commCellId = @i_commCellId
INSERT	INTO #tblAC
SELECT	ACM.archChunkId, ACM.chunkCommcellId, ACM.archCopyId, AC.cclip, AC.physicalSize, V.VolumeId, V.SIDBStoreId, V.MediaSideId, V.RecordingFormatId
FROM	#tblACM ACM, archChunk AC WITH (READUNCOMMITTED), MMVolume V WITH (READUNCOMMITTED)
WHERE	AC.id = ACM.archChunkId AND AC.CommcellId = ACM.chunkCommcellId
	AND V.VolumeId = AC.volumeId
-- The archive file does not have valid data so all chunks can be pruned.
IF @i_validBytes = 0
BEGIN
	IF EXISTS (SELECT * FROM #tblAC WHERE SIDBStoreId > 0)
	BEGIN
		UPDATE	archFileCopy
SET		flags = flags | 256, agedBy = agedBy | 524288
		WHERE	archFileId = @i_archFileId AND commCellId = @i_commCellId
			AND archCopyId IN (SELECT DISTINCT archCopyId FROM #tblAC WHERE SIDBStoreId > 0)
		DELETE	FROM archFileCopy
		WHERE	archFileId = @i_archFileId AND commCellId = @i_commCellId
			AND archCopyId IN (SELECT DISTINCT archCopyId FROM #tblAC WHERE SIDBStoreId > 0)
		INSERT  INTO archFileSubStore (archFileId, commCellId, SIDBStoreId, SIDBSubStoreId, primaryObjects, secondaryObjects, flags)
		SELECT	DISTINCT @i_archFileId, @i_commCellId, TAC.SIDBStoreId, 0, 0, 0, 0
		FROM	(SELECT DISTINCT SIDBStoreId FROM #tblAC WHERE SIDBStoreId > 0) TAC LEFT OUTER JOIN archFileSubStore
										ON	archFileSubStore.archFileId = @i_archFileId
											AND archFileSubStore.commCellId = @i_commCellId
											AND archFileSubStore.SIDBStoreId = TAC.SIDBStoreId
		WHERE	archFileSubStore.archFileId IS NULL
		UPDATE	archFileSubStore
		SET		flags = flags | 2 --CVA_AFSS_EXTRA_CHUNKS_WERE_DELETED
		WHERE	archFileId = @i_archFileId
				AND commCellId = @i_commCellId
				AND SIDBStoreId IN (SELECT DISTINCT SIDBStoreId FROM #tblAC WHERE SIDBStoreId > 0)
	END
	IF EXISTS (SELECT * FROM #tblAC WHERE SIDBStoreId = 0)
	BEGIN
		UPDATE	archChunkMapping
SET		flags = flags | 256, agedBy = agedBy | 524288
		WHERE	archFileId = @i_archFileId AND commCellId = @i_commCellId
		DELETE	archChunkMapping
		WHERE	archFileId = @i_archFileId AND commCellId = @i_commCellId
		UPDATE	archFileCopy
		SET		isValid = 0, lastChunkNumber = 0, physicalSize = 0, logicalSize = 0, drivePoolId = 0, mediaType = 0, unCompSize = 0
		WHERE	archFileId = @i_archFileId AND commCellId = @i_commCellId
	END
	UPDATE	archFile
	SET		isValid = 0
	WHERE	Id = @i_archFileId AND commCellId = @i_commCellId
	GOTO DEL_CHUNKS
END
DECLARE @l_defCopyId int
SELECT	@l_defCopyId = defaultCopy
FROM	archGroup WITH (READUNCOMMITTED)
WHERE	id = (SELECT archGroupId FROM archFile WITH (READUNCOMMITTED) WHERE id = @i_archFileId AND commCellId = @i_commCellId)
-- The input validBytes must match with the boundary of one chunk
IF NOT EXISTS (SELECT * FROM #tblACM WHERE diffBytes = 0 AND archCopyId = @l_defCopyId)
BEGIN
	SET @o_retVal = -1
	GOTO FINISH
END
IF NOT EXISTS (SELECT * FROM #tblACM WHERE diffBytes > 0 AND archCopyId = @l_defCopyId)
	GOTO FINISH
DECLARE @l_numOfChunks int
DECLARE @l_maxChunkNum int
DECLARE @l_physicalSize bigint
DECLARE @l_logicalSize bigint
DECLARE @l_unCompSize bigint
DECLARE @l_primaryObjects		integer
DECLARE @l_secondaryObjects		integer
DECLARE @l_primaryObjSize		bigint
DECLARE @l_secondaryObjSize		bigint
DECLARE @l_primaryMetaDataSize		bigint
DECLARE @l_secondaryMetaDataSize	bigint
SELECT	@l_numOfChunks = count(*), @l_maxChunkNum = ISNULL(MAX(chunkNumber), 0),
		@l_physicalSize = SUM(physicalSize), @l_logicalSize = SUM(logicalSize), @l_unCompSize = SUM(unCompSize)
FROM	#tblACM
WHERE	diffBytes <= 0 AND chunkNumber > 0 AND archCopyId = @l_defCopyId
IF @l_numOfChunks <> @l_maxChunkNum
BEGIN
	SET @o_retVal = -2
	GOTO FINISH
END
UPDATE	archFileCopy
SET		lastChunkNumber = @l_maxChunkNum, physicalSize = @l_physicalSize, logicalSize = @l_logicalSize, unCompSize = @l_unCompSize
WHERE	archFileId = @i_archFileId AND commCellId = @i_commCellId AND archCopyId = @l_defCopyId
UPDATE	archFileSubStore
SET		flags = flags | 2 --CVA_AFSS_EXTRA_CHUNKS_WERE_DELETED
WHERE	archFileId = @i_archFileId
		AND commCellId = @i_commCellId
		AND SIDBStoreId IN (SELECT DISTINCT SIDBStoreId FROM #tblAC WHERE SIDBStoreId > 0 and archCopyid = @l_defCopyId)
DECLARE	@l_isNASArchFile int = 0
IF EXISTS (SELECT * FROM archFileCopy WITH (READUNCOMMITTED) WHERE archFileId = @i_archFileId AND commCellId = @i_commCellId AND archCopyId = @l_defCopyId AND (flags & 32) = 32)
	SET	@l_isNASArchFile = 1
IF (@l_isNASArchFile = 1)
BEGIN
	SELECT	@l_primaryObjects = SUM(primaryObjects), @l_secondaryObjects = SUM(secondaryObjects),
			@l_primaryObjSize = SUM(primaryObjSize), @l_secondaryObjSize = SUM(secondaryObjSize),
			@l_primaryMetaDataSize = SUM(primaryMetaDataSize), @l_secondaryMetaDataSize = SUM(secondaryMetaDataSize)
	FROM	archChunkMapping ACM WITH (READUNCOMMITTED), archChunkMappingNASDedup ACMD WITH (READUNCOMMITTED)
	WHERE	ACM.archFileId = ACMD.archFileId
			AND ACM.commCellId = ACMD.commCellId
			AND ACM.archChunkId = ACMD.archChunkId
			AND ACM.chunkCommCellId = ACMD.chunkCommCellId
			AND ACM.archCopyId = ACMD.archCopyId
			AND ACM.archFileId = @i_archFileId
			AND ACM.commCellId = @i_commCellId
			AND ACM.archCopyId = @l_defCopyId
			AND ACM.chunkNumber <= @l_maxChunkNum
	UPDATE	archFileCopyDedup
	SET		primaryObjects = @l_primaryObjects, secondaryObjects = @l_secondaryObjects,
			primaryObjSize = @l_primaryObjSize, secondaryObjSize = @l_secondaryObjSize,
			primaryMetaDataSize = @l_primaryMetaDataSize, secondaryMetaDataSize = @l_secondaryMetaDataSize
	WHERE	archFileId = @i_archFileId AND commCellId = @i_commCellId AND archCopyId = @l_defCopyId
END
IF EXISTS (SELECT * FROM #tblACM WHERE archCopyId <> @l_defCopyId
			AND (physicalOffset + physicalSize - @l_physicalSize) > 0)
BEGIN
	UPDATE	archFileCopy
	SET		lastChunkNumber = b.lastChunkNumber, physicalSize = b.physicalSize, logicalSize = b.logicalSize, unCompSize = b.unCompSize
	FROM	archFileCopy a,
			(SELECT	archCopyId, MAX(CASE WHEN diffBytes <= 0 AND chunkNumber > 0 THEN chunkNumber ELSE 0 END) AS lastChunkNumber,
								SUM(CASE WHEN diffBytes <= 0 AND chunkNumber > 0 THEN physicalSize ELSE 0 END) AS physicalSize,
								SUM(CASE WHEN diffBytes <= 0 AND chunkNumber > 0 THEN logicalSize ELSE 0 END) AS logicalSize,
								SUM(CASE WHEN diffBytes <= 0 AND chunkNumber > 0 THEN unCompSize ELSE 0 END) AS unCompSize
			FROM	#tblACM
			WHERE	archCopyId <> @l_defCopyId
			GROUP BY archCopyId) b
	WHERE	a.archFileId = @i_archFileId AND a.commCellId = @i_commCellId AND a.archCopyId = b.archCopyId
	UPDATE	SecC
	SET		isValid = 0
	FROM	archFileCopy SecC, archFileCopy PriC WITH (READUNCOMMITTED)
	WHERE	SecC.archFileId = PriC.archFileId AND SecC.commCellId = PriC.commCellId
			AND SecC.archCopyId <> @l_defCopyId
			AND PriC.archCopyId = @l_defCopyId
			AND SecC.isValid = 1
			AND SecC.physicalSize < PriC.physicalSize
	IF (@l_isNASArchFile = 1)
	BEGIN
		UPDATE	archFileCopyDedup
		SET		primaryObjects = b.primaryObjects, secondaryObjects = b.secondaryObjects,
				primaryObjSize = b.primaryObjSize, secondaryObjSize = b.secondaryObjSize,
				primaryMetaDataSize = b.primaryMetaDataSize, secondaryMetaDataSize = b.secondaryMetaDataSize
		FROM	archFileCopyDedup a,
				(SELECT	ACM.archCopyId, MAX(CASE WHEN diffBytes <= 0 AND chunkNumber > 0 THEN chunkNumber ELSE 0 END) AS lastChunkNumber,
						SUM(CASE WHEN diffBytes <= 0 AND chunkNumber > 0 THEN primaryObjects ELSE 0 END) AS primaryObjects,
						SUM(CASE WHEN diffBytes <= 0 AND chunkNumber > 0 THEN secondaryObjects ELSE 0 END) AS secondaryObjects,
						SUM(CASE WHEN diffBytes <= 0 AND chunkNumber > 0 THEN primaryObjSize ELSE 0 END) AS primaryObjSize,
						SUM(CASE WHEN diffBytes <= 0 AND chunkNumber > 0 THEN secondaryObjSize ELSE 0 END) AS secondaryObjSize,
						SUM(CASE WHEN diffBytes <= 0 AND chunkNumber > 0 THEN primaryMetaDataSize ELSE 0 END) AS primaryMetaDataSize,
						SUM(CASE WHEN diffBytes <= 0 AND chunkNumber > 0 THEN secondaryMetaDataSize ELSE 0 END) AS secondaryMetaDataSize
				FROM	#tblACM ACM, archChunkMappingNASDedup ACMD WITH (READUNCOMMITTED)
				WHERE	ACM.archCopyId <> @l_defCopyId
						AND ACM.archChunkId = ACMD.archChunkId
						AND ACM.chunkCommCellId = ACMD.chunkCommCellId
				GROUP BY ACM.archCopyId) b
		WHERE	a.archFileId = @i_archFileId AND a.commCellId = @i_commCellId AND a.archCopyId = b.archCopyId
	END
END
UPDATE	archChunkMapping
SET		flags = flags | 256, agedBy = agedBy | 524288
WHERE	archFileId = @i_archFileId AND commCellId = @i_commCellId
	AND (physicalOffset + physicalSize - @l_physicalSize) > 0
DELETE	archChunkMapping
WHERE	archFileId = @i_archFileId AND commCellId = @i_commCellId
	AND (physicalOffset + physicalSize - @l_physicalSize) > 0
DELETE	#tblAC
FROM	#tblAC a, #tblACM b
WHERE	b.archChunkId = a.archChunkId
AND		b.chunkCommcellId = a.chunkCommcellId
	AND	(b.physicalOffset + b.physicalSize - @l_physicalSize) <= 0
DEL_CHUNKS:
DELETE	FROM #tblAC
FROM	#tblAC a, (SELECT ACM.archChunkId, ACM.chunkCommCellId, MIN(ACM.flags & 256) AS flags
									FROM archChunkMapping ACM WITH (READUNCOMMITTED), #tblAC TMP
									WHERE ACM.archChunkId = TMP.archChunkId
									AND 	ACM.chunkCommCellId = TMP.chunkCommCellId
									GROUP BY ACM.archChunkId, ACM.chunkCommCellId) b
WHERE	b.archChunkId = a.archChunkId
AND 	b.chunkCommCellId = a.chunkCommCellId
AND		b.flags = 0
IF EXISTS (SELECT * FROM #tblAC)
BEGIN
	INSERT	INTO MMDeletedAF
	SELECT	0, volumeId, 0, 0, archCopyId, cclip, physicalSize, archChunkId, CASE WHEN AC.recordingFormat = 10001 THEN ISNULL(MP.MountPathId,0) ELSE 0 END, 0, @i_commCellId, dbo.GetUnixTime(GETUTCDATE()), 0, 0, 0, 0, 0, chunkCommcellId
	FROM	#tblAC AC LEFT JOIN MMMountPath MP WITH (NOLOCK) ON AC.MediaSideId = MP.MediaSideId
	WHERE	SIDBStoreId = 0
	INSERT	INTO MMDeletedAF
SELECT	(case when @i_validBytes = 0 then @i_archFileId else 0x7FFFFFFF end),
			AC.volumeId, 0, 0, AC.archCopyId, AC.cclip, AC.physicalSize, AC.archChunkId,
			MP.MountPathId, AC.SIDBStoreId, @i_commCellId, dbo.GetUnixTime(GETUTCDATE()), 0, 0, 0, 0, 0, chunkCommcellId
	FROM	#tblAC AC, MMMountPath MP WITH (READUNCOMMITTED)
	WHERE	AC.SIDBStoreId > 0
		AND AC.MediaSideId = MP.MediaSideId
	-- Update chunks to AGED status before deleting
	UPDATE	archChunk
SET flags = flags | 256, agedBy = agedBy | 524288
	FROM	archChunk b,  #tblAC a
	WHERE	b.id = a.archChunkId
	AND 	b.commCellId = a.chunkCommcellId
	--Delete chunks only if no chunks in archChunkMapping table, else leave them with AGED status
	DELETE	archChunk
	FROM	archChunk b INNER JOIN #tblAC a
	ON	b.id = a.archChunkId AND b.commCellId = a.chunkCommcellId
	LEFT OUTER JOIN archChunkMapping ACM
	ON b.id = ACM.archChunkId AND b.commCellId = ACM.chunkCommcellId
	WHERE ACM.archChunkId IS NULL
END
FINISH:
IF object_id('tempdb.dbo.#tblACM') IS NOT null DROP TABLE #tblACM
IF object_id('tempdb.dbo.#tblAC') IS NOT null DROP TABLE #tblAC
SELECT @o_retVal
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archDeleteExtraChunks')
	delete from GxQscripts where name = 'archDeleteExtraChunks'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeleteExtraChunks')
	delete from GXDBVersions where aliasname = 'archDeleteExtraChunks'
GO

insert into GXDBVersions values(2, 'archDeleteExtraChunks',  '00010018006000090000', 'archDeleteExtraChunks', '00010018006000090000')
GO

