

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archDeleteEncKeyProvider.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archDeleteEncKeyProvider.sp,v $ $Id: archDeleteEncKeyProvider.sp,v 1.1.2.7 2018/03/22 01:09:01 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "archDeleteEncKeyProvider"							|
--	|																		|
--	| Deletes encryption key provider										|
--	| 																		|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archDeleteEncKeyProvider <<<'

IF EXISTS (select * from sysobjects where name='archDeleteEncKeyProvider')
	drop procedure archDeleteEncKeyProvider
IF EXISTS (select * from GxQscripts where name='archDeleteEncKeyProvider')
	delete from GxQscripts where name = 'archDeleteEncKeyProvider'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeleteEncKeyProvider')
	delete from GXDBVersions where aliasname = 'archDeleteEncKeyProvider'
GO
print '... Creating Procedure: archDeleteEncKeyProvider'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archDeleteEncKeyProvider
  @i_keyProviderId int,
  @i_localeId bigint
AS
BEGIN
  DECLARE @o_errorCode int;
  DECLARE @o_errorStr NVARCHAR(1024);
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
SET @o_errorCode = 0
	SET @o_errorStr = ''
	DECLARE @l_keyProviderName nvarchar(1024) = (SELECT keyProviderName FROM ArchEncKeyProvider WHERE keyProviderId = @i_keyProviderId)
	IF EXISTS(SELECT 1 FROM ArchEncKeyProviderAssoc WITH (READUNCOMMITTED) WHERE KeyProviderId = @i_keyProviderId)
OR EXISTS(SELECT 1 FROM GxGlobalParam WITH (READUNCOMMITTED) WHERE name = 'DefaultKeyProviderForNewCopies' and value = @l_keyProviderName)
	BEGIN
SET @o_errorCode = 202
SET @o_errorStr = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (227 | (CAST(POWER(2, 24) AS BIGINT) * 80)) AND localeId = @i_localeId)
        SET @o_errorStr = REPLACE(@o_errorStr, '^1%s', @l_keyProviderName)
		GOTO CX_EXIT
	END
	-- Delete provider
	DELETE 	ArchEncKeyProvider
	WHERE	KeyProviderId =  @i_keyProviderId
	IF @@ERROR <> 0
	BEGIN
SET @o_errorCode = 2
SET @o_errorStr = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (18 | (CAST(POWER(2, 24) AS BIGINT) * 80)) AND localeId = @i_localeId)
		GOTO CX_EXIT
	END
	--Remove Security Associations
EXEC sec_deleteSecurityAssociationsForEntity 178 /*KEY_MANAGEMENT_SERVER_ENTITY*/, @i_keyProviderId
CX_EXIT:
SELECT @o_errorCode, @o_errorStr
END

IF EXISTS (select * from GxQscripts where name = 'archDeleteEncKeyProvider')
	delete from GxQscripts where name = 'archDeleteEncKeyProvider'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeleteEncKeyProvider')
	delete from GXDBVersions where aliasname = 'archDeleteEncKeyProvider'
GO

insert into GXDBVersions values(2, 'archDeleteEncKeyProvider',  '00010001000200070000', 'archDeleteEncKeyProvider', '00010001000200070000')
GO

