

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archDeferredCatalogUnpickByTime.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  archDeferredCatalogUnpickByTime.sp                         */
/*                                                                            */
/*  Author      :  Praveen Kumar Krishnan                                     */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archDeferredCatalogUnpickByTime.sp,v $ $Id: archDeferredCatalogUnpickByTime.sp,v 1.1.54.2 2018/05/22 23:41:45 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archDeferredCatalogUnpickByTime <<<'

IF EXISTS (select * from sysobjects where name='archDeferredCatalogUnpickByTime')
	drop procedure archDeferredCatalogUnpickByTime
IF EXISTS (select * from GxQscripts where name='archDeferredCatalogUnpickByTime')
	delete from GxQscripts where name = 'archDeferredCatalogUnpickByTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeferredCatalogUnpickByTime')
	delete from GXDBVersions where aliasname = 'archDeferredCatalogUnpickByTime'
GO
print '... Creating Procedure: archDeferredCatalogUnpickByTime'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archDeferredCatalogUnpickByTime
  @i_archGroupId integer,
  @i_startTime integer,
  @i_unPickReason integer
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
--Unpick jobs that are not already being processed
UPDATE	JMJobSnapDeferredCatalogStats
SET		disabled = (J.disabled | 1), unPickReason = @i_unPickReason
FROM	JMJobSnapDeferredCatalogStats J INNER JOIN JMBkpStats B ON J.jobId = B.jobId AND J.commCellId = B.commCellId
WHERE B.opType = 59 AND B.servStartDate < @i_startTime
	AND J.archGrpId = @i_archGroupId
	AND J.disabled & (1+256) = 0
	AND J.catalogstatus <> 100
	AND NOT EXISTS
	(
	SELECT 1
	FROM JMJobWF JWF WITH(NOLOCK) INNER JOIN JMJobInfo RJ WITH(NOLOCK) ON RJ.jobId = JWF.childJobId AND RJ.commCellId = JWF.commcellId AND RJ.opType = 59 AND RJ.subOptype = 96 --enum CVOpType{   DELAYEDCATALOG = 96, -- Delayed Catalog
	AND JWF.processedJobId = J.jobId AND JWF.processedCommcellId = J.commcellId
	)
SELECT	@@ERROR
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archDeferredCatalogUnpickByTime')
	delete from GxQscripts where name = 'archDeferredCatalogUnpickByTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeferredCatalogUnpickByTime')
	delete from GXDBVersions where aliasname = 'archDeferredCatalogUnpickByTime'
GO

insert into GXDBVersions values(2, 'archDeferredCatalogUnpickByTime',  '00010001005400020000', 'archDeferredCatalogUnpickByTime', '00010001005400020000')
GO

