

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archDeferredCatalogPickNewJob.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  archDeferredCatalogPickNewJob.sp                           */
/*                                                                            */
/*  Description :  Picks new snap job for deferred catalog at the end         */
/*                 of snap backup job                                         */
/*  Author      :  Praveen                                                    */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archDeferredCatalogPickNewJob.sp,v $ $Id: archDeferredCatalogPickNewJob.sp,v 1.1.54.4 2018/10/13 06:18:17 hkapadia Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archDeferredCatalogPickNewJob')
BEGIN
	print '>>> Drop Stored Procedure: archDeferredCatalogPickNewJob <<<'
	drop procedure archDeferredCatalogPickNewJob
END
IF EXISTS (select * from GxQscripts where name='archDeferredCatalogPickNewJob')
	delete from GxQscripts where name = 'archDeferredCatalogPickNewJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeferredCatalogPickNewJob')
	delete from GXDBVersions where aliasname = 'archDeferredCatalogPickNewJob'
GO
print '... Creating Procedure: archDeferredCatalogPickNewJob'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archDeferredCatalogPickNewJob
  @i_jobId integer,
  @i_appId integer,
  @i_appType integer,
  @i_startDate integer,
  @i_backupLevel integer,
  @i_fullCycleNum integer,
  @i_today integer
AS
  DECLARE @retVal INTEGER;
SET NOCOUNT ON
DECLARE	@i_commCellId   INTEGER
SET	@i_commCellId = 2
DECLARE @EX_FULL_JOB_IN_CYCLE		BIGINT											-- JMBKP_EX_FULL_JOB_IN_CYCLE
SET			@EX_FULL_JOB_IN_CYCLE   = 0x10000000000000
DECLARE @EX_APPAWARE_CHILD_JOB	 BIGINT											-- JMBKP_EX_APPAWARE_CHILD_JOB
SET			@EX_APPAWARE_CHILD_JOB   = 0x20000000000000
SET @retVal = 0
-- Check if backup of snapshot is applicable
IF NOT EXISTS (
	SELECT * FROM JMOpTable
	WHERE	appTypeType = @i_appType AND operation = 60)
	GOTO RETURN_PROC
DECLARE	@l_archGroupId	INT = 0
DECLARE	@l_enabled		INT = 0
DECLARE	@l_type			INT = 0
DECLARE	@l_flags		INT = 0
DECLARE	@l_startTime	INT = 0
DECLARE	@l_sourceCopyId	INT = 0
DECLARE	@l_numPeriod	INT = 0
DECLARE	@l_dayNumber	INT = 0
DECLARE	@l_currPeriodBegin	INT = 0
DECLARE	@l_currPeriodEnd	INT = 0
DECLARE	@l_prevPeriodBegin	INT = 0
DECLARE	@l_nextPeriodEnd	INT = 0
DECLARE @l_inlineBackupCopyType INT = 0
DECLARE @l_operationType INT = 0
DECLARE @l_bkpAttributesEx BIGINT = 0
DECLARE @isVSAV2Parent INT = 0
if object_id('tempdb.dbo.#archGroupToAppId') is not null DROP TABLE #archGroupToAppId
CREATE TABLE #archGroupToAppId (
archGroupId			INTEGER,
AppId				INTEGER
)
CREATE CLUSTERED INDEX idx_archGroupToAppId ON #archGroupToAppId (archGroupId,AppId)
IF EXISTS
(
		SELECT 1
		FROM JMJobDataLink JDL WITH (NOLOCK)
		WHERE JDL.parentJobId = @i_jobId
		AND JDL.commcellId = @i_commCellId
AND JDL.linkType = 7
)
BEGIN
	SET @isVSAV2Parent = 1
END
SELECT	@l_archGroupId = J.archGrpId, @l_flags =  SnapProp.flags
FROM	JMJobDataStats J WITH (NOLOCK), archGroupCopy C WITH (NOLOCK), ArchDeferredCatalogProp SnapProp WITH (NOLOCK), ArchGroup AG WITH (NOLOCK)
WHERE	J.jobId = @i_jobId AND J.commCellId = @i_commCellId AND J.dataType IN (1, 4)
	AND J.status IN (100, 101, 102, 103) AND J.disabled & (1+256) = 0
	AND J.archGrpCopyId = C.id AND C.isSnapCopy = 1 AND J.archGrpId = SnapProp.archGroupId AND J.archGrpId = AG.id
	AND ((SnapProp.sourceCopyId > 0 AND J.archGrpCopyId = SnapProp.sourceCopyId) OR (SnapProp.sourceCopyId <=0 AND J.archGrpCopyId = AG.defaultSnapCopy))
IF @l_archGroupId = 0
	GOTO RETURN_PROC
SELECT @l_bkpAttributesEx = bkpAttributesEx
FROM JMBkpStats WITH (NOLOCK)
WHERE jobId = @i_jobId AND commCellId = @i_commCellId
-- Check for selective subclient association for Deferred Catalog
SET @l_operationType = 2
IF EXISTS (SELECT 1 FROM archGroupToApp WITH (NOLOCK) WHERE archGroupId = @l_archGroupId AND OperationType = @l_operationType AND assocType <> 2)
BEGIN
	INSERT INTO #archGroupToAppId
	SELECT @l_archGroupId, @i_appId
	exec archGetArchGroupToAppAssociations @l_archGroupId, @l_operationType
	IF NOT EXISTS (
	    SELECT	1
			FROM	#archGroupToAppId t
			WHERE t.archGroupId = @l_archGroupId  AND t.AppId = @i_appId
	) AND @isVSAV2Parent = 0
	BEGIN
		GOTO RETURN_PROC
	END
END
SELECT	@l_enabled = enabled, @l_type = type, @l_flags = flags, @l_startTime = startTime,
		@l_sourceCopyId = sourceCopyId, @l_numPeriod = numPeriod, @l_dayNumber = dayNumber,
		@l_currPeriodBegin = currPeriodBegin, @l_currPeriodEnd = currPeriodEnd,
		@l_prevPeriodBegin = prevPeriodBegin, @l_nextPeriodEnd = nextPeriodEnd
FROM	ArchDeferredCatalogProp
WHERE	archGroupId = @l_archGroupId
IF @l_sourceCopyId = 0
	SELECT @l_sourceCopyId = defaultSnapCopy FROM archGroup WITH (NOLOCK) WHERE id = @l_archGroupId
IF (dbo.IsDeferredCatalogSupported(@i_appId) = 0)
		GOTO RETURN_PROC
--bcd already exists do not pick for catalog
IF EXISTS(SELECT 1 FROM archFile WITH (NOLOCK) WHERE jobId = @i_jobId AND commcellId = @i_commCellId AND fileType = 6) AND dbo.IsIndexingV2Enabled(0, 0, @i_appId) = 0
		GOTO RETURN_PROC
IF	@l_enabled = 0
OR @l_type = 9
 OR (
@l_type <> 0
 			AND (
	 					(@i_backupLevel NOT IN (1, 64, 128, 1024, 32768) AND dbo.GetBkpLevelOfSnapJobs(@i_jobId, @i_CommCellId, @l_sourceCopyId) <> 1)
 						OR
 						(@l_bkpAttributesEx & @EX_APPAWARE_CHILD_JOB > 0 AND @l_bkpAttributesEx & @EX_FULL_JOB_IN_CYCLE = 0)
 					)
 		)
 OR @i_startDate < @l_startTime
 GOTO RETURN_PROC
IF	@l_type = 0 OR @l_type = 1 AND @l_numPeriod = 1
	GOTO SELECT_JOB
-- Apply selection rules.
IF	@l_type IN (1, 10, 3, 2, 4, 6)
BEGIN
	DECLARE @l_startDate	INT = 0
	DECLARE @l_fullCycleNum	INT = 0
	SELECT	TOP 1 @l_startDate = J.servStartDate, @l_fullCycleNum = J.fullCycleNum
	FROM	JMBkpStats J WITH (NOLOCK),
JMJobSnapDeferredCatalogStats S WITH (NOLOCK)
	WHERE	J.jobId = S.jobId AND J.commCellId = S.commCellId
AND S.appId = @i_appId AND ((S.catalogStatus IN (101, 102, 103) AND S.disabled & (1+256) = 0) OR S.catalogStatus = 100)
	ORDER BY J.servStartDate DESC
IF	@l_type = 1
	BEGIN
		IF	@i_fullCycleNum < (@l_numPeriod + @l_fullCycleNum)
			GOTO RETURN_PROC
	END
	ELSE
IF	@l_type IN (10, 3, 2, 4, 6)
	BEGIN
		DECLARE	@l_nextFullTime	INTEGER
		DECLARE @tblNextFullTime TABLE (nextFullTime int)
		INSERT  INTO @tblNextFullTime
		EXEC @l_nextFullTime = TM_GetNextScheduleRunTime @i_appId, 1/*BackupLvl- Full*/, 1/*countDisabled*/, 0/*countRunningJob*/
		/*
		If option to consider incremental as full is set on the policy and this appId fits for that setting and if there is an incremental schedule coming up
		before full schedule use that as the nex full time for job selection decision
		*/
		IF (dbo.GetBkpLevelForSnapCopy(@i_appId, 2, @l_sourceCopyId) = 1)
		BEGIN
			DECLARE @l_nextFullTimeForSnap INTEGER
    		INSERT INTO @tblNextFullTime
    		EXEC @l_nextFullTimeForSnap = TM_GetNextScheduleRunTime @i_appId, 2/*BackupLvl- Incr*/, 1/*countDisabled*/, 0/*countRunningJob*/
    		IF (@l_nextFullTimeForSnap <> 0 AND (@l_nextFullTimeForSnap < @l_nextFullTime OR @l_nextFullTime = 0))
          		SET @l_nextFullTime = @l_nextFullTimeForSnap
		END
		DECLARE	@l_clientId int
		SELECT	@l_clientId = clientId FROM APP_Application WITH (NOLOCK) WHERE id = @i_appId
		DECLARE	@l_TimeZone varchar(255)
		SET		@l_TimeZone = dbo.ArchGroupTimeZone(@l_archGroupId, @l_clientId)
		DECLARE	@now INT
		SET		@now = dbo.GetUnixTime(GETUTCDATE())
		IF @l_TimeZone <> ''
		BEGIN
			DECLARE	@l_csTimeZone varchar(255)
			SET		@l_csTimeZone = dbo.GetClientTimeZone(2)
			IF	@l_TimeZone <> @l_csTimeZone
			BEGIN
				SET @now = @now + dbo.GetDiffFromCSTimeZone(@now, @l_TimeZone, @l_csTimeZone)
				SET	@i_startDate = @i_startDate + dbo.GetDiffFromCSTimeZone(@i_startDate, @l_TimeZone, @l_csTimeZone)
				IF	@l_startDate > 0
					SET	@l_startDate = @l_startDate + dbo.GetDiffFromCSTimeZone(@l_startDate, @l_TimeZone, @l_csTimeZone)
IF	@l_nextFullTime > 0 AND (@l_flags & 4096) <> 0 AND (@l_flags & 8192) = 0
					SET	@l_nextFullTime = @l_nextFullTime + dbo.GetDiffFromCSTimeZone(@l_nextFullTime, @l_TimeZone, @l_csTimeZone)
			END
		END
		IF	@l_startDate > 0 AND
			(	@i_startDate >= @l_prevPeriodBegin AND @l_startDate >= @l_prevPeriodBegin AND @i_startDate < @l_currPeriodBegin AND @l_startDate < @l_currPeriodBegin
			OR	@i_startDate >= @l_currPeriodBegin AND @l_startDate >= @l_currPeriodBegin AND @i_startDate < @l_currPeriodEnd   AND @l_startDate < @l_currPeriodEnd
			OR	@i_startDate >= @l_currPeriodEnd   AND @l_startDate >= @l_currPeriodEnd   AND @i_startDate < @l_nextPeriodEnd   AND @l_startDate < @l_nextPeriodEnd
			OR	@i_startDate >= @l_nextPeriodEnd   AND @l_startDate >= @l_nextPeriodEnd)
			GOTO RETURN_PROC
IF	(@l_flags & 4096) <> 0 AND (@l_flags & 8192) = 0 AND @l_nextFullTime > 0 AND
			(	@i_startDate <  @l_prevPeriodBegin AND @l_nextFullTime <  @l_prevPeriodBegin
			OR	@i_startDate >= @l_prevPeriodBegin AND @l_nextFullTime >= @l_prevPeriodBegin AND @i_startDate < @l_currPeriodBegin AND @l_nextFullTime < @l_currPeriodBegin
			OR	@i_startDate >= @l_currPeriodBegin AND @l_nextFullTime >= @l_currPeriodBegin AND @i_startDate < @l_currPeriodEnd   AND @l_nextFullTime < @l_currPeriodEnd
			OR	@i_startDate >= @l_currPeriodEnd   AND @l_nextFullTime >= @l_currPeriodEnd   AND @i_startDate < @l_nextPeriodEnd   AND @l_nextFullTime < @l_nextPeriodEnd
			OR	@i_startDate >= @l_nextPeriodEnd   AND @l_nextFullTime >= @l_nextPeriodEnd)
			GOTO RETURN_PROC
IF	(@l_flags & 4096) <> 0 AND (@l_flags & 8192) <> 0 AND
			(	@i_startDate >= @l_prevPeriodBegin AND @now < @l_currPeriodBegin
			OR	@i_startDate >= @l_currPeriodBegin AND @now < @l_currPeriodEnd
			OR	@i_startDate >= @l_currPeriodEnd   AND @now < @l_nextPeriodEnd
			OR	@i_startDate >= @l_nextPeriodEnd)
			GOTO RETURN_PROC
	END
END
SELECT_JOB:
IF (@i_backupLevel NOT IN (1, 64, 128, 1024, 32768))
AND (dbo.IsIndexingV2Enabled(0, 0, @i_appId) = 0)
BEGIN
	/*If deferred catalog and if it is incremental job we can go ahead without checking full job in the cycle if we find any previous job in this cycle already cataloged*/
	IF @i_backupLevel = 4 /*enum CVBkpLevel{ DIFFERENTIAL = 0x4,*/
	OR (
	NOT EXISTS (
	SELECT 1 FROM JMJobDataStats jds WITH (NOLOCK) inner join JMBkpStats jbkp WITH (NOLOCK)
	ON jbkp.appId = @i_appId AND jbkp.fullCycleNum = @i_fullCycleNum AND jbkp.servStartDate < @i_startDate AND jbkp.status in (1, 3, 14)
AND jds.jobId = jbkp.jobId AND jds.commcellId = jbkp.commcellId AND jds.dataType = 6
AND (jds.disabled & 256) = 0
	)
	)
	BEGIN
		DECLARE @fullJobId int = 0
		DECLARE @fullJobCommCellId int = 0
		DECLARE @fullJobStartDate int = 0
		DECLARE @fullJobArchGroupId int = 0
		DECLARE @isFullBackupSnapJob int = 0
		SELECT top 1 @fullJobId = jbkp.jobID, @fullJobCommCellId = jbkp.commCellId, @fullJobStartDate = jbkp.servStartDate, @fullJobArchGroupId = jbkp.dataArchGrpId, @isFullBackupSnapJob = CASE WHEN jbkp.opType IN (59, 65) /*SNAPBACKUP , SNAPBACKUP3RD*/ THEN 1 ELSE 0 END
		FROM JMBkpStats jbkp WITH (NOLOCK)
		WHERE jbkp.fullCycleNum = @i_fullCycleNum
		AND jbkp.appId = @i_appId AND jbkp.bkpLevel in (1, 64, 128, 1024, 32768)
		AND jbkp.status in (1, 3, 14) --typedef enum CVJobStatus{ JMSUCCESS=1, PARTIALSUCCESS=3, JMSUCCESSWITHWARNINGS = 14,
		ORDER BY jbkp.servStartDate asc
		IF @@ROWCOUNT = 0 --We have an incremental/differential that we are going to pick for snap to tape but we did not find its corresponding full, so do not pick up
			GOTO RETURN_PROC
		/*
		If it is deferred catalog when we hit the following condition it means the full job of the cycle is already cataloged but we don't find any previous job in the cycle
		with bcd index row (either completely valid or marked for auxcopy) in the catalog source copyId without aged data flag set. It means the full job is cataloged and aged
		or full job is cataloged in an old source copy but bcd index row is not marked for auxcopy in current source copy
		So we cannot pick this incremental for catalog as we don't see a possibility of any previous job in this cycle going to be cataloged in curent source copy for catalog
		Note: We should not do this for differential job
IF EXISTS (SELECT 1 FROM JMJobDataStats WITH (NOLOCK) WHERE jobId = @fullJobId AND commcellId = @fullJobCommCellId AND dataType = 6) AND @i_backupLevel <> 4 /*enum CVBkpLevel{ DIFFERENTIAL = 0x4,*/
			GOTO RETURN_PROC
		*/
IF NOT EXISTS(SELECT 1 FROM JMJobSnapDeferredCatalogStats WITH (NOLOCK) WHERE jobId = @fullJobId AND commcellId = @fullJobCommCellId/* AND archGrpId = @l_archGroupId*/)
AND NOT EXISTS(SELECT 1 FROM JMJobDataStats WITH(NOLOCK) WHERE jobId = @fullJobId AND commcellId = @fullJobCommCellId AND dataType = 6)
		BEGIN
			DECLARE @l_fullJobSourceCopyId int = 0
			SELECT	@l_fullJobSourceCopyId = ISNULL(sourceCopyId, 0)
FROM	ArchDeferredCatalogProp WITH(NOLOCK)
			WHERE	archGroupId = @fullJobArchGroupId
			IF @l_fullJobSourceCopyId = 0
				SELECT @l_fullJobSourceCopyId = defaultSnapCopy FROM archGroup WITH (NOLOCK) WHERE id = @fullJobArchGroupId
			--Pick up the corresponding full job in this cycle
			IF EXISTS(SELECT 1 FROM JMJobDataStats JDS WITH(NOLOCK) WHERE JDS.jobId = @fullJobId AND JDS.commcellId = @fullJobCommCellId
AND archGrpCopyId = @l_fullJobSourceCopyId AND (disabled & 256) = 0) AND @isFullBackupSnapJob = 1
      BEGIN
INSERT INTO JMJobSnapDeferredCatalogStats
				SELECT	@fullJobId, @fullJobCommCellId, 101, 0, 0, @i_appId, @fullJobArchGroupId, 0, 0
				IF EXISTS
				(
					SELECT 1
					FROM JMJobDataLink JDL WITH (NOLOCK)
					WHERE JDL.childJobId = @fullJobId
					AND JDL.commcellId = @fullJobCommCellId
AND JDL.linkType = 7
				)
				BEGIN
					--Insert VSA V2 Parent job
INSERT INTO JMJobSnapDeferredCatalogStats
					SELECT	DISTINCT JDS.jobId, JDS.commCellId, 101, 0, 0, JDS.appId, JDS.archGrpId, 0, 0
					FROM	JMJobDataLink JDL WITH (NOLOCK) INNER JOIN JMJobDataStats JDS WITH (NOLOCK)
					ON 		JDL.parentJobId = JDS.jobId
					AND 	JDL.commcellId = JDS.commcellId
					AND		JDL.childJobId = @fullJobId
					AND 	JDL.commcellId = @fullJobCommCellId
AND 	JDL.linkType = 7
LEFT OUTER JOIN JMJobSnapDeferredCatalogStats S
					ON 		JDS.jobId = S.jobId
					AND 	JDS.commCellId = S.commcellId
					WHERE JDS.archGrpCopyId = @l_fullJobSourceCopyId
					AND		JDS.status IN (100, 101, 102, 103)
					AND 	JDS.disabled & (1 + 256) = 0
					AND 	S.jobId IS NULL
				END
			END
		END
	END
END
PICK_JOB:
	IF EXISTS(
							SELECT 1
							FROM JMJobDataStats JDS WITH (NOLOCK)
							WHERE JDS.jobId = @i_jobId
							AND 	JDS.commcellId = @i_commCellId
	            AND 	JDS.archGrpCopyId = @l_sourceCopyId
AND 	(JDS.disabled & 256) = 0
            )
  BEGIN
INSERT	INTO JMJobSnapDeferredCatalogStats
		SELECT	@i_jobId, @i_commCellId, 101, 0, 0, @i_appId, @l_archGroupId, 0, 0
WHERE NOT EXISTS (SELECT 1 FROM JMJobSnapDeferredCatalogStats WITH (NOLOCK) WHERE jobId = @i_jobId AND commcellId = @i_commCellId)
		IF EXISTS
		(
			SELECT 1
			FROM JMJobDataLink JDL WITH (NOLOCK)
			WHERE JDL.childJobId = @i_jobId
			AND JDL.commcellId = @i_commCellId
AND JDL.linkType = 7
		)
		BEGIN
INSERT INTO JMJobSnapDeferredCatalogStats
			SELECT	DISTINCT JDS.jobId, JDS.commCellId, 101, 0, 0, JDS.appId, JDS.archGrpId, 0, 0
			FROM	JMJobDataLink JDL WITH (NOLOCK) INNER JOIN JMJobDataStats JDS WITH (NOLOCK)
			ON 		JDL.parentJobId = JDS.jobId
			AND 	JDL.commcellId = JDS.commcellId
			AND		JDL.childJobId = @i_jobId
			AND 	JDL.commcellId = @i_commCellId
AND 	JDL.linkType = 7
LEFT OUTER JOIN JMJobSnapDeferredCatalogStats S
			ON 		JDS.jobId = S.jobId
			AND 	JDS.commCellId = S.commcellId
			WHERE JDS.archGrpCopyId = @l_sourceCopyId
			AND		JDS.status IN (100, 101, 102, 103)
			AND 	JDS.disabled & (1 + 256) = 0
			AND 	S.jobId IS NULL
		END
	END
SET @retVal = @@ERROR
RETURN_PROC:
if object_id('tempdb.dbo.#archGroupToAppId') is not null DROP TABLE #archGroupToAppId
SELECT   @retVal
RETURN   @retVal;
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archDeferredCatalogPickNewJob')
	delete from GxQscripts where name = 'archDeferredCatalogPickNewJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeferredCatalogPickNewJob')
	delete from GXDBVersions where aliasname = 'archDeferredCatalogPickNewJob'
GO

insert into GXDBVersions values(2, 'archDeferredCatalogPickNewJob',  '00010001005400040000', 'archDeferredCatalogPickNewJob', '00010001005400040000')
GO

