

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archDeferredCatalogPickJobs.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  archDeferredCatalogPickJobs.sp                             */
/*                                                                            */
/*  Description :  Picks input jobs for deferred catalog                      */
/*																			  */
/*  Author      :  Praveen                                                    */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archDeferredCatalogPickJobs.sp,v $ $Id: archDeferredCatalogPickJobs.sp,v 1.1.54.4 2018/10/13 06:18:05 hkapadia Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archDeferredCatalogPickJobs')
BEGIN
	print '>>> Drop Stored Procedure: archDeferredCatalogPickJobs <<<'
	drop procedure archDeferredCatalogPickJobs
END
IF EXISTS (select * from GxQscripts where name='archDeferredCatalogPickJobs')
	delete from GxQscripts where name = 'archDeferredCatalogPickJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeferredCatalogPickJobs')
	delete from GXDBVersions where aliasname = 'archDeferredCatalogPickJobs'
GO
print '... Creating Procedure: archDeferredCatalogPickJobs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archDeferredCatalogPickJobs
  @i_archGroupId integer,
  @i_jobIdsXml xml
AS
  DECLARE @retVal INTEGER;
SET NOCOUNT ON
DECLARE	@FULL_BITS		INT
SET		@FULL_BITS		= (1+64+128+1024+32768)
DECLARE @DIFFERENTIAL_BIT INT
SET @DIFFERENTIAL_BIT = 4
CREATE TABLE #tempJobIds (jobId int, commCellId int, appId int, bkpLevel int, fullCycleNum int, startDate int, hasSource int, isForeignSnap int, archGroupId int, isVSAV2Parent int)
CREATE CLUSTERED INDEX Idx_tempJobIds_jobId_commCellId ON #tempJobIds (jobId, commcellId)
INSERT	INTO #tempJobIds
SELECT	T.c.value('@jobId', 'int'), T.c.value('@commCellId', 'int'), 0, 0, 0, 0, 0, 0, 0, 0
FROM	@i_jobIdsXml.nodes('/r/h') T(c)
--Deferred catalog is not supported on all appTypes
--Do not process jobs for deferred catalog if the catalog was not skipped during backup. This is to handle the case when subclient is V2 but has jobs run before enabling deferred catalog hence has catalog already created
DELETE #tempJobIds
FROM #tempJobIds J inner join JMBkpStats JINFO WITH(NOLOCK) ON J.jobId = JINFO.jobId AND J.commcellId = JINFO.commcellId
WHERE dbo.IsDeferredCatalogSupported(JINFO.appId) = 0 OR JINFO.bkpAttributes & 0x200000000000000 = 0 --#define JMBKP_SKIP_CATALOG_PHASE_SNAP_BKUP  0x200000000000000LL
DECLARE @tblAppIds table(appId int, isIndexingV2Enabled int)
INSERT INTO @tblAppIds
SELECT DISTINCT JBKP.appId, 0
FROM #tempJobIds J inner join JMBkpStats JBKP WITH(NOLOCK) ON J.jobId = JBKP.jobId AND J.CommcellId = JBKP.CommcellId
UPDATE @tblAppIds SET isIndexingV2Enabled = dbo.IsIndexingV2Enabled(0, 0, appId)
--If deferred catalog do not consider jobs that have bcd index created already for V1
DELETE #tempJobIds
FROM #tempJobIds J inner join ArchFile AF WITH(NOLOCK) ON J.jobId = AF.jobId AND J.commcellId = AF.commcellId AND AF.fileType = 6
INNER JOIN @tblAppIds App ON AF.appId = App.appId
WHERE App.isIndexingV2Enabled = 0
--Be it V1 or V2 do not process jobs that are already processed for deferred catalog successfully
DELETE #tempJobIds
FROM #tempJobIds J inner join JMJobSnapDeferredCatalogStats JS WITH(NOLOCK) ON J.jobId = JS.jobId AND J.commcellId = JS.commcellId AND JS.CatalogStatus = 100
UPDATE	#tempJobIds SET isForeignSnap = 1
WHERE	commCellId IN (SELECT id FROM APP_CommCell WHERE id IN (SELECT DISTINCT commCellId FROM #tempJobIds) AND type > 1)
DECLARE	@l_sourceCopyId INT
SET		@l_sourceCopyId = 0
SET		@retVal = 0
SELECT	@l_sourceCopyId = sourceCopyId
FROM	ArchDeferredCatalogProp WITH (NOLOCK)
WHERE	archGroupId = @i_archGroupId
IF	@l_sourceCopyId = 0
	SELECT	@l_sourceCopyId = defaultSnapCopy
	FROM	archGroup WITH (NOLOCK)
	WHERE	id = @i_archGroupId
IF	@l_sourceCopyId = 0
SET @retVal = 80
ELSE
BEGIN
	UPDATE	#tempJobIds
	SET		appId = J.appId, hasSource = 1, archGroupId = J.archGrpId
	FROM	JMJobDataStats J, #tempJobIds T
	WHERE	J.jobId = T.jobId AND J.commCellId = T.commCellId
AND J.dataType IN (1, 4)
		AND (J.archGrpId = @i_archGroupId AND J.archGrpCopyId = @l_sourceCopyId OR isForeignSnap = 1)
		AND J.status IN (100, 101, 102, 103) AND J.disabled & (1+256) = 0
	UPDATE #tempJobIds
	SET appId = b.appId, bkpLevel = b.bkpLevel, fullCycleNum = b.fullCycleNum, startDate = b.servStartDate
	FROM #tempJobIds a inner join JMBkpStats b WITH (NOLOCK) ON a.jobId = b.jobId AND a.commcellId = b.commcellId
	UPDATE #tempJobIds
	SET isVSAV2Parent = 1
	FROM #tempJobIds T INNER JOIN JMJobDataLink JDL WITH (NOLOCK)
	ON T.appId = JDL.parentAppId
AND JDL.linkType = 7
	DELETE	#tempJobIds
FROM	JMJobSnapDeferredCatalogStats J, #tempJobIds T
	WHERE	J.jobId > T.jobId AND J.commCellId = T.commCellId
		--AND J.archGrpId = @i_archGroupId
		AND J.appId = T.appId
AND J.catalogStatus IN (100, 102, 103)
		AND	T.isVSAV2Parent = 0
	IF	@@ROWCOUNT > 0
	BEGIN
SET @retVal = 115
	END
	/*
	For backup copy both incremental and differential has dependency with full in the cycle.
	For deferred catalog incrementals need any previous job in the cycle with catalog.
	For deferred catalog differentials have dependency with full in the cycle.
	*/
	IF(OBJECT_ID('tempdb.dbo.#fullIncrMap') is not null)
		DROP TABLE #fullIncrMap
	CREATE TABLE #fullIncrMap (incrJobId int, incrJobCCId int, fullJobId int, fullJobCCId int, fullJobArchGroupId int, sourceCopyId int, appId int, bkpLevel int, fullCycleNum int, startDate int, isFullBackUpSnapJob int)
	CREATE INDEX Idx_fullIncrMap_fullJobId_fullJobCCId ON #fullIncrMap(fullJobId, fullJobCCId)
	CREATE INDEX Idx_fullIncrMap_incrJobId_incrJobCCId ON #fullIncrMap(incrJobId, incrJobCCId)
	IF(OBJECT_ID('tempdb..#incrJobsWithCatalogInCurrentCycle') is not null)
		DROP TABLE #incrJobsWithCatalogInCurrentCycle
	CREATE TABLE #incrJobsWithCatalogInCurrentCycle (jobId int, commcellId int, primary key(jobId, commcellId))
	/*
	If deferred catalog get the list of incremental jobs that have a previous job in the cycle cataloged already  (don't include differential jobs)
	While finding corresponding full jobs in the cycle for incremental jobs we can ignore jobs from this list
	*/
	INSERT INTO #incrJobsWithCatalogInCurrentCycle
	SELECT distinct jobList.jobId, jobList.commcellId
	FROM #tempJobIds jobList inner join JMBkpStats jbkp WITH(NOLOCK)
	ON jobList.appId = jbkp.appId AND jobList.fullCycleNum = jbkp.fullCycleNum AND jbkp.servStartDate < jobList.startDate AND jbkp.status in (1, 3, 14)
	AND jobList.bkpLevel & @FULL_BITS = 0 AND jobList.bkpLevel & @DIFFERENTIAL_BIT = 0
	inner join JMJobDataStats jds WITH (NOLOCK) ON
jds.jobId = jbkp.jobId AND jds.commcellId = jbkp.commcellId AND jds.dataType = 6
AND (jds.disabled & 256) = 0
	INNER JOIN @tblAppIds App ON jobList.appId = App.appId AND App.IsIndexingV2Enabled = 0
	/*
		We can ignore incr jobs from list #incrJobsWithCatalogInCurrentCycle as we don't need to look for full jobs for them
		Note that #fullIncrMap maps full jobs with incremental jobs that do not have any previously cataloged job in their cycle and differential jobs
	*/
	INSERT INTO #fullIncrMap
	SELECT incrJobId , incrJobCCId , fullJobId , fullJobCCId, fullJobArchGroupId, 0, appId, bkpLevel, fullCycleNum, servStartDate, isFullBackUpSnapJob
	FROM
	(
	SELECT a.jobId as incrJobId, a.commcellId as incrJobCCId, b.jobId as fullJobId, b.commcellId as fullJobCCId, b.dataArchGrpId as fullJobArchGroupId,
	b.appId, b.bkpLevel, b.fullCycleNum, b.servStartDate, (CASE WHEN b.opType IN (59, 65) /*SNAPBACKUP , SNAPBACKUP3RD*/ THEN 1 ELSE 0 END) as isFullBackUpSnapJob,
	row_number() OVER (partition by a.JobId, a.commcellId order by b.servStartDate asc) as rn
	FROM #tempJobIds a inner join JMBkpStats b WITH (NOLOCK) ON a.fullCycleNum = b.fullCycleNum AND a.appId = b.appId
	AND b.bkpLevel & @FULL_BITS <> 0 AND a.bkpLevel & @FULL_BITS = 0 AND b.status IN (1, 3, 14)
	left outer join #incrJobsWithCatalogInCurrentCycle d ON a.jobId = d.jobId AND a.commcellId = d.commcellId
	INNER JOIN @tblAppIds App ON a.appId = App.appId AND App.IsIndexingV2Enabled = 0
	WHERE d.jobId is null
	AND		a.isVSAV2Parent = 0
	) C
	WHERE rn = 1
	UPDATE #fullIncrMap SET sourceCopyId = CASE WHEN PROP.SourceCopyId > 0 THEN PROP.SourceCopyId ELSE AG.defaultSnapCopy END
FROM #fullIncrMap T INNER JOIN ArchDeferredCatalogProp PROP WITH(NOLOCK) ON T.fullJobArchGroupId = PROP.ArchGroupId
	INNER JOIN ArchGroup AG WITH(NOLOCK) ON PROP.ArchGroupId = AG.id
	DELETE #fullIncrMap
	FROM #fullIncrMap a left outer join JMJobDataStats jds WITH (NOLOCK)
	ON a.fullJobId = jds.jobId AND a.fullJobCCId = jds.commcellId
	AND jds.archGrpCopyId = a.sourceCopyId
AND jds.status IN (100, 101, 102, 103) AND jds.disabled & (256) = 0
left outer join JMJobSnapDeferredCatalogStats J WITH(NOLOCK) ON a.fullJobId = J.jobId AND a.fullJobCCId = J.commcellId
WHERE jds.jobId is null AND (J.jobId is null OR J.catalogStatus IN (101, 102, 103)) AND a.isFullBackUpSnapJob = 1
	/*
	For deferred catalog if we find the full jobs are already cataloged but we still have them in #fullIncrMap
	that means we did not find catalog for any previous jobs in cycle for those incremental in the source copy (either valid or marked for auxcopy) but still the full job
	is cataloged. So the catalog is either aged or done in another copy and not marked for auxcopy. We'll skip such incremental jobs as we don't see a possibility of
	any previous job in cycle getting catalog in current source copy for catalog
	Note: This can be done only for incrementals not differentials
	DELETE #fullIncrMap
	FROM #fullIncrMap a inner join JMJobDataStats jds WITH (NOLOCK)
ON a.fullJobId = jds.jobId AND a.fullJobCCId = jds.commcellId AND jds.dataType = 6
	inner join #tempJobIds c
	ON a.incrJobId = c.jobId AND a.incrJobCCId = c.commcellId
	WHERE c.bkpLevel & @DIFFERENTIAL_BIT = 0
	*/
	-- Do not fail for VSA V2 parent jobs without corresponding Full. Its not required
	DELETE #tempJobIds
	FROM #tempJobIds a
	INNER JOIN @tblAppIds App ON a.appId = App.appId AND App.IsIndexingV2Enabled = 0
	left outer join #fullIncrMap b
	ON a.jobId = b.incrJobId AND a.commcellId = b.incrJobCCId
	left outer join #incrJobsWithCatalogInCurrentCycle c
	ON a.jobId = c.jobId AND a.commcellId = c.commcellId
	WHERE b.fullJobId is null AND a.bkpLevel & @FULL_BITS = 0
	AND 	c.jobId is null
	AND		a.isVSAV2Parent = 0
	IF	@@ROWCOUNT > 0 AND @retVal = 0
	BEGIN
SET @retVal = 118
	END
	--delete the jobs for deleted subclients
	DELETE #tempJobIds
	FROM #tempJobIds t LEFT JOIN APP_Application aa WITH (NOLOCK) ON t.appId = aa.id
WHERE aa.id IS NULL OR (aa.subclientStatus & 0x00004 > 0)
	IF	@@ROWCOUNT > 0 AND @retVal = 0
	BEGIN
SET @retVal = 199
	END
	/*If deferred catalog let us make sure the full job that we are going to pick doesn't have bcd index already*/
	INSERT INTO #tempJobIds
	SELECT a.fullJobId, a.fullJobCCId, a.appId, a.bkpLevel, a.fullCycleNum, a.startDate, 1, 0, fullJobArchGroupId, 0
FROM #fullIncrMap a	left outer join JMJobDataStats jds WITH (NOLOCK) ON a.fullJobId = jds.jobId AND a.fullJobCCId = jds.commcellId AND jds.dataType = 6
	WHERE jds.jobId is null AND a.isFullBackUpSnapJob = 1
	IF EXISTS(SELECT 1 FROM #tempJobIds WHERE hasSource = 0 AND isForeignSnap = 0 AND isVSAV2Parent = 0) AND @retVal = 0
	BEGIN
SET @retVal = 120
	END
	--Migrated jobs belonging to simpana commcell are not supported for backup copy and deferred catalog
	DELETE #tempJobIds
	FROM #tempJobIds a inner join App_Commcell b
ON a.CommCellId = b.id AND a.CommCellId > 2 AND b.type = 1
	IF	@@ROWCOUNT > 0 AND @retVal = 0
	BEGIN
SET @retVal = 122
	END
	BEGIN TRY
	BEGIN TRAN
UPDATE	JMJobSnapDeferredCatalogStats
	SET		disabled = (J.disabled & ~1)
FROM	JMJobSnapDeferredCatalogStats J, #tempJobIds T
	WHERE	J.jobId = T.jobId AND J.commCellId = T.commCellId
		--AND J.archGrpId = @i_archGroupId
		AND (J.disabled & 1) = 1
		AND (T.hasSource = 1 OR isForeignSnap = 1)
	DELETE	#tempJobIds
FROM	JMJobSnapDeferredCatalogStats J, #tempJobIds T
	WHERE	J.jobId = T.jobId AND J.commCellId = T.commCellId
		--AND J.archGrpId = @i_archGroupId
INSERT INTO JMJobSnapDeferredCatalogStats
	SELECT	DISTINCT jobId, commCellId, 101, 0, 0, appId, archGroupId, 0, 0
	FROM	#tempJobIds
	WHERE	hasSource = 1 OR isForeignSnap = 1
	COMMIT TRAN
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    ROLLBACK TRAN
    SET @retVal = ERROR_NUMBER()
    END CATCH
END
SELECT	@retVal
IF OBJECT_ID('tempdb.dbo.#tempJobIds') is not null DROP TABLE #tempJobIds
IF OBJECT_ID('tempdb.dbo.#fullIncrMap') is not null DROP TABLE #fullIncrMap
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archDeferredCatalogPickJobs')
	delete from GxQscripts where name = 'archDeferredCatalogPickJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeferredCatalogPickJobs')
	delete from GXDBVersions where aliasname = 'archDeferredCatalogPickJobs'
GO

insert into GXDBVersions values(2, 'archDeferredCatalogPickJobs',  '00010001005400040000', 'archDeferredCatalogPickJobs', '00010001005400040000')
GO

