

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archDeferredCatalogPickByPolicy.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  archDeferredCatalogPickByPolicy.sp                         */
/*                                                                            */
/*  Description :  Picks snap jobs in policy for deferred catalog             */
/*																			  */
/*  Author      :  Praveen                                                    */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archDeferredCatalogPickByPolicy.sp,v $ $Id: archDeferredCatalogPickByPolicy.sp,v 1.1.54.3 2018/10/13 06:17:45 hkapadia Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archDeferredCatalogPickByPolicy')
BEGIN
	print '>>> Drop Stored Procedure: archDeferredCatalogPickByPolicy <<<'
	drop procedure archDeferredCatalogPickByPolicy
END
IF EXISTS (select * from GxQscripts where name='archDeferredCatalogPickByPolicy')
	delete from GxQscripts where name = 'archDeferredCatalogPickByPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeferredCatalogPickByPolicy')
	delete from GXDBVersions where aliasname = 'archDeferredCatalogPickByPolicy'
GO
print '... Creating Procedure: archDeferredCatalogPickByPolicy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archDeferredCatalogPickByPolicy
  @i_archGroupId integer,
  @i_today integer,
  @i_order integer
AS
  DECLARE @r_appId integer;
  DECLARE @r_jobId integer;
  DECLARE @r_commCellId integer;
  DECLARE @r_startDate integer;
  DECLARE @r_selected integer;
SET NOCOUNT ON
DECLARE	@FULL_BITS		INT
SET		@FULL_BITS		= (1+64+128+1024+32768)
DECLARE @DIFFERENTIAL_BIT INT
SET @DIFFERENTIAL_BIT = 4
DECLARE @EX_FULL_JOB_IN_CYCLE		BIGINT											-- JMBKP_EX_FULL_JOB_IN_CYCLE
SET			@EX_FULL_JOB_IN_CYCLE   = 0x10000000000000
DECLARE @EX_APPAWARE_CHILD_JOB	 BIGINT											-- JMBKP_EX_APPAWARE_CHILD_JOB
SET			@EX_APPAWARE_CHILD_JOB   = 0x20000000000000
DECLARE	@l_enabled		INT
DECLARE	@l_type			INT
DECLARE	@l_flags		INT
DECLARE	@l_startTime	INT
DECLARE	@l_sourceCopyId	INT
DECLARE	@l_numPeriod	INT
DECLARE	@l_dayNumber	INT
DECLARE	@l_currPeriodBegin	INT
DECLARE	@l_currPeriodEnd	INT
DECLARE	@l_prevPeriodBegin	INT
DECLARE	@l_nextPeriodEnd	INT
DECLARE	@l_clientId		INT
DECLARE @l_operationType INT
CREATE TABLE #App (appId INT, clientId INT, startDate INT, fullCycleNum INT, selected INT)
CREATE CLUSTERED INDEX Idx_App_AppId ON #App(appId)
CREATE TABLE #notSelectedJob (appId INT, jobId INT, commCellId INT, bkpLevel INT, startDate INT, fullCycleNum INT, selected INT, TimeZone VARCHAR(255))
CREATE CLUSTERED INDEX Idx_NotSelectedJob_jobId_commCellId ON #notSelectedJob (jobId, commcellId)
IF object_id('tempdb.dbo.#archGroupToAppId') is not null DROP TABLE #archGroupToAppId
CREATE TABLE #archGroupToAppId (
archGroupId			INTEGER,
AppId				INTEGER
)
CREATE CLUSTERED INDEX idx_archGroupToAppId ON #archGroupToAppId (archGroupId,AppId)
-- Check for selective subclient association for Deferred Catalog
SET @l_operationType = 2
SET @l_enabled = 0
SELECT	@l_enabled = enabled, @l_type = type, @l_flags = flags, @l_startTime = startTime,
		@l_sourceCopyId = sourceCopyId, @l_numPeriod = numPeriod, @l_dayNumber = dayNumber,
		@l_currPeriodBegin = currPeriodBegin, @l_currPeriodEnd = currPeriodEnd,
		@l_prevPeriodBegin = prevPeriodBegin, @l_nextPeriodEnd = nextPeriodEnd
FROM	ArchDeferredCatalogProp WITH (NOLOCK)
WHERE	archGroupId = @i_archGroupId
IF	@l_enabled = 0 OR @l_type = 9 OR @l_startTime > @i_today
	GOTO OUTPUT_EXIT
IF	@l_sourceCopyId <= 0
	SELECT	@l_sourceCopyId = defaultSnapCopy FROM archGroup WITH (NOLOCK) WHERE id = @i_archGroupId
INSERT INTO #App
SELECT	B.appId, 0, MAX(B.servStartDate), MAX(B.fullCycleNum), 0
FROM	JMBkpStats B WITH (NOLOCK),
		(SELECT	MAX(jobId) AS jobId, commCellId, appId
FROM	JMJobSnapDeferredCatalogStats WITH (NOLOCK)
		WHERE	archGrpId = @i_archGroupId
		GROUP BY commCellId, appId) A
WHERE	B.jobId = A.jobId AND B.commCellId = A.commCellId
GROUP BY B.appId
--Do not pick VSA V2 parent jobs based on rules. Pick them if any child VM is picked.
--For AppAware App backups, pick only the Full jobs that are associated to VSA Full jobs
INSERT INTO #notSelectedJob
SELECT	B.appId, B.jobId, B.commCellId, B.bkpLevel, B.servStartDate, B.fullCycleNum, 0, ''
FROM	JMBkpStats B WITH (NOLOCK) LEFT OUTER JOIN #App A
	ON	B.appId = A.appId
WHERE	B.dataArchGrpId = @i_archGroupId AND B.status IN (1, 3, 14) AND B.opType IN (59, 65) AND B.servStartDate > @l_startTime
	AND (
(@l_type = 0)
				OR
				((B.bkpAttributesEx & @EX_APPAWARE_CHILD_JOB = 0) AND ((B.bkpLevel & @FULL_BITS <> 0) OR (dbo.GetBkpLevelOfSnapJobs(B.JobId, B.CommCellId, @l_sourceCopyId) = 1)))
				OR
				((B.bkpAttributesEx & @EX_APPAWARE_CHILD_JOB > 0) AND (B.bkpAttributesEx & @EX_FULL_JOB_IN_CYCLE > 0))
			)
	AND (A.appId IS NULL OR B.servStartDate > A.startDate)
	AND NOT EXISTS (SELECT JDL.parentJobId
									FROM JMJobDataLink JDL WITH (NOLOCK)
									WHERE JDL.parentJobId = B.jobId
									AND		JDL.commCellId = B.commCellId
AND		JDL.linkType = 7
								 )
	--Delayed catalog is not supported on all appTypes
	AND dbo.IsDeferredCatalogSupported(B.appId) > 0
DECLARE @tblAppIds table(appId int, isIndexingV2Enabled int)
INSERT INTO @tblAppIds
SELECT DISTINCT JBKP.appId, 0
FROM #notSelectedJob J inner join JMBkpStats JBKP WITH(NOLOCK) ON J.jobId = JBKP.jobId AND J.CommcellId = JBKP.CommcellId
UPDATE @tblAppIds SET isIndexingV2Enabled = dbo.IsIndexingV2Enabled(0, 0, appId)
--If deferred catalog do not consider jobs that have bcd index created already for V1
DELETE #notSelectedJob
FROM #notSelectedJob J inner join ArchFile AF WITH(NOLOCK) ON J.jobId = AF.jobId AND J.commcellId = AF.commcellId AND AF.fileType = 6
INNER JOIN @tblAppIds App ON AF.appId = App.appId
WHERE App.isIndexingV2Enabled = 0
--Be it V1 or V2 do not process jobs that are already processed for deferred catalog successfully
DELETE #notSelectedJob
FROM #notSelectedJob J inner join JMJobSnapDeferredCatalogStats JS WITH(NOLOCK) ON J.jobId = JS.jobId AND J.commcellId = JS.commcellId AND JS.CatalogStatus = 100
--This is to not process jobs for deferred catalog if the catalog was not skipped during backup. This is to handle the case when subclient is V2 but has jobs run before enabling deferred catalog hence has catalog already created
DELETE #notSelectedJob
FROM #notSelectedJob J inner join JMBkpStats JBKP WITH(NOLOCK) ON J.jobId = JBKP.jobId AND J.commcellId = JBKP.commcellId AND JBKP.bkpAttributes & 0x200000000000000 = 0 --#define JMBKP_SKIP_CATALOG_PHASE_SNAP_BKUP  0x200000000000000LL
IF EXISTS (SELECT 1 FROM archGroupToApp WITH (NOLOCK) WHERE archGroupId = @i_archGroupId AND OperationType = @l_operationType AND assocType <> 2 )
BEGIN
	INSERT INTO #archGroupToAppId
	SELECT DISTINCT @i_archGroupId, T.appId
	FROM #notSelectedJob T
	exec archGetArchGroupToAppAssociations @i_archGroupId, @l_operationType
	DELETE	#notSelectedJob
	FROM #notSelectedJob SJ LEFT JOIN #archGroupToAppId t ON t.archGroupId = @i_archGroupId AND SJ.appId = t.AppId
	WHERE  	t.AppId IS NULL
END
-- Go to set CI flag if it's for all backups or for all full backups
IF	@l_type = 0 OR @l_type = 1 AND @l_numPeriod = 1
BEGIN
IF (@l_type <> 0)
	BEGIN
		DELETE #notSelectedJob
		FROM #notSelectedJob a left outer join JMJobDataStats jds WITH (NOLOCK)
		ON a.jobId = jds.jobId AND a.commcellId = jds.commcellId
		AND jds.archGrpCopyId = @l_sourceCopyId
		AND jds.status IN (100, 101, 102, 103) AND jds.disabled & (1+256) = 0
		WHERE jds.jobId is null
		/*
		For backup copy both incremental and differential has dependency with full in the cycle.
		For deferred catalog incrementals need any previous job in the cycle with catalog.
		For deferred catalog differentials have dependency with full in the cycle.
		*/
		IF(OBJECT_ID('tempdb.dbo.#fullIncrMap') is not null)
			DROP TABLE #fullIncrMap
		CREATE TABLE #fullIncrMap (incrJobId int, incrJobCCId int, fullJobId int, fullJobCCId int, fullJobArchGroupId int, sourceCopyId int, appId int, bkpLevel int, fullCycleNum int, servStartDate int, isFullBackUpSnapJob int)
		CREATE INDEX Idx_fullIncrMap_fullJobId_fullJobCCId ON #fullIncrMap(fullJobId, fullJobCCId)
		CREATE INDEX Idx_fullIncrMap_incrJobId_incrJobCCId ON #fullIncrMap(incrJobId, incrJobCCId)
		IF(OBJECT_ID('tempdb..#incrJobsWithCatalogInCurrentCycle') is not null)
			DROP TABLE #incrJobsWithCatalogInCurrentCycle
		CREATE TABLE #incrJobsWithCatalogInCurrentCycle (jobId int, commcellId int, primary key(jobId, commcellId))
		/*
		If deferred catalog get the list of incremental jobs that have a previous job in the cycle cataloged already (don't include differential jobs)
		While finding corresponding full jobs in the cycle for incremental jobs we can ignore jobs from this list
		*/
		INSERT INTO #incrJobsWithCatalogInCurrentCycle
		SELECT distinct jobList.jobId, jobList.commcellId
		FROM #notSelectedJob jobList inner join JMBkpStats jbkp WITH(NOLOCK)
		ON jobList.appId = jbkp.appId AND jobList.fullCycleNum = jbkp.fullCycleNum AND jbkp.servStartDate < jobList.startDate AND jbkp.status in (1, 3, 14)
		AND jobList.bkpLevel & @FULL_BITS = 0 AND jobList.bkpLevel & @DIFFERENTIAL_BIT = 0
		inner join JMJobDataStats jds WITH (NOLOCK) ON
jds.jobId = jbkp.jobId AND jds.commcellId = jbkp.commcellId AND jds.dataType = 6
AND (jds.disabled & 256) = 0
		INNER JOIN @tblAppIds App ON jobList.appId = App.appId AND App.IsIndexingV2Enabled = 0
		/*
		We can ignore incr jobs from list #incrJobsWithCatalogInCurrentCycle as we don't need to look for full jobs for them
		Note that #fullIncrMap maps full jobs with incremental jobs that do not have any previously cataloged job in their cycle and differential jobs
		*/
		INSERT INTO #fullIncrMap
		SELECT incrJobId , incrJobCCId , fullJobId , fullJobCCId, fullJobArchGroupId, 0, appId, bkpLevel, fullCycleNum, servStartDate, isFullBackUpSnapJob
		FROM
		(
		SELECT a.jobId as incrJobId, a.commcellId as incrJobCCId, b.jobId as fullJobId, b.commcellId as fullJobCCId, b.dataArchGrpId as fullJobArchGroupId,
		b.appId, b.bkpLevel, b.fullCycleNum, b.servStartDate, (CASE WHEN b.opType IN (59, 65) /*SNAPBACKUP , SNAPBACKUP3RD*/ THEN 1 ELSE 0 END) as isFullBackUpSnapJob,
		row_number() OVER (partition by a.JobId, a.commcellId order by b.servStartDate asc) as rn
		FROM #notSelectedJob a inner join JMBkpStats b WITH (NOLOCK) ON a.fullCycleNum = b.fullCycleNum AND a.appId = b.appId
		AND b.bkpLevel & @FULL_BITS <> 0 AND a.bkpLevel & @FULL_BITS = 0 AND b.status IN (1, 3, 14)
		left outer join #incrJobsWithCatalogInCurrentCycle d ON a.jobId = d.jobId AND a.commcellId = d.commcellId
		INNER JOIN @tblAppIds App ON a.appId = App.appId AND App.IsIndexingV2Enabled = 0
		WHERE d.jobId is null
		) C
		WHERE rn = 1
		UPDATE #fullIncrMap SET sourceCopyId = CASE WHEN PROP.SourceCopyId > 0 THEN PROP.SourceCopyId ELSE AG.defaultSnapCopy END
FROM #fullIncrMap T INNER JOIN ArchDeferredCatalogProp PROP WITH(NOLOCK) ON T.fullJobArchGroupId = PROP.ArchGroupId
		INNER JOIN ArchGroup AG WITH(NOLOCK) ON PROP.ArchGroupId = AG.id
		DELETE #fullIncrMap
		FROM #fullIncrMap a left outer join JMJobDataStats jds WITH (NOLOCK)
		ON a.fullJobId = jds.jobId AND a.fullJobCCId = jds.commcellId
		AND jds.archGrpCopyId = a.sourceCopyId
AND jds.status IN (100, 101, 102, 103) AND jds.disabled & (256) = 0
left outer join JMJobSnapDeferredCatalogStats J WITH(NOLOCK) ON a.fullJobId = J.jobId AND a.fullJobCCId = J.commcellId
        WHERE jds.jobId is null AND J.jobId is null AND a.isFullBackUpSnapJob = 1
		/*
		For deferred catalog if we find the full jobs are already cataloged but we still have them in #fullIncrMap
		that means we did not find catalog for any previous jobs in cycle for those incremental in the source copy (either valid or marked for auxcopy) but still the full job
		is cataloged. So the catalog is either aged or done in another copy and not marked for auxcopy. We'll skip such incremental jobs as we don't see a possibility of
		any previous job in cycle getting catalog in current source copy for catalog
		Note: This can be done only for incrementals not differentials
		DELETE #fullIncrMap
		FROM #fullIncrMap a inner join JMJobDataStats jds WITH (NOLOCK)
ON a.fullJobId = jds.jobId AND a.fullJobCCId = jds.commcellId AND jds.dataType = 6
		inner join #notSelectedJob c
		ON a.incrJobId = c.jobId AND a.incrJobCCId = c.commcellId
		WHERE c.bkpLevel & @DIFFERENTIAL_BIT = 0
		*/
		DELETE #notSelectedJob
		FROM #notSelectedJob a
		INNER JOIN @tblAppIds App ON a.appId = App.appId AND App.IsIndexingV2Enabled = 0
		left outer join #fullIncrMap b
		ON a.jobId = b.incrJobId AND a.commcellId = b.incrJobCCId
		left outer join #incrJobsWithCatalogInCurrentCycle c
		ON a.jobId = c.jobId AND a.commcellId = c.commcellId
		WHERE b.fullJobId is null AND a.bkpLevel & @FULL_BITS = 0
		AND c.jobId is null
		INSERT INTO #notSelectedJob
		SELECT a.appId, a.fullJobId, a.fullJobCCId, a.bkpLevel, a.servStartDate, a.fullCycleNum, 0, ''
FROM #fullIncrMap a left outer join JMJobSnapDeferredCatalogStats b WITH (NOLOCK) ON a.fullJobId = b.jobId AND a.fullJobCCId = b.commcellId-- AND archGrpId = @i_archGroupId
left outer join JMJobDataStats jds WITH (NOLOCK) ON a.fullJobId = jds.jobId AND a.fullJobCCId = jds.commcellId AND jds.dataType = 6
		WHERE b.jobId is null AND a.isFullBackUpSnapJob = 1
		AND jds.jobId is null
		DROP TABLE #fullIncrMap
		DROP TABLE #incrJobsWithCatalogInCurrentCycle
	END
	--Migrated jobs belonging to simpana commcell are not supported for backup copy and deferred catalog
	DELETE #notSelectedJob
	FROM #notSelectedJob A inner join App_Commcell B
ON A.commcellId = B.id AND B.type = 1 AND A.commcellId > 2
--Pick VSA V2 Parent jobs if any corresponding VM jobs are picked and parent is not already picked
INSERT INTO #notSelectedJob
SELECT DISTINCT B.appId, B.jobId, B.commCellId, B.bkpLevel, B.servStartDate, B.fullCycleNum, 0, ''
FROM	JMBkpStats B WITH (NOLOCK) LEFT OUTER JOIN #App A
	ON	B.appId = A.appId
LEFT OUTER JOIN JMJobSnapDeferredCatalogStats JS WITH (NOLOCK)
	ON B.jobId = JS.jobId
	AND B.commcellId = JS.commcellId
	INNER JOIN JMJobDataLink JDL WITH (NOLOCK)
	ON 	JDL.parentJobId = B.jobId
	AND	JDL.commCellId = B.commCellId
AND	JDL.linkType = 7
	INNER JOIN #notSelectedJob T
	ON T.jobId = JDL.childJobId
	AND	T.commCellId = JDL.commCellId
WHERE	JS.jobId IS NULL	--just check for entry in JMJobSnapDeferredCatalogStats as if it was picked before and disabled for any reason then no need to re-pick them
	AND B.dataArchGrpId = @i_archGroupId AND B.status IN (1, 3, 14) AND B.opType IN (59, 65) -- AND B.servStartDate > @l_startTime --No need to check as this will be based on selected VM level jobs
AND @l_type = 0
	AND (A.appId IS NULL OR B.servStartDate > A.startDate)
INSERT INTO JMJobSnapDeferredCatalogStats
	SELECT	DISTINCT J.jobId, J.commCellId, 101, 0, 0, J.appId, J.archGrpId, 0, 0
FROM	JMJobDataStats J WITH (NOLOCK), #notSelectedJob S, ArchDeferredCatalogProp PROP WITH(NOLOCK), ArchGroup AG WITH(NOLOCK)
	WHERE	J.jobId = S.jobId AND J.commCellId = S.commCellId AND J.archGrpId = PROP.ArchGroupId AND J.archGrpId = AG.id
		AND ((J.archGrpCopyId = PROP.SourceCopyId) OR (PROP.SourceCopyId = 0 AND J.archGrpCopyId = AG.defaultSnapCopy))
		AND J.status IN (100, 101, 102, 103) AND J.disabled & (1+256) = 0
	TRUNCATE TABLE #notSelectedJob
END
IF	@l_type IN (10, 3, 2, 4, 6)
BEGIN
	INSERT INTO #notSelectedJob
	SELECT	B.appId, B.jobId, B.commCellId, B.bkpLevel, B.servStartDate, B.fullCycleNum, 1, ''
FROM	#App A, JMBkpStats B WITH (NOLOCK), JMJobSnapDeferredCatalogStats S WITH (NOLOCK)
	WHERE	B.appId = A.appId AND B.servStartDate = A.startDate
		AND S.jobId = B.jobId AND S.commCellId = B.commCellId
AND ((S.catalogStatus IN (101, 102, 103) AND S.disabled &( 1+256) = 0) OR S.catalogStatus = 100)
		AND NOT EXISTS (SELECT JDL.parentJobId
										FROM JMJobDataLink JDL WITH (NOLOCK)
										WHERE JDL.parentJobId = B.jobId
										AND		JDL.commCellId = B.commCellId
AND		JDL.linkType = 7
									 )
	--Migrated jobs belonging to simpana commcell are not supported for backup copy and deferred catalog
	DELETE #notSelectedJob
	FROM #notSelectedJob A inner join App_Commcell B
ON A.commcellId = B.id AND B.type = 1 AND A.commcellId > 2 AND A.selected = 0
	IF EXISTS (SELECT 1 FROM archGroupToApp WITH (NOLOCK) WHERE archGroupId = @i_archGroupId AND OperationType = @l_operationType AND assocType <> 2)
	BEGIN
		DELETE	#notSelectedJob
		FROM #notSelectedJob SJ LEFT JOIN #archGroupToAppId t ON t.archGroupId = @i_archGroupId AND SJ.appId = t.AppId
		WHERE  t.AppId IS NULL
	END
	DECLARE	@now			INT
	DECLARE	@l_TimeZoneType	INT
	DECLARE @l_TimeZone		VARCHAR(255)
	DECLARE @l_csTimeZone	VARCHAR(255)
	SET		@now = dbo.GetUnixTime(GETUTCDATE())
	SELECT	@l_TimeZoneType = TimeZoneType, @l_TimeZone = TimeZone
	FROM	archGroup WITH (NOLOCK)
	WHERE	id = @i_archGroupId
	IF	@l_TimeZoneType > 0
		SET @l_csTimeZone = dbo.GetClientTimeZone(2)
	IF	@l_TimeZoneType = 1
	BEGIN
		;WITH TempClientTZ_CTE (ClientId, TimeZone)
		AS
		(  SELECT T.clientId, dbo.ArchGroupTimeZone(@i_archGroupId, T.clientId) "TimeZone"
			FROM	(SELECT DISTINCT clientId FROM #App) T
		)
		UPDATE	#notSelectedJob
		SET		startDate = J.startDate + dbo.GetDiffFromCSTimeZone(J.startDate, C.TimeZone, @l_csTimeZone), TimeZone = C.TimeZone
		FROM	#notSelectedJob J, #App A, TempClientTZ_CTE C
		WHERE	J.appId = A.appId AND A.clientId = C.clientId AND C.TimeZone <> '' AND C.TimeZone <> @l_csTimeZone
	END
	ELSE
	IF	@l_TimeZoneType = 2 AND @l_TimeZone <> @l_csTimeZone
		UPDATE	#notSelectedJob
		SET		startDate = startDate + dbo.GetDiffFromCSTimeZone(startDate, @l_TimeZone, @l_csTimeZone), TimeZone = @l_TimeZone
IF (@l_flags & 4096) <> 0
	BEGIN
IF (@l_flags & 8192) = 0
		BEGIN
			DECLARE	@nextFullTime	INT
			DECLARE @t_appId		INT
			DECLARE @t_startDate	INT
			DECLARE @t_TimeZone		VARCHAR(255)
			DECLARE getLastFullJobsForApp CURSOR FOR
			SELECT	appId, MAX(startDate), TimeZone
			FROM	#notSelectedJob
			WHERE	selected = 0
			GROUP BY appId, TimeZone
			OPEN  getLastFullJobsForApp
			FETCH NEXT FROM getLastFullJobsForApp INTO @t_appId, @t_startDate, @t_TimeZone
			WHILE @@FETCH_STATUS = 0
			BEGIN
				DECLARE	@tblNextFullTime TABLE (nextFullTime int)
				INSERT	INTO @tblNextFullTime
				EXEC	@nextFullTime = TM_GetNextScheduleRunTime @t_appId, 1/*BkpLevel Full*/, 1/*counDisabled*/, 1/*countRunnigJob*/
				IF	@nextFullTime > 0 AND @t_TimeZone <> ''
					SET	@nextFullTime = @nextFullTime + dbo.GetDiffFromCSTimeZone(@nextFullTime, @t_TimeZone, @l_csTimeZone)
				IF (dbo.GetBkpLevelForSnapCopy(@t_appId, 2, @l_sourceCopyId) = 1)
				BEGIN
					DECLARE	@l_nextFullTimeForSnap INTEGER
					INSERT	INTO @tblNextFullTime
					EXEC @l_nextFullTimeForSnap = TM_GetNextScheduleRunTime @t_appId, 2/*BkpLevel Incr*/, 1/*counDisabled*/, 1/*countRunnigJob*/
					IF	@l_nextFullTimeForSnap > 0
						SET @l_nextFullTimeForSnap = @l_nextFullTimeForSnap + dbo.GetDiffFromCSTimeZone(@l_nextFullTimeForSnap, @t_TimeZone, @l_csTimeZone)
					IF (@l_nextFullTimeForSnap <> 0 AND (@l_nextFullTimeForSnap < @nextFullTime OR @nextFullTime = 0))
						SET @nextFullTime = @l_nextFullTimeForSnap
				END
				IF	@nextFullTime > 0 AND @nextFullTime < @l_prevPeriodBegin
				AND @t_startDate  < @l_prevPeriodBegin
					DELETE	FROM #notSelectedJob
					WHERE	appId = @t_appId
				ELSE
				IF	@nextFullTime >= @l_prevPeriodBegin AND @nextFullTime < @l_currPeriodBegin
				AND @t_startDate  >= @l_prevPeriodBegin AND @t_startDate  < @l_currPeriodBegin
					DELETE	FROM #notSelectedJob
					WHERE	appId = @t_appId AND startDate >= @l_prevPeriodBegin
				ELSE
				IF	@nextFullTime >= @l_currPeriodBegin AND @nextFullTime < @l_currPeriodEnd
				AND @t_startDate  >= @l_currPeriodBegin AND @t_startDate  < @l_currPeriodEnd
					DELETE	FROM #notSelectedJob
					WHERE	appId = @t_appId AND startDate >= @l_currPeriodBegin
				ELSE
				IF	@nextFullTime >= @l_currPeriodEnd AND @nextFullTime < @l_nextPeriodEnd
				AND @t_startDate  >= @l_currPeriodEnd AND @t_startDate  < @l_nextPeriodEnd
					DELETE	FROM #notSelectedJob
					WHERE	appId = @t_appId AND startDate >= @l_currPeriodEnd
				ELSE
				IF	@nextFullTime >= @l_nextPeriodEnd
				AND @t_startDate  >= @l_nextPeriodEnd
					DELETE	FROM #notSelectedJob
					WHERE	appId = @t_appId AND startDate >= @l_nextPeriodEnd
				FETCH NEXT FROM getLastFullJobsForApp INTO @t_appId, @t_startDate, @t_TimeZone
			END
			CLOSE getLastFullJobsForApp
			DEALLOCATE getLastFullJobsForApp
		END
		ELSE
		BEGIN
			CREATE	TABLE #ActiveFullStartDate (appId INT, startDate INT)
			INSERT	INTO #ActiveFullStartDate
			EXEC	MMS2startDateOfActiveBackupForApp @i_archGroupId
			UPDATE	#ActiveFullStartDate
			SET		startDate = A.startDate + dbo.GetDiffFromCSTimeZone(A.startDate, T.TimeZone, @l_csTimeZone)
			FROM	#ActiveFullStartDate A, (SELECT DISTINCT appId, TimeZone FROM #notSelectedJob WHERE TimeZone <> '') T
			WHERE	A.appId = T.appId
			DELETE	#notSelectedJob
			FROM	#notSelectedJob J, #ActiveFullStartDate A
			WHERE	J.appId = A.appId
				AND (	A.startDate <  @l_prevPeriodBegin AND J.startDate <  @l_prevPeriodBegin
					 OR	A.startDate >= @l_prevPeriodBegin AND J.startDate >= @l_prevPeriodBegin AND
						A.startDate <  @l_currPeriodBegin AND J.startDate <  @l_currPeriodBegin
					 OR A.startDate >= @l_currPeriodBegin AND J.startDate >= @l_currPeriodBegin AND
						A.startDate <  @l_currPeriodEnd   AND J.startDate <  @l_currPeriodEnd
					 OR A.startDate >= @l_currPeriodEnd   AND J.startDate >= @l_currPeriodEnd   AND
						A.startDate <  @l_nextPeriodEnd   AND J.startDate <  @l_nextPeriodEnd
					 OR	A.startDate >= @l_nextPeriodEnd   AND J.startDate >= @l_nextPeriodEnd)
			DROP	TABLE #ActiveFullStartDate
			DELETE	#notSelectedJob
			WHERE	startDate >= @l_prevPeriodBegin AND (@now + dbo.GetDiffFromCSTimeZone(@now, TimeZone, @l_csTimeZone)) < @l_currPeriodBegin
				OR	startDate >= @l_currPeriodBegin AND (@now + dbo.GetDiffFromCSTimeZone(@now, TimeZone, @l_csTimeZone)) < @l_currPeriodEnd
				OR	startDate >= @l_currPeriodEnd   AND (@now + dbo.GetDiffFromCSTimeZone(@now, TimeZone, @l_csTimeZone)) < @l_nextPeriodEnd
				OR	startDate >= @l_nextPeriodEnd
		END
	END
END
OUTPUT_EXIT:
-- Output for selective copies
IF	@i_order = 0
	SELECT	S.appId, S.jobId, S.commCellId, S.startDate, S.selected
	FROM	JMJobDataStats J WITH (NOLOCK), #notSelectedJob S
	WHERE	J.jobId = S.jobId AND J.commCellId = S.commCellId
		AND J.archGrpCopyId = @l_sourceCopyId
AND (S.selected = 1 OR J.status IN (100, 101, 102, 103) AND J.disabled&(1+256) = 0)
	GROUP BY S.appId, S.jobId, S.commCellId, S.startDate, S.selected
	ORDER BY S.appId ASC, S.jobId ASC
ELSE
	SELECT	S.appId, S.jobId, S.commCellId, S.startDate, S.selected
	FROM	JMJobDataStats J WITH (NOLOCK), #notSelectedJob S
	WHERE	J.jobId = S.jobId AND J.commCellId = S.commCellId
		AND J.archGrpCopyId = @l_sourceCopyId
AND (S.selected = 1 OR J.status IN (100, 101, 102, 103) AND J.disabled&(1+256) = 0)
	GROUP BY S.appId, S.jobId, S.commCellId, S.startDate, S.selected
	ORDER BY S.appId ASC, S.selected DESC, S.jobId DESC
DROP TABLE #App
DROP TABLE #notSelectedJob
IF object_id('tempdb.dbo.#archGroupToAppId') is not null DROP TABLE #archGroupToAppId
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archDeferredCatalogPickByPolicy')
	delete from GxQscripts where name = 'archDeferredCatalogPickByPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeferredCatalogPickByPolicy')
	delete from GXDBVersions where aliasname = 'archDeferredCatalogPickByPolicy'
GO

insert into GXDBVersions values(2, 'archDeferredCatalogPickByPolicy',  '00010001005400030000', 'archDeferredCatalogPickByPolicy', '00010001005400030000')
GO

