

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archDeferredCatalogCheckPickedJobs.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  archDeferredCatalogCheckPickedJobs.sp                      */
/*                                                                            */
/*  Author      :  Praveen Kumar Krishnan                                     */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archDeferredCatalogCheckPickedJobs.sp,v $ $Id: archDeferredCatalogCheckPickedJobs.sp,v 1.1.54.2 2018/10/13 06:17:42 hkapadia Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archDeferredCatalogCheckPickedJobs')
BEGIN
	print '>>> Drop Stored Procedure: archDeferredCatalogCheckPickedJobs <<<'
	drop procedure archDeferredCatalogCheckPickedJobs
END
IF EXISTS (select * from GxQscripts where name='archDeferredCatalogCheckPickedJobs')
	delete from GxQscripts where name = 'archDeferredCatalogCheckPickedJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeferredCatalogCheckPickedJobs')
	delete from GXDBVersions where aliasname = 'archDeferredCatalogCheckPickedJobs'
GO
print '... Creating Procedure: archDeferredCatalogCheckPickedJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archDeferredCatalogCheckPickedJobs
  @i_archGroupId integer
AS
  DECLARE @retVal INTEGER;
SET NOCOUNT ON
DECLARE	@l_sourceCopyId INT
SET		@l_sourceCopyId = 0
SET		@retVal = 0
SELECT	@l_sourceCopyId = sourceCopyId
FROM	ArchDeferredCatalogProp WITH (NOLOCK)
WHERE	archGroupId = @i_archGroupId
IF	@l_sourceCopyId = 0
	SELECT	@l_sourceCopyId = defaultSnapCopy
	FROM	archGroup WITH (NOLOCK)
	WHERE	id = @i_archGroupId
IF	@l_sourceCopyId = 0
SET @retVal = 80
ELSE
BEGIN
	if OBJECT_ID('tempdb.dbo.#tempJobIds') IS NOT NULL DROP TABLE #tempJobIds
	CREATE TABLE #tempJobIds(jobId int, commCellId int)
	CREATE CLUSTERED INDEX Idx_tempJobIds ON #tempJobIds (JobId, CommCellId)
	INSERT	INTO #tempJobIds
	SELECT	DISTINCT A.jobId, A.commCellId
FROM	JMJobSnapDeferredCatalogStats A WITH (NOLOCK) LEFT JOIN JMJobDataStats B WITH (NOLOCK)
		ON	A.jobId = B.jobId AND A.commCellId = B.commCellId
AND B.archGrpCopyId = @l_sourceCopyId AND B.status IN (100, 101, 102, 103) AND B.disabled & (1+256 ) = 0
	WHERE	B.jobId IS NULL
AND A.archGrpId = @i_archGroupId AND A.catalogStatus IN (101, 102, 103) AND A.disabled & 1 = 0
UPDATE	JMJobSnapDeferredCatalogStats
SET		disabled = (disabled | 1),
unPickReason = 6
FROM	JMJobSnapDeferredCatalogStats J, #tempJobIds T
	WHERE	J.jobId = T.jobId
		AND J.commCellId = T.commCellId
		AND J.archGrpId = @i_archGroupId
AND J.disabled & 1 = 0
	TRUNCATE TABLE #tempJobIds
	--Unpick Parent VSA V2 jobs if no child VMs are in picked state
	INSERT	INTO #tempJobIds
	SELECT	DISTINCT A.jobId, A.commCellId
FROM	JMJobSnapDeferredCatalogStats A WITH (NOLOCK), JMJobDataLink JDL WITH (NOLOCK)
	WHERE A.archGrpId = @i_archGroupId
AND 	A.catalogStatus IN (101, 102, 103)
AND 	A.disabled & 1 = 0
	AND		A.jobId = JDL.parentJobId
	AND		A.commCellId = JDL.commCellId
AND 	JDL.linkType = 7
	AND 	NOT EXISTS (SELECT SS.jobId
FROM JMJobSnapDeferredCatalogStats SS WITH (NOLOCK)
										WHERE SS.jobId = JDL.childJobId
										AND		SS.commCellId = JDL.commCellId
AND		SS.catalogStatus IN (101, 102, 103)
AND 	SS.disabled & 1 = 0
									)
UPDATE	JMJobSnapDeferredCatalogStats
SET		disabled = (disabled | 1),
unPickReason = 6
FROM	JMJobSnapDeferredCatalogStats J, #tempJobIds T
	WHERE	J.jobId = T.jobId
		AND J.commCellId = T.commCellId
		AND J.archGrpId = @i_archGroupId
AND J.disabled & 1 = 0
	DROP TABLE #tempJobIds
END
SELECT	@retVal
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archDeferredCatalogCheckPickedJobs')
	delete from GxQscripts where name = 'archDeferredCatalogCheckPickedJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeferredCatalogCheckPickedJobs')
	delete from GXDBVersions where aliasname = 'archDeferredCatalogCheckPickedJobs'
GO

insert into GXDBVersions values(2, 'archDeferredCatalogCheckPickedJobs',  '00010001005400020000', 'archDeferredCatalogCheckPickedJobs', '00010001005400020000')
GO

