

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archDeferredCatalogCheckJobValidity.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  archDeferredCatalogCheckJobValidity.sp                     */
/*                                                                            */
/*  Description :  Check validity of snap job before deferred catalog process */
/*																			  */
/*  Author      :  Praveen                                                    */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archDeferredCatalogCheckJobValidity.sp,v $ $Id: archDeferredCatalogCheckJobValidity.sp,v 1.1.54.4 2020/12/28 18:27:23 pkrishnan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archDeferredCatalogCheckJobValidity')
BEGIN
	print '>>> Drop Stored Procedure: archDeferredCatalogCheckJobValidity <<<'
	drop procedure archDeferredCatalogCheckJobValidity
END
IF EXISTS (select * from GxQscripts where name='archDeferredCatalogCheckJobValidity')
	delete from GxQscripts where name = 'archDeferredCatalogCheckJobValidity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeferredCatalogCheckJobValidity')
	delete from GXDBVersions where aliasname = 'archDeferredCatalogCheckJobValidity'
GO
print '... Creating Procedure: archDeferredCatalogCheckJobValidity'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archDeferredCatalogCheckJobValidity
  @i_jobId integer,
  @i_commCellId integer,
  @i_archGroupId integer
AS
  DECLARE @o_retCode INTEGER;
  DECLARE @o_validStatus INTEGER;
SET NOCOUNT ON
/*
o_validStatus  0 - Error,
							 1 - valid,
							 2 - job is unpicked or already backup copied,
							 3 - job to be processed is aged on source,
							 4 - job is incremental and the corresponding full of the cycle is not available (in primary copy for backup copy/in sourceCopy for deferred catalog)
							 5 - required operation not enabled on storage policy
							 6 - This is incremental and previous jobs in the same cycle are not available in the primary(classic) copy
							 7 - This job is to be cataloged/backup copied but we found a job later than this job already cataloged/backupcopied
							 8 - catalog/backup copy job is already running for this subclient
							 9 - subclient deconfigured
							 10 - VSA app aware child job. Parent is not moved yet
							 11 - VSA app aware child job. Parent job info not found in DB
							 12 - VSA app aware child job. Parent has not backed up the child VM successfully
							 13 - Max parallel backup copy jobs for the storage policy exceeded. Cannot submit any more backup copy jobs
							 14 - This job is to be cataloged/backup copied but we found an older job that is pending to be cataloged/backupcopied
*/
DECLARE @l_enabled int = 0
DECLARE @l_srcCopyId int = 0
DECLARE @l_bkpLevel int = 0
DECLARE @l_appType int = 0
DECLARE @l_fullCycleNum int = 0
DECLARE @l_appId int = 0
DECLARE @l_clientId int = 0
DECLARE @l_servStartDate int = 0
DECLARE @l_servEndDate int = 0
DECLARE @l_isVSAV2Parent int = 0
SET @o_retCode = 0
SET @o_validStatus = 1
SELECT @l_bkpLevel = bkpLevel, @l_appId = appId, @l_appType = appType, @l_fullCycleNum = fullCycleNum, @l_servStartDate = servStartDate, @l_servEndDate = servEndDate
FROM JMBkpStats WITH (NOLOCK) WHERE jobId = @i_jobId AND commcellId = @i_commcellId
SELECT @o_retCode = @@ERROR
IF @o_retCode <> 0
BEGIN
	SET @o_validStatus = 0
	GOTO RETURN_PROC
END
SELECT @l_clientId = clientId
FROM App_Application WITH (NOLOCK) WHERE id = @l_appId
SELECT @o_retCode = @@ERROR
IF @o_retCode <> 0
BEGIN
	SET @o_validStatus = 0
	GOTO RETURN_PROC
END
IF EXISTS (SELECT TOP 1 1
					 FROM JMJobDataLink J WITH (NOLOCK)
					 WHERE	J.parentAppId = @l_appId
AND		J.linkType IN (7, 8)
					)
BEGIN
	SET @l_isVSAV2Parent = 1
END
IF EXISTS ( SELECT * FROM JMJobInfo JI
			INNER JOIN JMBkpJobInfo BI ON BI.jobId = JI.jobId AND BI.commcellId = JI.commCellId
			WHERE BI.applicationId = @l_appId
			AND JI.subOpType = 96 -- DELAYEDCATALOG
		)
BEGIN
	SET @o_validStatus = 8
	GOTO RETURN_PROC
END
IF((SELECT subclientStatus&0x00002 FROM App_Application WITH (NOLOCK) WHERE id = @l_appId) > 0)
BEGIN
	SET @o_validStatus = 9
	GOTO RETURN_PROC
END
SELECT @l_srcCopyId = CASE WHEN sourceCopyId <> 0 THEN sourceCopyId ELSE (SELECT defaultSnapCopy FROM archGroup WITH (NOLOCK) WHERE id = @i_archGroupId) END,
@l_enabled = enabled
FROM ArchDeferredCatalogProp WITH (NOLOCK) WHERE archGroupId = @i_archGroupId
SELECT @o_retCode = @@ERROR
IF @o_retCode <> 0
BEGIN
	SET @o_validStatus = 0
	GOTO RETURN_PROC
END
IF @l_enabled = 0
BEGIN
	SET @o_validStatus = 5
	GOTO RETURN_PROC
END
IF NOT EXISTS (SELECT 1 FROM JMJobSnapDeferredCatalogStats WITH(NOLOCK) WHERE jobId = @i_jobId AND commcellId = @i_commCellId AND (disabled & 1) = 0 AND catalogStatus IN (101, 102, 103))
BEGIN
	SET @o_validStatus = 2
	GOTO RETURN_PROC
END
DECLARE @validAFTypes table(afType int)
INSERT @validAFTypes
SELECT dataType FROM JMJobDataStats WITH(NOLOCK)
WHERE jobId = @i_jobId AND commCellId = @i_commCellId
AND archGrpCopyId = @l_srcCopyId AND dataType IN (1, 4)
AND (disabled & 256 = 0)
SELECT @o_retCode = @@ERROR
IF @o_retCode <> 0
BEGIN
	SET @o_validStatus = 0
	GOTO RETURN_PROC
END
IF NOT EXISTS(SELECT 1 FROM @validAFTypes)
BEGIN
UPDATE JMJobSnapDeferredCatalogStats SET disabled = disabled | 1, unPickReason = 6
WHERE jobId = @i_jobId AND commcellId = @i_commcellId AND catalogStatus IN (101, 102, 103) AND (disabled & 1) = 0
	SET @o_validStatus = 3
	GOTO RETURN_PROC
END
IF @l_bkpLevel NOT IN (1, 64, 128, 1024, 32768) --It is an incremental
BEGIN
	/*
	--If it is backup copy matDestCopy is the copy to which we are going copy the snap job else if it is deferred catalog it is the copy on which the catalog is going to be created
	DECLARE @matDestCopy int
	SET @matDestCopy = @l_srcCopyId
	SELECT @o_retCode = @@ERROR
	IF @o_retCode <> 0
	BEGIN
		SET @o_validStatus = 0
		GOTO RETURN_PROC
	END
    */
	DECLARE @fullJobId int = 0
	DECLARE @fullJobCCId int = 0
	DECLARE @isFullBackUpSnapJob int = 0
	SELECT  top 1 @fullJobId = a.jobId, @fullJobCCId = a.commcellId, @isFullBackUpSnapJob = CASE WHEN a.opType IN (59, 65) /*SNAPBACKUP , SNAPBACKUP3RD*/ THEN 1 ELSE 0 END
	FROM JMBkpStats a WITH(NOLOCK) INNER JOIN JMBkpStats b WITH(NOLOCK) ON b.jobId = @i_jobId AND b.commcellId = @i_commcellId AND a.appId = b.appId
	AND a.fullCycleNum = b.fullCycleNum AND a.status IN (1, 3, 14) AND a.bkpLevel IN (1, 64, 128, 1024, 32768) ORDER BY a.servStartDate
	SELECT @o_retCode = @@ERROR
	IF @o_retCode <> 0
	BEGIN
		SET @o_validStatus = 0
		GOTO RETURN_PROC
	END
	--If it is deferred catalog and incremental the source for catalog should have any previous job in same cycle already cataloged and not-aged
	--If it is deferred catalog and differential the source for catalog should have corresponding full in same cycle already cataloged and not-aged
	/*enum CVBkpLevel{ DIFFERENTIAL = 0x4,*/
	IF(dbo.IsIndexingV2Enabled(0, 0, @l_appId) = 0)
	BEGIN
		IF (@l_bkpLevel <> 4 AND NOT EXISTS(
					SELECT 1 FROM JMJobDataStats jds WITH(NOLOCK) INNER JOIN JMBkpStats jbkp WITH (NOLOCK)
					ON jds.jobId = jbkp.jobId AND jds.commcellId = jbkp.commcellId AND jbkp.fullCycleNum = @l_fullCycleNum AND jbkp.appId = @l_appId AND jbkp.servStartDate < @l_servStartDate
AND jbkp.status IN (1, 3, 14) AND jds.dataType = 6	AND (jds.disabled & 256) = 0 AND jds.status = 100
					))
					OR
					(@l_bkpLevel = 4 AND NOT EXISTS(
					SELECT 1 FROM JMJobDataStats WITH(NOLOCK) WHERE jobId = @fullJobId AND commcellId = @fullJobCCId
AND dataType = 6
AND (disabled & 256) = 0 AND status = 100
					))
		BEGIN
			--If fulljob is disabled for catalog then disable the incr/differential job too
	        --If full job is already cataloged but we did not find a valid catalog disable the incr/differential job too
			IF @isFullBackUpSnapJob = 0
			OR
EXISTS (SELECT 1 FROM JMJobSnapDeferredCatalogStats WITH(NOLOCK) WHERE jobId = @fullJobId AND commcellId = @fullJobCCId AND (disabled & 1) = 1)
			OR
EXISTS (SELECT 1 FROM JMJobSnapDeferredCatalogStats WITH(NOLOCK) WHERE jobId = @fullJobId AND commcellId = @fullJobCCId AND catalogStatus = 100)
			BEGIN
UPDATE JMJobSnapDeferredCatalogStats SET disabled = disabled | 1, unPickReason = 5
WHERE jobId = @i_jobId AND commcellId = @i_commcellId AND catalogStatus IN (101, 102, 103) AND (disabled & 1) = 0
			END
			SET @o_validStatus = 4
			GOTO RETURN_PROC
		END
	END
END
--When backup copying\cataloging a job there cannot be a job that is older than this and pending to be backup copied\cataloged
--Skip this check for VSA V2 parent jobs
IF (@l_isVSAV2Parent = 0
		AND
		EXISTS(
						SELECT 1
						FROM JMBkpStats JBKP1 WITH (NOLOCK) INNER JOIN JMBkpStats JBKP2 WITH (NOLOCK)
						ON 	JBKP1.jobId = @i_jobId
						AND JBKP1.commCellId = @i_commCellId
						AND JBKP1.appId =JBKP2.appId
						AND jbkp1.servStartDate > JBKP2.servStartDate
						AND JBKP2.status IN (1, 3, 14)
INNER JOIN JMJobSnapDeferredCatalogStats JSS WITH (NOLOCK)
						ON 	JSS.jobId = JBKP2.jobId
						AND JSS.commcellId = JBKP2.commcellId
						AND JSS.appId = JBKP2.appId
AND JSS.catalogStatus IN (101, 102, 103)
						AND JSS.disabled & 1 = 0
				)
)
BEGIN
	SET @o_validStatus = 14
	GOTO RETURN_PROC
END
--When cataloging a job there cannot be a job that is newer than this and cataloged already(be it deferrred or during backup). Here by catalog we mean the regular index too
IF(dbo.IsIndexingV2Enabled(0, 0, @l_appId) = 0)
BEGIN
	IF EXISTS(
				SELECT 1 FROM JMBkpStats jbkp1 WITH (NOLOCK) INNER JOIN JMBkpStats jbkp2 WITH (NOLOCK)
						ON jbkp1.jobId = @i_jobId AND jbkp1.commCellId = @i_commCellId AND jbkp2.appId =jbkp1.appId AND jbkp2.servStartDate > jbkp1.servStartDate AND jbkp2.status IN (1, 3, 14)
INNER JOIN ArchFile AF WITH (NOLOCK) ON AF.jobId = jbkp2.jobId AND AF.commcellId = jbkp2.commcellId AND (AF.fileType = 6 OR  (AF.fileType = 2 AND AF.flags & 4 = 0)) AND AF.isValid = 1
				)
	BEGIN
UPDATE JMJobSnapDeferredCatalogStats SET disabled = disabled | 1, unPickReason = 8
WHERE jobId = @i_jobId AND commcellId = @i_commcellId AND catalogStatus IN (101, 102, 103) AND (disabled & 1) = 0
		SET @o_validStatus = 7
		GOTO RETURN_PROC
	END
END
ELSE
BEGIN
	IF EXISTS(
				SELECT 1 FROM JMBkpStats jbkp1 WITH (NOLOCK) INNER JOIN JMBkpStats jbkp2 WITH (NOLOCK)
						ON jbkp1.jobId = @i_jobId AND jbkp1.commCellId = @i_commCellId AND jbkp2.appId =jbkp1.appId AND jbkp2.servStartDate > jbkp1.servStartDate AND jbkp2.status IN (1, 3, 14)
						INNER JOIN ArchFile AF WITH (NOLOCK) ON AF.jobId = jbkp2.jobId AND AF.commcellId = jbkp2.commcellId AND AF.isValid = 1
LEFT OUTER JOIN JMJobSnapDeferredCatalogStats S WITH(NOLOCK) ON AF.jobId = S.jobId AND AF.commcellId = S.commcellId
						LEFT OUTER JOIN App_SubclientProp SPROP WITH(NOLOCK) ON SPROP.componentNameId = @l_appId AND SPROP.AttrName = 'Enable Snap Backups' AND (jbkp2.ServStartDate > SPROP.Created) AND (jbkp2.ServStartDate < SPROP.modified OR SPROP.modified = 0)
						LEFT OUTER JOIN App_ClientProp CPROP WITH(NOLOCK) ON CPROP.componentNameId = @l_clientId AND CPROP.AttrName = 'Snap Backups Enabled' AND (jbkp2.ServStartDate > CPROP.Created) AND (jbkp2.ServStartDate < CPROP.modified OR CPROP.modified = 0)
WHERE (AF.fileType = 6 AND (S.catalogStatus IN(100, 102, 103) OR jbkp2.bkpAttributes & 0x200000000000000 = 0)) OR (AF.fileType = 2 AND AF.flags & 4 = 0 AND (SPROP.attrVal = N'0' OR CPROP.attrVal = N'0'))
						--#define JMBKP_SKIP_CATALOG_PHASE_SNAP_BKUP  0x200000000000000LL
				)
	BEGIN
UPDATE JMJobSnapDeferredCatalogStats SET disabled = disabled | 1, unPickReason = 8
WHERE jobId = @i_jobId AND commcellId = @i_commcellId AND catalogStatus IN (101, 102, 103) AND (disabled & 1) = 0
		SET @o_validStatus = 7
		GOTO RETURN_PROC
	END
END
SET @o_retCode = 0
SET @o_validStatus = 1
RETURN_PROC:
SELECT @o_retCode, @o_validStatus
GO

IF EXISTS (select * from GxQscripts where name = 'archDeferredCatalogCheckJobValidity')
	delete from GxQscripts where name = 'archDeferredCatalogCheckJobValidity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDeferredCatalogCheckJobValidity')
	delete from GXDBVersions where aliasname = 'archDeferredCatalogCheckJobValidity'
GO

insert into GXDBVersions values(2, 'archDeferredCatalogCheckJobValidity',  '00010001005400040000', 'archDeferredCatalogCheckJobValidity', '00010001005400040000')
GO

