

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archDataMoverType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2006  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archDataMoverType.sp,v $ $Id: archDataMoverType.sp,v 1.6.14.5 2020/08/18 21:46:55 chandru Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 	SP: "archDataMoverType"
--	|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archDataMoverType')
BEGIN
	print '>>> Drop Stored Procedure: archDataMoverType <<<'
	drop procedure archDataMoverType
END
IF EXISTS (select * from GxQscripts where name='archDataMoverType')
	delete from GxQscripts where name = 'archDataMoverType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDataMoverType')
	delete from GXDBVersions where aliasname = 'archDataMoverType'
GO
print '... Creating Procedure: archDataMoverType'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archDataMoverType
-- ------------------------------------------------------------------------------------------
-- Function is used to get the datamover type for the given mediagroupId
-- ------------------------------------------------------------------------------------------
  @i_archFileId integer,
  @i_commCellId integer,
  @i_archCopyId integer,
  @i_jobId integer
AS
  DECLARE @o_DataMoverType integer
  DECLARE @o_DrivePoolType integer
  DECLARE @o_MMErrorCode integer
SET NOCOUNT ON
DECLARE	@l_archChunkId	bigint
DECLARE	@l_volumeId		int
DECLARE	@l_drivePoolId	int
DECLARE @l_chunkCommCellId int
DECLARE @l_opType	int
SET		@l_archChunkId	= 0
SET		@l_volumeId		= 0
SET		@l_drivePoolId	= 0
SET		@l_chunkCommCellId = 0
IF EXISTS ( SELECT 1 FROM archGroupCopy WITH (READUNCOMMITTED)
			WHERE id = @i_archCopyId
AND extendedFlags & 1 = 1 )
BEGIN
	SELECT @i_archCopyId = AFC.archCopyId
	FROM archGroupCopy AGC WITH (READUNCOMMITTED), archFileCopy AFC WITH (READUNCOMMITTED)
	WHERE AGC.destMediaCopyId = @i_archCopyId
		AND AGC.id = AFC.archCopyId
		AND archFileId = @i_archFileId
		AND commCellId = @i_commCellId
END
SELECT	@l_drivePoolId = drivePoolId
FROM	archFileCopy WITH (READUNCOMMITTED)
WHERE	archFileId = @i_archFileId AND commCellId = @i_commCellId AND archCopyId = @i_archCopyId
-- If the drive pool ID is not valid (probably de-configured), reset it to 0
IF	@l_drivePoolId > 0 AND NOT EXISTS (SELECT 1 FROM MMDrivePool WITH (READUNCOMMITTED) WHERE DrivePoolId = @l_drivePoolId)
	SET @l_drivePoolId = 0
IF EXISTS (SELECT 1 FROM MMConfigs WITH (READUNCOMMITTED) WHERE name = 'MM_CONFIG_GET_DATAMOVERTYPE_ON_TOBE_COPIED_CHUNK' AND Value = 1)
BEGIN
	SELECT	@l_opType = opType
	FROM	JMJobInfo WITH (READUNCOMMITTED)
	WHERE	JobId = @i_jobId
	IF (@i_jobId > 0 AND @l_opType = 104)
	BEGIN
		SELECT	TOP 1 @l_archChunkId = ACM.archChunkId, @l_chunkCommCellId  = ACM.chunkCommCellId
		FROM	archChunkMapping ACM WITH (READUNCOMMITTED), archChunkToReplicate R WITH (READUNCOMMITTED)
		WHERE	ACM.archFileId = @i_archFileId AND ACM.commCellId = @i_commCellId AND ACM.archCopyId = @i_archCopyId
				AND R.adminjobId = @i_jobId AND R.archChunkId = ACM.archChunkId AND R.chunkCommCellId = ACM.chunkCommCellId
		ORDER BY ACM.chunkNumber
	END
	IF ((@l_archChunkId = 0) AND (@i_jobId > 0) AND (@l_opType = 13))
	BEGIN
		SELECT	TOP 1 @l_archChunkId = ACM.archChunkId, @l_chunkCommCellId  = ACM.chunkCommCellId
		FROM	archChunkMapping ACM WITH (READUNCOMMITTED), archChunkToCopyHistory R WITH (READUNCOMMITTED)
		WHERE	ACM.archFileId = @i_archFileId AND ACM.commCellId = @i_commCellId AND ACM.archCopyId = @i_archCopyId
				AND R.adminjobId = @i_jobId AND R.archChunkId = ACM.archChunkId
		ORDER BY ACM.chunkNumber
	END
END
IF (@l_archChunkId = 0)
BEGIN
	SELECT	TOP 1 @l_archChunkId = archChunkId, @l_chunkCommCellId  = chunkCommCellId
	FROM	archChunkMapping WITH (READUNCOMMITTED)
	WHERE	archFileId = @i_archFileId AND commCellId = @i_commCellId AND archCopyId = @i_archCopyId
END
IF @l_archChunkId > 0
	SELECT	@l_volumeId = volumeId
	FROM	archChunk WITH (READUNCOMMITTED)
	WHERE	id = @l_archChunkId AND commCellId = @l_chunkCommCellId --@i_commCellId
IF (@l_volumeId > 0)
	SET	@l_drivePoolId = 0
EXEC MMGetDataMoverType @i_archCopyId, @l_volumeId, @l_drivePoolId, 0
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archDataMoverType')
	delete from GxQscripts where name = 'archDataMoverType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archDataMoverType')
	delete from GXDBVersions where aliasname = 'archDataMoverType'
GO

insert into GXDBVersions values(2, 'archDataMoverType',  '00010006001400050000', 'archDataMoverType', '00010006001400050000')
GO

