

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archCreateNewDDBsOnFull.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archCreateNewDDBsOnFull.sp,v $ $Id: archCreateNewDDBsOnFull.sp,v 1.1.2.21.4.1 2021/01/29 03:17:10 pnara Exp $";
--  +========================================================================+
--  | Stored Proc:  archCreateNewDDBsOnFull
--  |
--  | Description:  Checks for threshold values for AvgQITime, DiskSpace
--	| for DDBs and sets the flags accordingly and created new DDBs if needed
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archCreateNewDDBsOnFull')
BEGIN
	print '>>> Drop Stored Procedure: archCreateNewDDBsOnFull <<<'
	drop procedure archCreateNewDDBsOnFull
END
IF EXISTS (select * from GxQscripts where name='archCreateNewDDBsOnFull')
	delete from GxQscripts where name = 'archCreateNewDDBsOnFull'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCreateNewDDBsOnFull')
	delete from GXDBVersions where aliasname = 'archCreateNewDDBsOnFull'
GO
print '... Creating Procedure: archCreateNewDDBsOnFull'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archCreateNewDDBsOnFull
  @i_copyId integer = 0,
  @i_appTypeGroupId integer = 0,
  @i_skipResults integer = 0
AS
DECLARE		@o_retVal		INTEGER = 0
SET NOCOUNT ON
	/*
	--
	-- DDB Creation Rules:
	--
	•	Default 3 DDBs one for each AppTypeGroup (Files, Databases and VMs) gets created.
	•	More DDBs for each AppTypeGroup will be added when existing DDB becomes full.
	•	When a DDB hits any of the below conditions then we mark that DDB as full and creates a new DDB.
		a.	30 days AvgQITime reaches 1 millisecond (50% of two milliseconds threshold) and number of primary records on each of the partition is 200 million or more.
		b.	Number of primary records on each of the partition is 800 million or more.
		c.	(Optional) Disk free space on  any one of the partition falls down to user configured threshold percentage of the capacity and has atleast 200 million records on each of the partition.
		d.	(Optional) Number of associated subclients reaches the user configured threshold value.
	•   Existing subclients which are already mapped to the old DDB will still continue using the old DDB, only new
	•	When a DDB hits full condition then we check the status of previously marked full DDB if there is any and if that is in good condition then it will be marked as active instead of creating a new DDB. So third DDB gets created only when the first 2 DDBs becomes full and so on.
	*/
DECLARE @thresholdDaysToConsider int = 30
DECLARE	@maxAvgQITime int = 2000
DECLARE	@storeAvgQITimePercent int = 50
	DECLARE @avgQITimeLimit int = 0
DECLARE @minPrimaryEntries int = 200
DECLARE @primaryEntriesLimit int = 800
DECLARE @subclientLimit int = 0
DECLARE	@storeFreeSpacePercent int = 0
	DECLARE @numberOfFullDDBs int = 0
DECLARE @maxNumDDBsPerAppTypeGroup int = 3
DECLARE @maxNumPartitionsOnMA int = 50
	DECLARE @tranStarted BIT = 0
DECLARE @autoBalanceEnabled BIT = 1
DECLARE @autoBalanceInDays INT = 7
DECLARE @autoBalancePrimaryEntiresLimitPercent INT = 25
	DECLARE @autoBalancePrimaryEntiresLimitInMil INT = 0
	DECLARE @autoBalancePrimaryEntiresLimit BIGINT = 0
DECLARE @autoBalancePrimaryEntiresToMove INT = 10
DECLARE @autoBalanceSubclientsToMovePercent INT = 10
SELECT	@thresholdDaysToConsider = ISNULL(value, 30)
	FROM	MMConfigs WITH (READUNCOMMITTED)
	WHERE	name = 'MMCONFIG_INFINI_STORE_AVG_QI_TIME_LIMIT_DAYS_TO_CONSIDER'
	SELECT	@o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
SELECT	@maxAvgQITime = ISNULL(value, 2000)
	FROM	MMConfigs WITH (READUNCOMMITTED)
	WHERE	name = 'MMCONFIG_MAX_AVGQITIME_FOR_SIDB'
	SELECT	@o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
SELECT	@storeAvgQITimePercent = ISNULL(value, 50)
	FROM	MMConfigs WITH (READUNCOMMITTED)
	WHERE	name = 'MMCONFIG_INFINI_STORE_AVG_QI_TIME_LIMIT_PERCENT'
	SELECT	@o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
	SET	@avgQITimeLimit = @maxAvgQITime * @storeAvgQITimePercent / 100
	SELECT	@minPrimaryEntries = value
	FROM	MMConfigs WITH (READUNCOMMITTED)
	WHERE	name = 'MMCONFIG_INFINI_STORE_MIN_PRIMARY_ENTRIES'
	SELECT	@o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
	SELECT	@primaryEntriesLimit = value
	FROM	MMConfigs WITH (READUNCOMMITTED)
	WHERE	name = 'MMCONFIG_INFINI_STORE_PRIMARY_ENTRIES'
	SELECT	@o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
	SELECT	@subclientLimit = value
	FROM	MMConfigs WITH (READUNCOMMITTED)
	WHERE	name = 'MMCONFIG_INFINI_STORE_NUMBER_OF_SUBCLIENTS'
	SELECT	@o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
SELECT	@storeFreeSpacePercent = ISNULL(value, 0)
	FROM	MMConfigs WITH (READUNCOMMITTED)
	WHERE	name = 'MMCONFIG_INFINI_STORE_FREE_SPACE_PERC'
	SELECT	@o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
	SELECT	@maxNumDDBsPerAppTypeGroup = value
	FROM	MMConfigs WITH (READUNCOMMITTED)
	WHERE	name = 'MMCONFIG_INFINI_STORE_MAX_NUM_DDBS_PER_APPTYPEGROUP_IN_6_MONTHS'
	SELECT	@o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
	SELECT	@maxNumPartitionsOnMA = value
	FROM	MMConfigs WITH (READUNCOMMITTED)
	WHERE	name = 'MMCONFIG_INFINI_STORE_MAX_PATITIONS_ON_MA'
	SELECT	@o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
	SELECT	@autoBalanceEnabled = value
	FROM	MMConfigs WITH (READUNCOMMITTED)
	WHERE	name = 'MMCONFIG_INFINI_STORE_ENABLE_AUTO_BALANCE'
	SELECT	@autoBalanceInDays = value
	FROM	MMConfigs WITH (READUNCOMMITTED)
	WHERE	name = 'MMCONFIG_INFINI_STORE_AUTO_BALANCE_IN_DAYS'
	SELECT	@autoBalancePrimaryEntiresLimitPercent = value
	FROM	MMConfigs WITH (READUNCOMMITTED)
	WHERE	name = 'MMCONFIG_INFINI_STORE_AUTO_BALANCE_PRIMARY_ENTRIES_LIMIT_PERCENT'
	SET @autoBalancePrimaryEntiresLimitInMil = @primaryEntriesLimit + (@primaryEntriesLimit * @autoBalancePrimaryEntiresLimitPercent * 1.0 / 100)
	SET @autoBalancePrimaryEntiresLimit = @autoBalancePrimaryEntiresLimitInMil * 1000000  --convert from millions
	SELECT	@autoBalancePrimaryEntiresToMove = value
	FROM	MMConfigs WITH (READUNCOMMITTED)
	WHERE	name = 'MMCONFIG_INFINI_STORE_AUTO_BALANCE_PRIMARY_ENTRIES_TO_MOVE'
	SET @autoBalancePrimaryEntiresToMove = @autoBalancePrimaryEntiresToMove * 1000000  --convert from millions
	SELECT	@autoBalanceSubclientsToMovePercent = value
	FROM	MMConfigs WITH (READUNCOMMITTED)
	WHERE	name = 'MMCONFIG_INFINI_STORE_AUTO_BALANCE_SUBCLIENTS_TO_MOVE_PERCENT'
	DECLARE @l_nowDate datetime = GETUTCDATE()
	DECLARE @l_now INT = dbo.GetUnixTime(@l_nowDate)
	DECLARE @l_6MonthsTime INT = dbo.GetUnixTime(DATEADD(MM, -6, @l_nowDate))
DECLARE @l_CSClientName NVARCHAR(255) = (SELECT name FROM App_Client WITH(READUNCOMMITTED) WHERE id = 2)
	IF OBJECT_ID('tempdb..#NextEvIDTable') IS NOT NULL DROP TABLE #NextEvIDTable
	CREATE TABLE #NextEvIDTable (id int)
	DECLARE @EvMsgId INT = 0
	--
	-- Get DDBs list
	--
	DECLARE @lt_SIDBStores TABLE
	(
		CopyId 					int,
		SIDBGroupId				int,
		AppTypeGroupId 			int,
		SIDBStoreId 			int,
StoreName				nvarchar(256),
StoreAliasName			nvarchar(256),
		CreatedTime 			int,
		AvgQITime 				bigint,
		FreeSpacePercent 		int,
		PrimaryEntriesInMil		int,
		NumberOfSubClients		int,
		wasFull 				int,
		isFull 					int,
		fullReason				tinyint,
		FullTime				int,
		SubStoreCount			int
	)
	INSERT INTO @lt_SIDBStores
	SELECT	AGC.id, SG.SIDBGroupId, ST.AppTypeGroupId, ACS.SIDBStoreId, ST.SIDBStoreName, ST.SIDBStoreAliasName, ST.CreatedTime,
			dbo.GetCurrentAvgQITimeMedian(ACS.SIDBStoreId, 0 /*SubStoreId*/, ST.CommCellId, @thresholdDaysToConsider),
			100 /*FreeSpacePercent*/, 0 PrimaryEntriesInMil, 0 NumberOfSubClients,
(case when ACS.flags & 1 > 0 then 1 else 0 end) wasFull, 0 isFull, 0 fullReason, FullTime, ST.SubStoreCount
	FROM	archGroupCopy AGC with (readuncommitted),
			archCopySIDBStore ACS with (readuncommitted),
			IdxSIDBStore ST with (readuncommitted),
			IdxSIDBGroup SG with (readuncommitted)
	WHERE	AGC.id = ACS.copyId
	AND 	ACS.SIDBStoreId = ST.SIDBStoreId
	AND		ST.SIDBGroupId = SG.SIDBGroupId
AND		AGC.dedupeFlags & 134217728 = 0
AND		ACS.flags & 4 > 0
	AND		(@i_copyId > 0 OR ST.Version <> -1) --skip uninitialized DDBs only when run from admin thread, we should consider uninitialized DDBs for subclient limit
	AND 	(@i_copyId = 0 OR AGC.id = @i_copyId)
	AND 	(@i_appTypeGroupId = 0 OR ST.AppTypeGroupId = @i_appTypeGroupId)
	SELECT	@o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
	-- For old DDBs mark full and create new only when all MAs (DDB and Datamover) at v11 SP15 or higher
	DELETE	S
	FROM	@lt_SIDBStores S
	WHERE	S.AppTypeGroupId = 0
			AND EXISTS
			(
				-- For InfiniStore all MAs (DDB and Datamover) should be at v11 SP15 or higher
				SELECT 	1
				FROM	App_Client CN WITH(READUNCOMMITTED)
						INNER JOIN simInstalledPackages PKG WITH(READUNCOMMITTED) ON CN.id = PKG.ClientId
						INNER JOIN
						(
							SELECT 	ISNULL(VC.PMClientId, SS.clientId) clientId
							FROM	IdxSIDBSubStore SS WITH(READUNCOMMITTED)
									LEFT OUTER JOIN APP_VMToPMMap VC WITH(READUNCOMMITTED) ON VC.VMClientId = SS.clientId
							WHERE	S.SIDBStoreId = SS.SIDBStoreId
							UNION
							SELECT 	ISNULL(VC.PMClientId, DPool.clientId) clientId
							FROM	MMDataPath DPath WITH(READUNCOMMITTED)
									INNER JOIN MMDrivePool DPool WITH(READUNCOMMITTED)
										ON DPath.copyId = S.copyId AND DPath.DrivePoolId = DPool.DrivePoolId
									LEFT OUTER JOIN APP_VMToPMMap VC WITH(READUNCOMMITTED) ON VC.VMClientId = DPool.clientId
						) AS T ON CN.id = T.clientId
				WHERE	(CN.releaseId < 16 OR (CN.releaseId = 16 AND PKG.HighestSP < 15))
AND PKG.simPackageID IN (51, 1301)
			)
	--Skip DDBs which undergoing ddb move
	DELETE	S
	FROM	@lt_SIDBStores S, IdxSIDBSubStore SS WITH(READUNCOMMITTED)
	WHERE 	SS.SIDBStoreId = S.SIDBStoreId
AND SS.Flags & 1024 > 0
	--Get Number of Primary Entries
	UPDATE 	S
	SET		PrimaryEntriesInMil = B.PrimaryEntriesInMil
	FROM	@lt_SIDBStores S,
			(
				SELECT	SU.SIDBStoreId, ISNULL(AVG(SU.PrimaryEntries)/1000000, 0) PrimaryEntriesInMil
				FROM	IdxSIDBUsageHistory SU WITH(READUNCOMMITTED),
						(
							SELECT	U.SIDBStoreId, U.SubStoreId, MAX(U.ModifiedTime) ModifiedTime
							FROM	@lt_SIDBStores T,
									IdxSIDBUsageHistory U WITH(READUNCOMMITTED)
							WHERE	T.SIDBStoreId = U.SIDBStoreId
							GROUP BY U.SIDBStoreId, U.SubStoreId
						) M
				WHERE	SU.SIDBStoreId = M.SIDBStoreId
						AND SU.SubStoreId = M.SubStoreId
						AND SU.ModifiedTime = M.ModifiedTime
				GROUP BY SU.SIDBStoreId
			) B
	WHERE	S.SIDBStoreId = B.SIDBStoreId
	--Get Free Space Percent if config param is enabled
	IF @storeFreeSpacePercent > 0
	BEGIN
		UPDATE 	S
		SET		FreeSpacePercent = B.FreeSpacePercent
		FROM	@lt_SIDBStores S,
				(
					SELECT	T.SIDBStoreId, MIN(CAST(C.FreeDiskSpaceMB * 1.0 / C.TotalCapacityMB * 100 AS INT)) FreeSpacePercent
					FROM	@lt_SIDBStores T,
							IdxSIDBSubStore SS WITH(READUNCOMMITTED),
							IdxCache C WITH(READUNCOMMITTED)
					WHERE	T.SIDBStoreId = SS.SIDBStoreId
							AND SS.IdxCacheId = C.IdxCacheId
							AND C.TotalCapacityMB > 0
							AND C.FreeDiskSpaceMB < C.TotalCapacityMB
					GROUP BY T.SIDBStoreId
				) B
		WHERE	S.SIDBStoreId = B.SIDBStoreId
		--
		-- If current active DDB is still on old DDB path then ignore free space limit
		-- 1. Find last full DDB for each active DDB
		-- 2. Check if active DDB is on same path
		--
		;WITH LastFullDDB AS
		(
			SELECT 	S.SIDBStoreId,
					FS.SIDBStoreId LastFullSIDBStoreId,
					ROW_NUMBER() OVER (PARTITION BY S.SIDBStoreId ORDER BY FS.FullTime DESC) RowNum
			FROM	@lt_SIDBStores S,
					ArchCopySIDBStore FS2C WITH(READUNCOMMITTED),
					IdxSIDBStore FS WITH(READUNCOMMITTED)
			WHERE	S.copyId = FS2C.copyId
					AND FS.SIDBStoreId = FS2C.SIDBStoreId
					AND S.SIDBGroupId = FS.SIDBGroupId
					AND S.AppTypeGroupId > 0
					AND	(S.AppTypeGroupId = FS.AppTypeGroupId OR FS.AppTypeGroupId = 0)
					AND S.wasFull = 0 --current active DDB
AND FS2C.flags & 1 > 0
		)
		UPDATE 	S
		SET		S.FreeSpacePercent = 100
		FROM	@lt_SIDBStores S,
				LastFullDDB F,
				IdxSIDBSubStore SS WITH(READUNCOMMITTED),
				IdxAccessPath AP WITH(READUNCOMMITTED),
				IdxSIDBSubStore FSS WITH(READUNCOMMITTED),
				IdxAccessPath FAP WITH(READUNCOMMITTED)
		WHERE	F.RowNum = 1
				AND S.SIDBStoreId = F.SIDBStoreId
				AND S.SIDBStoreId = SS.SIDBStoreId
				AND SS.IdxAccessPathId = AP.IdxAccessPathId
				AND F.LastFullSIDBStoreId = FSS.SIDBStoreId
				AND FSS.IdxAccessPathId = FAP.IdxAccessPathId
				AND SS.ClientId = FSS.ClientId
				AND LEFT(AP.Path, LEN(AP.Path) - LEN(cast(F.SIDBStoreId AS varchar))) = LEFT(FAP.Path, LEN(FAP.Path) - LEN(cast(F.LastFullSIDBStoreId AS varchar)))
	END
	--
	--Get number of subclients
	--
	UPDATE 	S
	SET		NumberOfSubClients = B.NumberOfSubClients
	FROM	@lt_SIDBStores S,
			(
				SELECT	T.SIDBStoreId, COUNT(M.appId) NumberOfSubClients
				FROM	@lt_SIDBStores T,
						archSubclientCopyDDBMap M WITH(READUNCOMMITTED)
				WHERE	T.SIDBStoreId = M.SIDBStoreId
				GROUP BY T.SIDBStoreId
			) B
	WHERE	S.SIDBStoreId = B.SIDBStoreId
	--
	-- Check which DDBs became full
	--
	UPDATE	@lt_SIDBStores
	SET		isFull = 1,
			fullReason = (case when @storeFreeSpacePercent > 0 AND FreeSpacePercent <= @storeFreeSpacePercent AND PrimaryEntriesInMil >= @minPrimaryEntries
then 2 else 0 end) |
(case when AvgQITime >= @avgQITimeLimit AND PrimaryEntriesInMil >= @minPrimaryEntries then 1 else 0 end) |
(case when PrimaryEntriesInMil >= @primaryEntriesLimit then 4 else 0 end) |
(case when @subclientLimit > 0 AND NumberOfSubClients >= @subclientLimit then 8 else 0 end)
	WHERE	(AvgQITime >= @avgQITimeLimit AND PrimaryEntriesInMil >= @minPrimaryEntries)
			OR (@storeFreeSpacePercent > 0 AND FreeSpacePercent <= @storeFreeSpacePercent AND PrimaryEntriesInMil >= @minPrimaryEntries)
			OR PrimaryEntriesInMil >= @primaryEntriesLimit
			OR (@subclientLimit > 0 AND NumberOfSubClients >= @subclientLimit)
	--
	-- Auto balance full DDBs
	-- Automatically move some subclients to active non-full DDB from full DDB
	-- This is done to prevent too much growth of full DDB since alreday mapped subclients still backups to it and causes it to grow further
	-- It will also helpful for existing customers to move to InfiniStore seamlessly without any manual intervention.
	--
	-- 1. Pick DDBs whcih are marked full min 7 days back and not auto balanced within last 7 days
	-- 2. Compute total primary entries belongs to associated subclients.
	-- 3. Compute associated subclients having data.
	-- 4. Pick DDBs which are having more than 25% (1000 millions) above the primary entries limit (800 millions)
	-- 5. Pick subclients worth of 10 million primary entries up to 10% of total subclients in other order of least primary entries
	-- 6. Remove mapping for these picked subclients
	--
	-- We will pick active DDB for these subclients when job runs to it.
	--
	IF @autoBalanceEnabled = 1 AND @i_copyId = 0  --auto balance only when proc is run from MM thread
	BEGIN
		DECLARE @lt_AutoBalanceDDBs TABLE
		(
			SIDBStoreId 					int,
			SubStoreCount					int,
			PrimaryEntriesInMil				int,
			SecondaryEntriesRatio			float,
			MaxSubclientsToMove				int
		)
		--
		-- Pick critical full DDBs for auto balancing
		-- 1. Was full min 7 days back and still full
		-- 2. Was not auto balanced in last 7 days
		--
		INSERT INTO @lt_AutoBalanceDDBs
		SELECT T.SIDBStoreId, T.SubStoreCount, T.PrimaryEntriesInMil, 0, 0
		FROM
		(
			SELECT 	SIDBStoreId, SubStoreCount, PrimaryEntriesInMil,
					DATEDIFF(d, dbo.GetDateTime(FullTime), @l_nowDate) FullTimeInDays
			FROM	@lt_SIDBStores
			WHERE	wasFull = 1 AND isFull = 1
					AND PrimaryEntriesInMil > @autoBalancePrimaryEntiresLimitInMil
					AND NumberOfSubClients > 0
		) AS T
		WHERE T.FullTimeInDays >= 7 AND (T.FullTimeInDays % @autoBalanceInDays) = 0
		DECLARE @NumAutoBalanceDDBs INT = @@ROWCOUNT
		IF @NumAutoBalanceDDBs > 0
		BEGIN
			--
			-- Get valid AFs primary and secondary entries from archFileCopyDedup
			--
			DECLARE @lt_Subclients TABLE (SIDBStoreId int, AppId int, isAssociated BIT, PrimaryEntries bigint, SecondaryEntries bigint)
			INSERT 	INTO @lt_Subclients
			SELECT 	S.SIDBStoreId, AF.AppId, 0 isAssociated,
					SUM(CAST(AFD.primaryObjects AS BIGINT)) / S.SubStoreCount,
					SUM(CAST(AFD.secondaryObjects AS BIGINT)) / S.SubStoreCount
			FROM 	@lt_AutoBalanceDDBs S,
					archFileCopyDedup AFD WITH(READUNCOMMITTED),
					archFile AF WITH(READUNCOMMITTED)
			WHERE	S.SIDBStoreId = AFD.SIDBStoreId
					AND AF.id = AFD.archFileId
					AND AF.commCellId = AFD.commCellId
			GROUP BY S.SIDBStoreId, AF.AppId, S.SubStoreCount
			-- Identify associated subclients
			UPDATE 	SC
			SET		isAssociated = 1
			FROM	@lt_Subclients SC,
					archSubclientCopyDDBMap M WITH(READUNCOMMITTED)
			WHERE	SC.SIDBStoreId = M.SIDBStoreId
					AND SC.AppId = M.AppId
			-- Compute max subclients to move
			UPDATE 	S
			SET		MaxSubclientsToMove = T.NumberOfSubClients * @autoBalanceSubclientsToMovePercent / 100
			FROM	@lt_AutoBalanceDDBs S,
					(
						SELECT	SIDBStoreId, COUNT(1) NumberOfSubClients
						FROM	@lt_Subclients
						WHERE	isAssociated = 1
						GROUP BY SIDBStoreId
					) AS T
			WHERE	S.SIDBStoreId = T.SIDBStoreId
			--Remove DDBs where max subclients to move is 0
			DELETE @lt_AutoBalanceDDBs
			WHERE MaxSubclientsToMove = 0
			SET @NumAutoBalanceDDBs = @NumAutoBalanceDDBs - @@ROWCOUNT
			--
			-- Compute secondary entries ratio
			-- 1. Figure out aged AFs primary entries which are still referred by valid AFs
			--    PrunedPrimaryEntries = PrimaryEntries reported by DDB - Valid AFs PrimaryEntries
			-- 2. Fiture out total secondary entries of valid AFs.
			-- 3. Compute ration :  Pruned Primary Entries / Total Secondary Entries
			--
			UPDATE	S
			SET		SecondaryEntriesRatio = (S.PrimaryEntriesInMil - T.PrimaryEntriesInMil) * 1.0 / T.SecondaryEntriesInMil
			FROM	@lt_AutoBalanceDDBs S,
					(
						SELECT	SIDBStoreId, SUM(PrimaryEntries)/ 1000000 PrimaryEntriesInMil, SUM(SecondaryEntries)/ 1000000 SecondaryEntriesInMil
						FROM	@lt_Subclients
						GROUP BY SIDBStoreId
					) AS T
			WHERE	S.SIDBStoreId = T.SIDBStoreId
					AND T.SecondaryEntriesInMil > 0
					AND (S.PrimaryEntriesInMil - T.PrimaryEntriesInMil) > 0
			--
			-- Valid AFs may still refer to aged AFs so distribute the pruned primary entries to subclients based on secondary entries ratio
			--
			UPDATE 	SC
			SET		PrimaryEntries = PrimaryEntries + CAST(S.SecondaryEntriesRatio * SC.SecondaryEntries AS BIGINT)
			FROM	@lt_Subclients SC,
					@lt_AutoBalanceDDBs S
			WHERE	SC.SIDBStoreId = S.SIDBStoreId
			--
			-- Check primary entries limit (default 25% above threshold limit) for auto balance
			-- Use primary entries of associated subclients for this check since already moved subclients data pruning may takes time
			--
			DELETE	S
			FROM	@lt_AutoBalanceDDBs	S,
					(
						SELECT	SIDBStoreId, SUM(PrimaryEntries) PrimaryEntries
						FROM	@lt_Subclients
						WHERE	isAssociated = 1
						GROUP BY SIDBStoreId
					) AS T
			WHERE	S.SIDBStoreId = T.SIDBStoreId
					AND T.PrimaryEntries <= @autoBalancePrimaryEntiresLimit
			SET @NumAutoBalanceDDBs = @NumAutoBalanceDDBs - @@ROWCOUNT
			IF @NumAutoBalanceDDBs > 0
			BEGIN
				--
				-- Pick subclients to move based on primary entries to move in an attempt (default 10 million)
				-- Sum up each subclient primary entries in asending order and pick the nearest row to 10 million
				-- Remove all subclients before this picked row from mapping table
				-- We pick an active DDB for these removed subclients when next job runs to them.
				--
				DECLARE @lt_SubclientsToPick TABLE (SIDBStoreId int, AppId int, TotalPrimaryEntries bigint, RowNum int)
				INSERT INTO @lt_SubclientsToPick
				SELECT 	SC.SIDBStoreId, SC.AppId,
						SUM(SC.PrimaryEntries) OVER (PARTITION BY SC.SIDBStoreId ORDER BY SC.PrimaryEntries) TotalPrimaryEntries,
						ROW_NUMBER() OVER (PARTITION BY SC.SIDBStoreId ORDER BY SC.PrimaryEntries) RowNum
				FROM	@lt_Subclients SC,
						@lt_AutoBalanceDDBs	S
				WHERE	SC.isAssociated = 1
						AND SC.SIDBStoreId = S.SIDBStoreId
				DELETE 	M
				FROM	archSubclientCopyDDBMap M,
						@lt_SubclientsToPick SC,
						(
							SELECT	SIDBStoreId, MIN(TotalPrimaryEntries) PickedPrimaryEntries
							FROM	@lt_SubclientsToPick
							WHERE	TotalPrimaryEntries >= @autoBalancePrimaryEntiresToMove --pick nearest row
							GROUP BY SIDBStoreId
						) AS T,
						@lt_AutoBalanceDDBs S
				WHERE	M.SIDBStoreId = SC.SIDBStoreId
						AND M.AppId = SC.AppId
						AND SC.SIDBStoreId = T.SIDBStoreId
						AND T.SIDBStoreId = S.SIDBStoreId
						AND SC.TotalPrimaryEntries <= T.PickedPrimaryEntries
						AND SC.RowNum <= S.MaxSubclientsToMove
			END
		END
	END
	--
	-- Skip old style DDBs which were already marked full, they remain full forever
	--
	DELETE @lt_SIDBStores
	WHERE	wasFull = 1 AND AppTypeGroupId = 0
	--
	-- Skip all DDBs for a given copy, SIDBGroup and appTypeGroup if active DDB of that group is not full
	--
	DELETE	S
	FROM	@lt_SIDBStores S,
			(
				SELECT	copyId, SIDBGroupId, AppTypeGroupId
				FROM	@lt_SIDBStores
				WHERE	wasFull = 0  -- current active DDBs
						AND isFull = 0
				GROUP BY copyId, SIDBGroupId, AppTypeGroupId
			) T
	WHERE	S.copyId = T.copyId
			AND S.SIDBGroupId = T.SIDBGroupId
			AND S.AppTypeGroupId = T.AppTypeGroupId
	--
	-- Get Current Active Stores which became full and mark them as full
	-- There should be only one active store for (copy, SIDBGroup and appTypeGroupId) combination
	--
DECLARE @lt_FullSIDBStores TABLE ( CopyId 				int, SIDBGroupId			int, AppTypeGroupId 		int, SIDBStoreId 		int default 0, StoreName 			nvarchar(256) default N'', StoreAliasName 		nvarchar(256) default N'', AppTypeGroupName 	nvarchar(256) default N'', newSIDBStoreId 		int default 0, newStoreName 		nvarchar(256) default N'', FullReason			tinyint default 0, createNewDDB		BIT default 1 ) 			DELETE @lt_FullSIDBStores
	INSERT INTO @lt_FullSIDBStores (CopyId, SIDBGroupId, AppTypeGroupId, SIDBStoreId, StoreName, StoreAliasName, AppTypeGroupName, FullReason)
	SELECT	S.CopyId, S.SIDBGroupId, S.AppTypeGroupId, S.SIDBStoreId, S.StoreName, S.StoreAliasName, ISNULL(G.GroupName, ''), S.FullReason
	FROM	@lt_SIDBStores S
LEFT OUTER JOIN App_AppTypeGroup G ON S.AppTypeGroupId = G.AppTypeGroupId AND G.TypeOfGroup = 4
	WHERE	wasFull = 0  -- current active DDBs
			AND isFull = 1
	SET @numberOfFullDDBs = @@ROWCOUNT
	IF @numberOfFullDDBs = 0
		GOTO CX_ERROR_EXIT;
	--
	-- Don't create more than 3 DDBs (configurable) in 6 months per AppTypeGroup
	--
	DELETE 	F
	FROM	@lt_FullSIDBStores F,
			(
				SELECT 	FS.copyId, FS.SIDBGroupId, FS.AppTypeGroupId
				FROM	@lt_FullSIDBStores FS,
						archCopySIDBStore CS WITH(READUNCOMMITTED),
						IdxSIDBStore S WITH(READUNCOMMITTED)
				WHERE	FS.copyId = CS.copyId
						AND FS.AppTypeGroupId = S.AppTypeGroupId
						AND CS.SIDBStoreId = S.SIDBStoreId
						AND S.SealedTime = 0
						AND S.CreatedTime >= @l_6MonthsTime
				GROUP BY FS.copyId, FS.SIDBGroupId, FS.AppTypeGroupId
				HAVING COUNT(1) >= @maxNumDDBsPerAppTypeGroup
			) AS T
	WHERE	F.copyId = T.copyId AND F.SIDBGroupId = T.SIDBGroupId AND F.AppTypeGroupId = T.AppTypeGroupId
AND (F.FullReason & (1 | 2)) > 0
	SET @numberOfFullDDBs = @numberOfFullDDBs - @@ROWCOUNT
	IF @numberOfFullDDBs = 0
		GOTO CX_ERROR_EXIT;
	--
	-- Don't create more than 30 partitions (configurable) on a MA
	--
	DECLARE @lt_MAPartitions TABLE (ClientId INT, NumPartitions INT)
	;WITH NewPartitions AS
	(
		SELECT 	SS.clientId, COUNT(1) NumPartitions
		FROM	@lt_FullSIDBStores FS,
				IdxSIDBSubStore SS WITH(READUNCOMMITTED)
		WHERE	FS.SIDBStoreId = SS.SIDBStoreId
		GROUP BY SS.ClientId
	)
	INSERT INTO @lt_MAPartitions
	SELECT 	NP.ClientId, (SUM(T.NumPartitions) + NP.NumPartitions) NumPartitions
	FROM	NewPartitions NP,
			(
				SELECT 	SS.clientId, 1 NumPartitions
				FROM 	NewPartitions N,
						IdxSIDBSubStore SS WITH(READUNCOMMITTED)
				WHERE	N.clientId = SS.clientId
						AND EXISTS(SELECT 1 FROM archCopySIDBStore CS WITH(READUNCOMMITTED) WHERE CS.SIDBStoreId = SS.SIDBStoreId)
			) AS T
	WHERE	NP.clientId = T.clientId
	GROUP BY NP.ClientId, NP.NumPartitions
	HAVING (SUM(T.NumPartitions) + NP.NumPartitions) >= @maxNumPartitionsOnMA
	IF @@ROWCOUNT > 0
	BEGIN
		DECLARE @CopyReachedMALimit TABLE (CopyId INT, SIDBGroupId INT, AppTypeGroupId INT)
		INSERT INTO @CopyReachedMALimit
		SELECT	F.CopyId, F.SIDBGroupId, F.AppTypeGroupId
		FROM	@lt_FullSIDBStores F
		WHERE 	EXISTS
				(
					SELECT 	1
					FROM 	@lt_MAPartitions M,
							IdxSIDBSubStore SS WITH(READUNCOMMITTED)
					WHERE	SS.SIDBStoreId = F.SIDBStoreId
							AND M.ClientId = SS.clientId
				)
		--
		-- Generate event to inform user to provision new MA
		--
		DECLARE @cur_archGroupId INT = 0
		DECLARE	@cur_archGroupName nvarchar(256)
		DECLARE @cur_copyName nvarchar(256)
		DECLARE @cur_isStoragePool BIT = 0
		DECLARE curStore CURSOR LOCAL FORWARD_ONLY FOR
SELECT 	DISTINCT AG.id, AG.name, AGC.name, IIF(AGC.dedupeFlags & 268435456 > 0, 1, 0)
		FROM 	@CopyReachedMALimit C, ArchGroupCopy AGC WITH(READUNCOMMITTED), ArchGroup AG WITH(READUNCOMMITTED)
		WHERE	C.CopyId = AGC.id AND AGC.archGroupId = AG.id
		OPEN curStore
		FETCH NEXT FROM curStore INTO @cur_archGroupId, @cur_archGroupName, @cur_copyName, @cur_isStoragePool
		WHILE (@@FETCH_STATUS = 0)
		BEGIN
			TRUNCATE TABLE #NextEvIDTable
			INSERT INTO #NextEvIDTable
			EXECUTE GetNextEventId
			SELECT @EvMsgId = id FROM  #NextEvIDTable
			INSERT INTO EvMsg (id, TimeSource, TimeServer, Severity, Ack, Acked, Type,
				ParamNum, MessageId, JobId_h, JobId_l, ClientId, CommcellId,
				UserId, SubSystemId, Client, CommCell, UserName, SubSystem,
				MsgEnglish, RepeatCount, LastOccurrence, NextPost,
				mediaId, driveId, libraryId, maClientId)
SELECT  @EvMsgId, @l_now, @l_now, 9, 0, 0, 0,
1, (531 | (CAST(POWER(2, 24) AS BIGINT) * 32)), 0, 0, 2, 2,
					0, 0, @l_CSClientName, 0, 0, 'MediaManager',
					'', 1, @l_now, 1,
					0, 0, 0, 0
			INSERT 	INTO EvParam(EvMsgId, EventId, Position, Type, Size, Data)
SELECT 	@EvMsgId, (531 | (CAST(POWER(2, 24) AS BIGINT) * 32)), 1, 0, 0, IIF(@cur_isStoragePool = 1, @cur_archGroupName, @cur_archGroupName + ' / '+ @cur_copyName)
			FETCH NEXT FROM curStore INTO @cur_archGroupId, @cur_archGroupName, @cur_copyName, @cur_isStoragePool
		END
		CLOSE curStore
		DEALLOCATE curStore
		DELETE 	F
		FROM	@lt_FullSIDBStores F, @CopyReachedMALimit C
		WHERE	F.CopyId = C.CopyId
				AND F.SIDBGroupId = C.SIDBGroupId
				AND F.appTypeGroupId = C.AppTypeGroupId
		SET @numberOfFullDDBs = @numberOfFullDDBs - @@ROWCOUNT
		IF @numberOfFullDDBs = 0
			GOTO CX_ERROR_EXIT;
	END
	BEGIN
		BEGIN TRY
			BEGIN TRAN
			SET @tranStarted = 1
			--Mark current active stores as full
			UPDATE 	ACS
SET		flags = (ACS.flags | 1)
			FROM	archCopySIDBStore ACS,
					@lt_FullSIDBStores S
			WHERE	ACS.SIDBStoreId = S.SIDBStoreId
			UPDATE 	ST
SET		ExtendedFlags = (ST.ExtendedFlags | 1),
					FullReason	= S.FullReason,
					FullTime = @l_now
			FROM	IdxSIDBStore ST,
					@lt_FullSIDBStores S
			WHERE	ST.SIDBStoreId = S.SIDBStoreId
			--
			-- Check if there are any good old full DDBs instead of creating new if current active is full
			--
			UPDATE 	S
			SET		createNewDDB = 0,
					newSIDBStoreId = ST.SIDBStoreId,
					newStoreName = ST.SIDBStoreName
			FROM 	@lt_FullSIDBStores S,
					IdxSIDBStore ST,
					(
						SELECT	T.copyId, T.SIDBGroupId, T.AppTypeGroupId, MIN(S.SIDBStoreId) SIDBStoreId
						FROM	@lt_SIDBStores S,
								@lt_FullSIDBStores T
						WHERE	S.copyId = T.copyId
								AND S.SIDBGroupId = T.SIDBGroupId
								AND S.AppTypeGroupId = T.AppTypeGroupId
								AND S.SIDBStoreId <> T.SIDBStoreId
								AND S.wasFull = 1
								AND S.isFull = 0
						GROUP BY T.copyId, T.SIDBGroupId, T.AppTypeGroupId
					) F
			WHERE	S.copyId = F.copyId
					AND S.SIDBGroupId = F.SIDBGroupId
					AND S.AppTypeGroupId = F.AppTypeGroupId
					AND ST.SIDBStoreId = F.SIDBStoreId
			DECLARE @NumOldStores INT = @@ROWCOUNT
			IF @NumOldStores > 0
			BEGIN
				SET @numberOfFullDDBs = @numberOfFullDDBs - @NumOldStores
				--Unset full flag on old good DDBs
				UPDATE 	ACS
SET		flags = (ACS.flags & ~1)
				FROM	archCopySIDBStore ACS,
						@lt_FullSIDBStores S
				WHERE	ACS.SIDBStoreId = S.newSIDBStoreId
						AND S.createNewDDB = 0
				UPDATE 	ST
SET		ExtendedFlags = (ST.ExtendedFlags & ~1)
				FROM	IdxSIDBStore ST,
						@lt_FullSIDBStores S
				WHERE	ST.SIDBStoreId = S.newSIDBStoreId
						AND S.createNewDDB = 0
			END
			IF @numberOfFullDDBs > 0
			BEGIN
				--
				-- Now create new DDBs if we don't find good old DDB for current active DDB
				--
--
-- BEGIN: archCreateNewDDBs.spb
--
				--
				-- Set name for DDB
				-- Format : <StoragePolicyName + [copyName] + [AppTypeGroupName]>
				--
				UPDATE 	S
				SET 	StoreAliasName = AG.name
						+
						(
							--Append copy name for standalone copies
case when AGC.dedupeFlags & 268435456 = 0
								then N'_' + AGC.name
								else N''
							end
						)
						+
						(
							--Append AppTypeGroupName for appType based DDBs
							case when S.AppTypeGroupId > 0
								then N'_' + S.AppTypeGroupName
								else N''
							end
						)
				FROM	@lt_FullSIDBStores S,
						ArchGroupCopy AGC WITH(READUNCOMMITTED),
						ArchGroup AG WITH(READUNCOMMITTED)
				WHERE	S.CopyId = AGC.id
						AND AGC.archGroupId = AG.id
						AND S.StoreAliasName = N''
DECLARE @GarbageCollectionConfig INT = ISNULL((SELECT value FROM MMConfigs WITH(READUNCOMMITTED) WHERE name = 'MMS2_CONFIG_ENABLE_DDB_GARBAGE_COLLECTION'), 1)
				DECLARE @l_CopyId INT = 0
				DECLARE @l_NewSIDBGroupId INT = 0
				DECLARE @l_AppTypeGroupId INT = 0
				DECLARE @l_OldStoreId INT = 0
				DECLARE @l_NewStoreId INT = 0
DECLARE @l_StoreAliasName nvarchar(256) = N''
				DECLARE @l_AppTypeGroupName nvarchar(256) = N''
				DECLARE @l_StrStoreId nvarchar(15) = N''
				DECLARE @l_SubStoreId INT = 0
				DECLARE	@l_DefSIDBStoreId	INT = 0
				DECLARE @l_nowTime INT = dbo.GetUnixTime(GETUTCDATE())
				DECLARE curStore CURSOR LOCAL FORWARD_ONLY FOR
				SELECT CopyId, SIDBGroupId, AppTypeGroupId, SIDBStoreId, StoreAliasName, AppTypeGroupName
				FROM @lt_FullSIDBStores
				WHERE  createNewDDB = 1
				ORDER BY AppTypeGroupId, SIDBStoreId
				OPEN curStore
				FETCH NEXT FROM curStore INTO @l_CopyId, @l_NewSIDBGroupId, @l_AppTypeGroupId, @l_oldStoreId, @l_StoreAliasName, @l_AppTypeGroupName
				WHILE (@@FETCH_STATUS = 0)
				BEGIN
					--Remove old storeId from name
					SET @l_StrStoreId = N'_' + CONVERT(nvarchar, @l_OldStoreId)
					SET @l_StoreAliasName = case when CHARINDEX(@l_StrStoreId, @l_StoreAliasName, len(@l_StoreAliasName) - len(@l_StrStoreId) + 1) > 0
												then LEFT(@l_StoreAliasName, CHARINDEX(@l_StrStoreId, @l_StoreAliasName, len(@l_StoreAliasName) - len(@l_StrStoreId) + 1) - 1)
												else @l_StoreAliasName
											end
					--
					--Create DDBs
					--
					INSERT  INTO IdxSIDBStore (SIDBStoreName, SIDBStoreAliasName, CommCellId,
								IdxCacheId, IdxAccessPathId, ClientId, FirstBackupTime,
								MinObjSizeKB, oldestEligibleObjArchiveTime, SignatureType,
								flags,
								TotalDataSizeBytes, InstancedDataSizeBytes, Status,
								LastAccessTime, CreatedTime, SealedTime, origCCSIDBStoreId,
								Version, SIDBSnapPath, LastSnapTime, LastRecoveryTime,
								SealedReason, SIDBSiloedTime, SIDBSiloStatus, SIDBSiloJobId,
								SubStoreCount, MaxAllowedConnections, MaxNumOfAFsInSecFile,
								LastDDBVerificationTime, LastDataVerificationTime, DedupFactor, AppTypeGroupId,
								ExtendedFlags, SIDBGroupId)
					SELECT  @l_StoreAliasName, @l_StoreAliasName, 2,
							IdxCacheId, IdxAccessPathId, ClientId, -1,
							MinObjSizeKB, oldestEligibleObjArchiveTime, SignatureType,
(flags & ~( 32 | 64 | 128 | 256 | 512 | 1024 | 2048 | 4096 | 8192 | 16384 | 32768 | 4194304 | 16777216 | 33554432 | 67108864 | 134217728 | 268435456 | 1073741824									)) | ( 536870912 | 131072),
							0, 0, 0,
							0, @l_nowTime, 0, 0,
							-1, SIDBSnapPath, 0, 0,
							0, 0, 0, 0,
							SubStoreCount, MaxAllowedConnections, 1 /*MaxNumOfAFsInSecFile*/,
							0, 0, DedupFactor, @l_AppTypeGroupId,
(ExtendedFlags & ~( 1 | 2											)) | ( 0 ) |
								(
CASE WHEN @GarbageCollectionConfig = 1 AND ((flags & ~( 32 | 64 | 128 | 256 | 512 | 1024 | 2048 | 4096 | 8192 | 16384 | 32768 | 4194304 | 16777216 | 33554432 | 67108864 | 134217728 | 268435456 | 1073741824									)) | ( 536870912 | 131072) & 8192) = 0
AND ExtendedFlags & (4 | 8) = 0
THEN (4 | 8)
										ELSE 0
									END
								),
							@l_NewSIDBGroupId
					FROM    IdxSIDBStore WITH (READUNCOMMITTED)
					WHERE 	SIDBStoreId = @l_OldStoreId
					SELECT	@o_retVal = @@ERROR, @l_NewStoreId = SCOPE_IDENTITY()
					IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
					SET @l_StoreAliasName = @l_StoreAliasName + N'_' + CONVERT(nvarchar, @l_NewStoreId)
					UPDATE 	@lt_FullSIDBStores
					SET		newSIDBStoreId 	= @l_NewStoreId,
							newStoreName 	= @l_StoreAliasName
					WHERE	SIDBStoreId = @l_oldStoreId
					SELECT	@o_retVal = @@ERROR
					IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
					--
					--Update name with new storeId
					--
					UPDATE  IdxSIDBStore
					SET     SIDBStoreName = @l_StoreAliasName,
							SIDBStoreAliasName = @l_StoreAliasName
					WHERE   SIDBStoreId = @l_NewStoreId
					SELECT	@o_retVal = @@ERROR
					IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
					--
					--Add association to copies
					--
					INSERT INTO archCopySIDBStore (CopyId, SIDBStoreId, CommCellId, flags, TotalDataSizeBytes, InstancedDataSizeBytes)
					SELECT
						CopyId,
@l_NewStoreId , CommCellId, flags & ~(1 | 2)
							, 0, 0
					FROM    archCopySIDBStore WITH (READUNCOMMITTED)
					WHERE	SIDBStoreId = @l_OldStoreId
					SELECT	@o_retVal = @@ERROR
					IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
					--
					--Create SubStores
					--
					DECLARE curSubStore CURSOR LOCAL FORWARD_ONLY FOR
					SELECT 	SS.SubStoreId
					FROM 	IdxSIDBSubStore SS WITH (READUNCOMMITTED),
							IdxAccessPath AP WITH (READUNCOMMITTED)
					WHERE	SIDBStoreId = @l_OldStoreId
							AND SS.IdxAccessPathId = AP.IdxAccessPathId
					OPEN curSubStore
					FETCH NEXT FROM curSubStore INTO @l_SubStoreId
					WHILE (@@FETCH_STATUS = 0)
					BEGIN
						--
						-- Create SubStore
						--
						INSERT INTO IdxSIDBSubStore
							   ([SIDBStoreId], [commCellId], [GroupNumber], [IdxCacheId]
							   ,[IdxAccessPathId], [ClientId], [FirstBackupTime]
							   ,[flags]
							   ,[TotalDataSizeBytes],[InstancedDataSizeBytes],[Status],[LastAccessTime]
							   ,[CreatedTime],[SealedTime],[Version],[SIDBSnapPath]
							   ,[LastSnapTime],[origSubStoreId], [ReconLevel], LastSnapJobId, DDBBackupCSGUID, PrimaryId, MemDbTimeStamp, CorruptionTime, ZeroRefBatchSeq, StartLogSequence, EndLogSequence, SnapLogSequence, MaxNumOfAFsInSecFile
							   ,ExtendedFlags, PageSize)
						SELECT
							   @l_NewStoreId, SS.commCellId, SS.GroupNumber, SS.IdxCacheId
							   ,SS.IdxAccessPathId, SS.ClientId,-1
,(SS.flags & ~( 32 | 64 | 128 | 256 | 512 | 1024 | 2048 | 4096 | 8192 | 16384 | 32768 | 4194304 | 16777216 | 33554432 | 67108864 | 134217728 | 268435456 | 1073741824									)) | ( 536870912 | 131072)
							   ,0,0,0,0
							   ,@l_nowTime,0,-1,''
							   ,0,0, 0, 0, '',0, 0, 0, 0
							   , '', '', '', 1 /*MaxNumOfAFsInSecFile*/
,(SS.ExtendedFlags & ~(	4	)) |
(CASE WHEN S.ExtendedFlags & 4 > 0 THEN 1 ELSE 0 END) |
(CASE WHEN S.ExtendedFlags & 8 > 0 THEN 2 ELSE 0 END)
							   ,SS.PageSize
						FROM	IdxSIDBSubStore SS WITH(READUNCOMMITTED),
								IdxSIDBStore S WITH(READUNCOMMITTED)
						WHERE	SS.SIDBStoreId = @l_OldStoreId
								AND SS.SubStoreId = @l_SubStoreId
								AND S.SIDBStoreId = @l_NewStoreId
						SELECT	@o_retVal = @@ERROR
						IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
						FETCH NEXT FROM curSubStore INTO @l_SubStoreId
					END
					CLOSE curSubStore
					DEALLOCATE curSubStore
					FETCH NEXT FROM curStore INTO @l_CopyId, @l_NewSIDBGroupId, @l_AppTypeGroupId, @l_oldStoreId, @l_StoreAliasName, @l_AppTypeGroupName
				END
				CLOSE curStore
				DEALLOCATE curStore
--
-- END: archCreateNewDDBs.spb
--
			END
			COMMIT TRAN
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			SET @o_retVal = ERROR_NUMBER()
			GOTO CX_ERROR_EXIT
		END CATCH
	END
	--
	-- Generate events
	--
DECLARE @cur_oldDDBName nvarchar(256)
DECLARE @cur_newDDBName nvarchar(256)
	DECLARE	@cur_msgId int
	DECLARE curNewStore CURSOR LOCAL FORWARD_ONLY FOR
	SELECT 	StoreName, newStoreName,
			CASE
WHEN FullReason & 2 > 0	THEN IIF(createNewDDB = 1, (520 | (CAST(POWER(2, 24) AS BIGINT) * 32)), (517 | (CAST(POWER(2, 24) AS BIGINT) * 32)))
WHEN FullReason & 1 > 0	THEN IIF(createNewDDB = 1, (521 | (CAST(POWER(2, 24) AS BIGINT) * 32)), (522 | (CAST(POWER(2, 24) AS BIGINT) * 32)))
WHEN FullReason & 4 > 0	THEN IIF(createNewDDB = 1, (526 | (CAST(POWER(2, 24) AS BIGINT) * 32)), (528 | (CAST(POWER(2, 24) AS BIGINT) * 32)))
ELSE IIF(createNewDDB = 1, (525 | (CAST(POWER(2, 24) AS BIGINT) * 32)), (527 | (CAST(POWER(2, 24) AS BIGINT) * 32)))
			END
	FROM 	@lt_FullSIDBStores
	OPEN curNewStore
	FETCH NEXT FROM curNewStore INTO @cur_oldDDBName, @cur_newDDBName, @cur_msgId
	WHILE (@@FETCH_STATUS = 0)
	BEGIN
		TRUNCATE TABLE #NextEvIDTable
		INSERT INTO #NextEvIDTable
		EXECUTE GetNextEventId
		SELECT @EvMsgId = id FROM  #NextEvIDTable
		INSERT INTO EvMsg (id, TimeSource, TimeServer, Severity, Ack, Acked, Type,
			ParamNum, MessageId, JobId_h, JobId_l, ClientId, CommcellId,
			UserId, SubSystemId, Client, CommCell, UserName, SubSystem,
			MsgEnglish, RepeatCount, LastOccurrence, NextPost,
			mediaId, driveId, libraryId, maClientId)
SELECT  @EvMsgId, @l_now, @l_now, 9, 0, 0, 0,
				2, @cur_msgId, 0, 0, 2, 2,
				0, 0, @l_CSClientName, 0, 0, 'MediaManager',
				'', 1, @l_now, 1,
				0, 0, 0, 0
		INSERT 	INTO EvParam(EvMsgId, EventId, Position, Type, Size, Data)
		SELECT 	@EvMsgId, @cur_msgId, 1, 0, 0, @cur_oldDDBName
		UNION ALL
		SELECT 	@EvMsgId, @cur_msgId, 2, 0, 0, @cur_newDDBName
		FETCH NEXT FROM curNewStore INTO @cur_oldDDBName, @cur_newDDBName, @cur_msgId
	END
	CLOSE curNewStore
	DEALLOCATE curNewStore
IF @i_skipResults = 0
	SELECT 	@o_retVal, 0, 0, '', 0, '', 0, 0
RETURN
CX_ERROR_EXIT:
	IF @tranStarted = 1
		ROLLBACK TRAN
	IF @i_skipResults = 0
		SELECT 	@o_retVal, 0, 0, '', 0, '', 0, 0
IF OBJECT_ID('tempdb..#NextEvIDTable') IS NOT NULL DROP TABLE #NextEvIDTable
RETURN  @o_retVal
-- END of stored procedure
GO

IF EXISTS (select * from GxQscripts where name = 'archCreateNewDDBsOnFull')
	delete from GxQscripts where name = 'archCreateNewDDBsOnFull'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCreateNewDDBsOnFull')
	delete from GXDBVersions where aliasname = 'archCreateNewDDBsOnFull'
GO

insert into GXDBVersions values(2, 'archCreateNewDDBsOnFull',  'v1.1.2.21.4.1', 'archCreateNewDDBsOnFull', 'v1.1.2.21.4.1')
GO

