

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archCreateNewDDBGroup.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archCreateNewDDBGroup.sp,v $ $Id: archCreateNewDDBGroup.sp,v 1.1.2.4.4.1 2021/01/29 03:17:08 pnara Exp $";
--  +========================================================================+
--  | Stored Proc:  archCreateNewDDBGroup
--  |
--  | Description:  Creates new DDB Group
--	|
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archCreateNewDDBGroup')
BEGIN
	print '>>> Drop Stored Procedure: archCreateNewDDBGroup <<<'
	drop procedure archCreateNewDDBGroup
END
IF EXISTS (select * from GxQscripts where name='archCreateNewDDBGroup')
	delete from GxQscripts where name = 'archCreateNewDDBGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCreateNewDDBGroup')
	delete from GXDBVersions where aliasname = 'archCreateNewDDBGroup'
GO
print '... Creating Procedure: archCreateNewDDBGroup'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archCreateNewDDBGroup
  @i_copyId integer,
  @i_commCellId integer,
  @o_errorCode integer OUTPUT
AS
DECLARE		@o_retVal		INTEGER = 0
SET NOCOUNT ON
SET @o_errorCode = 2
DECLARE @maxNumPartitionsOnMA int = 50
DECLARE @createAppTypeDDBsPerCommCell int = 0
	DECLARE @createAppTypeDDBs BIT = 1
	DECLARE @numberOfFullDDBs INT = 0
	DECLARE @tranStarted BIT = 0
	SELECT	@maxNumPartitionsOnMA = value
	FROM	MMConfigs WITH (READUNCOMMITTED)
	WHERE	name = 'MMCONFIG_INFINI_STORE_MAX_PATITIONS_ON_MA'
	SELECT	@createAppTypeDDBsPerCommCell = value
	FROM	MMConfigs WITH (READUNCOMMITTED)
	WHERE	name = 'MMCONFIG_INFINI_STORE_CREATE_APPTYPE_DDBS_PER_COMMCELL'
	--
	-- Get existing DDB group and clone it to create new group
	--
	DECLARE @l_SIDBGroupId INT =
	(
		SELECT 	TOP 1 S.SIDBGroupId
		FROM	archCopySIDBStore CS WITH(READUNCOMMITTED),
				IdxSIDBStore S WITH(READUNCOMMITTED)
		WHERE	CS.copyId = @i_copyId
				AND CS.SIDBStoreId = S.SIDBStoreId
		ORDER BY S.SIDBGroupId
	)
	--
	-- Get DDBs to clone from selected group
	--
DECLARE @lt_FullSIDBStores TABLE ( CopyId 				int, SIDBGroupId			int, AppTypeGroupId 		int, SIDBStoreId 		int default 0, StoreName 			nvarchar(256) default N'', StoreAliasName 		nvarchar(256) default N'', AppTypeGroupName 	nvarchar(256) default N'', newSIDBStoreId 		int default 0, newStoreName 		nvarchar(256) default N'', FullReason			tinyint default 0, createNewDDB		BIT default 1 ) 			DELETE @lt_FullSIDBStores
	INSERT INTO @lt_FullSIDBStores (CopyId, SIDBGroupId, AppTypeGroupId, SIDBStoreId, AppTypeGroupName)
	SELECT	AGC.id, ST.SIDBGroupId, ST.AppTypeGroupId, ACS.SIDBStoreId, ISNULL(G.GroupName, '')
	FROM	archGroupCopy AGC with (readuncommitted)
			INNER JOIN archCopySIDBStore ACS with (readuncommitted) ON AGC.id = ACS.copyId
			INNER JOIN IdxSIDBStore ST with (readuncommitted) ON ACS.SIDBStoreId = ST.SIDBStoreId
LEFT OUTER JOIN App_AppTypeGroup G ON ST.AppTypeGroupId = G.AppTypeGroupId AND G.TypeOfGroup = 4
WHERE	ACS.flags & (4 | 1) = 4
	AND 	AGC.id = @i_copyId
	AND 	ST.SIDBGroupId = @l_SIDBGroupId
	SET @numberOfFullDDBs = @@ROWCOUNT
	IF @numberOfFullDDBs = 0
	BEGIN
		SET @o_retVal = -1
		GOTO CX_ERROR_EXIT;
	END
	--
	-- AppType based DDBs disabled for CommCellId groups then keep only one DDB
	--
IF @i_commCellId > 2 AND @createAppTypeDDBsPerCommCell = 0
	BEGIN
		SET @createAppTypeDDBs = 0
		DELETE 	@lt_FullSIDBStores
		WHERE	AppTypeGroupId NOT IN (SELECT TOP 1 AppTypeGroupId FROM @lt_FullSIDBStores ORDER BY AppTypeGroupId)
		SET @numberOfFullDDBs = @numberOfFullDDBs - @@ROWCOUNT
		IF @numberOfFullDDBs = 0
		BEGIN
			SET @o_retVal = -2
			GOTO CX_ERROR_EXIT;
		END
	END
	--
	-- Don't create more than 30 partitions (configurable) on a MA
	--
	DECLARE @lt_MAPartitions TABLE (ClientId INT, NumPartitions INT)
	;WITH NewPartitions AS
	(
		SELECT 	SS.clientId, COUNT(1) NumPartitions
		FROM	@lt_FullSIDBStores FS,
				IdxSIDBSubStore SS WITH(READUNCOMMITTED)
		WHERE	FS.SIDBStoreId = SS.SIDBStoreId
		GROUP BY SS.ClientId
	)
	INSERT INTO @lt_MAPartitions
	SELECT 	NP.ClientId, (SUM(T.NumPartitions) + NP.NumPartitions) NumPartitions
	FROM	NewPartitions NP,
			(
				SELECT 	SS.clientId, 1 NumPartitions
				FROM 	NewPartitions N,
						IdxSIDBSubStore SS WITH(READUNCOMMITTED)
				WHERE	N.clientId = SS.clientId
						AND EXISTS(SELECT 1 FROM archCopySIDBStore CS WITH(READUNCOMMITTED) WHERE CS.SIDBStoreId = SS.SIDBStoreId)
			) AS T
	WHERE	NP.clientId = T.clientId
	GROUP BY NP.ClientId, NP.NumPartitions
	HAVING (SUM(T.NumPartitions) + NP.NumPartitions) >= @maxNumPartitionsOnMA
	DELETE 	F
	FROM	@lt_FullSIDBStores F
	WHERE 	EXISTS
			(
				SELECT 	1
				FROM 	@lt_MAPartitions M,
						IdxSIDBSubStore SS WITH(READUNCOMMITTED)
				WHERE	SS.SIDBStoreId = F.SIDBStoreId
						AND M.ClientId = SS.clientId
			)
	SET @numberOfFullDDBs = @numberOfFullDDBs - @@ROWCOUNT
	IF @numberOfFullDDBs = 0
	BEGIN
		SET @o_retVal = -3
SET @o_errorCode = 361
		GOTO CX_ERROR_EXIT;
	END
	--
	-- Check if there are DDBs with AppTypeGroupId = 0 then create AppType DDBs
	-- DDBs created before InfiniStore feature will have AppTypeGroupId = 0
	--
	IF EXISTS(SELECT 1 FROM @lt_FullSIDBStores WHERE AppTypeGroupId = 0)
	BEGIN
		INSERT INTO @lt_FullSIDBStores (CopyId, SIDBGroupId, AppTypeGroupId, SIDBStoreId, AppTypeGroupName)
		SELECT 	S.CopyId, S.SIDBGroupId, G.AppTypeGroupId, S.SIDBStoreId, G.GroupName
		FROM	@lt_FullSIDBStores S,
				App_AppTypeGroup G WITH(READUNCOMMITTED)
		WHERE	S.AppTypeGroupId = 0
AND G.TypeOfGroup = 4
				AND (@createAppTypeDDBs = 1 OR G.AppTypeGroupId = 1001 /*APPGRP_DDB_FILES*/)
		DELETE @lt_FullSIDBStores WHERE	AppTypeGroupId = 0
	END
	--
	-- Set names for DDBs
	-- Format : <StoragePolicyName + [copyName] + [CommCell Name] + [AppTypeGroupName]>
	--
	UPDATE 	S
	SET 	StoreAliasName = AG.name
			+
			(
				--Append copy name for standalone copies
case when AGC.dedupeFlags & 268435456 = 0
					then N'_' + AGC.name
					else N''
				end
			)
			+
			(
				--Append CommCell name for migrated CommCells
case when @i_commCellId > 2
					then N'_' + CC.aliasName
					else N''
				end
			)
			+
			(
				--Append AppTypeGroupName for appType based DDBs
				case when @createAppTypeDDBs = 1
					then N'_' + S.AppTypeGroupName
					else N''
				end
			)
	FROM	@lt_FullSIDBStores S,
			ArchGroupCopy AGC WITH(READUNCOMMITTED),
			ArchGroup AG WITH(READUNCOMMITTED),
			App_CommCell CC WITH(READUNCOMMITTED)
	WHERE	S.CopyId = AGC.id
			AND AGC.archGroupId = AG.id
			AND CC.id = @i_commCellId
	--
	-- Now create new group and DDBs
	--
	BEGIN
		BEGIN TRY
			BEGIN TRAN
				SET @tranStarted = 1
				--
				-- Create new group
				--
				INSERT INTO IdxSIDBGroup (CopyId, CommCellId)
				SELECT @i_copyId, @i_commCellId
				SELECT	@o_retVal = @@ERROR, @l_SIDBGroupId = SCOPE_IDENTITY()
				IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
				UPDATE 	@lt_FullSIDBStores
				SET 	SIDBGroupId = @l_SIDBGroupId
				--
				-- Create DDBs
				--
--
-- BEGIN: archCreateNewDDBs.spb
--
				--
				-- Set name for DDB
				-- Format : <StoragePolicyName + [copyName] + [AppTypeGroupName]>
				--
				UPDATE 	S
				SET 	StoreAliasName = AG.name
						+
						(
							--Append copy name for standalone copies
case when AGC.dedupeFlags & 268435456 = 0
								then N'_' + AGC.name
								else N''
							end
						)
						+
						(
							--Append AppTypeGroupName for appType based DDBs
							case when S.AppTypeGroupId > 0
								then N'_' + S.AppTypeGroupName
								else N''
							end
						)
				FROM	@lt_FullSIDBStores S,
						ArchGroupCopy AGC WITH(READUNCOMMITTED),
						ArchGroup AG WITH(READUNCOMMITTED)
				WHERE	S.CopyId = AGC.id
						AND AGC.archGroupId = AG.id
						AND S.StoreAliasName = N''
DECLARE @GarbageCollectionConfig INT = ISNULL((SELECT value FROM MMConfigs WITH(READUNCOMMITTED) WHERE name = 'MMS2_CONFIG_ENABLE_DDB_GARBAGE_COLLECTION'), 1)
				DECLARE @l_CopyId INT = 0
				DECLARE @l_NewSIDBGroupId INT = 0
				DECLARE @l_AppTypeGroupId INT = 0
				DECLARE @l_OldStoreId INT = 0
				DECLARE @l_NewStoreId INT = 0
DECLARE @l_StoreAliasName nvarchar(256) = N''
				DECLARE @l_AppTypeGroupName nvarchar(256) = N''
				DECLARE @l_StrStoreId nvarchar(15) = N''
				DECLARE @l_SubStoreId INT = 0
				DECLARE	@l_DefSIDBStoreId	INT = 0
				DECLARE @l_nowTime INT = dbo.GetUnixTime(GETUTCDATE())
				DECLARE curStore CURSOR LOCAL FORWARD_ONLY FOR
				SELECT CopyId, SIDBGroupId, AppTypeGroupId, SIDBStoreId, StoreAliasName, AppTypeGroupName
				FROM @lt_FullSIDBStores
				WHERE  createNewDDB = 1
				ORDER BY AppTypeGroupId, SIDBStoreId
				OPEN curStore
				FETCH NEXT FROM curStore INTO @l_CopyId, @l_NewSIDBGroupId, @l_AppTypeGroupId, @l_oldStoreId, @l_StoreAliasName, @l_AppTypeGroupName
				WHILE (@@FETCH_STATUS = 0)
				BEGIN
					--Remove old storeId from name
					SET @l_StrStoreId = N'_' + CONVERT(nvarchar, @l_OldStoreId)
					SET @l_StoreAliasName = case when CHARINDEX(@l_StrStoreId, @l_StoreAliasName, len(@l_StoreAliasName) - len(@l_StrStoreId) + 1) > 0
												then LEFT(@l_StoreAliasName, CHARINDEX(@l_StrStoreId, @l_StoreAliasName, len(@l_StoreAliasName) - len(@l_StrStoreId) + 1) - 1)
												else @l_StoreAliasName
											end
					--
					--Create DDBs
					--
					INSERT  INTO IdxSIDBStore (SIDBStoreName, SIDBStoreAliasName, CommCellId,
								IdxCacheId, IdxAccessPathId, ClientId, FirstBackupTime,
								MinObjSizeKB, oldestEligibleObjArchiveTime, SignatureType,
								flags,
								TotalDataSizeBytes, InstancedDataSizeBytes, Status,
								LastAccessTime, CreatedTime, SealedTime, origCCSIDBStoreId,
								Version, SIDBSnapPath, LastSnapTime, LastRecoveryTime,
								SealedReason, SIDBSiloedTime, SIDBSiloStatus, SIDBSiloJobId,
								SubStoreCount, MaxAllowedConnections, MaxNumOfAFsInSecFile,
								LastDDBVerificationTime, LastDataVerificationTime, DedupFactor, AppTypeGroupId,
								ExtendedFlags, SIDBGroupId)
					SELECT  @l_StoreAliasName, @l_StoreAliasName, 2,
							IdxCacheId, IdxAccessPathId, ClientId, -1,
							MinObjSizeKB, oldestEligibleObjArchiveTime, SignatureType,
(flags & ~( 32 | 64 | 128 | 256 | 512 | 1024 | 2048 | 4096 | 8192 | 16384 | 32768 | 4194304 | 16777216 | 33554432 | 67108864 | 134217728 | 268435456 | 1073741824									)) | ( 536870912 | 131072),
							0, 0, 0,
							0, @l_nowTime, 0, 0,
							-1, SIDBSnapPath, 0, 0,
							0, 0, 0, 0,
							SubStoreCount, MaxAllowedConnections, 1 /*MaxNumOfAFsInSecFile*/,
							0, 0, DedupFactor, @l_AppTypeGroupId,
(ExtendedFlags & ~( 1 | 2											)) | ( 0 ) |
								(
CASE WHEN @GarbageCollectionConfig = 1 AND ((flags & ~( 32 | 64 | 128 | 256 | 512 | 1024 | 2048 | 4096 | 8192 | 16384 | 32768 | 4194304 | 16777216 | 33554432 | 67108864 | 134217728 | 268435456 | 1073741824									)) | ( 536870912 | 131072) & 8192) = 0
AND ExtendedFlags & (4 | 8) = 0
THEN (4 | 8)
										ELSE 0
									END
								),
							@l_NewSIDBGroupId
					FROM    IdxSIDBStore WITH (READUNCOMMITTED)
					WHERE 	SIDBStoreId = @l_OldStoreId
					SELECT	@o_retVal = @@ERROR, @l_NewStoreId = SCOPE_IDENTITY()
					IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
					SET @l_StoreAliasName = @l_StoreAliasName + N'_' + CONVERT(nvarchar, @l_NewStoreId)
					UPDATE 	@lt_FullSIDBStores
					SET		newSIDBStoreId 	= @l_NewStoreId,
							newStoreName 	= @l_StoreAliasName
					WHERE	SIDBStoreId = @l_oldStoreId
					SELECT	@o_retVal = @@ERROR
					IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
					--
					--Update name with new storeId
					--
					UPDATE  IdxSIDBStore
					SET     SIDBStoreName = @l_StoreAliasName,
							SIDBStoreAliasName = @l_StoreAliasName
					WHERE   SIDBStoreId = @l_NewStoreId
					SELECT	@o_retVal = @@ERROR
					IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
					--
					--Add association to copies
					--
					INSERT INTO archCopySIDBStore (CopyId, SIDBStoreId, CommCellId, flags, TotalDataSizeBytes, InstancedDataSizeBytes)
					SELECT
						CopyId,
@l_NewStoreId , CommCellId, flags & ~(1 | 2)
							, 0, 0
					FROM    archCopySIDBStore WITH (READUNCOMMITTED)
					WHERE	SIDBStoreId = @l_OldStoreId
							--Dependent copy can have data from only one CommCell so it can point to only one CommCellId group
							--so while creating new group add mapping to only GDSP
							--Mapping for dependent copy will be added after copy creation using this group
							AND copyId = @i_copyId
					SELECT	@o_retVal = @@ERROR
					IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
					--
					--Create SubStores
					--
					DECLARE curSubStore CURSOR LOCAL FORWARD_ONLY FOR
					SELECT 	SS.SubStoreId
					FROM 	IdxSIDBSubStore SS WITH (READUNCOMMITTED),
							IdxAccessPath AP WITH (READUNCOMMITTED)
					WHERE	SIDBStoreId = @l_OldStoreId
							AND SS.IdxAccessPathId = AP.IdxAccessPathId
					OPEN curSubStore
					FETCH NEXT FROM curSubStore INTO @l_SubStoreId
					WHILE (@@FETCH_STATUS = 0)
					BEGIN
						--
						-- Create SubStore
						--
						INSERT INTO IdxSIDBSubStore
							   ([SIDBStoreId], [commCellId], [GroupNumber], [IdxCacheId]
							   ,[IdxAccessPathId], [ClientId], [FirstBackupTime]
							   ,[flags]
							   ,[TotalDataSizeBytes],[InstancedDataSizeBytes],[Status],[LastAccessTime]
							   ,[CreatedTime],[SealedTime],[Version],[SIDBSnapPath]
							   ,[LastSnapTime],[origSubStoreId], [ReconLevel], LastSnapJobId, DDBBackupCSGUID, PrimaryId, MemDbTimeStamp, CorruptionTime, ZeroRefBatchSeq, StartLogSequence, EndLogSequence, SnapLogSequence, MaxNumOfAFsInSecFile
							   ,ExtendedFlags, PageSize)
						SELECT
							   @l_NewStoreId, SS.commCellId, SS.GroupNumber, SS.IdxCacheId
							   ,SS.IdxAccessPathId, SS.ClientId,-1
,(SS.flags & ~( 32 | 64 | 128 | 256 | 512 | 1024 | 2048 | 4096 | 8192 | 16384 | 32768 | 4194304 | 16777216 | 33554432 | 67108864 | 134217728 | 268435456 | 1073741824									)) | ( 536870912 | 131072)
							   ,0,0,0,0
							   ,@l_nowTime,0,-1,''
							   ,0,0, 0, 0, '',0, 0, 0, 0
							   , '', '', '', 1 /*MaxNumOfAFsInSecFile*/
,(SS.ExtendedFlags & ~(	4	)) |
(CASE WHEN S.ExtendedFlags & 4 > 0 THEN 1 ELSE 0 END) |
(CASE WHEN S.ExtendedFlags & 8 > 0 THEN 2 ELSE 0 END)
							   ,SS.PageSize
						FROM	IdxSIDBSubStore SS WITH(READUNCOMMITTED),
								IdxSIDBStore S WITH(READUNCOMMITTED)
						WHERE	SS.SIDBStoreId = @l_OldStoreId
								AND SS.SubStoreId = @l_SubStoreId
								AND S.SIDBStoreId = @l_NewStoreId
						SELECT	@o_retVal = @@ERROR
						IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
						FETCH NEXT FROM curSubStore INTO @l_SubStoreId
					END
					CLOSE curSubStore
					DEALLOCATE curSubStore
					FETCH NEXT FROM curStore INTO @l_CopyId, @l_NewSIDBGroupId, @l_AppTypeGroupId, @l_oldStoreId, @l_StoreAliasName, @l_AppTypeGroupName
				END
				CLOSE curStore
				DEALLOCATE curStore
--
-- END: archCreateNewDDBs.spb
--
			COMMIT TRAN
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			SET @o_retVal = ERROR_NUMBER()
			GOTO CX_ERROR_EXIT;
		END CATCH
	END
	SET @o_retVal = 0
	SET @o_errorCode = 0
RETURN
CX_ERROR_EXIT:
IF @tranStarted = 1
	ROLLBACK TRAN
RETURN  @o_retVal
RETURN
-- END of stored procedure
GO

IF EXISTS (select * from GxQscripts where name = 'archCreateNewDDBGroup')
	delete from GxQscripts where name = 'archCreateNewDDBGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCreateNewDDBGroup')
	delete from GXDBVersions where aliasname = 'archCreateNewDDBGroup'
GO

insert into GXDBVersions values(2, 'archCreateNewDDBGroup',  'v1.1.2.4.4.1', 'archCreateNewDDBGroup', 'v1.1.2.4.4.1')
GO

