

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archCreateCopySubClientDDBMAp.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  archCreateCopySubClientDDBMAp.sp                        	  */
/*                                                                            */
/*  Description :  Create archSubClientCopyDDBMap entries                     */
/*																			  */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archCreateCopySubClientDDBMAp.sp,v $ $Id: archCreateCopySubClientDDBMAp.sp,v 1.1.2.18.4.1 2021/01/29 03:17:12 pnara Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archCreateCopySubClientDDBMAp')
BEGIN
	print '>>> Drop Stored Procedure: archCreateCopySubClientDDBMAp <<<'
	drop procedure archCreateCopySubClientDDBMAp
END
IF EXISTS (select * from GxQscripts where name='archCreateCopySubClientDDBMAp')
	delete from GxQscripts where name = 'archCreateCopySubClientDDBMAp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCreateCopySubClientDDBMAp')
	delete from GXDBVersions where aliasname = 'archCreateCopySubClientDDBMAp'
GO
print '... Creating Procedure: archCreateCopySubClientDDBMAp'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archCreateCopySubClientDDBMAp
  @i_appIdsXML XML,
  @i_isAuxCopy INT = 0
AS
  DECLARE @o_outXML XML
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @isTmpTablePrePopulated BIT = 0
IF object_id('tempdb.dbo.#inputApps') is not null
	SET @isTmpTablePrePopulated = 1
ELSE
	CREATE TABLE #inputApps -- only populate appID and copyID if this table is being created in the caller
	(
		appId	 INT,
		copyId	 INT,
		appTypeId	INT,
		instanceId	INT,
		clientId  INT,
		clientstatus INT,
		releaseId INT,
		servicePack INT
	)
if object_id('tempdb.dbo.#pseudoClientApps') is not null drop table #pseudoClientApps
CREATE TABLE #pseudoClientApps
(
	appId	 INT,
	copyId	 INT,
	appTypeId	INT,
	instanceId	INT,
	pseudoClientId  INT,
	pseudoClientstatus INT,
	minReleaseId INT,
	minServicePack INT
)
DECLARE @xmlText  XML
DECLARE @skipVersionCheck BIT = 0
IF @isTmpTablePrePopulated = 0
BEGIN
	insert into #inputApps (appId,copyId)
	select DISTINCT N.value(N'(subclient/@subclientId)[1]', N'int'),N.value(N'(copy/@copyId)[1]', N'int')
	from @i_appIdsXML.nodes('//subclientToCopyMaps') AS T(N)
END
UPDATE 	#inputApps
SET 	appTYpeId = aa.appTYpeId, instanceId = aa.instance, clientId = aa.clientId, releaseId = c.releaseId
FROM 	#inputApps t
		INNER JOIN app_application aa WITH(READUNCOMMITTED) ON aa.id = t.appId
		INNER JOIN app_client c WITH(READUNCOMMITTED) ON c.id = aa.clientId
--Skip version check if all clients in CommCell are at v11 SP14 or higher
IF NOT EXISTS
(
	SELECT 	1
	FROM 	App_Client  CN WITH(READUNCOMMITTED)
			INNER JOIN simInstalledPackages PKG WITH(READUNCOMMITTED) ON PKG.clientID = CN.id
	WHERE	(
				CN.releaseId < 16
				OR (CN.releaseId = 16 AND PKG.highestSP < 14)
			)
)
BEGIN
	SET @skipVersionCheck = 1
	GOTO INSERT_MAPS;
END
UPDATE 	#inputApps
SET 	servicePack = t2.SP
FROM 	#inputApps t1,
		(
			SELECT 	t.appId, MAX(s.highestSP) SP
			FROM 	#inputApps t
					LEFT JOIN simInstalledPackages s WITH(READUNCOMMITTED) ON s.clientID = t.clientID
			GROUP BY t.appId
		) t2
WHERE 	t1.appId= t2.appId
--
-- Backups won't run to uninstalled clients but auxcopy can still run.
-- Set supported version for such clients since only auxcopy can run to it and client version doesn't matter for aux
-- if user installs packages with older version then we fail backups during setup pipeline so no issues.
--
UPDATE	SC
SET		servicePack = 14
FROM	#inputApps SC,
		App_ClientProp CP WITH(READUNCOMMITTED)
WHERE	SC.servicePack IS NULL
		AND SC.clientId = CP.componentNameId
		AND CP.attrName = N'PlatformDeleted 4'
		AND CP.modified = 0
		AND CP.attrVal = N'1'
--
-- Get Pseudo clients if there are any
--
insert 	into #pseudoClientApps (appId, copyId, appTypeId, instanceId, pseudoClientId,pseudoClientstatus )
SELECT 	DISTINCT appId, copyId, appTypeId, instanceId, clientId, clientstatus
FROM 	#inputApps t
WHERE 	servicePack IS NULL
IF @@ROWCOUNT = 0  -- no psuedo clients, just jump to insertion part
	GOTO INSERT_MAPS;
--
-- BEGIN: Get Version for pseudo clients
--
--
-- BEGIN: archGetMinVersionOfAccessNodesForSC.spb
--
if object_id('tempdb.dbo.#pseudoClientApps') is  null
BEGIN
	GOTO CX_EXIT;
END
DECLARE @ProxyTable TABLE
(
	pseudoClientId int,
	proxyClientId int
)
DECLARE @instanceId int
DECLARE @actualInstance int
DEClARE @clientId int
declare @appTypeId int
declare @appId int
DECLARE @inputxml XML
DECLARE @outputXML XML
UPDATE t
SET pseudoClientId = c.id, pseudoClientstatus = status , appTypeId = aa.appTypeId, instanceId = aa.instance
FROM app_client c WITH(READUNCOMMITTED), app_Application aa WITH(READUNCOMMITTED), #pseudoClientApps t
WHERE c.id = aa.clientID AND aa.id = t.appId
--
-- Exchange DAG
--
IF EXISTS (SELECT 1 FROM  #pseudoClientApps WHERE pseudoClientstatus & 0x200000 = 0x200000)
BEGIN
	INSERT 	INTO @ProxyTable
	SELECT  PC.pseudoClientId, EP.id
	FROM   	#pseudoClientApps PC
			INNER JOIN app_clientprop prop WITH(READUNCOMMITTED)
				on PC.pseudoClientId = prop.componentNameId
				and prop.attrType = 125 /*PROPERTY_DAG_MEMBERSERVER*/
				and prop.modified = 0
			INNER JOIN app_client EP WITH(READUNCOMMITTED)
				on EP.net_hostname = prop.attrName
WHERE 	PC.pseudoClientstatus & 0x200000 = 0x200000
			AND NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY PC.pseudoClientId, EP.id
END
--
-- Oracle RAC
--
IF EXISTS (SELECT 1 FROM  #pseudoClientApps WHERE pseudoClientstatus & 0x0040 = 0x0040)
BEGIN
IF EXISTS (SELECT 1 FROM APP_InstanceName I WITH (READUNCOMMITTED), #pseudoClientApps PC WHERE PC.instanceId = I.Id AND I.status & 0x0800 = 0x0800)
	BEGIN
		INSERT 	INTO @ProxyTable
		SELECT  PC.pseudoClientId, EP.id
FROM   	#pseudoClientApps PC INNER JOIN APP_InstanceName I WITH (READUNCOMMITTED) ON I.Id = PC.instanceId AND I.status & 0x0800 = 0x0800 INNER JOIN App_Application A WITH (READUNCOMMITTED) ON A.clientId = PC.pseudoClientId
				INNER JOIN APP_OracleRacInstance R WITH(READUNCOMMITTED)
					ON A.instance = R.instaceId
AND PC.appTypeId = 80
				INNER JOIN app_client EP WITH(READUNCOMMITTED)
					ON EP.id = R.clientid
WHERE 	PC.pseudoClientstatus & 0x0040 = 0x0040
				AND NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = EP.id)
		GROUP BY PC.pseudoClientId, EP.id
	END
	INSERT 	INTO @ProxyTable
	SELECT  PC.pseudoClientId, EP.id
	FROM   	#pseudoClientApps PC
			INNER JOIN APP_OracleRacInstance R WITH(READUNCOMMITTED)
				ON PC.instanceId = R.instaceId
AND PC.appTypeId = 80
			INNER JOIN app_client EP WITH(READUNCOMMITTED)
				ON EP.id = R.clientid
WHERE 	PC.pseudoClientstatus & 0x0040 = 0x0040
			AND NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY PC.pseudoClientId, EP.id
END
--
-- MS SQL
--
IF EXISTS (SELECT 1 FROM  #pseudoClientApps WHERE appTypeId = 81)
BEGIN
	INSERT 	INTO @ProxyTable
	SELECT  T.pseudoClientId, EP.id
	FROM   	(
				select 	PC.pseudoClientId, cast(prop.attrval as xml) as replicas
				from  	#pseudoClientApps PC,
						APP_InstanceProp prop WITH(READUNCOMMITTED)
				where 	prop.attrName ='Availability Replicas'
						and prop.modified = 0
						and PC.instanceId = prop.componentNameId
and PC.appTypeId = 81
and PC.pseudoClientstatus & 0x20000000 = 0x20000000
			) T, app_client EP WITH(READUNCOMMITTED)
	WHERE	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = T.pseudoClientId AND P.proxyClientId = EP.id)
	AND    EP.id IN  (SELECT N.value('(replicaClient/@clientId)[1]','int') FROM T.replicas.nodes('App_SQLAvailabilityReplicas/SQLAvailabilityReplicasList') AS T(N) )
	GROUP BY T.pseudoClientId, EP.id
	INSERT 	INTO @ProxyTable
	SELECT  T.pseudoClientId, EP.id
	FROM   	(
				SELECT 	PC.pseudoClientId, cast(AIP.attrval as xml) memberServers
				FROM	#pseudoClientApps PC
						INNER JOIN APP_IDAName AID WITH(READUNCOMMITTED) ON PC.pseudoClientId = AID.clientId  AND PC.appTypeId = AID.appTypeId
						INNER JOIN APP_IDAProp AIP WITH(READUNCOMMITTED)
							ON AID.id = AIP.componentNameId
							AND AIP.attrName = N'Cloud Proxy Servers'
							AND AIP.modified = 0
WHERE	PC.appTypeId = 81
AND PC.pseudoClientstatus & 0x20000000 = 0
			) T
			inner join app_client EP WITH(READUNCOMMITTED)
				on
				(
					EP.id IN (SELECT N.value('(client/@clientId)[1]','int') FROM T.memberServers.nodes('App_MemberServers/memberServers') AS T(N)  )
					OR
					EP.id IN
					(
						SELECT 	clientId
						FROM 	APP_ClientGroupAssoc WITH(READUNCOMMITTED)
						WHERE 	clientGroupId IN ( SELECT   N.value('(client/@clientGroupId)[1]','int') FROM T.memberServers.nodes('App_MemberServers/memberServers') AS T(N)  )
					)
				)
	WHERE 	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = T.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY T.pseudoClientId, EP.id
END
--
-- Oracle Agentless
--
IF EXISTS (SELECT 1 FROM  #pseudoClientApps WHERE appTypeId = 22)
BEGIN
	INSERT 	INTO @ProxyTable
	SELECT  T.pseudoClientId, EP.id
	FROM   	(
				select 	pseudoClientId, prop.componentNameId, cast(prop.attrval as xml) as bkpConfigNodes
				from  	#pseudoClientApps PC,
						APP_InstanceProp prop WITH(READUNCOMMITTED)
				where 	prop.attrName = 'DB Thin Client Proxy Client List'
						and prop.modified = 0
						and PC.instanceId = prop.componentNameId
and PC.appTypeId = 22
			) T
			inner join app_client EP WITH(READUNCOMMITTED)
				on
				(
					EP.id IN (SELECT  N.value('(@clientId)[1]','int') FROM T.bkpConfigNodes.nodes('App_BackupConfigurationNodes/backupDataAccessNodes') AS T(N) )
					OR
					EP.id IN
					(
						SELECT 	clientId
						FROM 	APP_ClientGroupAssoc WITH(READUNCOMMITTED)
						WHERE 	clientGroupId IN ( SELECT   N.value('(@clientGroupId)[1]','int') FROM T.bkpConfigNodes.nodes('App_BackupConfigurationNodes/backupDataAccessNodes') AS T(N))
					)
				)
	WHERE 	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = T.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY T.pseudoClientId, EP.id
END
--
-- Cloud Apps
--
--IF EXISTS (SELECT 1 FROM  #pseudoClientApps WHERE appTypeId IN (134, 33, 104))
BEGIN
	INSERT 	INTO @ProxyTable
	SELECT  T.pseudoClientId, EP.id
	FROM   	(
				select 	pseudoClientId, prop.componentNameId, cast(prop.attrval as xml) as bkpConfigNodes
				from  	#pseudoClientApps PC,
						APP_InstanceProp prop WITH(READUNCOMMITTED)
				where 	prop.attrName in ( 'Proxy Clients','Amazon S3 Proxy Clients','Azure Proxy Clients', 'Oracle Cloud Proxy Clients',
					'Openstack Proxy Clients', 'Google Cloud Proxy Clients', 'Azure DL Proxy Clients')
						and prop.modified = 0
						and PC.instanceId = prop.componentNameId
and PC.appTypeId IN (134, 33)
			) T
			inner join app_client EP WITH(READUNCOMMITTED)
				on
				(
					EP.id IN
					(
						SELECT  N.value('(@clientId)[1]','int') FROM T.bkpConfigNodes.nodes('App_GeneralCloudProperties/proxyServers') AS T(N)
						UNION
						SELECT  N.value('(client/@clientId)[1]','int') FROM T.bkpConfigNodes.nodes('App_GeneralCloudProperties/memberServers') AS T(N)
						UNION
						SELECT 	clientId
						FROM 	APP_ClientGroupAssoc WITH(READUNCOMMITTED)
						WHERE 	clientGroupId IN ( SELECT   N.value('(client/@clientGroupId)[1]','int') FROM T.bkpConfigNodes.nodes('App_GeneralCloudProperties/memberServers') AS T(N)  )
					)
				)
	WHERE 	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = T.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY T.pseudoClientId, EP.id
	UNION
	SELECT  PC.pseudoClientId, EP.id
	FROM   	#pseudoClientApps PC
			inner join APP_InstanceProp I WITH(READUNCOMMITTED)
				on PC.instanceId = I.componentNameId
				and I.attrname  = 'Salesforce backup client'
				and I.modified =0
			inner join app_client EP WITH(READUNCOMMITTED)
				on cast(EP.id as nvarchar) = I.attrval
WHERE 	PC.appTypeId IN (134, 33)
			AND NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY PC.pseudoClientId, EP.id
	UNION
	SELECT  T.pseudoClientId, EP.id
	FROM   	(
				SELECT 	PC.pseudoClientId, cast(prop.attrval as xml) dataNodes
				FROM #pseudoClientApps PC
					INNER JOIN APP_IDAName I WITH(READUNCOMMITTED) on PC.pseudoClientId = I.clientId AND PC.appTypeId = I.appTypeId
					INNER JOIN App_IDAProp prop WITH(READUNCOMMITTED)
					on prop.componentNameId = I.id
					AND prop.attrname  = 'Cloud DB Config'
					and prop.modified =0
			) T
			inner join app_client EP WITH(READUNCOMMITTED)
				on EP.id IN
				(
					SELECT N.value('(client/@clientId)[1]','int') FROM T.dataNodes.nodes('App_CloudDBConfig/dbProxyClientList') AS T(N)
					UNION
					SELECT 	clientId
					FROM 	APP_ClientGroupAssoc WITH(READUNCOMMITTED)
					WHERE 	clientGroupId IN ( SELECT   N.value('(client/@clientGroupId)[1]','int') FROM T.dataNodes.nodes('App_CloudDBConfig/dbProxyClientList') AS T(N)  )
				)
	WHERE 	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = T.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY T.pseudoClientId, EP.id
END
--
-- Distributed iDA
--
IF EXISTS (SELECT 1 FROM  #pseudoClientApps WHERE appTypeId = 64)
BEGIN
	INSERT 	INTO @ProxyTable
	SELECT  PC.pseudoClientId, EP.id
	FROM   	#pseudoClientApps PC
			INNER JOIN APP_InstanceProp prop WITH(READUNCOMMITTED)
				on PC.instanceId = prop.componentNameId
				and prop.attrName IN ('Greenplum Master Client Id','Coordinator Node')
				and prop.modified = 0
			inner join app_client EP WITH(READUNCOMMITTED)
				on EP.id = prop.attrVal
WHERE 	PC.appTypeId = 64
			AND NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY PC.pseudoClientId, EP.id
	INSERT 	INTO @ProxyTable
	SELECT  T.pseudoClientId, EP.id
	FROM   	(
				select 	pseudoClientId, prop.componentNameId, cast(REPLACE(prop.attrval, '<?xml version="1.0" encoding="UTF-8" standalone="no" ?>','') as xml) as dataNodes
				from  	#pseudoClientApps PC,
						APP_SubClientProp prop WITH(READUNCOMMITTED)
				where 	prop.attrName = 'Data Access Nodes'
						and prop.modified = 0
						and PC.appId = prop.componentNameId
and PC.appTypeId = 64
			) T
			inner join app_client EP WITH(READUNCOMMITTED)
				on EP.id IN (SELECT N.value('(@clientId)[1]','int') FROM T.dataNodes.nodes('App_DataAccessNodes/dataAccessNodes') AS T(N))
	WHERE 	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = T.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY T.pseudoClientId, EP.id
	--For CTree Index Server, MediaAgent acts as a proxy
	INSERT 	INTO @ProxyTable
	SELECT 	PC.pseudoClientId, dp.clientId
	FROM   	#pseudoClientApps PC
			INNER JOIN App_ClientProp CP WITH(READUNCOMMITTED)
				ON PC.pseudoClientId = CP.componentNameId
AND CP.attrName = 'Index Server Type'
				AND CP.modified = 0
AND CP.attrVal = N'15'
			INNER JOIN APP_InstanceProp IP WITH(READUNCOMMITTED)
				ON PC.instanceId = IP.componentNameId
AND IP.attrName = 'Distributed Cluster Type'
				AND IP.modified = 0
AND IP.attrVal = N'7'
			INNER JOIN MMDataPath dPath WITH(READUNCOMMITTED) ON dPath.copyId = PC.copyId
			INNER JOIN MMDrivePool dp WITH(READUNCOMMITTED) ON dPath.DrivePoolId = dp.DrivePoolId
WHERE	PC.appTypeId = 64
			AND NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = dp.clientId)
	--For Solr Index Server, find nodes
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
    CREATE TABLE #getIndexServers
                        (     serverURL NVARCHAR(512),
                                clientId INT,
                                clientName NVARCHAR(256),
                                cloudId INT,
                                hostName NVARCHAR(256),
                                basePort INT,
                                engineName  NVARCHAR(256),
                                serverType INT,
                                indexServerClientId INT,
                                internalCloudName NVARCHAR(256)
                        )
    EXEC DM2GetIndexServers
	INSERT 	INTO @ProxyTable
	SELECT 	PC.pseudoClientId, ISrvr.clientId
	FROM   	#pseudoClientApps PC
			INNER JOIN #getIndexServers ISrvr ON PC.pseudoClientId = ISrvr.indexServerClientId
WHERE	PC.appTypeId = 64
			AND NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = ISrvr.clientId)
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
END
--
-- Exchange OnePass
--
IF EXISTS (SELECT 1 FROM  #pseudoClientApps WHERE appTypeId = 137)
BEGIN
	INSERT 	INTO @ProxyTable
	SELECT  T.pseudoClientId, EP.id
	FROM   	(
				select 	PC.pseudoClientId, cast(replace(prop.attrval,'encoding="UTF-8"', '') as xml) as dataNodes
				from  	#pseudoClientApps PC
						INNER JOIN APP_IDAName I WITH(READUNCOMMITTED) on PC.pseudoClientId = I.clientId AND PC.appTypeId = I.appTypeId
						INNER JOIN App_IDAProp prop WITH(READUNCOMMITTED)
							ON prop.attrName ='OnePass Member Servers'
							and prop.modified = 0
							and prop.componentNameId  = I.id
where 	PC.appTypeId = 137
			) T
			inner join app_client EP
				on
				(
					EP.id IN (SELECT N.value('(client/@clientId)[1]','int') FROM T.dataNodes.nodes('App_MemberServers/memberServers') AS T(N))
					OR
					EP.id IN
					(
						SELECT 	clientID
						FROM 	APP_ClientGroupAssoc WITH(READUNCOMMITTED)
						WHERE	clientGroupID IN (SELECT N.value('(client/@clientGroupId)[1]','int') FROM T.dataNodes.nodes('App_MemberServers/memberServers') AS T(N))
					)
				)
	WHERE 	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = T.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY T.pseudoClientId, EP.id
	--For Case Manager, MediaAgent acts as a proxy
	INSERT 	INTO @ProxyTable
	SELECT 	PC.pseudoClientId, dp.clientId
	FROM   	#pseudoClientApps PC
			INNER JOIN App_ClientProp CP WITH(READUNCOMMITTED)
				ON PC.pseudoClientId = CP.componentNameId
				AND CP.attrName = N'Case Manager Pseudo Client'
				AND CP.modified = 0
				AND CP.attrVal = N'1'
			INNER JOIN MMDataPath dPath WITH(READUNCOMMITTED) ON dPath.copyId = PC.copyId
			INNER JOIN MMDrivePool dp WITH(READUNCOMMITTED) ON dPath.DrivePoolId = dp.DrivePoolId
WHERE	PC.appTypeId = 137
			AND NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = dp.clientId)
END
--
-- VSA
--
IF EXISTS (SELECT 1 FROM  #pseudoClientApps WHERE appTypeId = 106)
BEGIN
	declare cur CURSOR LOCAL for
		select DISTINCT pseudoClientId, Prop.componentNameId, PC.instanceId
		FROM #pseudoClientApps PC INNER JOIN APP_InstanceProp Prop ON
							(PC.instanceID = Prop.componentNameId OR
							 prop.componentNameId IN (SELECT attrVal FROM APP_ClientProp cp WHERE cp.componentNameId = PC.pseudoClientId AND cp.attrName = 'Virtual Machine Instance ID'))
							AND Prop.attrName LIKE 'Virtual Server Instance Type'
							AND Prop.modified = 0
	open cur
	fetch next from cur into @clientId, @instanceId, @actualInstance
	while @@FETCH_STATUS = 0
	BEGIN
		SET @inputxml = '<App_GetVSMemberServersRequest expandClientGroup="1"><entity _type_="5" instanceId="' + convert(varchar(10),@instanceId) + '"/></App_GetVSMemberServersRequest>'
		IF OBJECT_ID('tempdb..#lt_AppGetVSMemberServersOutput') IS NOT NULL DROP TABLE #lt_AppGetVSMemberServersOutput
		CREATE TABLE #lt_AppGetVSMemberServersOutput (xmlOutput XML)
		exec AppGetVSMemberServers @inputxml
		SELECT	@outputXML = xmlOutput
		FROM 	#lt_AppGetVSMemberServersOutput
		IF OBJECT_ID('tempdb..#lt_AppGetVSMemberServersOutput') IS NOT NULL DROP TABLE #lt_AppGetVSMemberServersOutput
		insert into @ProxyTable
		select 	@clientId, c.value('@clientId','int')
		from 	@outputXML.nodes('App_GetVSMemberServersResponse/associatedClients/memberServers/client') C ( c )
		where 	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = @clientId AND P.proxyClientId = c.value('@clientId','int'))
		fetch next from cur into @clientId, @instanceId, @actualInstance
	END
	close cur
	deallocate cur
END
--
-- NAS, non NDMP
--
IF EXISTS( SELECT 1 FROM #pseudoClientApps PC WHERE pseudoClientstatus & (CAST(0x0080 AS BIGINT)|CAST(0x8000000 AS BIGINT)) > 0 )
BEGIN
	declare cur CURSOR LOCAL for
		select Pc.pseudoClientId, PC.InstanceId, PC.ApptypeId, PC.appId
		from #pseudoClientApps  PC
WHERE pseudoClientstatus & (CAST(0x0080 AS BIGINT)|CAST(0x8000000 AS BIGINT) ) > 0
	open cur
	fetch next from cur into @clientId, @instanceId, @appTypeId, @appId
	while @@FETCH_STATUS = 0
	BEGIN
		IF OBJECT_ID('tempdb..#lt_AppGetBackupConfigNodesOutput') IS NOT NULL DROP TABLE #lt_AppGetBackupConfigNodesOutput
		CREATE TABLE #lt_AppGetBackupConfigNodesOutput (xmlOutput XML)
		exec AppGetBackupConfigNodes @clientId, @appTypeId, @appId, 0, 2, 0,0, 0
		SELECT	@outputXML = xmlOutput
		FROM 	#lt_AppGetBackupConfigNodesOutput
		IF OBJECT_ID('tempdb..#lt_AppGetBackupConfigNodesOutput') IS NOT NULL DROP TABLE #lt_AppGetBackupConfigNodesOutput
		insert into @ProxyTable
		select 	@clientId, c.value('@clientId','int')
		from 	@outputXML.nodes('App_BackupConfigurationNodes/backupDataAccessNodes') C ( c )
		where 	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = @clientId AND P.proxyClientId = c.value('@clientId','int'))
		fetch next from cur into @clientId, @instanceId, @appTypeId, @appId
	END
	close cur
	deallocate cur
	--For NAS, the proxies are optional and MediaAgent acts as a proxy if there are no proxies returned by AppGetBackupConfigNodes
	INSERT 	INTO @ProxyTable
	SELECT 	PC.pseudoClientId, dp.ClientId
	FROM   	#pseudoClientApps PC
			INNER JOIN MMDataPath dPath WITH(READUNCOMMITTED) ON dPath.copyId = PC.copyId
			INNER JOIN MMDrivePool dp WITH(READUNCOMMITTED) ON dPath.DrivePoolId = dp.DrivePoolId
WHERE	PC.pseudoClientstatus & (CAST(0x0080 AS BIGINT)|CAST(0x8000000 AS BIGINT)) > 0
			AND NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId)
END
--
-- Open VMS
--
IF EXISTS  (SELECT 1 FROM  #pseudoClientApps WHERE appTypeId = 38)
BEGIN
	INSERT 	INTO @ProxyTable
	SELECT  T.pseudoClientId, EP.id
	FROM   	(
				select 	PC.pseudoClientId, cast(prop.attrval as xml) as bkpConfigNodes
				from	#pseudoClientApps PC,
						APP_ClientProp prop WITH(READUNCOMMITTED)
				where 	PC.pseudoClientId = prop.componentNameId
						and prop.attrName = 'Open VMS proxy client list'
						and prop.modified = 0
and PC.appTypeId = 38
			) T
			inner join app_client EP WITH(READUNCOMMITTED)
				on
				(
					EP.id IN (SELECT N.value('(@clientId)[1]','int') FROM T.bkpConfigNodes.nodes('App_BackupConfigurationNodes/backupDataAccessNodes') AS T(N))
					OR
					EP.id IN (SELECT clientID FROM APP_ClientGroupAssoc WITH(READUNCOMMITTED) where clientGroupID IN (SELECT N.value('(@clientGroupId)[1]','int') FROM T.bkpConfigNodes.nodes('App_BackupConfigurationNodes/backupDataAccessNodes') AS T(N)))
				)
	WHERE 	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = T.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY T.pseudoClientId, EP.id
END
--
-- Cluster Clients
--
INSERT 	INTO @ProxyTable
SELECT	PC.pseudoClientId, VC.PMClientId
FROM	#pseudoClientApps PC
		INNER JOIN APP_VMToPMMap VC WITH(READUNCOMMITTED) ON VC.VMClientId = PC.pseudoClientId
WHERE 	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = VC.PMClientId)
GROUP BY PC.pseudoClientId, VC.PMClientId
--
-- SAP HANA
--
IF EXISTS (SELECT 1 FROM  #pseudoClientApps WHERE appTypeId = 135)
BEGIN
	INSERT 	INTO @ProxyTable
	SELECT  PC.pseudoClientId, EP.id
	FROM   	#pseudoClientApps PC
			INNER JOIN app_InstanceProp ip WITH(READUNCOMMITTED)
				on PC.instanceID = ip.componentNameId
				and ip.attrName = 'Database Clients'
				and ip.modified = 0
			CROSS APPLY dbo.SplitIDString(replace(ip.attrVal,'+',',')) T
			INNER JOIN app_client EP WITH(READUNCOMMITTED)
				on EP.id =  T._ID
WHERE 	PC.appTypeId = 135
			AND NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY PC.pseudoClientId, EP.id
END
--
-- DB2
--
IF EXISTS (SELECT 1 FROM  #pseudoClientApps WHERE appTypeId = 103)
BEGIN
	INSERT 	INTO @ProxyTable
	SELECT  PC.pseudoClientId, EP.id
	FROM   	#pseudoClientApps PC
			INNER JOIN app_InstanceProp ip WITH(READUNCOMMITTED)
				on PC.instanceID = ip.componentNameId
				and ip.attrName = 'DB2 Partition Clients'
				and ip.modified = 0
			CROSS APPLY dbo.SplitString(IP.attrVal, ' ') T
			INNER JOIN app_client EP WITH(READUNCOMMITTED)
				on EP.id =  substring(T.Data, CHARINDEX(',', T.Data)+1, LEN(T.Data))
WHERE 	PC.appTypeId = 103
			AND NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY PC.pseudoClientId, EP.id
END
--
-- 3dfs
--
IF EXISTS (SELECT 1 FROM  #pseudoClientApps t, APP_SubClientProp sp
WHERE appTypeId = 29 AND sp.componentNameId = t.appID AND sp.attrname='3dfs Is NFS Share Enabled' AND attrVal = 1)
BEGIN
	INSERT 	INTO @ProxyTable
	SELECT  PC.pseudoClientId, EP.id
	FROM   	#pseudoClientApps PC
			INNER JOIN APP_SubClientProp sp1 WITH(READUNCOMMITTED)
				ON sp1.attrName = 'Associated subclient Policy'
				AND sp1.modified = 0
				AND sp1.componentNameId = PC.appId
			INNER JOIN APP_SubClientProp sp2 WITH(READUNCOMMITTED)
				ON sp1.attrVal = sp2.componentNameId AND sp2.attrName = '3dfs NFS Servers'
			inner join app_client EP WITH(READUNCOMMITTED)
				on EP.name = sp2.attrVal
WHERE 	PC.appTypeId = 29
			AND EXISTS (SELECT 1 FROM APP_SubClientProp WHERE componentNameId = PC.appID AND attrname='3dfs Is NFS Share Enabled' AND attrVal = 1)
			AND NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY PC.pseudoClientId, EP.id
END
--
-- Edge Drive
--
IF EXISTS (SELECT 1 FROM  #pseudoClientApps WHERE pseudoClientstatus & 0x10000000 = 0x10000000)
BEGIN
	--Get all webservers
	INSERT 	INTO @ProxyTable
	SELECT  PC.pseudoClientId, PKG.clientId
	FROM   	#pseudoClientApps PC,
			simInstalledPackages PKG WITH(READUNCOMMITTED)
WHERE 	PC.pseudoClientstatus & 0x10000000 = 0x10000000
AND PKG.simPackageID = 252
	GROUP BY PC.pseudoClientId, PKG.clientId
	--Get connected laptop clients configured for offline backup
	INSERT 	INTO @ProxyTable
	SELECT  PC.pseudoClientId, SC.clientId
	FROM   	#pseudoClientApps PC
			INNER JOIN App_SyncCloudConfig SC WITH(READUNCOMMITTED) ON PC.appId = SC.subclientId
			INNER JOIN App_SyncCloudFolder SF WITH(READUNCOMMITTED)
ON SF.syncWebFolderId = SC.syncWebFolderId AND SF.flag & 0x10 = 0x10
WHERE 	PC.pseudoClientstatus & 0x10000000 = 0x10000000
			AND SC.syncType  = 3 -- Edge offline linked laptops
	GROUP BY PC.pseudoClientId, SC.clientId
END
IF EXISTS(SELECT 1 FROM  #pseudoClientApps WHERE pseudoClientstatus & 0x1000 = 0x1000)
BEGIN
	INSERT 	INTO @ProxyTable
	SELECT  PC.pseudoClientId, ACP.attrval
	FROM   	#pseudoClientApps PC, APP_ClientProp ACP WITH (READUNCOMMITTED)
	WHERE	PC.pseudoClientId = ACP.componentNameId AND ACP.attrname = 'Physical Client Id' AND ACP.modified = 0
AND PC.pseudoClientstatus & 0x1000 = 0x1000
	GROUP BY PC.pseudoClientId, ACP.attrval
END
--
-- O365
--
IF EXISTS (SELECT 1 FROM  #pseudoClientApps WHERE appTypeId = 78)
BEGIN
	INSERT 	INTO @ProxyTable
	SELECT  T.pseudoClientId, EP.id
	FROM   	(
				select 	PC.pseudoClientId, cast(replace(prop.attrval,'encoding="UTF-8"', '') as xml) as dataNodes
				from  	#pseudoClientApps PC
						INNER JOIN APP_IDAName I WITH(READUNCOMMITTED) on PC.pseudoClientId = I.clientId AND PC.appTypeId = I.appTypeId
						INNER JOIN App_IDAProp prop WITH(READUNCOMMITTED)
							ON prop.attrName ='Sharepoint Member Servers'
							and prop.modified = 0
							and prop.componentNameId  = I.id
where 	PC.appTypeId = 78
				UNION ALL
				select 	PC.pseudoClientId, cast(replace(prop.stringVal,'encoding="UTF-8"', '') as xml) as dataNodes
				from  	#pseudoClientApps PC
						INNER JOIN APP_ComponentProp prop WITH(READUNCOMMITTED)
on PC.pseudoClientId = prop.componentId AND prop.propertyTypeId = 1046
							and prop.modified = 0
where 	PC.appTypeId = 78
			) T
			inner join app_client EP
				on
				(
					EP.id IN (SELECT N.value('(client/@clientId)[1]','int') FROM T.dataNodes.nodes('App_MemberServers/memberServers') AS T(N))
					OR
					EP.id IN
					(
						SELECT 	clientID
						FROM 	APP_ClientGroupAssoc WITH(READUNCOMMITTED)
						WHERE	clientGroupID  IN (SELECT N.value('(client/@clientGroupId)[1]','int') FROM T.dataNodes.nodes('App_MemberServers/memberServers') AS T(N))
					)
				)
	WHERE 	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = T.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY T.pseudoClientId, EP.id
	UNION
	SELECT  PC.pseudoClientId, EP.id
	FROM   	#pseudoClientApps PC
INNER JOIN app_clientProp prop WITH(READUNCOMMITTED) ON PC.pseudoClientId = componentNameId AND attrName = 'SharePoint Primary Member Server' AND PC.appTypeId = 78 AND prop.modified = 0
			inner join app_client EP WITH(READUNCOMMITTED) ON EP.Id = prop.attrVal
	WHERE 	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY PC.pseudoClientId, EP.id
END
--
-- Azure AD
--
IF EXISTS (SELECT 1 FROM  #pseudoClientApps WHERE appTypeId = 139)
BEGIN
	INSERT 	INTO @ProxyTable
	SELECT  T.pseudoClientId, EP.id
	FROM   	(
				select 	PC.pseudoClientId, cast(replace(prop.attrval,'encoding="UTF-8"', '') as xml) as dataNodes
				from  	#pseudoClientApps PC
						INNER JOIN APP_IDAName I WITH(READUNCOMMITTED) on PC.pseudoClientId = I.clientId AND PC.appTypeId = I.appTypeId
						INNER JOIN App_IDAProp prop WITH(READUNCOMMITTED)
							ON prop.attrName ='Azure AD Member Servers'
							and prop.modified = 0
							and prop.componentNameId  = I.id
where 	PC.appTypeId = 139
			) T
			inner join app_client EP
				on
				(
					EP.id IN (SELECT N.value('(client/@clientId)[1]','int') FROM T.dataNodes.nodes('App_MemberServers/memberServers') AS T(N))
					OR
					EP.id IN
					(
						SELECT 	clientID
						FROM 	APP_ClientGroupAssoc WITH(READUNCOMMITTED)
						WHERE	clientGroupID  IN (SELECT N.value('(client/@clientGroupId)[1]','int') FROM T.dataNodes.nodes('App_MemberServers/memberServers') AS T(N))
					)
				)
	WHERE 	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = T.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY T.pseudoClientId, EP.id
END
---
--- Case Manager
---
IF EXISTS (SELECT 1 FROM   	#pseudoClientApps PC
			INNER JOIN App_ClientProp CP WITH(READUNCOMMITTED)
				ON PC.pseudoClientId = CP.componentNameId
				AND CP.attrName = 'Case Manager Pseudo Client' AND CP.attrVal = 1
				AND CP.modified = 0)
BEGIN
	--For CTree Index Server, MediaAgent acts as a proxy
	INSERT 	INTO @ProxyTable
	SELECT 	PC.pseudoClientId, dp.clientId
	FROM   	#pseudoClientApps PC
			INNER JOIN App_ClientProp CP WITH(READUNCOMMITTED)
				ON PC.pseudoClientId = CP.componentNameId
				AND CP.attrName = 'Case Manager Pseudo Client' AND CP.attrVal = 1
				AND CP.modified = 0
			INNER JOIN MMDataPath dPath WITH(READUNCOMMITTED) ON dPath.copyId = PC.copyId
			INNER JOIN MMDrivePool dp WITH(READUNCOMMITTED) ON dPath.DrivePoolId = dp.DrivePoolId
	WHERE	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = dp.clientId)
END
--
-- Final Step:
-- Get min Version for each pseudo client
--
;WITH ClientVersion AS
(
	SELECT  T.pseudoClientId, MIN(CN.ReleaseId) minReleaseId, MIN(PKG.HighestSP) minServicePack
	FROM    (
				SELECT 	PC.pseudoClientId, ISNULL(VC.PMClientId, PC.proxyClientId) proxyClientId
				FROM 	@ProxyTable PC
						LEFT OUTER JOIN APP_VMToPMMap VC WITH(READUNCOMMITTED) ON VC.VMClientId = PC.proxyClientId
			) T
			INNER JOIN App_Client CN WITH(READUNCOMMITTED) ON CN.id = T.proxyClientId
			INNER JOIN simInstalledPackages PKG WITH(READUNCOMMITTED) ON CN.id = PKG.ClientId
	GROUP BY T.pseudoClientId
)
UPDATE 	PC
SET		minReleaseId = V.minReleaseId,
		minServicePack = V.minServicePack
FROM	#pseudoClientApps PC,
		ClientVersion V
WHERE	PC.pseudoClientId = V.pseudoClientId
UPDATE 	PC
SET		minReleaseId = 16,
		minServicePack = CASE WHEN  AI.attrVal = 3 THEN  22 ELSE 17 END
FROM	#pseudoClientApps PC, APP_InstanceProp AI WITH (READUNCOMMITTED)
WHERE	appTypeId = 134 AND AI.componentNameId = PC.instanceId AND AI.attrName = 'Cloud Apps Instance Type' AND AI.attrVal IN (3, 22, 23, 24, 25) --SALESFORCE , AMAZON_DYNAMODB, COSMOSDB, ALICLOUD, IBM_COS
UPDATE 	PC
SET		minReleaseId = 16,
		minServicePack = 18
FROM	#pseudoClientApps PC
WHERE 	ISNULL(minReleaseId ,0) = 0 AND ISNULL(minServicePack, 0) = 0
AND appTypeId IN (125,104)
CX_EXIT:
--
-- END: archGetMinVersionOfAccessNodesForSC.spb
--
--
-- END: Get Version for pseudo clients
--
UPDATE 	#inputApps
SET 	servicePack = minServicePack, releaseId = minReleaseId
FROM 	#pseudoClientApps p, #inputApps t
WHERE 	t.appId = p.appId
IF @i_isAuxCopy = 0
BEGIN
	IF NOT EXISTS (SELECT 1 FROM MMConfigs WITH (NOLOCK) WHERE name = 'MMCONFIG_SKIP_DDB_MAP_CHECK_FOR_INFINISTORE' and Value > 0)
	BEGIN
		DELETE 	#inputApps
		WHERE 	servicePack IS NULL
	END
END
ELSE
BEGIN
	--
	-- Proxies may be removed after backup is done in case of uninstalled/deconfigured/deactivated clients but auxcopy can still run.
	-- Set supported version for such clients since only auxcopy can run to it and client version doesn't matter for aux
	--
	UPDATE	#inputApps
	SET		servicePack = 14
	WHERE	servicePack IS NULL
END
INSERT_MAPS:
DECLARE @subclientLimit int = 0
DECLARE @infiniDDB BIT = 0
IF EXISTS(SELECT 1 FROM MMConfigs WITH(READUNCOMMITTED) WHERE name = 'MMS2_CONFIG_ENABLE_INFINI_STORE' AND value = 1)
BEGIN
	SET @infiniDDB = 1
	SELECT	@subclientLimit = value
	FROM	MMConfigs WITH (READUNCOMMITTED)
	WHERE	name = 'MMCONFIG_INFINI_STORE_NUMBER_OF_SUBCLIENTS'
END
DECLARE @l_appId 			INT = 0
DECLARE @l_tcopyId 			INT = 0
DECLARE @l_hostCopyId 		INT = 0
DECLARE @l_appTypeId		INT = 0
DECLARE @l_releaseId		INT = 0
DECLARE @l_servicePack		INT = 0
DECLARE @l_SIDBStoreId		INT = 0
DECLARE @l_tappTypeGroupId	INT = 0
DECLARE @l_scAppTypeGroupId	INT = 0
DECLARE @l_scAppTypeGroupName	NVARCHAR(1024) = N''
DECLARE @l_DDBCommCellId	INT = 2
DECLARE @l_SIDBGroupId		INT = 0
DECLARE @l_StoreName 		nvarchar(256) = N''
DECLARE @l_StoreIdStr 		nvarchar(15) = N''
DECLARE @o_retVal 			INT = 0
DECLARE @l_lockName			nvarchar(255) = N''
DECLARE @l_lockRetVal		INT = 0
-- We take transaction level lock so start a tran if not started by caller already
DECLARE @l_isTranStarted BIT = 0
IF @@TRANCOUNT = 0
BEGIN
	BEGIN TRAN
	SET @l_isTranStarted = 1
END
DECLARE curApp CURSOR LOCAL FORWARD_ONLY FOR
SELECT 	SC.appId, SC.copyId, SC.appTypeId, ISNULL(SC.releaseId, 0), ISNULL(SC.servicePack, 0), ISNULL(G.defaultCopy, SC.copyId) hostCopyId
FROM 	#inputApps SC
		LEFT OUTER JOIN archCopyToGlobalPolicy CG WITH(READUNCOMMITTED) ON CG.copyId = SC.copyId
		LEFT OUTER JOIN archGroup G WITH(READUNCOMMITTED) ON CG.globalPolicyId = G.id
WHERE	SC.copyId > 0
		AND NOT EXISTS(SELECT 1 FROM archSubclientCopyDDBMap ASCM WITH(READUNCOMMITTED) WHERE ASCM.copyId = SC.copyId AND ASCM.appId = SC.appID)
OPEN curApp
FETCH NEXT FROM curApp INTO @l_appId, @l_tcopyId, @l_appTypeId, @l_releaseId, @l_servicePack, @l_hostCopyId
WHILE (@@FETCH_STATUS = 0)
BEGIN
	SELECT  TOP 1 @l_scAppTypeGroupId = ATGA.appGroupId, @l_scAppTypeGroupName = ATG.GroupName
	FROM 	APP_AppTypeGroupAssoc ATGA WITH (NOLOCK),
			App_AppTypeGroup ATG WITH(NOLOCK)
	WHERE 	ATGA.appGroupId = ATG.appTypeGroupId
			AND (ATGA.appTypeId = @l_appTypeId OR ATGA.appGroupId = 1001 /*APPGRP_DDB_FILES*/)
AND ATGA.TypeOfGroup = 0
AND ATG.TypeOfGroup = 4
	ORDER BY (CASE WHEN ATGA.appTypeId = @l_appTypeId THEN 0 ELSE 1 END)  --matching by subclient appType else files group
	--
	-- MR#305500
	-- Multiple process may call this stored proc simultaneously
	-- if 2 processes calls this proc for subclients of same appType and pointing to same storage pool then there is a chance that we may create 2 DDBs for that appType.
	-- to avoid creating multiple DDBs take lock on storage pool and appTypeGroup, format:  CreateSubclientToDDBMap_<copyId>_<appTypeGroupId>
	--
	SET @l_lockName = N'CreateSubclientToDDBMap_' + CAST(@l_hostCopyId as NVARCHAR(20)) + N'_' + CAST(@l_scAppTypeGroupId as NVARCHAR(20))
	EXEC @l_lockRetVal = sp_getapplock @Resource = @l_lockName, @LockMode = 'Exclusive', @LockTimeout = 300000  /*5 mins in milliseconds*/
	IF @l_lockRetVal >= 0
	BEGIN
	SELECT 	TOP 1 @l_SIDBStoreId = S.SIDBStoreId, @l_tappTypeGroupId = S.AppTypeGroupId, @l_DDBCommCellId = SG.CommCellId, @l_SIDBGroupId = S.SIDBGroupId, @l_StoreName = SIDBStoreName
	FROM 	archCopySIDBStore ACS WITH (NOLOCK)
			INNER JOIN IdxSIDBStore S WITH (NOLOCK) ON ACS.SIDBStoreId = S.SIDBStoreId
			INNER JOIN IdxSIDBGroup SG WITH (NOLOCK) ON S.SIDBGroupId = SG.SIDBGroupId
	WHERE 	(
				(
					@skipVersionCheck = 1
AND (ACS.flags & 1) = 0
				)
				OR
				(
					(@l_releaseId > 16
					OR (@l_releaseId = 16 AND @l_servicePack > 13))
AND (ACS.flags & 1) = 0 -- it is not possible to have all full DDBs
				)
				OR
				(
					(
						@l_releaseId < 16
						OR (@l_releaseId = 16 AND @l_servicePack < 14)
					)
					AND
					(
(ACS.flags & 2 /*IDX_COPY_DDB_DEFAULT*/) > 0
OR SG.CommCellId > 2 --Only aux will run for migrated data and default DDB may only be in CCId 2 group
					)
				)
			)
AND ACS.flags & 4 = 4 -- IDX_COPY_DDB_ACTIVE
			AND ACS.CopyId = @l_tcopyId
	ORDER BY
			--Non full DDB first
ACS.flags & 1,
			--Matching DDB by AppType first
			(CASE WHEN S.AppTypeGroupId = @l_scAppTypeGroupId THEN 0 ELSE 1 END),
			--Default DDB
(CASE WHEN (ACS.flags & 2 /*IDX_COPY_DDB_DEFAULT*/) > 0 THEN 0 ELSE 1 END),
			S.SIDBStoreId
	IF @infiniDDB = 1
	BEGIN
		--
		-- The first DDB created as part of copy creation won't be assigned to any apptype
		-- Update the appType with the first subclient getting associated with the DDB.
		-- This is done to avoid create 3 DDB initially even if user is using only one appType clients.
		-- With this if only VSA is used then only VSA DDB will be present and no other appType DDBs will be created.
		--
		-- Create second/third DDB if appType DDB is exists.
		-- skip creating second and third DDB for migrated CommCell group DDBs.
		--
		IF @l_tappTypeGroupId = 0
		BEGIN
			--
			--Update DDB appTypeGroup and name
			--
			--Remove storeId from name and append it after adding appTypeGroupName
			SET @l_StoreIdStr = N'_' + CONVERT(nvarchar, @l_SIDBStoreId)
			SET @l_StoreName = (case when CHARINDEX(@l_StoreIdStr, @l_StoreName, len(@l_StoreName) - len(@l_StoreIdStr) + 1) > 0
										then LEFT(@l_StoreName, CHARINDEX(@l_StoreIdStr, @l_StoreName, len(@l_StoreName) - len(@l_StoreIdStr) + 1) - 1)
										else @l_StoreName
									end) + '_' + @l_scAppTypeGroupName + @l_StoreIdStr
			--Alias name is used to find sealed DDB for store priming feature so don't update alias name if there is already another DDB with same alias name.
			UPDATE 	IdxSIDBStore
			SET		SIDBStoreName = @l_StoreName,
					SIDBStoreAliasName = (CASE WHEN EXISTS(SELECT 1 FROM IdxSIDBStore WITH(READUNCOMMITTED) WHERE SIDBStoreId <> @l_SIDBStoreId AND SIDBStoreAliasName = @l_StoreName) THEN SIDBStoreAliasName ELSE @l_StoreName END),
					AppTypeGroupId = @l_scAppTypeGroupId
			WHERE	SIDBStoreId = @l_SIDBStoreId
		END
		ELSE IF @l_tappTypeGroupId > 0 AND @l_scAppTypeGroupId <> @l_tappTypeGroupId
AND @l_DDBCommCellId = 2
				AND (@skipVersionCheck = 1 OR @l_releaseId > 16 OR (@l_releaseId = 16 AND @l_servicePack > 13))
		BEGIN
			-- To create multiple DDBs all MAs (DDB and Datamover) should be at v11 SP15 or higher
			IF NOT EXISTS
			(
				SELECT 	1
				FROM	App_Client CN WITH(READUNCOMMITTED)
						INNER JOIN simInstalledPackages PKG WITH(READUNCOMMITTED) ON CN.id = PKG.ClientId
						INNER JOIN
						(
							SELECT 	ISNULL(VC.PMClientId, ST.clientId) clientId
							FROM	IdxSIDBSubStore ST WITH(READUNCOMMITTED)
									LEFT OUTER JOIN APP_VMToPMMap VC WITH(READUNCOMMITTED) ON ST.clientId = VC.VMClientId
							WHERE	ST.SIDBStoreId = @l_SIDBStoreId
							UNION
							SELECT	ISNULL(VC.PMClientId, LDPool.clientId) clientId
							FROM	MMDataPath DPath WITH(READUNCOMMITTED)
									INNER JOIN MMDrivePool DPool WITH(READUNCOMMITTED) ON DPath.DrivePoolId = DPool.DrivePoolId
									INNER JOIN MMDrivePool LDPool WITH(READUNCOMMITTED) ON DPool.MasterPoolId = LDPool.MasterPoolId
									LEFT OUTER JOIN APP_VMToPMMap VC WITH(READUNCOMMITTED) ON LDPool.clientId = VC.VMClientId
							WHERE	DPath.copyId = @l_tcopyId
						) AS T ON CN.id = T.clientId
				WHERE	(CN.releaseId < 16 OR (CN.releaseId = 16 AND PKG.HighestSP < 15))
AND PKG.simPackageID IN (51, 1301)
			)
			BEGIN
				--
				-- Crate new DDB
				--
DECLARE @lt_FullSIDBStores TABLE ( CopyId 				int, SIDBGroupId			int, AppTypeGroupId 		int, SIDBStoreId 		int default 0, StoreName 			nvarchar(256) default N'', StoreAliasName 		nvarchar(256) default N'', AppTypeGroupName 	nvarchar(256) default N'', newSIDBStoreId 		int default 0, newStoreName 		nvarchar(256) default N'', FullReason			tinyint default 0, createNewDDB		BIT default 1 ) 			DELETE @lt_FullSIDBStores
				INSERT INTO @lt_FullSIDBStores (CopyId, SIDBGroupId, AppTypeGroupId, SIDBStoreId, AppTypeGroupName)
				SELECT	@l_hostCopyId, @l_SIDBGroupId, @l_scAppTypeGroupId, @l_SIDBStoreId, @l_scAppTypeGroupName
				SET @o_retVal = 0
--
-- BEGIN: archCreateNewDDBs.spb
--
				--
				-- Set name for DDB
				-- Format : <StoragePolicyName + [copyName] + [AppTypeGroupName]>
				--
				UPDATE 	S
				SET 	StoreAliasName = AG.name
						+
						(
							--Append copy name for standalone copies
case when AGC.dedupeFlags & 268435456 = 0
								then N'_' + AGC.name
								else N''
							end
						)
						+
						(
							--Append AppTypeGroupName for appType based DDBs
							case when S.AppTypeGroupId > 0
								then N'_' + S.AppTypeGroupName
								else N''
							end
						)
				FROM	@lt_FullSIDBStores S,
						ArchGroupCopy AGC WITH(READUNCOMMITTED),
						ArchGroup AG WITH(READUNCOMMITTED)
				WHERE	S.CopyId = AGC.id
						AND AGC.archGroupId = AG.id
						AND S.StoreAliasName = N''
DECLARE @GarbageCollectionConfig INT = ISNULL((SELECT value FROM MMConfigs WITH(READUNCOMMITTED) WHERE name = 'MMS2_CONFIG_ENABLE_DDB_GARBAGE_COLLECTION'), 1)
				DECLARE @l_CopyId INT = 0
				DECLARE @l_NewSIDBGroupId INT = 0
				DECLARE @l_AppTypeGroupId INT = 0
				DECLARE @l_OldStoreId INT = 0
				DECLARE @l_NewStoreId INT = 0
DECLARE @l_StoreAliasName nvarchar(256) = N''
				DECLARE @l_AppTypeGroupName nvarchar(256) = N''
				DECLARE @l_StrStoreId nvarchar(15) = N''
				DECLARE @l_SubStoreId INT = 0
				DECLARE	@l_DefSIDBStoreId	INT = 0
				DECLARE @l_nowTime INT = dbo.GetUnixTime(GETUTCDATE())
				DECLARE curStore CURSOR LOCAL FORWARD_ONLY FOR
				SELECT CopyId, SIDBGroupId, AppTypeGroupId, SIDBStoreId, StoreAliasName, AppTypeGroupName
				FROM @lt_FullSIDBStores
				WHERE  createNewDDB = 1
				ORDER BY AppTypeGroupId, SIDBStoreId
				OPEN curStore
				FETCH NEXT FROM curStore INTO @l_CopyId, @l_NewSIDBGroupId, @l_AppTypeGroupId, @l_oldStoreId, @l_StoreAliasName, @l_AppTypeGroupName
				WHILE (@@FETCH_STATUS = 0)
				BEGIN
					--Remove old storeId from name
					SET @l_StrStoreId = N'_' + CONVERT(nvarchar, @l_OldStoreId)
					SET @l_StoreAliasName = case when CHARINDEX(@l_StrStoreId, @l_StoreAliasName, len(@l_StoreAliasName) - len(@l_StrStoreId) + 1) > 0
												then LEFT(@l_StoreAliasName, CHARINDEX(@l_StrStoreId, @l_StoreAliasName, len(@l_StoreAliasName) - len(@l_StrStoreId) + 1) - 1)
												else @l_StoreAliasName
											end
					--
					--Create DDBs
					--
					INSERT  INTO IdxSIDBStore (SIDBStoreName, SIDBStoreAliasName, CommCellId,
								IdxCacheId, IdxAccessPathId, ClientId, FirstBackupTime,
								MinObjSizeKB, oldestEligibleObjArchiveTime, SignatureType,
								flags,
								TotalDataSizeBytes, InstancedDataSizeBytes, Status,
								LastAccessTime, CreatedTime, SealedTime, origCCSIDBStoreId,
								Version, SIDBSnapPath, LastSnapTime, LastRecoveryTime,
								SealedReason, SIDBSiloedTime, SIDBSiloStatus, SIDBSiloJobId,
								SubStoreCount, MaxAllowedConnections, MaxNumOfAFsInSecFile,
								LastDDBVerificationTime, LastDataVerificationTime, DedupFactor, AppTypeGroupId,
								ExtendedFlags, SIDBGroupId)
					SELECT  @l_StoreAliasName, @l_StoreAliasName, 2,
							IdxCacheId, IdxAccessPathId, ClientId, -1,
							MinObjSizeKB, oldestEligibleObjArchiveTime, SignatureType,
(flags & ~( 32 | 64 | 128 | 256 | 512 | 1024 | 2048 | 4096 | 8192 | 16384 | 32768 | 4194304 | 16777216 | 33554432 | 67108864 | 134217728 | 268435456 | 1073741824									)) | ( 536870912 | 131072),
							0, 0, 0,
							0, @l_nowTime, 0, 0,
							-1, SIDBSnapPath, 0, 0,
							0, 0, 0, 0,
							SubStoreCount, MaxAllowedConnections, 1 /*MaxNumOfAFsInSecFile*/,
							0, 0, DedupFactor, @l_AppTypeGroupId,
(ExtendedFlags & ~( 1 | 2											)) | ( 0 ) |
								(
CASE WHEN @GarbageCollectionConfig = 1 AND ((flags & ~( 32 | 64 | 128 | 256 | 512 | 1024 | 2048 | 4096 | 8192 | 16384 | 32768 | 4194304 | 16777216 | 33554432 | 67108864 | 134217728 | 268435456 | 1073741824									)) | ( 536870912 | 131072) & 8192) = 0
AND ExtendedFlags & (4 | 8) = 0
THEN (4 | 8)
										ELSE 0
									END
								),
							@l_NewSIDBGroupId
					FROM    IdxSIDBStore WITH (READUNCOMMITTED)
					WHERE 	SIDBStoreId = @l_OldStoreId
					SELECT	@o_retVal = @@ERROR, @l_NewStoreId = SCOPE_IDENTITY()
					IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
					SET @l_StoreAliasName = @l_StoreAliasName + N'_' + CONVERT(nvarchar, @l_NewStoreId)
					UPDATE 	@lt_FullSIDBStores
					SET		newSIDBStoreId 	= @l_NewStoreId,
							newStoreName 	= @l_StoreAliasName
					WHERE	SIDBStoreId = @l_oldStoreId
					SELECT	@o_retVal = @@ERROR
					IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
					--
					--Update name with new storeId
					--
					UPDATE  IdxSIDBStore
					SET     SIDBStoreName = @l_StoreAliasName,
							SIDBStoreAliasName = @l_StoreAliasName
					WHERE   SIDBStoreId = @l_NewStoreId
					SELECT	@o_retVal = @@ERROR
					IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
					--
					--Add association to copies
					--
					INSERT INTO archCopySIDBStore (CopyId, SIDBStoreId, CommCellId, flags, TotalDataSizeBytes, InstancedDataSizeBytes)
					SELECT
						CopyId,
@l_NewStoreId , CommCellId, flags & ~(1 | 2)
							, 0, 0
					FROM    archCopySIDBStore WITH (READUNCOMMITTED)
					WHERE	SIDBStoreId = @l_OldStoreId
					SELECT	@o_retVal = @@ERROR
					IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
					--
					--Create SubStores
					--
					DECLARE curSubStore CURSOR LOCAL FORWARD_ONLY FOR
					SELECT 	SS.SubStoreId
					FROM 	IdxSIDBSubStore SS WITH (READUNCOMMITTED),
							IdxAccessPath AP WITH (READUNCOMMITTED)
					WHERE	SIDBStoreId = @l_OldStoreId
							AND SS.IdxAccessPathId = AP.IdxAccessPathId
					OPEN curSubStore
					FETCH NEXT FROM curSubStore INTO @l_SubStoreId
					WHILE (@@FETCH_STATUS = 0)
					BEGIN
						--
						-- Create SubStore
						--
						INSERT INTO IdxSIDBSubStore
							   ([SIDBStoreId], [commCellId], [GroupNumber], [IdxCacheId]
							   ,[IdxAccessPathId], [ClientId], [FirstBackupTime]
							   ,[flags]
							   ,[TotalDataSizeBytes],[InstancedDataSizeBytes],[Status],[LastAccessTime]
							   ,[CreatedTime],[SealedTime],[Version],[SIDBSnapPath]
							   ,[LastSnapTime],[origSubStoreId], [ReconLevel], LastSnapJobId, DDBBackupCSGUID, PrimaryId, MemDbTimeStamp, CorruptionTime, ZeroRefBatchSeq, StartLogSequence, EndLogSequence, SnapLogSequence, MaxNumOfAFsInSecFile
							   ,ExtendedFlags, PageSize)
						SELECT
							   @l_NewStoreId, SS.commCellId, SS.GroupNumber, SS.IdxCacheId
							   ,SS.IdxAccessPathId, SS.ClientId,-1
,(SS.flags & ~( 32 | 64 | 128 | 256 | 512 | 1024 | 2048 | 4096 | 8192 | 16384 | 32768 | 4194304 | 16777216 | 33554432 | 67108864 | 134217728 | 268435456 | 1073741824									)) | ( 536870912 | 131072)
							   ,0,0,0,0
							   ,@l_nowTime,0,-1,''
							   ,0,0, 0, 0, '',0, 0, 0, 0
							   , '', '', '', 1 /*MaxNumOfAFsInSecFile*/
,(SS.ExtendedFlags & ~(	4	)) |
(CASE WHEN S.ExtendedFlags & 4 > 0 THEN 1 ELSE 0 END) |
(CASE WHEN S.ExtendedFlags & 8 > 0 THEN 2 ELSE 0 END)
							   ,SS.PageSize
						FROM	IdxSIDBSubStore SS WITH(READUNCOMMITTED),
								IdxSIDBStore S WITH(READUNCOMMITTED)
						WHERE	SS.SIDBStoreId = @l_OldStoreId
								AND SS.SubStoreId = @l_SubStoreId
								AND S.SIDBStoreId = @l_NewStoreId
						SELECT	@o_retVal = @@ERROR
						IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
						FETCH NEXT FROM curSubStore INTO @l_SubStoreId
					END
					CLOSE curSubStore
					DEALLOCATE curSubStore
					FETCH NEXT FROM curStore INTO @l_CopyId, @l_NewSIDBGroupId, @l_AppTypeGroupId, @l_oldStoreId, @l_StoreAliasName, @l_AppTypeGroupName
				END
				CLOSE curStore
				DEALLOCATE curStore
--
-- END: archCreateNewDDBs.spb
--
				CX_ERROR_EXIT:
				IF @o_retVal <> 0
				BEGIN
					SET	@l_SIDBStoreId = 0
				END
				ELSE
				BEGIN
					--Associate subclient to newly created DDB
					SELECT 	@l_SIDBStoreId = newSIDBStoreId
					FROM 	@lt_FullSIDBStores
					WHERE	SIDBStoreId = @l_SIDBStoreId
					SET @l_tappTypeGroupId = @l_scAppTypeGroupId
				END
			END
		END
	END
	IF @l_SIDBStoreId > 0
	BEGIN
		INSERT INTO archSubclientCopyDDBMap (appId, copyId, SIDBStoreId)
		SELECT 	@l_appId, @l_tcopyId, @l_SIDBStoreId
		WHERE 	NOT EXISTS(SELECT 1 FROM archSubclientCopyDDBMap ASCM WHERE ASCM.copyId = @l_tcopyId AND ASCM.appId = @l_appId)
		--
		-- If subclient limit config param is enabled then call create new DDB to mark DDB full if limit reached
		-- Don't call the proc if client version is below v11 SP14 since it will always gets mapped to default DDB regardless of limit
		--
		IF 	@subclientLimit > 0
			AND
			(
				@skipVersionCheck = 1
				OR @l_releaseId > 16
				OR (@l_releaseId = 16 AND @l_servicePack > 13)
			)
		IF 	(
SELECT	SUM(case when CN.status & 0x1000 > 0 then 0.5 else 1 end) NumberOfSubClients
				FROM	archSubclientCopyDDBMap M WITH(READUNCOMMITTED),
						App_Application SC WITH(READUNCOMMITTED),
						App_Client CN WITH(READUNCOMMITTED)
				WHERE	M.SIDBStoreId = @l_SIDBStoreId
						AND M.appId = SC.id
						AND SC.clientId = CN.id
			) >= @subclientLimit
		BEGIN
			EXEC archCreateNewDDBsOnFull @l_hostCopyId, @l_tappTypeGroupId, 1 /*skipResults*/
		END
	END
	--
	-- Release lock
	--
	EXEC sp_releaseapplock @Resource = @l_lockName
	END --@l_lockRetVal >= 0
	FETCH NEXT FROM curApp INTO @l_appId, @l_tcopyId, @l_appTypeId, @l_releaseId, @l_servicePack, @l_hostCopyId
END
CLOSE curApp
DEALLOCATE curApp
IF @l_isTranStarted = 1
BEGIN
	COMMIT TRAN
END
SET @xmlText =
(
	SELECT ERROR_STATE() AS N'@errorCode', ERROR_MESSAGE() AS N'@errorString'
	FOR XML PATH(N'App_GenericEntityResponse'), TYPE
)
IF @isTmpTablePrePopulated = 0
BEGIN
	IF object_id('tempdb.dbo.#inputApps') is not null DROP TABLE #inputApps
END
IF OBJECT_ID('tempdb..#lt_archCreateCopySubClientDDBMApOutput') IS NOT NULL
	INSERT INTO #lt_archCreateCopySubClientDDBMApOutput
	SELECT @xmlText
ELSE
	SELECT @xmlText
GO

IF EXISTS (select * from GxQscripts where name = 'archCreateCopySubClientDDBMAp')
	delete from GxQscripts where name = 'archCreateCopySubClientDDBMAp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCreateCopySubClientDDBMAp')
	delete from GXDBVersions where aliasname = 'archCreateCopySubClientDDBMAp'
GO

insert into GXDBVersions values(2, 'archCreateCopySubClientDDBMAp',  'v1.1.2.18.4.1', 'archCreateCopySubClientDDBMAp', 'v1.1.2.18.4.1')
GO

