

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archCopyUseGlobalPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archCopyUseGlobalPolicy.sp,v $ $Id: archCopyUseGlobalPolicy.sp,v 1.1.2.6 2020/03/05 01:45:50 pveeravalli Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archCopyUseGlobalPolicy')
BEGIN
	print '>>> Drop Stored Procedure: archCopyUseGlobalPolicy <<<'
	drop procedure archCopyUseGlobalPolicy
END
IF EXISTS (select * from GxQscripts where name='archCopyUseGlobalPolicy')
	delete from GxQscripts where name = 'archCopyUseGlobalPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCopyUseGlobalPolicy')
	delete from GXDBVersions where aliasname = 'archCopyUseGlobalPolicy'
GO
print '... Creating Procedure: archCopyUseGlobalPolicy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archCopyUseGlobalPolicy
  @i_CopyId int,
  @i_HostArchGroupId int,
  @i_reserve int
AS
  DECLARE @o_retVal integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @o_retVal = 0
IF	@i_CopyId < 1
BEGIN
SELECT	9
	RETURN
END
IF	@i_HostArchGroupId <= 1
BEGIN
SELECT	3
	RETURN
END
DECLARE	@l_HostCopyId	INT
SET		@l_HostCopyId	= 0
DECLARE	@l_HostSIDBStoreId	INT
SET		@l_HostSIDBStoreId	= 0
SELECT	@l_HostCopyId = defaultCopy
FROM	archGroup
WHERE	id = @i_HostArchGroupId
IF	@l_HostCopyId = 0
BEGIN
SELECT	193
	RETURN
END
DECLARE	@l_archGroupId	INT = 0
DECLARE @l_defaultCopyId INTEGER = 0
DECLARE @l_defaultSnapCopyId INTEGER = 0
SELECT	@l_archGroupId = archGroupId FROM archGroupCopy WHERE id = @i_CopyId
SELECT 	@l_defaultCopyId = defaultCopy, @l_defaultSnapCopyId = defaultSnapCopy
FROM	archGroup WITH (READUNCOMMITTED)
WHERE	id = @l_archGroupId
BEGIN TRY
	BEGIN TRANSACTION
	DECLARE	@COPY_EXT_FLAGS	INT
SET	@COPY_EXT_FLAGS = 8192
	UPDATE	archGroupCopy
	SET		extendedFlags		= archGroupCopy.extendedFlags | @COPY_EXT_FLAGS
	WHERE	id = @i_CopyId
	INSERT INTO archCopyToGlobalPolicy (copyId, globalPolicyId, flags)
	VALUES(@i_CopyId, @i_HostArchGroupId, 0)
	SELECT	DrivePoolId, HostClientId, SpareGroupId
	INTO	#defDataPath
	FROM	MMDataPath
	WHERE	CopyId = @i_CopyId
	IF	@@ROWCOUNT > 0
		INSERT	INTO MMDataPath
SELECT	@i_CopyId, DrivePoolId, HostClientId, (Flag & ~1), SpareGroupId,
				ReadinessFlag, Priority, IsHardwareCompressed, ChunkSizeMB, FlushBlockSizeKB, UseHardwareEncryption
		FROM	MMDataPath DP
		WHERE	CopyId = @l_HostCopyId
			AND NOT EXISTS (SELECT * FROM #defDataPath
							WHERE DrivePoolId = DP.DrivePoolId AND HostClientId = DP.HostClientId AND SpareGroupId = DP.SpareGroupId)
	ELSE
		INSERT	INTO MMDataPath
		SELECT	@i_CopyId, DrivePoolId, HostClientId, Flag, SpareGroupId,
				ReadinessFlag, Priority, IsHardwareCompressed, ChunkSizeMB, FlushBlockSizeKB, UseHardwareEncryption
		FROM	MMDataPath DP
		WHERE	CopyId = @l_HostCopyId
	-- If dependent storage policy with DFM info is being created, then while associating primary classic copy
	-- with GSP copy, also populate the default datapath for snap primary copy
	IF (@l_defaultCopyId = @i_CopyId AND @l_defaultSnapCopyId <> 0 AND
		NOT EXISTS (SELECT * FROM MMDataPath WHERE CopyId = @l_defaultSnapCopyId))
	BEGIN
		INSERT INTO MMDataPath
		SELECT	@l_defaultSnapCopyId, DrivePoolId, HostClientId, Flag, SpareGroupId,
				ReadinessFlag, Priority, IsHardwareCompressed, ChunkSizeMB, FlushBlockSizeKB, UseHardwareEncryption
		FROM	MMDataPath DP WITH(READUNCOMMITTED)
		WHERE	CopyId = @l_HostCopyId
				AND (Flag & 1) <> 0 -- MMS2_DEFAULT_FAILOVER
	END
	COMMIT TRANSACTION
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_retVal = ERROR_NUMBER()
	ROLLBACK TRANSACTION
END	CATCH
SELECT @o_retVal
GO

IF EXISTS (select * from GxQscripts where name = 'archCopyUseGlobalPolicy')
	delete from GxQscripts where name = 'archCopyUseGlobalPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCopyUseGlobalPolicy')
	delete from GXDBVersions where aliasname = 'archCopyUseGlobalPolicy'
GO

insert into GXDBVersions values(2, 'archCopyUseGlobalPolicy',  '00010001000200060000', 'archCopyUseGlobalPolicy', '00010001000200060000')
GO

