

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archCopyUseGlobalDedupe.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archCopyUseGlobalDedupe.sp,v $ $Id: archCopyUseGlobalDedupe.sp,v 1.17.42.20 2020/12/17 10:57:06 anarulkar Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archCopyUseGlobalDedupe')
BEGIN
	print '>>> Drop Stored Procedure: archCopyUseGlobalDedupe <<<'
	drop procedure archCopyUseGlobalDedupe
END
IF EXISTS (select * from GxQscripts where name='archCopyUseGlobalDedupe')
	delete from GxQscripts where name = 'archCopyUseGlobalDedupe'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCopyUseGlobalDedupe')
	delete from GXDBVersions where aliasname = 'archCopyUseGlobalDedupe'
GO
print '... Creating Procedure: archCopyUseGlobalDedupe'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archCopyUseGlobalDedupe
  @i_CopyId int,
  @i_HostArchGroupId int
AS
  DECLARE @o_retVal integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @o_retVal = 0
IF	@i_CopyId < 1
BEGIN
SELECT	9
	RETURN
END
IF	@i_HostArchGroupId <= 1
BEGIN
SELECT	3
	RETURN
END
DECLARE	@l_HostCopyId	INT
SET		@l_HostCopyId	= 0
DECLARE	@l_defaultCopyId INTEGER = 0
DECLARE	@l_defaultSnapCopyId INTEGER = 0
SELECT	@l_HostCopyId = id
FROM	archGroupCopy WITH(READUNCOMMITTED)
WHERE	archGroupId = @i_HostArchGroupId AND (dedupeFlags & 268435456) <> 0
IF	@l_HostCopyId = 0
BEGIN
SELECT	80
	RETURN
END
DECLARE	@l_archGroupId	INT = 0
DECLARE @l_sourceCopyId INT = 0
SELECT	@l_archGroupId = archGroupId, @l_sourceCopyId = sourceCopyId FROM archGroupCopy WITH(READUNCOMMITTED) WHERE id = @i_CopyId
IF	@l_archGroupId = @i_HostArchGroupId
 OR EXISTS (SELECT AGC.id
			FROM archCopyToGlobalPolicy GP WITH(READUNCOMMITTED), archGroupCopy AGC WITH(READUNCOMMITTED)
			WHERE GP.globalPolicyId = @i_HostArchGroupId
				  AND GP.copyId = AGC.id
				  AND AGC.archGroupId = @l_archGroupId
AND ((AGC.dedupeFlags & 134217728) > 0))
BEGIN
SELECT	90
	RETURN
END
DECLARE	@l_SIBlockSizeKB INT
SET		@l_SIBlockSizeKB = 0
DECLARE @l_SPCommCellId INT = 0
DECLARE @l_Src_SIBlockSizeKB INT = 0
SELECT	@l_SIBlockSizeKB = SIBlockSizeKB, @l_defaultCopyId = defaultCopy, @l_defaultSnapCopyId = defaultSnapCopy,
@l_SPCommCellId = (case when origCCcommCellID > 0 then origCCcommCellID else 2 end)
FROM	archGroup WITH(READUNCOMMITTED)
WHERE	id = @l_archGroupId
IF @l_sourceCopyId = 0
BEGIN
	SET @l_sourceCopyId = @l_defaultCopyId
	SET @l_Src_SIBlockSizeKB = @l_SIBlockSizeKB
END
ELSE
BEGIN
	SELECT @l_Src_SIBlockSizeKB = SrcAG.SIBlockSizeKB
	FROM archGroup SrcAG WITH (READUNCOMMITTED)
		INNER JOIN archCopyToGlobalPolicy ACGP WITH (READUNCOMMITTED) ON ACGP.globalPolicyId = SrcAG.id
	WHERE ACGP.copyId = @l_sourceCopyId
END
DECLARE	@l_HostSIBlockSizeKB INT
SET		@l_HostSIBlockSizeKB = 0
SELECT	@l_HostSIBlockSizeKB = SIBlockSizeKB FROM archGroup WITH(READUNCOMMITTED) WHERE id = @i_HostArchGroupId
-- If primary copy is using GDSP, update the block size based on host block size
IF NOT EXISTS (SELECT id FROM archGroupCopy WHERE archGroupId = @l_archGroupId AND id <> @i_CopyId AND (dedupeFlags & 262144) <> 0)
	UPDATE	archGroup SET SIBlockSizeKB = @l_HostSIBlockSizeKB WHERE id = @l_archGroupId
-- If source copy is using Hyperscale and if current secondary copy to GDSP is to cloud and no other copy then update the blocksize of cloud GDSP to source copy's GDSP
IF (@l_HostSIBlockSizeKB <> @l_Src_SIBlockSizeKB)
-- Removed the checks for cloud since we want to have this behaviour for disk to disk also.
BEGIN
	-- Removed checks for hyperscale also.
	-- We want this behaviour in the following 2 conditions only
	-- 1) When no copy is already pointing to the GDSP.
	-- 2) When the store is not initialized
	IF NOT EXISTS (SELECT DISTINCT CDS.CopyId FROM archCopySIDBStore CS WITH (READUNCOMMITTED)
					INNER JOIN archCopySIDBStore CDS WITH (READUNCOMMITTED) ON CS.SIDBStoreId = CDS.SIDBStoreId
				WHERE CS.CopyId = @l_HostCopyId
				AND CDS.CopyId <> @l_HostCopyId
				)
	-- Also make sure that no backups are run to the destination store.
	AND NOT EXISTS (SELECT 1 FROM archCopySIDBStore CDS WITH (READUNCOMMITTED)
				INNER JOIN IdxSIDBStore S WITH (READUNCOMMITTED) ON CDS.SIDBStoreId = S.SIDBStoreId
			WHERE CDS.CopyId = @l_HostCopyId
			AND S.FirstBackupTime <> -1)
	BEGIN
		UPDATE archGroup SET SIBlockSizeKB = @l_Src_SIBlockSizeKB WHERE id = @i_HostArchGroupId
	END
END
-- CMR - 213957 this is to allow block size change
-- We are opening it up for all cases after discussion with Manoj and Rajiv
-- IF @l_HostSIBlockSizeKB <> @l_SIBlockSizeKB
-- BEGIN
-- IF NOT EXISTS (SELECT id FROM archGroupCopy WHERE archGroupId = @l_archGroupId AND id <> @i_CopyId AND (dedupeFlags & 262144) <> 0)
		-- UPDATE	archGroup SET SIBlockSizeKB = @l_HostSIBlockSizeKB WHERE id = @l_archGroupId
	-- ELSE
	-- BEGIN
		--IF 7 <> (SELECT TOP 1 MountPathTypeId -- If host policy uses a cloud library (mount path type 7 -- MOUNT_PATH_EXTERNAL_REMOTE_HOST), allow differing block size
	-- FROM MMMountPath MP WITH(READUNCOMMITTED) INNER JOIN MMDrivePool MD WITH(READUNCOMMITTED) ON MP.MasterPoolId = MD.MasterPoolId
	-- INNER JOIN MMDataPath MDP WITH(READUNCOMMITTED) ON MD.DrivePoolId = MDP.DrivePoolId
	-- INNER JOIN archGroupCopy AGC WITH(READUNCOMMITTED) ON AGC.id = MDP.CopyId
	-- WHERE AGC.archGroupId = @i_HostArchGroupId)
		-- BEGIN
-- SELECT	91
			-- RETURN
		-- END
	-- END
-- END
--
-- Don't allow using GDSP when store has data from different CommCell
-- if InfiniStore enabled and MAs are at v11 SP15 or higher then
-- auto create new DDB group for the commCellId if not exists and allow using GDSP.
--
DECLARE @l_CommCellId INT = @l_SPCommCellId
--For migrated storage policy try getting commCellId from jobs if there are any other copies exists already
IF  @l_SPCommCellId > 2
BEGIN
	SELECT 	@l_CommCellId = ISNULL(MIN(JS.commCellId), @l_SPCommCellId)
	FROM	JMJobDataStats JS WITH(READUNCOMMITTED)
	WHERE	JS.archGrpCopyId = @l_sourceCopyId
END
IF NOT EXISTS
(
	SELECT 	1
	FROM	archCopySIDBStore CS WITH(READUNCOMMITTED),
			IdxSIDBStore S WITH(READUNCOMMITTED),
			IdxSIDBGroup SG WITH(READUNCOMMITTED)
	WHERE	CS.copyId = @l_HostCopyId
			AND CS.SIDBStoreId = S.SIDBStoreId
			AND S.SIDBGroupId = SG.SIDBGroupId
			AND SG.CommCellId = @l_CommCellId
)
BEGIN
	--
	--Don't allow If GDSP is already used for migrated data and doesn't has CommCellId 2 group
	--We can create CCId 2 group and map copy to it but problem with that the default DDB will be with migrated CCId
	--So we won't be able to add mapping for older version clients for backups
	--
IF @l_CommCellId = 2
	BEGIN
SELECT	105
		RETURN
	END
	--
	-- Create new DDB group for CommCellId if InifniStore enabled and all MAs are at supported level
	--
	ELSE IF EXISTS(SELECT 1 FROM MMConfigs WITH(READUNCOMMITTED) WHERE name = 'MMS2_CONFIG_ENABLE_INFINI_STORE' AND value = 1)
	AND NOT EXISTS
	(
		SELECT	1
		FROM	App_Client CN WITH(READUNCOMMITTED)
				INNER JOIN simInstalledPackages PKG WITH(READUNCOMMITTED) ON CN.id = PKG.ClientId
				INNER JOIN
				(
					SELECT 	ISNULL(VC.PMClientId, ST.clientId) clientId
					FROM	archCopySIDBStore CS WITH(READUNCOMMITTED)
							INNER JOIN IdxSIDBSubStore ST WITH(READUNCOMMITTED) ON CS.SIDBStoreId = ST.SIDBStoreId
							LEFT OUTER JOIN APP_VMToPMMap VC WITH(READUNCOMMITTED) ON ST.clientId = VC.VMClientId
					WHERE	CS.copyId = @l_HostCopyId
					UNION
					SELECT	ISNULL(VC.PMClientId, LDPool.clientId) clientId
					FROM	MMDataPath DPath WITH(READUNCOMMITTED)
							INNER JOIN MMDrivePool DPool WITH(READUNCOMMITTED) ON DPath.DrivePoolId = DPool.DrivePoolId
							INNER JOIN MMDrivePool LDPool WITH(READUNCOMMITTED) ON DPool.MasterPoolId = LDPool.MasterPoolId
							LEFT OUTER JOIN APP_VMToPMMap VC WITH(READUNCOMMITTED) ON LDPool.clientId = VC.VMClientId
					WHERE	DPath.copyId = @l_HostCopyId
				) AS T ON CN.id = T.clientId
		WHERE	(CN.releaseId < 16 OR (CN.releaseId = 16 AND PKG.HighestSP < 15))
AND PKG.simPackageID IN (51, 1301)
	)
	BEGIN
		DECLARE @l_errCode INT = 0
		EXEC archCreateNewDDBGroup @l_HostCopyId, @l_CommCellId, @l_errCode OUTPUT
		IF @l_errCode <> 0
		BEGIN
			SELECT	@l_errCode
			RETURN
		END
	END
	--
	-- Empty GDSP and not used by any local storage policies
	-- Then move it from default group to commcellId group
	--
	ELSE IF NOT EXISTS
	(
		SELECT 	1
		FROM	archCopyToGlobalPolicy GP WITH(READUNCOMMITTED),
				archGroupCopy AGC WITH(READUNCOMMITTED),
				archGroup AG WITH(READUNCOMMITTED)
		WHERE	GP.globalPolicyId = @i_HostArchGroupId
				AND GP.copyId = AGC.id
				AND AGC.archGroupId = AG.id
AND AG.origCCcommCellID IN (0, 2)
	)
	AND NOT EXISTS(SELECT 1 FROM IdxSIDBGroup WITH(READUNCOMMITTED) WHERE CopyId = @l_HostCopyId)
	BEGIN
		BEGIN TRY
			BEGIN TRANSACTION
			--
			-- Move DDBs to new commCellId group
			--
			DECLARE @l_SIDBGroupId INT = 0
			INSERT INTO IdxSIDBGroup (CopyId, CommCellId)
			SELECT @l_HostCopyId, @l_CommCellId
			SELECT	@l_SIDBGroupId = SCOPE_IDENTITY()
			UPDATE	S
			SET		SIDBGroupId = @l_SIDBGroupId
			FROM	IdxSIDBStore S,
					archCopySIDBStore CS WITH(READUNCOMMITTED)
			WHERE	S.SIDBStoreId = CS.SIDBStoreId
					AND CS.copyId = @l_HostCopyId
			COMMIT TRANSACTION
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			SET @o_retVal = ERROR_NUMBER()
			ROLLBACK TRANSACTION
SELECT 2
			RETURN @o_retVal
		END	CATCH
	END
	ELSE
	BEGIN
SELECT	105
		RETURN
	END
END
BEGIN TRY
	BEGIN TRANSACTION
	DECLARE	@COPY_DEDUP_FLAGS	INT
SET	@COPY_DEDUP_FLAGS = (2 | 4 | 8 | 262144 | 							1048576 | 134217728 |
524288 | 8388608 | 536870912)
	DECLARE	@HOST_DEDUP_FLAGS	INT
SET	@HOST_DEDUP_FLAGS = (2 | 4 | 8 | 2097152 | 							4194304 | 16777216 |
33554432 | 67108864)
	INSERT	INTO archCopySIDBStore (CopyId, SIDBStoreId, CommCellId, flags, TotalDataSizeBytes, InstancedDataSizeBytes)
	SELECT	@i_CopyId, CS.SIDBStoreId, 2, CS.flags, 0, 0
	FROM	archCopySIDBStore CS WITH(READUNCOMMITTED),
			IdxSIDBStore S WITH(READUNCOMMITTED),
			IdxSIDBGroup SG WITH(READUNCOMMITTED)
WHERE	CS.CopyId = @l_HostCopyId AND (CS.flags & 4) > 0
			AND CS.SIDBStoreId = S.SIDBStoreId
			AND S.SIDBGroupId = SG.SIDBGroupId
			AND SG.CommCellId = @l_CommCellId
	UPDATE	archGroupCopy
	SET		SIDBStoreId			= T.SIDBStoreID,
dedupeFlags			= (262144 | (archGroupCopy.dedupeFlags & @COPY_DEDUP_FLAGS) | (T.dedupeFlags & @HOST_DEDUP_FLAGS)),
			sealStoreTaskId		= T.sealStoreTaskId,
			siloAppId			= T.siloAppId,
			nDataInstance		= T.nDataInstance,
			nSiloStreams		= T.nSiloStreams,
			silosInCache		= T.silosInCache,
			siloRestoreMAClientId	= T.siloRestoreMAClientId,
			siloRestoreClientId		= T.siloRestoreClientId,
			SIDBSnapIntervalHours	= T.SIDBSnapIntervalHours,
extendedFlags	|= (T.extendedFlags & 1024)
	FROM	(SELECT	AGC.dedupeFlags, AGC.sealStoreTaskId, AGC.siloAppId, AGC.nDataInstance, AGC.nSiloStreams, AGC.silosInCache, AGC.siloRestoreMAClientId, AGC.siloRestoreClientId, AGC.SIDBSnapIntervalHours, CS.SIDBStoreID, AGC.extendedFlags
			FROM	archGroupCopy AGC WITH(READUNCOMMITTED), archCopySIDBStore CS WITH(READUNCOMMITTED)
			WHERE	id = @l_HostCopyId
					AND AGC.id = CS.CopyID
AND ((CS.Flags & (2|4)) = (2|4))
			) T
	WHERE	id = @i_CopyId
	INSERT INTO archCopyToGlobalPolicy (copyId, globalPolicyId, flags)
	VALUES(@i_CopyId, @i_HostArchGroupId, 0)
	SELECT	DrivePoolId, HostClientId, SpareGroupId
	INTO	#defDataPath
	FROM	MMDataPath WITH(READUNCOMMITTED)
	WHERE	CopyId = @i_CopyId
	IF	@@ROWCOUNT > 0
		INSERT	INTO MMDataPath
SELECT	@i_CopyId, DrivePoolId, HostClientId, (Flag & ~1), SpareGroupId,
				ReadinessFlag, Priority, IsHardwareCompressed, ChunkSizeMB, FlushBlockSizeKB, UseHardwareEncryption
		FROM	MMDataPath DP
		WHERE	CopyId = @l_HostCopyId
			AND NOT EXISTS (SELECT * FROM #defDataPath
							WHERE DrivePoolId = DP.DrivePoolId AND HostClientId = DP.HostClientId AND SpareGroupId = DP.SpareGroupId)
	ELSE
		INSERT	INTO MMDataPath
		SELECT	@i_CopyId, DrivePoolId, HostClientId, Flag, SpareGroupId,
				ReadinessFlag, Priority, IsHardwareCompressed, ChunkSizeMB, FlushBlockSizeKB, UseHardwareEncryption
		FROM	MMDataPath DP WITH(READUNCOMMITTED)
		WHERE	CopyId = @l_HostCopyId
	-- Assign unassigned DDB Backup subclients to the dependent copy if this copy is a primary copy.
	IF (@i_CopyId = @l_defaultCopyId)
	BEGIN
		UPDATE APP_Application
		SET dataArchGrpID = @l_archGroupId,
		logArchGrpID	= @l_archGroupId
		FROM APP_Application APP WITH (NOLOCK)
			INNER JOIN APP_SubClientProp ASCP WITH (NOLOCK) ON ASCP.componentNameId = APP.id AND ASCP.attrName = 'DDB Backup'
		WHERE APP.clientId IN (SELECT clientId FROM IdxSIDBSubStore I WITH (NOLOCK), archCopySIDBStore CS WITH(READUNCOMMITTED)
WHERE	CS.CopyId = @l_HostCopyId AND (CS.flags & 4) > 0 AND I.SIDBStoreId = CS.SIDBStoreId)
		AND APP.dataArchGrpID <= 1 AND APP.logArchGrpID <= 1
		AND (APP.subClientStatus & 4) = 0
	END
	COMMIT TRANSACTION
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_retVal = ERROR_NUMBER()
	ROLLBACK TRANSACTION
SELECT 2
	RETURN @o_retVal
END	CATCH
SELECT 0
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'archCopyUseGlobalDedupe')
	delete from GxQscripts where name = 'archCopyUseGlobalDedupe'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCopyUseGlobalDedupe')
	delete from GXDBVersions where aliasname = 'archCopyUseGlobalDedupe'
GO

insert into GXDBVersions values(2, 'archCopyUseGlobalDedupe',  '00010017004200200000', 'archCopyUseGlobalDedupe', '00010017004200200000')
GO

